# Circe

[![crates.io](https://img.shields.io/crates/v/circe.svg)](https://crates.io/crates/circe)
[![Documentation](https://docs.rs/circe/badge.svg)](https://docs.rs/circe)
[![Unlicense](https://img.shields.io/crates/l/circe.svg)](./LICENSE)

`Circe` is a an IRC crate built to be as minimal as possible. It's currently work-in-progress, and more stuff is on its way!

## Getting started

To start using Circe, just add the crate to your `Cargo.toml`, and then follow the example below.

```rust
use circe::{Client, Config, Command};

fn main() -> Result<(), std::io::Error> {
    let config = Config::from_toml("config.toml")?;
    let mut client = Client::new(config)?;
    client.identify()?;

    loop {
        if let Ok(ref command) = client.read() {
            if let Command::OTHER(line) = command {
                print!("{}", line);
            }
            if let Command::PRIVMSG(channel, message) = command {
                println!("PRIVMSG received: {} {}", channel, message);
            }
        }    
    }
}
```

Happy hacking!