#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Exact {
    #[prost(bytes="vec", repeated, tag="1")]
    pub term: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Range {
    #[prost(bytes="vec", repeated, tag="1")]
    pub upper: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(bytes="vec", repeated, tag="2")]
    pub lower: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Constraint {
    #[prost(bytes="vec", tag="1")]
    pub index_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(oneof="constraint::Condition", tags="2, 3")]
    pub condition: ::core::option::Option<constraint::Condition>,
}
/// Nested message and enum types in `Constraint`.
pub mod constraint {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Condition {
        #[prost(message, tag="2")]
        Exact(super::Exact),
        #[prost(message, tag="3")]
        Range(super::Range),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Aggregate {
    #[prost(enumeration="aggregate::AggregateType", tag="2")]
    pub r#type: i32,
}
/// Nested message and enum types in `Aggregate`.
pub mod aggregate {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum AggregateType {
        Count = 0,
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Ordering {
    #[prost(bytes="vec", tag="1")]
    pub index_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(enumeration="ordering::Direction", tag="2")]
    pub direction: i32,
}
/// Nested message and enum types in `Ordering`.
pub mod ordering {
    #[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
    #[repr(i32)]
    pub enum Direction {
        Asc = 0,
        Desc = 1,
    }
}
//
//Query protobuf
//
//`limit`: define the maximum records to be returned
//`constraints`: constraints on the query (can be an empty list)
//`aggregates`: aggregates for the given constraints (can be an empty list)
//`skipResults`: if true then don't return the results (should be ignored if there are no aggregates)

#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Query {
    #[prost(uint32, tag="1")]
    pub limit: u32,
    #[prost(message, repeated, tag="2")]
    pub constraints: ::prost::alloc::vec::Vec<Constraint>,
    #[prost(message, repeated, tag="3")]
    pub aggregates: ::prost::alloc::vec::Vec<Aggregate>,
    #[prost(message, repeated, tag="4")]
    pub ordering: ::prost::alloc::vec::Vec<Ordering>,
    #[prost(bool, tag="5")]
    pub skip_results: bool,
    #[prost(uint32, tag="6")]
    pub offset: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct QueryRequest {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag="2")]
    pub query: ::core::option::Option<Query>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AggregateResult {
    #[prost(string, tag="1")]
    pub name: ::prost::alloc::string::String,
    #[prost(uint64, tag="2")]
    pub value: u64,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct QueryReply {
    #[prost(bytes="vec", repeated, tag="1")]
    pub result: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(message, repeated, tag="2")]
    pub aggregates: ::prost::alloc::vec::Vec<AggregateResult>,
    #[prost(message, repeated, tag="3")]
    pub records: ::prost::alloc::vec::Vec<super::documents::Document>,
}
