#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Document {
    #[prost(bytes="vec", tag="1")]
    pub id: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes="vec", tag="2")]
    pub source: ::prost::alloc::vec::Vec<u8>,
}
///
/// A term represents an indexed term value
/// and a posting link that relates to the source
/// document it indexes.
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Term {
    #[prost(bytes="vec", repeated, tag="1")]
    pub term: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
    #[prost(bytes="vec", tag="2")]
    pub link: ::prost::alloc::vec::Vec<u8>,
}
///
/// A vector represents a set of ciphertext terms
/// generated for the document by the Index (indexId)
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Vector {
    #[prost(bytes="vec", tag="1")]
    pub index_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, repeated, tag="2")]
    pub terms: ::prost::alloc::vec::Vec<Term>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PutRequest {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(message, optional, tag="2")]
    pub source: ::core::option::Option<Document>,
    #[prost(message, repeated, tag="3")]
    pub vectors: ::prost::alloc::vec::Vec<Vector>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PutReply {
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingPutBegin {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingPutDocument {
    #[prost(message, optional, tag="2")]
    pub source: ::core::option::Option<Document>,
    #[prost(message, repeated, tag="3")]
    pub vectors: ::prost::alloc::vec::Vec<Vector>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingPutRequest {
    #[prost(oneof="streaming_put_request::Payload", tags="1, 2")]
    pub payload: ::core::option::Option<streaming_put_request::Payload>,
}
/// Nested message and enum types in `StreamingPutRequest`.
pub mod streaming_put_request {
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Payload {
        #[prost(message, tag="1")]
        Begin(super::StreamingPutBegin),
        #[prost(message, tag="2")]
        Document(super::StreamingPutDocument),
    }
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct StreamingPutReply {
    #[prost(uint32, tag="1")]
    pub num_inserted: u32,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetRequest {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes="vec", tag="2")]
    pub id: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetReply {
    #[prost(message, optional, tag="1")]
    pub source: ::core::option::Option<Document>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAllRequest {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes="vec", repeated, tag="2")]
    pub ids: ::prost::alloc::vec::Vec<::prost::alloc::vec::Vec<u8>>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetAllReply {
    #[prost(message, repeated, tag="1")]
    pub documents: ::prost::alloc::vec::Vec<Document>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteRequest {
    #[prost(bytes="vec", tag="1")]
    pub collection_id: ::prost::alloc::vec::Vec<u8>,
    #[prost(bytes="vec", tag="2")]
    pub id: ::prost::alloc::vec::Vec<u8>,
}
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DeleteReply {
}
