# Completions

## Path Completion

When you hit `TAB` key after typing part of file/path name, cicada
will complete the full path if there is only one file matches the prefix.
If there are multiple paths match the prefix, cicada will complete you
to the maximal common part of them. In this case, you can hit `TAB` key
two times, all the candidates would show up. Then you can type more characters
and hit `TAB` again.

```
$ cd ~/Lib<TAB>
# cicada completes to:
$ cd ~/Library/

# hit Tab two times:
$ cd ~/Library/<TAB><TAB>
Application Support/      Mail/                   Logs/                     Fonts/
Assistant/                Compositions/           Internet Plug-Ins/        KeyboardServices/
Autosave Information/     Google/                 Voices/                   Metadata/
Saved Application State/  LanguageModeling/       Accounts/                 Screen Savers/

$ cd ~/Library/App<TAB>
$ cd ~/Library/Application\ S
$ cd ~/Library/Application\ S<TAB><TAB>
Application Support/  Application Scripts/

$ cd ~/Library/Application\ Su<TAB>
$ cd ~/Library/Application\ Support/
```

**Hint:** Always use strong quote when completing files with special
characters:

```
$ touch '[ www.MyMoive.com ] The Silence of the Lambs.srt'
$ ls -1
[ www.MyMoive.com ] The Silence of the Lambs.srt
$ mv '[<TAB>

# cicada will complete it to:
$ mv '[ www.MyMoive.com ] The Silence of the Lambs.srt'

# though, you can complete it without strong quote:
$ ls -lh \[<TAB>
# you would get:
$ ls -lh \[\ www.MyMoive.com\ \]\ The\ Silence\ of\ the\ Lambs.srt
```

Also, at the start of input, or behind a pipe `|`, cicada will
do the completion by searching your `$PATH` for executable binaries.

```
$ man sed | gre<TAB>
```

## Builtin Completions for Commands

In addition to path completion, cicada has some builtin completions for some
popular commands. Currently only following commands are supported.

- make
- ssh

Completion of `make` will read `Makefile` in currect directory, and for
`ssh`, [file](https://www.cyberciti.biz/faq/create-ssh-config-file-on-linux-unix/)
`~/.ssh/config` will be read.

**Note**: cicada will try not add more completions like this, since you can
always define you own completions for any commands. Please read "Customize
Completions" section below.

## Completions on Environment Variables

Cicada knows how to complete the OS Environment Variables too.

```
$ echo $LC_<TAB><TAB>
$LC_ALL  $LC_CTYPE

$ echo $LC_A<TAB>
$ echo $LC_ALL
en_US.UTF-8
```

## Customize Completions

Cicada supports simplifed customized completion using YAML file.
Put your completion files under `$XDG_CONFIG_HOME/cicada/completers`
(by default it's `~/.config/cicada/completers/`).
The completion files look like this:

> **NOTE:** cicada 0.9.x also loads completers from `~/.cicada/completers`
> (if `~/.config/cicada/completers` not exist) for
> compatibility. From 1.0, cicada will not read this location anymore.

```
$ ls ~/.config/cicada/completers/
brew.yaml git.yaml  pip.yaml  vox.yaml

$ cat ~/.config/cicada/completers/brew.yaml
- doctor
- info
- install
- list
- search
- uninstall
- update
- upgrade

$ brew u<Tab><Tab>
uninstall  update  upgrade
```

Currently, cicada supports maximum 2 levels of completion:

```
$ cat ~/.config/cicada/completers/pip.yaml
- install:
    - -U
    - --upgrade
    - -r
    - --requirement
- download
- uninstall
- search:
    - --no-cache-dir
    - --timeout
- wheel

$ pip ins<Tab>
$ pip install

$ pip install --re<Tab>
$ pip install --requirement
```

**You may use sub commands in it**. For example:

```
$ cat ~/.config/cicada/completers/git.yaml
... skipped ...

- checkout:
    - "`git branch -a | tr -d '* ' | grep -v HEAD | sed 's_^.*/__' | sort | uniq`"
- co:
    - "`git branch -a | tr -d '* ' | grep -v HEAD | sed 's_^.*/__' | sort | uniq`"

... skipped ...
```

Then completion results for `git co` and `git checkout` will be generated by
the sub command (i.e. `git branch -a | tr -d '* ' | grep -v HEAD | sed 's_^.*/__' | sort | uniq` here).

```
$ git co dev<TAB>
$ git co develep-the-customized-completion
```

**Hint**: though we can only define 2 levels of completions in file, It's
still possible to simulate 3 (or more) levels like this:

```
$ cat ~/.config/cicada/completers/git.yaml

... skipped ...

- remote:
    - add
    - origin
    - upstream
    - rm
    - -v

... skipped ...
```

This would work like this:
```
$ git rem<TAB>
# completes to:
$ git remote

$ git remote a<TAB>
# completes to:
$ git remote add

$ git remote add o<TAB>
# completes to:
$ git remote add origin
```
