use super::*;

async fn test_update_fails<'store>(
    query_end: &str,
    body: &str,
) -> Ciboulette2PgError {
    let ciboulette_store = gen_bag();
    let table_store = gen_table_store(&ciboulette_store);
    let parsed_url = Url::parse(format!("http://localhost{}", query_end).as_str()).unwrap();
    const INTENTION: CibouletteIntention = CibouletteIntention::Update;
    let body: Option<&str> = Some(body);

    let req_builder = CibouletteRequestBuilder::new(INTENTION, &parsed_url, &body);
    let request = req_builder.build(&ciboulette_store).unwrap();
    let ciboulette_request = CibouletteUpdateRequest::try_from(request).unwrap();
    Ciboulette2PgBuilder::gen_update(&ciboulette_store, &table_store, &ciboulette_request)
        .unwrap_err()
}

#[basiliq_test(run_migrations)]
async fn updating_one_to_many_rels(mut pool: sqlx::PgPool) {
    let data = basiliq_db_test_utils::init_values(&mut pool).await;
    let people_id = data.get("peoples").unwrap().first().unwrap();
    let err = test_update_fails(
        format!("/peoples/{}", people_id).as_str(),
        json!({
            "data": json!({
                "type": "peoples",
                "id": people_id,
                "attributes": json!({
                    "first-name": "New first",
                    "last-name": "New last name",
                }),
                "relationships": json!({
                    "articles": json!({
                        "data": json!({
                            "id": data.get("articles").unwrap().last().unwrap(),
                            "type": "articles"
                        })
                    }),
                }),
            })
        })
        .to_string()
        .as_str(),
    )
    .await;
    assert_eq!(
        matches!(err, Ciboulette2PgError::ManyRelationshipDirectWrite),
        true
    );
}
