#[doc = r" This file is generated and should not be edited directly."]
pub use events::*;
#[doc = r" This trait allows for implementing custom events that are not covered by the"]
#[doc = r" chrome protocol definitions."]
#[doc = r""]
#[doc = r" Every `CustomEvent` also requires an implementation of"]
#[doc = r" `chromiumoxide_types::MethodType` and it must be `DeserializeOwned`"]
#[doc = r" (`#[derive(serde::Deserialize)]`). This is necessary to identify match this"]
#[doc = r" type against the provided `method` identifier of a `CdpEventMessage`"]
#[doc = r" and to properly deserialize it from a `serde_json::Value`"]
pub trait CustomEvent:
    ::std::any::Any + serde::de::DeserializeOwned + chromiumoxide_types::MethodType + Send + Sync
{
    #[doc = r" Used to convert the json event into in instance of this type"]
    fn from_json(event: serde_json::Value) -> serde_json::Result<Self>
    where
        Self: Sized + 'static,
    {
        serde_json::from_value(event)
    }
}
impl<T: CustomEvent> sealed::SealedEvent for T {
    fn as_any(&self) -> &dyn ::std::any::Any {
        self
    }
}
#[doc = r" This is trait that all Events share"]
#[doc = r""]
#[doc = r" This trait is sealed to prevent implementation. The only way to implement a new `Event` is by implementing `CustomEvent`"]
pub trait Event: sealed::SealedEvent {}
impl<T: sealed::SealedEvent> Event for T {}
impl<T: CustomEvent + Event> sealed::SealedCustomEventConverter for T {}
#[doc = r" Function type to convert a json event into an instance of it self but as dyn Event"]
pub type EventConversion = Box<
    dyn Fn(serde_json::Value) -> serde_json::Result<::std::sync::Arc<dyn Event>> + Send + 'static,
>;
#[doc = r" An enum that does nothing for built in types but contains the conversion method for custom events"]
pub enum EventKind {
    BuiltIn,
    Custom(EventConversion),
}
impl EventKind {
    #[doc = r" Whether this is a custom event"]
    pub fn is_custom(&self) -> bool {
        matches!(self, EventKind::Custom(_))
    }
}
impl ::std::fmt::Debug for EventKind {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            EventKind::BuiltIn => f.debug_tuple("BuiltIn").finish(),
            EventKind::Custom(_) => f.debug_tuple("Custom").finish(),
        }
    }
}
#[doc = r" A trait on top of the `Event` trait"]
pub trait IntoEventKind: Event {
    #[doc = r" What kind of event this type is"]
    fn event_kind() -> EventKind
    where
        Self: Sized + 'static;
}
impl<T: sealed::SealedCustomEventConverter> IntoEventKind for T {
    fn event_kind() -> EventKind
    where
        Self: Sized + 'static,
    {
        EventKind::Custom(Box::new(Self::event_arc))
    }
}
pub(crate) mod sealed {
    pub trait SealedCustomEventConverter: super::CustomEvent + super::Event {
        fn event_arc(
            event: serde_json::Value,
        ) -> serde_json::Result<::std::sync::Arc<dyn super::Event>>
        where
            Self: Sized + 'static,
        {
            Ok(::std::sync::Arc::new(Self::from_json(event)?))
        }
    }
    pub trait SealedEvent: ArcAny + chromiumoxide_types::MethodType {
        #[doc = r" generate `&::std::any::Any`'s vtable from `&Trait`'s."]
        fn as_any(&self) -> &dyn ::std::any::Any;
    }
    pub trait ArcAny: ::std::any::Any + Send + Sync {
        fn into_any_arc(
            self: ::std::sync::Arc<Self>,
        ) -> ::std::sync::Arc<dyn ::std::any::Any + Send + Sync>;
    }
    impl<T: ::std::any::Any + Send + Sync> ArcAny for T {
        fn into_any_arc(
            self: ::std::sync::Arc<Self>,
        ) -> ::std::sync::Arc<dyn ::std::any::Any + Send + Sync> {
            self
        }
    }
    impl dyn SealedEvent {
        #[doc = r" Returns true if the trait object wraps an object of type `T`."]
        #[inline]
        pub fn is<T: SealedEvent>(&self) -> bool {
            self.as_any().is::<T>()
        }
        #[inline]
        pub fn downcast_arc<T: SealedEvent>(
            self: ::std::sync::Arc<Self>,
        ) -> Result<::std::sync::Arc<T>, ::std::sync::Arc<Self>>
        where
            T: ::std::any::Any + Send + Sync,
        {
            if self.is::<T>() {
                Ok(ArcAny::into_any_arc(self).downcast::<T>().unwrap())
            } else {
                Err(self)
            }
        }
    }
}
pub mod events {
    use serde::Deserialize;
    #[derive(Debug, PartialEq, Clone)]
    pub struct CdpEventMessage {
        #[doc = r" Name of the method"]
        pub method: chromiumoxide_types::MethodId,
        #[doc = r" The chromium session Id"]
        pub session_id: Option<String>,
        #[doc = r" Json params"]
        pub params: CdpEvent,
    }
    impl chromiumoxide_types::Method for CdpEventMessage {
        fn identifier(&self) -> chromiumoxide_types::MethodId {
            match &self.params {
                CdpEvent::DebuggerBreakpointResolved(inner) => inner.identifier(),
                CdpEvent::DebuggerPaused(inner) => inner.identifier(),
                CdpEvent::DebuggerResumed(inner) => inner.identifier(),
                CdpEvent::DebuggerScriptFailedToParse(inner) => inner.identifier(),
                CdpEvent::DebuggerScriptParsed(inner) => inner.identifier(),
                CdpEvent::HeapProfilerAddHeapSnapshotChunk(inner) => inner.identifier(),
                CdpEvent::HeapProfilerHeapStatsUpdate(inner) => inner.identifier(),
                CdpEvent::HeapProfilerLastSeenObjectId(inner) => inner.identifier(),
                CdpEvent::HeapProfilerReportHeapSnapshotProgress(inner) => inner.identifier(),
                CdpEvent::HeapProfilerResetProfiles(inner) => inner.identifier(),
                CdpEvent::ProfilerConsoleProfileFinished(inner) => inner.identifier(),
                CdpEvent::ProfilerConsoleProfileStarted(inner) => inner.identifier(),
                CdpEvent::ProfilerPreciseCoverageDeltaUpdate(inner) => inner.identifier(),
                CdpEvent::RuntimeBindingCalled(inner) => inner.identifier(),
                CdpEvent::RuntimeConsoleApiCalled(inner) => inner.identifier(),
                CdpEvent::RuntimeExceptionRevoked(inner) => inner.identifier(),
                CdpEvent::RuntimeExceptionThrown(inner) => inner.identifier(),
                CdpEvent::RuntimeExecutionContextCreated(inner) => inner.identifier(),
                CdpEvent::RuntimeExecutionContextDestroyed(inner) => inner.identifier(),
                CdpEvent::RuntimeExecutionContextsCleared(inner) => inner.identifier(),
                CdpEvent::RuntimeInspectRequested(inner) => inner.identifier(),
                CdpEvent::AnimationAnimationCanceled(inner) => inner.identifier(),
                CdpEvent::AnimationAnimationCreated(inner) => inner.identifier(),
                CdpEvent::AnimationAnimationStarted(inner) => inner.identifier(),
                CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(inner) => {
                    inner.identifier()
                }
                CdpEvent::ApplicationCacheNetworkStateUpdated(inner) => inner.identifier(),
                CdpEvent::AuditsIssueAdded(inner) => inner.identifier(),
                CdpEvent::BackgroundServiceRecordingStateChanged(inner) => inner.identifier(),
                CdpEvent::BackgroundServiceBackgroundServiceEventReceived(inner) => {
                    inner.identifier()
                }
                CdpEvent::CssFontsUpdated(inner) => inner.identifier(),
                CdpEvent::CssMediaQueryResultChanged(inner) => inner.identifier(),
                CdpEvent::CssStyleSheetAdded(inner) => inner.identifier(),
                CdpEvent::CssStyleSheetChanged(inner) => inner.identifier(),
                CdpEvent::CssStyleSheetRemoved(inner) => inner.identifier(),
                CdpEvent::CastSinksUpdated(inner) => inner.identifier(),
                CdpEvent::CastIssueUpdated(inner) => inner.identifier(),
                CdpEvent::DomAttributeModified(inner) => inner.identifier(),
                CdpEvent::DomAttributeRemoved(inner) => inner.identifier(),
                CdpEvent::DomCharacterDataModified(inner) => inner.identifier(),
                CdpEvent::DomChildNodeCountUpdated(inner) => inner.identifier(),
                CdpEvent::DomChildNodeInserted(inner) => inner.identifier(),
                CdpEvent::DomChildNodeRemoved(inner) => inner.identifier(),
                CdpEvent::DomDistributedNodesUpdated(inner) => inner.identifier(),
                CdpEvent::DomDocumentUpdated(inner) => inner.identifier(),
                CdpEvent::DomInlineStyleInvalidated(inner) => inner.identifier(),
                CdpEvent::DomPseudoElementAdded(inner) => inner.identifier(),
                CdpEvent::DomPseudoElementRemoved(inner) => inner.identifier(),
                CdpEvent::DomSetChildNodes(inner) => inner.identifier(),
                CdpEvent::DomShadowRootPopped(inner) => inner.identifier(),
                CdpEvent::DomShadowRootPushed(inner) => inner.identifier(),
                CdpEvent::DomStorageDomStorageItemAdded(inner) => inner.identifier(),
                CdpEvent::DomStorageDomStorageItemRemoved(inner) => inner.identifier(),
                CdpEvent::DomStorageDomStorageItemUpdated(inner) => inner.identifier(),
                CdpEvent::DomStorageDomStorageItemsCleared(inner) => inner.identifier(),
                CdpEvent::DatabaseAddDatabase(inner) => inner.identifier(),
                CdpEvent::EmulationVirtualTimeBudgetExpired(inner) => inner.identifier(),
                CdpEvent::InspectorDetached(inner) => inner.identifier(),
                CdpEvent::InspectorTargetCrashed(inner) => inner.identifier(),
                CdpEvent::InspectorTargetReloadedAfterCrash(inner) => inner.identifier(),
                CdpEvent::LayerTreeLayerPainted(inner) => inner.identifier(),
                CdpEvent::LayerTreeLayerTreeDidChange(inner) => inner.identifier(),
                CdpEvent::LogEntryAdded(inner) => inner.identifier(),
                CdpEvent::NetworkDataReceived(inner) => inner.identifier(),
                CdpEvent::NetworkEventSourceMessageReceived(inner) => inner.identifier(),
                CdpEvent::NetworkLoadingFailed(inner) => inner.identifier(),
                CdpEvent::NetworkLoadingFinished(inner) => inner.identifier(),
                CdpEvent::NetworkRequestServedFromCache(inner) => inner.identifier(),
                CdpEvent::NetworkRequestWillBeSent(inner) => inner.identifier(),
                CdpEvent::NetworkResourceChangedPriority(inner) => inner.identifier(),
                CdpEvent::NetworkSignedExchangeReceived(inner) => inner.identifier(),
                CdpEvent::NetworkResponseReceived(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketClosed(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketCreated(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketFrameError(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketFrameReceived(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketFrameSent(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketHandshakeResponseReceived(inner) => inner.identifier(),
                CdpEvent::NetworkWebSocketWillSendHandshakeRequest(inner) => inner.identifier(),
                CdpEvent::NetworkRequestWillBeSentExtraInfo(inner) => inner.identifier(),
                CdpEvent::NetworkResponseReceivedExtraInfo(inner) => inner.identifier(),
                CdpEvent::OverlayInspectNodeRequested(inner) => inner.identifier(),
                CdpEvent::OverlayNodeHighlightRequested(inner) => inner.identifier(),
                CdpEvent::OverlayScreenshotRequested(inner) => inner.identifier(),
                CdpEvent::OverlayInspectModeCanceled(inner) => inner.identifier(),
                CdpEvent::PageDomContentEventFired(inner) => inner.identifier(),
                CdpEvent::PageFileChooserOpened(inner) => inner.identifier(),
                CdpEvent::PageFrameAttached(inner) => inner.identifier(),
                CdpEvent::PageFrameDetached(inner) => inner.identifier(),
                CdpEvent::PageFrameNavigated(inner) => inner.identifier(),
                CdpEvent::PageFrameResized(inner) => inner.identifier(),
                CdpEvent::PageFrameRequestedNavigation(inner) => inner.identifier(),
                CdpEvent::PageFrameStartedLoading(inner) => inner.identifier(),
                CdpEvent::PageFrameStoppedLoading(inner) => inner.identifier(),
                CdpEvent::PageDownloadWillBegin(inner) => inner.identifier(),
                CdpEvent::PageDownloadProgress(inner) => inner.identifier(),
                CdpEvent::PageInterstitialHidden(inner) => inner.identifier(),
                CdpEvent::PageInterstitialShown(inner) => inner.identifier(),
                CdpEvent::PageJavascriptDialogClosed(inner) => inner.identifier(),
                CdpEvent::PageJavascriptDialogOpening(inner) => inner.identifier(),
                CdpEvent::PageLifecycleEvent(inner) => inner.identifier(),
                CdpEvent::PageLoadEventFired(inner) => inner.identifier(),
                CdpEvent::PageNavigatedWithinDocument(inner) => inner.identifier(),
                CdpEvent::PageScreencastFrame(inner) => inner.identifier(),
                CdpEvent::PageScreencastVisibilityChanged(inner) => inner.identifier(),
                CdpEvent::PageWindowOpen(inner) => inner.identifier(),
                CdpEvent::PageCompilationCacheProduced(inner) => inner.identifier(),
                CdpEvent::PerformanceMetrics(inner) => inner.identifier(),
                CdpEvent::SecurityVisibleSecurityStateChanged(inner) => inner.identifier(),
                CdpEvent::SecuritySecurityStateChanged(inner) => inner.identifier(),
                CdpEvent::ServiceWorkerWorkerErrorReported(inner) => inner.identifier(),
                CdpEvent::ServiceWorkerWorkerRegistrationUpdated(inner) => inner.identifier(),
                CdpEvent::ServiceWorkerWorkerVersionUpdated(inner) => inner.identifier(),
                CdpEvent::StorageCacheStorageContentUpdated(inner) => inner.identifier(),
                CdpEvent::StorageCacheStorageListUpdated(inner) => inner.identifier(),
                CdpEvent::StorageIndexedDbContentUpdated(inner) => inner.identifier(),
                CdpEvent::StorageIndexedDbListUpdated(inner) => inner.identifier(),
                CdpEvent::TargetAttachedToTarget(inner) => inner.identifier(),
                CdpEvent::TargetDetachedFromTarget(inner) => inner.identifier(),
                CdpEvent::TargetReceivedMessageFromTarget(inner) => inner.identifier(),
                CdpEvent::TargetTargetCreated(inner) => inner.identifier(),
                CdpEvent::TargetTargetDestroyed(inner) => inner.identifier(),
                CdpEvent::TargetTargetCrashed(inner) => inner.identifier(),
                CdpEvent::TargetTargetInfoChanged(inner) => inner.identifier(),
                CdpEvent::TetheringAccepted(inner) => inner.identifier(),
                CdpEvent::TracingBufferUsage(inner) => inner.identifier(),
                CdpEvent::TracingDataCollected(inner) => inner.identifier(),
                CdpEvent::TracingTracingComplete(inner) => inner.identifier(),
                CdpEvent::FetchRequestPaused(inner) => inner.identifier(),
                CdpEvent::FetchAuthRequired(inner) => inner.identifier(),
                CdpEvent::WebAudioContextCreated(inner) => inner.identifier(),
                CdpEvent::WebAudioContextWillBeDestroyed(inner) => inner.identifier(),
                CdpEvent::WebAudioContextChanged(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioListenerCreated(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioListenerWillBeDestroyed(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioNodeCreated(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioNodeWillBeDestroyed(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioParamCreated(inner) => inner.identifier(),
                CdpEvent::WebAudioAudioParamWillBeDestroyed(inner) => inner.identifier(),
                CdpEvent::WebAudioNodesConnected(inner) => inner.identifier(),
                CdpEvent::WebAudioNodesDisconnected(inner) => inner.identifier(),
                CdpEvent::WebAudioNodeParamConnected(inner) => inner.identifier(),
                CdpEvent::WebAudioNodeParamDisconnected(inner) => inner.identifier(),
                CdpEvent::MediaPlayerPropertiesChanged(inner) => inner.identifier(),
                CdpEvent::MediaPlayerEventsAdded(inner) => inner.identifier(),
                CdpEvent::MediaPlayerMessagesLogged(inner) => inner.identifier(),
                CdpEvent::MediaPlayerErrorsRaised(inner) => inner.identifier(),
                CdpEvent::MediaPlayersCreated(inner) => inner.identifier(),
                _ => self.method.clone(),
            }
        }
    }
    impl chromiumoxide_types::EventMessage for CdpEventMessage {
        fn session_id(&self) -> Option<&str> {
            self.session_id.as_deref()
        }
    }
    #[derive(Debug, Clone, PartialEq)]
    pub enum CdpEvent {
        DebuggerBreakpointResolved(super::js_protocol::debugger::EventBreakpointResolved),
        DebuggerPaused(super::js_protocol::debugger::EventPaused),
        DebuggerResumed(super::js_protocol::debugger::EventResumed),
        DebuggerScriptFailedToParse(Box<super::js_protocol::debugger::EventScriptFailedToParse>),
        DebuggerScriptParsed(Box<super::js_protocol::debugger::EventScriptParsed>),
        HeapProfilerAddHeapSnapshotChunk(
            super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk,
        ),
        HeapProfilerHeapStatsUpdate(super::js_protocol::heap_profiler::EventHeapStatsUpdate),
        HeapProfilerLastSeenObjectId(super::js_protocol::heap_profiler::EventLastSeenObjectId),
        HeapProfilerReportHeapSnapshotProgress(
            super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress,
        ),
        HeapProfilerResetProfiles(super::js_protocol::heap_profiler::EventResetProfiles),
        ProfilerConsoleProfileFinished(super::js_protocol::profiler::EventConsoleProfileFinished),
        ProfilerConsoleProfileStarted(super::js_protocol::profiler::EventConsoleProfileStarted),
        ProfilerPreciseCoverageDeltaUpdate(
            super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate,
        ),
        RuntimeBindingCalled(super::js_protocol::runtime::EventBindingCalled),
        RuntimeConsoleApiCalled(super::js_protocol::runtime::EventConsoleApiCalled),
        RuntimeExceptionRevoked(super::js_protocol::runtime::EventExceptionRevoked),
        RuntimeExceptionThrown(Box<super::js_protocol::runtime::EventExceptionThrown>),
        RuntimeExecutionContextCreated(super::js_protocol::runtime::EventExecutionContextCreated),
        RuntimeExecutionContextDestroyed(
            super::js_protocol::runtime::EventExecutionContextDestroyed,
        ),
        RuntimeExecutionContextsCleared(super::js_protocol::runtime::EventExecutionContextsCleared),
        RuntimeInspectRequested(Box<super::js_protocol::runtime::EventInspectRequested>),
        AnimationAnimationCanceled(super::browser_protocol::animation::EventAnimationCanceled),
        AnimationAnimationCreated(super::browser_protocol::animation::EventAnimationCreated),
        AnimationAnimationStarted(Box<super::browser_protocol::animation::EventAnimationStarted>),
        ApplicationCacheApplicationCacheStatusUpdated(
            super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated,
        ),
        ApplicationCacheNetworkStateUpdated(
            super::browser_protocol::application_cache::EventNetworkStateUpdated,
        ),
        AuditsIssueAdded(Box<super::browser_protocol::audits::EventIssueAdded>),
        BackgroundServiceRecordingStateChanged(
            super::browser_protocol::background_service::EventRecordingStateChanged,
        ),
        BackgroundServiceBackgroundServiceEventReceived(
            super::browser_protocol::background_service::EventBackgroundServiceEventReceived,
        ),
        CssFontsUpdated(Box<super::browser_protocol::css::EventFontsUpdated>),
        CssMediaQueryResultChanged(super::browser_protocol::css::EventMediaQueryResultChanged),
        CssStyleSheetAdded(super::browser_protocol::css::EventStyleSheetAdded),
        CssStyleSheetChanged(super::browser_protocol::css::EventStyleSheetChanged),
        CssStyleSheetRemoved(super::browser_protocol::css::EventStyleSheetRemoved),
        CastSinksUpdated(super::browser_protocol::cast::EventSinksUpdated),
        CastIssueUpdated(super::browser_protocol::cast::EventIssueUpdated),
        DomAttributeModified(super::browser_protocol::dom::EventAttributeModified),
        DomAttributeRemoved(super::browser_protocol::dom::EventAttributeRemoved),
        DomCharacterDataModified(super::browser_protocol::dom::EventCharacterDataModified),
        DomChildNodeCountUpdated(super::browser_protocol::dom::EventChildNodeCountUpdated),
        DomChildNodeInserted(Box<super::browser_protocol::dom::EventChildNodeInserted>),
        DomChildNodeRemoved(super::browser_protocol::dom::EventChildNodeRemoved),
        DomDistributedNodesUpdated(super::browser_protocol::dom::EventDistributedNodesUpdated),
        DomDocumentUpdated(super::browser_protocol::dom::EventDocumentUpdated),
        DomInlineStyleInvalidated(super::browser_protocol::dom::EventInlineStyleInvalidated),
        DomPseudoElementAdded(Box<super::browser_protocol::dom::EventPseudoElementAdded>),
        DomPseudoElementRemoved(super::browser_protocol::dom::EventPseudoElementRemoved),
        DomSetChildNodes(super::browser_protocol::dom::EventSetChildNodes),
        DomShadowRootPopped(super::browser_protocol::dom::EventShadowRootPopped),
        DomShadowRootPushed(Box<super::browser_protocol::dom::EventShadowRootPushed>),
        DomStorageDomStorageItemAdded(
            super::browser_protocol::dom_storage::EventDomStorageItemAdded,
        ),
        DomStorageDomStorageItemRemoved(
            super::browser_protocol::dom_storage::EventDomStorageItemRemoved,
        ),
        DomStorageDomStorageItemUpdated(
            super::browser_protocol::dom_storage::EventDomStorageItemUpdated,
        ),
        DomStorageDomStorageItemsCleared(
            super::browser_protocol::dom_storage::EventDomStorageItemsCleared,
        ),
        DatabaseAddDatabase(super::browser_protocol::database::EventAddDatabase),
        EmulationVirtualTimeBudgetExpired(
            super::browser_protocol::emulation::EventVirtualTimeBudgetExpired,
        ),
        InspectorDetached(super::browser_protocol::inspector::EventDetached),
        InspectorTargetCrashed(super::browser_protocol::inspector::EventTargetCrashed),
        InspectorTargetReloadedAfterCrash(
            super::browser_protocol::inspector::EventTargetReloadedAfterCrash,
        ),
        LayerTreeLayerPainted(super::browser_protocol::layer_tree::EventLayerPainted),
        LayerTreeLayerTreeDidChange(super::browser_protocol::layer_tree::EventLayerTreeDidChange),
        LogEntryAdded(Box<super::browser_protocol::log::EventEntryAdded>),
        NetworkDataReceived(super::browser_protocol::network::EventDataReceived),
        NetworkEventSourceMessageReceived(
            super::browser_protocol::network::EventEventSourceMessageReceived,
        ),
        NetworkLoadingFailed(super::browser_protocol::network::EventLoadingFailed),
        NetworkLoadingFinished(super::browser_protocol::network::EventLoadingFinished),
        NetworkRequestServedFromCache(
            super::browser_protocol::network::EventRequestServedFromCache,
        ),
        NetworkRequestWillBeSent(Box<super::browser_protocol::network::EventRequestWillBeSent>),
        NetworkResourceChangedPriority(
            super::browser_protocol::network::EventResourceChangedPriority,
        ),
        NetworkSignedExchangeReceived(
            Box<super::browser_protocol::network::EventSignedExchangeReceived>,
        ),
        NetworkResponseReceived(Box<super::browser_protocol::network::EventResponseReceived>),
        NetworkWebSocketClosed(super::browser_protocol::network::EventWebSocketClosed),
        NetworkWebSocketCreated(Box<super::browser_protocol::network::EventWebSocketCreated>),
        NetworkWebSocketFrameError(super::browser_protocol::network::EventWebSocketFrameError),
        NetworkWebSocketFrameReceived(
            super::browser_protocol::network::EventWebSocketFrameReceived,
        ),
        NetworkWebSocketFrameSent(super::browser_protocol::network::EventWebSocketFrameSent),
        NetworkWebSocketHandshakeResponseReceived(
            super::browser_protocol::network::EventWebSocketHandshakeResponseReceived,
        ),
        NetworkWebSocketWillSendHandshakeRequest(
            super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest,
        ),
        NetworkRequestWillBeSentExtraInfo(
            super::browser_protocol::network::EventRequestWillBeSentExtraInfo,
        ),
        NetworkResponseReceivedExtraInfo(
            super::browser_protocol::network::EventResponseReceivedExtraInfo,
        ),
        OverlayInspectNodeRequested(super::browser_protocol::overlay::EventInspectNodeRequested),
        OverlayNodeHighlightRequested(
            super::browser_protocol::overlay::EventNodeHighlightRequested,
        ),
        OverlayScreenshotRequested(super::browser_protocol::overlay::EventScreenshotRequested),
        OverlayInspectModeCanceled(super::browser_protocol::overlay::EventInspectModeCanceled),
        PageDomContentEventFired(super::browser_protocol::page::EventDomContentEventFired),
        PageFileChooserOpened(super::browser_protocol::page::EventFileChooserOpened),
        PageFrameAttached(super::browser_protocol::page::EventFrameAttached),
        PageFrameDetached(super::browser_protocol::page::EventFrameDetached),
        PageFrameNavigated(Box<super::browser_protocol::page::EventFrameNavigated>),
        PageFrameResized(super::browser_protocol::page::EventFrameResized),
        PageFrameRequestedNavigation(super::browser_protocol::page::EventFrameRequestedNavigation),
        PageFrameStartedLoading(super::browser_protocol::page::EventFrameStartedLoading),
        PageFrameStoppedLoading(super::browser_protocol::page::EventFrameStoppedLoading),
        PageDownloadWillBegin(super::browser_protocol::page::EventDownloadWillBegin),
        PageDownloadProgress(super::browser_protocol::page::EventDownloadProgress),
        PageInterstitialHidden(super::browser_protocol::page::EventInterstitialHidden),
        PageInterstitialShown(super::browser_protocol::page::EventInterstitialShown),
        PageJavascriptDialogClosed(super::browser_protocol::page::EventJavascriptDialogClosed),
        PageJavascriptDialogOpening(super::browser_protocol::page::EventJavascriptDialogOpening),
        PageLifecycleEvent(super::browser_protocol::page::EventLifecycleEvent),
        PageLoadEventFired(super::browser_protocol::page::EventLoadEventFired),
        PageNavigatedWithinDocument(super::browser_protocol::page::EventNavigatedWithinDocument),
        PageScreencastFrame(super::browser_protocol::page::EventScreencastFrame),
        PageScreencastVisibilityChanged(
            super::browser_protocol::page::EventScreencastVisibilityChanged,
        ),
        PageWindowOpen(super::browser_protocol::page::EventWindowOpen),
        PageCompilationCacheProduced(super::browser_protocol::page::EventCompilationCacheProduced),
        PerformanceMetrics(super::browser_protocol::performance::EventMetrics),
        SecurityVisibleSecurityStateChanged(
            Box<super::browser_protocol::security::EventVisibleSecurityStateChanged>,
        ),
        SecuritySecurityStateChanged(super::browser_protocol::security::EventSecurityStateChanged),
        ServiceWorkerWorkerErrorReported(
            super::browser_protocol::service_worker::EventWorkerErrorReported,
        ),
        ServiceWorkerWorkerRegistrationUpdated(
            super::browser_protocol::service_worker::EventWorkerRegistrationUpdated,
        ),
        ServiceWorkerWorkerVersionUpdated(
            super::browser_protocol::service_worker::EventWorkerVersionUpdated,
        ),
        StorageCacheStorageContentUpdated(
            super::browser_protocol::storage::EventCacheStorageContentUpdated,
        ),
        StorageCacheStorageListUpdated(
            super::browser_protocol::storage::EventCacheStorageListUpdated,
        ),
        StorageIndexedDbContentUpdated(
            super::browser_protocol::storage::EventIndexedDbContentUpdated,
        ),
        StorageIndexedDbListUpdated(super::browser_protocol::storage::EventIndexedDbListUpdated),
        TargetAttachedToTarget(super::browser_protocol::target::EventAttachedToTarget),
        TargetDetachedFromTarget(super::browser_protocol::target::EventDetachedFromTarget),
        TargetReceivedMessageFromTarget(
            super::browser_protocol::target::EventReceivedMessageFromTarget,
        ),
        TargetTargetCreated(super::browser_protocol::target::EventTargetCreated),
        TargetTargetDestroyed(super::browser_protocol::target::EventTargetDestroyed),
        TargetTargetCrashed(super::browser_protocol::target::EventTargetCrashed),
        TargetTargetInfoChanged(super::browser_protocol::target::EventTargetInfoChanged),
        TetheringAccepted(super::browser_protocol::tethering::EventAccepted),
        TracingBufferUsage(super::browser_protocol::tracing::EventBufferUsage),
        TracingDataCollected(super::browser_protocol::tracing::EventDataCollected),
        TracingTracingComplete(super::browser_protocol::tracing::EventTracingComplete),
        FetchRequestPaused(Box<super::browser_protocol::fetch::EventRequestPaused>),
        FetchAuthRequired(Box<super::browser_protocol::fetch::EventAuthRequired>),
        WebAudioContextCreated(super::browser_protocol::web_audio::EventContextCreated),
        WebAudioContextWillBeDestroyed(
            super::browser_protocol::web_audio::EventContextWillBeDestroyed,
        ),
        WebAudioContextChanged(super::browser_protocol::web_audio::EventContextChanged),
        WebAudioAudioListenerCreated(super::browser_protocol::web_audio::EventAudioListenerCreated),
        WebAudioAudioListenerWillBeDestroyed(
            super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed,
        ),
        WebAudioAudioNodeCreated(super::browser_protocol::web_audio::EventAudioNodeCreated),
        WebAudioAudioNodeWillBeDestroyed(
            super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed,
        ),
        WebAudioAudioParamCreated(super::browser_protocol::web_audio::EventAudioParamCreated),
        WebAudioAudioParamWillBeDestroyed(
            super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed,
        ),
        WebAudioNodesConnected(super::browser_protocol::web_audio::EventNodesConnected),
        WebAudioNodesDisconnected(super::browser_protocol::web_audio::EventNodesDisconnected),
        WebAudioNodeParamConnected(super::browser_protocol::web_audio::EventNodeParamConnected),
        WebAudioNodeParamDisconnected(
            super::browser_protocol::web_audio::EventNodeParamDisconnected,
        ),
        MediaPlayerPropertiesChanged(super::browser_protocol::media::EventPlayerPropertiesChanged),
        MediaPlayerEventsAdded(super::browser_protocol::media::EventPlayerEventsAdded),
        MediaPlayerMessagesLogged(super::browser_protocol::media::EventPlayerMessagesLogged),
        MediaPlayerErrorsRaised(super::browser_protocol::media::EventPlayerErrorsRaised),
        MediaPlayersCreated(super::browser_protocol::media::EventPlayersCreated),
        Other(serde_json::Value),
    }
    impl CdpEvent {
        pub fn other(other: serde_json::Value) -> Self {
            CdpEvent::Other(other)
        }
        #[doc = r" Serializes the event as Json"]
        pub fn into_json(self) -> serde_json::Result<serde_json::Value> {
            match self {
                CdpEvent::DebuggerBreakpointResolved(inner) => serde_json::to_value(inner),
                CdpEvent::DebuggerPaused(inner) => serde_json::to_value(inner),
                CdpEvent::DebuggerResumed(inner) => serde_json::to_value(inner),
                CdpEvent::DebuggerScriptFailedToParse(inner) => serde_json::to_value(inner),
                CdpEvent::DebuggerScriptParsed(inner) => serde_json::to_value(inner),
                CdpEvent::HeapProfilerAddHeapSnapshotChunk(inner) => serde_json::to_value(inner),
                CdpEvent::HeapProfilerHeapStatsUpdate(inner) => serde_json::to_value(inner),
                CdpEvent::HeapProfilerLastSeenObjectId(inner) => serde_json::to_value(inner),
                CdpEvent::HeapProfilerReportHeapSnapshotProgress(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::HeapProfilerResetProfiles(inner) => serde_json::to_value(inner),
                CdpEvent::ProfilerConsoleProfileFinished(inner) => serde_json::to_value(inner),
                CdpEvent::ProfilerConsoleProfileStarted(inner) => serde_json::to_value(inner),
                CdpEvent::ProfilerPreciseCoverageDeltaUpdate(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeBindingCalled(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeConsoleApiCalled(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeExceptionRevoked(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeExceptionThrown(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeExecutionContextCreated(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeExecutionContextDestroyed(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeExecutionContextsCleared(inner) => serde_json::to_value(inner),
                CdpEvent::RuntimeInspectRequested(inner) => serde_json::to_value(inner),
                CdpEvent::AnimationAnimationCanceled(inner) => serde_json::to_value(inner),
                CdpEvent::AnimationAnimationCreated(inner) => serde_json::to_value(inner),
                CdpEvent::AnimationAnimationStarted(inner) => serde_json::to_value(inner),
                CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::ApplicationCacheNetworkStateUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::AuditsIssueAdded(inner) => serde_json::to_value(inner),
                CdpEvent::BackgroundServiceRecordingStateChanged(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::BackgroundServiceBackgroundServiceEventReceived(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::CssFontsUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::CssMediaQueryResultChanged(inner) => serde_json::to_value(inner),
                CdpEvent::CssStyleSheetAdded(inner) => serde_json::to_value(inner),
                CdpEvent::CssStyleSheetChanged(inner) => serde_json::to_value(inner),
                CdpEvent::CssStyleSheetRemoved(inner) => serde_json::to_value(inner),
                CdpEvent::CastSinksUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::CastIssueUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::DomAttributeModified(inner) => serde_json::to_value(inner),
                CdpEvent::DomAttributeRemoved(inner) => serde_json::to_value(inner),
                CdpEvent::DomCharacterDataModified(inner) => serde_json::to_value(inner),
                CdpEvent::DomChildNodeCountUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::DomChildNodeInserted(inner) => serde_json::to_value(inner),
                CdpEvent::DomChildNodeRemoved(inner) => serde_json::to_value(inner),
                CdpEvent::DomDistributedNodesUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::DomDocumentUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::DomInlineStyleInvalidated(inner) => serde_json::to_value(inner),
                CdpEvent::DomPseudoElementAdded(inner) => serde_json::to_value(inner),
                CdpEvent::DomPseudoElementRemoved(inner) => serde_json::to_value(inner),
                CdpEvent::DomSetChildNodes(inner) => serde_json::to_value(inner),
                CdpEvent::DomShadowRootPopped(inner) => serde_json::to_value(inner),
                CdpEvent::DomShadowRootPushed(inner) => serde_json::to_value(inner),
                CdpEvent::DomStorageDomStorageItemAdded(inner) => serde_json::to_value(inner),
                CdpEvent::DomStorageDomStorageItemRemoved(inner) => serde_json::to_value(inner),
                CdpEvent::DomStorageDomStorageItemUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::DomStorageDomStorageItemsCleared(inner) => serde_json::to_value(inner),
                CdpEvent::DatabaseAddDatabase(inner) => serde_json::to_value(inner),
                CdpEvent::EmulationVirtualTimeBudgetExpired(inner) => serde_json::to_value(inner),
                CdpEvent::InspectorDetached(inner) => serde_json::to_value(inner),
                CdpEvent::InspectorTargetCrashed(inner) => serde_json::to_value(inner),
                CdpEvent::InspectorTargetReloadedAfterCrash(inner) => serde_json::to_value(inner),
                CdpEvent::LayerTreeLayerPainted(inner) => serde_json::to_value(inner),
                CdpEvent::LayerTreeLayerTreeDidChange(inner) => serde_json::to_value(inner),
                CdpEvent::LogEntryAdded(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkDataReceived(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkEventSourceMessageReceived(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkLoadingFailed(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkLoadingFinished(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkRequestServedFromCache(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkRequestWillBeSent(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkResourceChangedPriority(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkSignedExchangeReceived(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkResponseReceived(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketClosed(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketCreated(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketFrameError(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketFrameReceived(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketFrameSent(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkWebSocketHandshakeResponseReceived(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::NetworkWebSocketWillSendHandshakeRequest(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::NetworkRequestWillBeSentExtraInfo(inner) => serde_json::to_value(inner),
                CdpEvent::NetworkResponseReceivedExtraInfo(inner) => serde_json::to_value(inner),
                CdpEvent::OverlayInspectNodeRequested(inner) => serde_json::to_value(inner),
                CdpEvent::OverlayNodeHighlightRequested(inner) => serde_json::to_value(inner),
                CdpEvent::OverlayScreenshotRequested(inner) => serde_json::to_value(inner),
                CdpEvent::OverlayInspectModeCanceled(inner) => serde_json::to_value(inner),
                CdpEvent::PageDomContentEventFired(inner) => serde_json::to_value(inner),
                CdpEvent::PageFileChooserOpened(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameAttached(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameDetached(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameNavigated(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameResized(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameRequestedNavigation(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameStartedLoading(inner) => serde_json::to_value(inner),
                CdpEvent::PageFrameStoppedLoading(inner) => serde_json::to_value(inner),
                CdpEvent::PageDownloadWillBegin(inner) => serde_json::to_value(inner),
                CdpEvent::PageDownloadProgress(inner) => serde_json::to_value(inner),
                CdpEvent::PageInterstitialHidden(inner) => serde_json::to_value(inner),
                CdpEvent::PageInterstitialShown(inner) => serde_json::to_value(inner),
                CdpEvent::PageJavascriptDialogClosed(inner) => serde_json::to_value(inner),
                CdpEvent::PageJavascriptDialogOpening(inner) => serde_json::to_value(inner),
                CdpEvent::PageLifecycleEvent(inner) => serde_json::to_value(inner),
                CdpEvent::PageLoadEventFired(inner) => serde_json::to_value(inner),
                CdpEvent::PageNavigatedWithinDocument(inner) => serde_json::to_value(inner),
                CdpEvent::PageScreencastFrame(inner) => serde_json::to_value(inner),
                CdpEvent::PageScreencastVisibilityChanged(inner) => serde_json::to_value(inner),
                CdpEvent::PageWindowOpen(inner) => serde_json::to_value(inner),
                CdpEvent::PageCompilationCacheProduced(inner) => serde_json::to_value(inner),
                CdpEvent::PerformanceMetrics(inner) => serde_json::to_value(inner),
                CdpEvent::SecurityVisibleSecurityStateChanged(inner) => serde_json::to_value(inner),
                CdpEvent::SecuritySecurityStateChanged(inner) => serde_json::to_value(inner),
                CdpEvent::ServiceWorkerWorkerErrorReported(inner) => serde_json::to_value(inner),
                CdpEvent::ServiceWorkerWorkerRegistrationUpdated(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::ServiceWorkerWorkerVersionUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::StorageCacheStorageContentUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::StorageCacheStorageListUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::StorageIndexedDbContentUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::StorageIndexedDbListUpdated(inner) => serde_json::to_value(inner),
                CdpEvent::TargetAttachedToTarget(inner) => serde_json::to_value(inner),
                CdpEvent::TargetDetachedFromTarget(inner) => serde_json::to_value(inner),
                CdpEvent::TargetReceivedMessageFromTarget(inner) => serde_json::to_value(inner),
                CdpEvent::TargetTargetCreated(inner) => serde_json::to_value(inner),
                CdpEvent::TargetTargetDestroyed(inner) => serde_json::to_value(inner),
                CdpEvent::TargetTargetCrashed(inner) => serde_json::to_value(inner),
                CdpEvent::TargetTargetInfoChanged(inner) => serde_json::to_value(inner),
                CdpEvent::TetheringAccepted(inner) => serde_json::to_value(inner),
                CdpEvent::TracingBufferUsage(inner) => serde_json::to_value(inner),
                CdpEvent::TracingDataCollected(inner) => serde_json::to_value(inner),
                CdpEvent::TracingTracingComplete(inner) => serde_json::to_value(inner),
                CdpEvent::FetchRequestPaused(inner) => serde_json::to_value(inner),
                CdpEvent::FetchAuthRequired(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioContextCreated(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioContextWillBeDestroyed(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioContextChanged(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioAudioListenerCreated(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioAudioListenerWillBeDestroyed(inner) => {
                    serde_json::to_value(inner)
                }
                CdpEvent::WebAudioAudioNodeCreated(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioAudioNodeWillBeDestroyed(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioAudioParamCreated(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioAudioParamWillBeDestroyed(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioNodesConnected(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioNodesDisconnected(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioNodeParamConnected(inner) => serde_json::to_value(inner),
                CdpEvent::WebAudioNodeParamDisconnected(inner) => serde_json::to_value(inner),
                CdpEvent::MediaPlayerPropertiesChanged(inner) => serde_json::to_value(inner),
                CdpEvent::MediaPlayerEventsAdded(inner) => serde_json::to_value(inner),
                CdpEvent::MediaPlayerMessagesLogged(inner) => serde_json::to_value(inner),
                CdpEvent::MediaPlayerErrorsRaised(inner) => serde_json::to_value(inner),
                CdpEvent::MediaPlayersCreated(inner) => serde_json::to_value(inner),
                CdpEvent::Other(val) => Ok(val),
            }
        }
        pub fn into_event(self) -> ::std::result::Result<Box<dyn super::Event>, serde_json::Value> {
            match self {
                CdpEvent::DebuggerBreakpointResolved(event) => Ok(Box::new(event)),
                CdpEvent::DebuggerPaused(event) => Ok(Box::new(event)),
                CdpEvent::DebuggerResumed(event) => Ok(Box::new(event)),
                CdpEvent::DebuggerScriptFailedToParse(event) => Ok(Box::new(*event)),
                CdpEvent::DebuggerScriptParsed(event) => Ok(Box::new(*event)),
                CdpEvent::HeapProfilerAddHeapSnapshotChunk(event) => Ok(Box::new(event)),
                CdpEvent::HeapProfilerHeapStatsUpdate(event) => Ok(Box::new(event)),
                CdpEvent::HeapProfilerLastSeenObjectId(event) => Ok(Box::new(event)),
                CdpEvent::HeapProfilerReportHeapSnapshotProgress(event) => Ok(Box::new(event)),
                CdpEvent::HeapProfilerResetProfiles(event) => Ok(Box::new(event)),
                CdpEvent::ProfilerConsoleProfileFinished(event) => Ok(Box::new(event)),
                CdpEvent::ProfilerConsoleProfileStarted(event) => Ok(Box::new(event)),
                CdpEvent::ProfilerPreciseCoverageDeltaUpdate(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeBindingCalled(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeConsoleApiCalled(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeExceptionRevoked(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeExceptionThrown(event) => Ok(Box::new(*event)),
                CdpEvent::RuntimeExecutionContextCreated(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeExecutionContextDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeExecutionContextsCleared(event) => Ok(Box::new(event)),
                CdpEvent::RuntimeInspectRequested(event) => Ok(Box::new(*event)),
                CdpEvent::AnimationAnimationCanceled(event) => Ok(Box::new(event)),
                CdpEvent::AnimationAnimationCreated(event) => Ok(Box::new(event)),
                CdpEvent::AnimationAnimationStarted(event) => Ok(Box::new(*event)),
                CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(event) => {
                    Ok(Box::new(event))
                }
                CdpEvent::ApplicationCacheNetworkStateUpdated(event) => Ok(Box::new(event)),
                CdpEvent::AuditsIssueAdded(event) => Ok(Box::new(*event)),
                CdpEvent::BackgroundServiceRecordingStateChanged(event) => Ok(Box::new(event)),
                CdpEvent::BackgroundServiceBackgroundServiceEventReceived(event) => {
                    Ok(Box::new(event))
                }
                CdpEvent::CssFontsUpdated(event) => Ok(Box::new(*event)),
                CdpEvent::CssMediaQueryResultChanged(event) => Ok(Box::new(event)),
                CdpEvent::CssStyleSheetAdded(event) => Ok(Box::new(event)),
                CdpEvent::CssStyleSheetChanged(event) => Ok(Box::new(event)),
                CdpEvent::CssStyleSheetRemoved(event) => Ok(Box::new(event)),
                CdpEvent::CastSinksUpdated(event) => Ok(Box::new(event)),
                CdpEvent::CastIssueUpdated(event) => Ok(Box::new(event)),
                CdpEvent::DomAttributeModified(event) => Ok(Box::new(event)),
                CdpEvent::DomAttributeRemoved(event) => Ok(Box::new(event)),
                CdpEvent::DomCharacterDataModified(event) => Ok(Box::new(event)),
                CdpEvent::DomChildNodeCountUpdated(event) => Ok(Box::new(event)),
                CdpEvent::DomChildNodeInserted(event) => Ok(Box::new(*event)),
                CdpEvent::DomChildNodeRemoved(event) => Ok(Box::new(event)),
                CdpEvent::DomDistributedNodesUpdated(event) => Ok(Box::new(event)),
                CdpEvent::DomDocumentUpdated(event) => Ok(Box::new(event)),
                CdpEvent::DomInlineStyleInvalidated(event) => Ok(Box::new(event)),
                CdpEvent::DomPseudoElementAdded(event) => Ok(Box::new(*event)),
                CdpEvent::DomPseudoElementRemoved(event) => Ok(Box::new(event)),
                CdpEvent::DomSetChildNodes(event) => Ok(Box::new(event)),
                CdpEvent::DomShadowRootPopped(event) => Ok(Box::new(event)),
                CdpEvent::DomShadowRootPushed(event) => Ok(Box::new(*event)),
                CdpEvent::DomStorageDomStorageItemAdded(event) => Ok(Box::new(event)),
                CdpEvent::DomStorageDomStorageItemRemoved(event) => Ok(Box::new(event)),
                CdpEvent::DomStorageDomStorageItemUpdated(event) => Ok(Box::new(event)),
                CdpEvent::DomStorageDomStorageItemsCleared(event) => Ok(Box::new(event)),
                CdpEvent::DatabaseAddDatabase(event) => Ok(Box::new(event)),
                CdpEvent::EmulationVirtualTimeBudgetExpired(event) => Ok(Box::new(event)),
                CdpEvent::InspectorDetached(event) => Ok(Box::new(event)),
                CdpEvent::InspectorTargetCrashed(event) => Ok(Box::new(event)),
                CdpEvent::InspectorTargetReloadedAfterCrash(event) => Ok(Box::new(event)),
                CdpEvent::LayerTreeLayerPainted(event) => Ok(Box::new(event)),
                CdpEvent::LayerTreeLayerTreeDidChange(event) => Ok(Box::new(event)),
                CdpEvent::LogEntryAdded(event) => Ok(Box::new(*event)),
                CdpEvent::NetworkDataReceived(event) => Ok(Box::new(event)),
                CdpEvent::NetworkEventSourceMessageReceived(event) => Ok(Box::new(event)),
                CdpEvent::NetworkLoadingFailed(event) => Ok(Box::new(event)),
                CdpEvent::NetworkLoadingFinished(event) => Ok(Box::new(event)),
                CdpEvent::NetworkRequestServedFromCache(event) => Ok(Box::new(event)),
                CdpEvent::NetworkRequestWillBeSent(event) => Ok(Box::new(*event)),
                CdpEvent::NetworkResourceChangedPriority(event) => Ok(Box::new(event)),
                CdpEvent::NetworkSignedExchangeReceived(event) => Ok(Box::new(*event)),
                CdpEvent::NetworkResponseReceived(event) => Ok(Box::new(*event)),
                CdpEvent::NetworkWebSocketClosed(event) => Ok(Box::new(event)),
                CdpEvent::NetworkWebSocketCreated(event) => Ok(Box::new(*event)),
                CdpEvent::NetworkWebSocketFrameError(event) => Ok(Box::new(event)),
                CdpEvent::NetworkWebSocketFrameReceived(event) => Ok(Box::new(event)),
                CdpEvent::NetworkWebSocketFrameSent(event) => Ok(Box::new(event)),
                CdpEvent::NetworkWebSocketHandshakeResponseReceived(event) => Ok(Box::new(event)),
                CdpEvent::NetworkWebSocketWillSendHandshakeRequest(event) => Ok(Box::new(event)),
                CdpEvent::NetworkRequestWillBeSentExtraInfo(event) => Ok(Box::new(event)),
                CdpEvent::NetworkResponseReceivedExtraInfo(event) => Ok(Box::new(event)),
                CdpEvent::OverlayInspectNodeRequested(event) => Ok(Box::new(event)),
                CdpEvent::OverlayNodeHighlightRequested(event) => Ok(Box::new(event)),
                CdpEvent::OverlayScreenshotRequested(event) => Ok(Box::new(event)),
                CdpEvent::OverlayInspectModeCanceled(event) => Ok(Box::new(event)),
                CdpEvent::PageDomContentEventFired(event) => Ok(Box::new(event)),
                CdpEvent::PageFileChooserOpened(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameAttached(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameDetached(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameNavigated(event) => Ok(Box::new(*event)),
                CdpEvent::PageFrameResized(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameRequestedNavigation(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameStartedLoading(event) => Ok(Box::new(event)),
                CdpEvent::PageFrameStoppedLoading(event) => Ok(Box::new(event)),
                CdpEvent::PageDownloadWillBegin(event) => Ok(Box::new(event)),
                CdpEvent::PageDownloadProgress(event) => Ok(Box::new(event)),
                CdpEvent::PageInterstitialHidden(event) => Ok(Box::new(event)),
                CdpEvent::PageInterstitialShown(event) => Ok(Box::new(event)),
                CdpEvent::PageJavascriptDialogClosed(event) => Ok(Box::new(event)),
                CdpEvent::PageJavascriptDialogOpening(event) => Ok(Box::new(event)),
                CdpEvent::PageLifecycleEvent(event) => Ok(Box::new(event)),
                CdpEvent::PageLoadEventFired(event) => Ok(Box::new(event)),
                CdpEvent::PageNavigatedWithinDocument(event) => Ok(Box::new(event)),
                CdpEvent::PageScreencastFrame(event) => Ok(Box::new(event)),
                CdpEvent::PageScreencastVisibilityChanged(event) => Ok(Box::new(event)),
                CdpEvent::PageWindowOpen(event) => Ok(Box::new(event)),
                CdpEvent::PageCompilationCacheProduced(event) => Ok(Box::new(event)),
                CdpEvent::PerformanceMetrics(event) => Ok(Box::new(event)),
                CdpEvent::SecurityVisibleSecurityStateChanged(event) => Ok(Box::new(*event)),
                CdpEvent::SecuritySecurityStateChanged(event) => Ok(Box::new(event)),
                CdpEvent::ServiceWorkerWorkerErrorReported(event) => Ok(Box::new(event)),
                CdpEvent::ServiceWorkerWorkerRegistrationUpdated(event) => Ok(Box::new(event)),
                CdpEvent::ServiceWorkerWorkerVersionUpdated(event) => Ok(Box::new(event)),
                CdpEvent::StorageCacheStorageContentUpdated(event) => Ok(Box::new(event)),
                CdpEvent::StorageCacheStorageListUpdated(event) => Ok(Box::new(event)),
                CdpEvent::StorageIndexedDbContentUpdated(event) => Ok(Box::new(event)),
                CdpEvent::StorageIndexedDbListUpdated(event) => Ok(Box::new(event)),
                CdpEvent::TargetAttachedToTarget(event) => Ok(Box::new(event)),
                CdpEvent::TargetDetachedFromTarget(event) => Ok(Box::new(event)),
                CdpEvent::TargetReceivedMessageFromTarget(event) => Ok(Box::new(event)),
                CdpEvent::TargetTargetCreated(event) => Ok(Box::new(event)),
                CdpEvent::TargetTargetDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::TargetTargetCrashed(event) => Ok(Box::new(event)),
                CdpEvent::TargetTargetInfoChanged(event) => Ok(Box::new(event)),
                CdpEvent::TetheringAccepted(event) => Ok(Box::new(event)),
                CdpEvent::TracingBufferUsage(event) => Ok(Box::new(event)),
                CdpEvent::TracingDataCollected(event) => Ok(Box::new(event)),
                CdpEvent::TracingTracingComplete(event) => Ok(Box::new(event)),
                CdpEvent::FetchRequestPaused(event) => Ok(Box::new(*event)),
                CdpEvent::FetchAuthRequired(event) => Ok(Box::new(*event)),
                CdpEvent::WebAudioContextCreated(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioContextWillBeDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioContextChanged(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioListenerCreated(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioListenerWillBeDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioNodeCreated(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioNodeWillBeDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioParamCreated(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioAudioParamWillBeDestroyed(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioNodesConnected(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioNodesDisconnected(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioNodeParamConnected(event) => Ok(Box::new(event)),
                CdpEvent::WebAudioNodeParamDisconnected(event) => Ok(Box::new(event)),
                CdpEvent::MediaPlayerPropertiesChanged(event) => Ok(Box::new(event)),
                CdpEvent::MediaPlayerEventsAdded(event) => Ok(Box::new(event)),
                CdpEvent::MediaPlayerMessagesLogged(event) => Ok(Box::new(event)),
                CdpEvent::MediaPlayerErrorsRaised(event) => Ok(Box::new(event)),
                CdpEvent::MediaPlayersCreated(event) => Ok(Box::new(event)),
                CdpEvent::Other(other) => Err(other),
            }
        }
    }
    use serde::de::{self, Deserializer, MapAccess, Visitor};
    use std::fmt;
    impl<'de> Deserialize<'de> for CdpEventMessage {
        fn deserialize<D>(deserializer: D) -> Result<Self, <D as Deserializer<'de>>::Error>
        where
            D: Deserializer<'de>,
        {
            enum Field {
                Method,
                Session,
                Params,
            }
            impl<'de> Deserialize<'de> for Field {
                fn deserialize<D>(deserializer: D) -> Result<Field, D::Error>
                where
                    D: Deserializer<'de>,
                {
                    struct FieldVisitor;
                    impl<'de> Visitor<'de> for FieldVisitor {
                        type Value = Field;
                        fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                            formatter.write_str("`method` or `sessionId` or `params`")
                        }
                        fn visit_str<E>(self, value: &str) -> Result<Field, E>
                        where
                            E: de::Error,
                        {
                            match value {
                                "method" => Ok(Field::Method),
                                "sessionId" => Ok(Field::Session),
                                "params" => Ok(Field::Params),
                                _ => Err(de::Error::unknown_field(value, FIELDS)),
                            }
                        }
                    }
                    deserializer.deserialize_identifier(FieldVisitor)
                }
            }
            struct MessageVisitor;
            impl<'de> Visitor<'de> for MessageVisitor {
                type Value = CdpEventMessage;
                fn expecting(&self, formatter: &mut fmt::Formatter) -> fmt::Result {
                    formatter.write_str("struct CdpEventMessage")
                }
                fn visit_map<A>(self, mut map: A) -> Result<Self::Value, A::Error>
                where
                    A: MapAccess<'de>,
                {
                    let mut method = None;
                    let mut session_id = None;
                    let mut params = None;
                    while let Some(key) = map.next_key()? {
                        match key {
                            Field::Method => {
                                if method.is_some() {
                                    return Err(de::Error::duplicate_field("method"));
                                }
                                method = Some(map.next_value::<String>()?);
                            }
                            Field::Session => {
                                if session_id.is_some() {
                                    return Err(de::Error::duplicate_field("sessionId"));
                                }
                                session_id = Some(map.next_value::<String>()?);
                            }
                            Field::Params => {
                                if params.is_some() {
                                    return Err(de::Error::duplicate_field("params"));
                                }
                                params = Some (match method . as_ref () . ok_or_else (|| de :: Error :: missing_field ("params")) ? . as_str () { super :: js_protocol :: debugger :: EventBreakpointResolved :: IDENTIFIER => CdpEvent :: DebuggerBreakpointResolved (map . next_value :: < super :: js_protocol :: debugger :: EventBreakpointResolved > () ?) , super :: js_protocol :: debugger :: EventPaused :: IDENTIFIER => CdpEvent :: DebuggerPaused (map . next_value :: < super :: js_protocol :: debugger :: EventPaused > () ?) , super :: js_protocol :: debugger :: EventResumed :: IDENTIFIER => CdpEvent :: DebuggerResumed (map . next_value :: < super :: js_protocol :: debugger :: EventResumed > () ?) , super :: js_protocol :: debugger :: EventScriptFailedToParse :: IDENTIFIER => CdpEvent :: DebuggerScriptFailedToParse (Box :: new (map . next_value :: < super :: js_protocol :: debugger :: EventScriptFailedToParse > () ?)) , super :: js_protocol :: debugger :: EventScriptParsed :: IDENTIFIER => CdpEvent :: DebuggerScriptParsed (Box :: new (map . next_value :: < super :: js_protocol :: debugger :: EventScriptParsed > () ?)) , super :: js_protocol :: heap_profiler :: EventAddHeapSnapshotChunk :: IDENTIFIER => CdpEvent :: HeapProfilerAddHeapSnapshotChunk (map . next_value :: < super :: js_protocol :: heap_profiler :: EventAddHeapSnapshotChunk > () ?) , super :: js_protocol :: heap_profiler :: EventHeapStatsUpdate :: IDENTIFIER => CdpEvent :: HeapProfilerHeapStatsUpdate (map . next_value :: < super :: js_protocol :: heap_profiler :: EventHeapStatsUpdate > () ?) , super :: js_protocol :: heap_profiler :: EventLastSeenObjectId :: IDENTIFIER => CdpEvent :: HeapProfilerLastSeenObjectId (map . next_value :: < super :: js_protocol :: heap_profiler :: EventLastSeenObjectId > () ?) , super :: js_protocol :: heap_profiler :: EventReportHeapSnapshotProgress :: IDENTIFIER => CdpEvent :: HeapProfilerReportHeapSnapshotProgress (map . next_value :: < super :: js_protocol :: heap_profiler :: EventReportHeapSnapshotProgress > () ?) , super :: js_protocol :: heap_profiler :: EventResetProfiles :: IDENTIFIER => CdpEvent :: HeapProfilerResetProfiles (map . next_value :: < super :: js_protocol :: heap_profiler :: EventResetProfiles > () ?) , super :: js_protocol :: profiler :: EventConsoleProfileFinished :: IDENTIFIER => CdpEvent :: ProfilerConsoleProfileFinished (map . next_value :: < super :: js_protocol :: profiler :: EventConsoleProfileFinished > () ?) , super :: js_protocol :: profiler :: EventConsoleProfileStarted :: IDENTIFIER => CdpEvent :: ProfilerConsoleProfileStarted (map . next_value :: < super :: js_protocol :: profiler :: EventConsoleProfileStarted > () ?) , super :: js_protocol :: profiler :: EventPreciseCoverageDeltaUpdate :: IDENTIFIER => CdpEvent :: ProfilerPreciseCoverageDeltaUpdate (map . next_value :: < super :: js_protocol :: profiler :: EventPreciseCoverageDeltaUpdate > () ?) , super :: js_protocol :: runtime :: EventBindingCalled :: IDENTIFIER => CdpEvent :: RuntimeBindingCalled (map . next_value :: < super :: js_protocol :: runtime :: EventBindingCalled > () ?) , super :: js_protocol :: runtime :: EventConsoleApiCalled :: IDENTIFIER => CdpEvent :: RuntimeConsoleApiCalled (map . next_value :: < super :: js_protocol :: runtime :: EventConsoleApiCalled > () ?) , super :: js_protocol :: runtime :: EventExceptionRevoked :: IDENTIFIER => CdpEvent :: RuntimeExceptionRevoked (map . next_value :: < super :: js_protocol :: runtime :: EventExceptionRevoked > () ?) , super :: js_protocol :: runtime :: EventExceptionThrown :: IDENTIFIER => CdpEvent :: RuntimeExceptionThrown (Box :: new (map . next_value :: < super :: js_protocol :: runtime :: EventExceptionThrown > () ?)) , super :: js_protocol :: runtime :: EventExecutionContextCreated :: IDENTIFIER => CdpEvent :: RuntimeExecutionContextCreated (map . next_value :: < super :: js_protocol :: runtime :: EventExecutionContextCreated > () ?) , super :: js_protocol :: runtime :: EventExecutionContextDestroyed :: IDENTIFIER => CdpEvent :: RuntimeExecutionContextDestroyed (map . next_value :: < super :: js_protocol :: runtime :: EventExecutionContextDestroyed > () ?) , super :: js_protocol :: runtime :: EventExecutionContextsCleared :: IDENTIFIER => CdpEvent :: RuntimeExecutionContextsCleared (map . next_value :: < super :: js_protocol :: runtime :: EventExecutionContextsCleared > () ?) , super :: js_protocol :: runtime :: EventInspectRequested :: IDENTIFIER => CdpEvent :: RuntimeInspectRequested (Box :: new (map . next_value :: < super :: js_protocol :: runtime :: EventInspectRequested > () ?)) , super :: browser_protocol :: animation :: EventAnimationCanceled :: IDENTIFIER => CdpEvent :: AnimationAnimationCanceled (map . next_value :: < super :: browser_protocol :: animation :: EventAnimationCanceled > () ?) , super :: browser_protocol :: animation :: EventAnimationCreated :: IDENTIFIER => CdpEvent :: AnimationAnimationCreated (map . next_value :: < super :: browser_protocol :: animation :: EventAnimationCreated > () ?) , super :: browser_protocol :: animation :: EventAnimationStarted :: IDENTIFIER => CdpEvent :: AnimationAnimationStarted (Box :: new (map . next_value :: < super :: browser_protocol :: animation :: EventAnimationStarted > () ?)) , super :: browser_protocol :: application_cache :: EventApplicationCacheStatusUpdated :: IDENTIFIER => CdpEvent :: ApplicationCacheApplicationCacheStatusUpdated (map . next_value :: < super :: browser_protocol :: application_cache :: EventApplicationCacheStatusUpdated > () ?) , super :: browser_protocol :: application_cache :: EventNetworkStateUpdated :: IDENTIFIER => CdpEvent :: ApplicationCacheNetworkStateUpdated (map . next_value :: < super :: browser_protocol :: application_cache :: EventNetworkStateUpdated > () ?) , super :: browser_protocol :: audits :: EventIssueAdded :: IDENTIFIER => CdpEvent :: AuditsIssueAdded (Box :: new (map . next_value :: < super :: browser_protocol :: audits :: EventIssueAdded > () ?)) , super :: browser_protocol :: background_service :: EventRecordingStateChanged :: IDENTIFIER => CdpEvent :: BackgroundServiceRecordingStateChanged (map . next_value :: < super :: browser_protocol :: background_service :: EventRecordingStateChanged > () ?) , super :: browser_protocol :: background_service :: EventBackgroundServiceEventReceived :: IDENTIFIER => CdpEvent :: BackgroundServiceBackgroundServiceEventReceived (map . next_value :: < super :: browser_protocol :: background_service :: EventBackgroundServiceEventReceived > () ?) , super :: browser_protocol :: css :: EventFontsUpdated :: IDENTIFIER => CdpEvent :: CssFontsUpdated (Box :: new (map . next_value :: < super :: browser_protocol :: css :: EventFontsUpdated > () ?)) , super :: browser_protocol :: css :: EventMediaQueryResultChanged :: IDENTIFIER => CdpEvent :: CssMediaQueryResultChanged (map . next_value :: < super :: browser_protocol :: css :: EventMediaQueryResultChanged > () ?) , super :: browser_protocol :: css :: EventStyleSheetAdded :: IDENTIFIER => CdpEvent :: CssStyleSheetAdded (map . next_value :: < super :: browser_protocol :: css :: EventStyleSheetAdded > () ?) , super :: browser_protocol :: css :: EventStyleSheetChanged :: IDENTIFIER => CdpEvent :: CssStyleSheetChanged (map . next_value :: < super :: browser_protocol :: css :: EventStyleSheetChanged > () ?) , super :: browser_protocol :: css :: EventStyleSheetRemoved :: IDENTIFIER => CdpEvent :: CssStyleSheetRemoved (map . next_value :: < super :: browser_protocol :: css :: EventStyleSheetRemoved > () ?) , super :: browser_protocol :: cast :: EventSinksUpdated :: IDENTIFIER => CdpEvent :: CastSinksUpdated (map . next_value :: < super :: browser_protocol :: cast :: EventSinksUpdated > () ?) , super :: browser_protocol :: cast :: EventIssueUpdated :: IDENTIFIER => CdpEvent :: CastIssueUpdated (map . next_value :: < super :: browser_protocol :: cast :: EventIssueUpdated > () ?) , super :: browser_protocol :: dom :: EventAttributeModified :: IDENTIFIER => CdpEvent :: DomAttributeModified (map . next_value :: < super :: browser_protocol :: dom :: EventAttributeModified > () ?) , super :: browser_protocol :: dom :: EventAttributeRemoved :: IDENTIFIER => CdpEvent :: DomAttributeRemoved (map . next_value :: < super :: browser_protocol :: dom :: EventAttributeRemoved > () ?) , super :: browser_protocol :: dom :: EventCharacterDataModified :: IDENTIFIER => CdpEvent :: DomCharacterDataModified (map . next_value :: < super :: browser_protocol :: dom :: EventCharacterDataModified > () ?) , super :: browser_protocol :: dom :: EventChildNodeCountUpdated :: IDENTIFIER => CdpEvent :: DomChildNodeCountUpdated (map . next_value :: < super :: browser_protocol :: dom :: EventChildNodeCountUpdated > () ?) , super :: browser_protocol :: dom :: EventChildNodeInserted :: IDENTIFIER => CdpEvent :: DomChildNodeInserted (Box :: new (map . next_value :: < super :: browser_protocol :: dom :: EventChildNodeInserted > () ?)) , super :: browser_protocol :: dom :: EventChildNodeRemoved :: IDENTIFIER => CdpEvent :: DomChildNodeRemoved (map . next_value :: < super :: browser_protocol :: dom :: EventChildNodeRemoved > () ?) , super :: browser_protocol :: dom :: EventDistributedNodesUpdated :: IDENTIFIER => CdpEvent :: DomDistributedNodesUpdated (map . next_value :: < super :: browser_protocol :: dom :: EventDistributedNodesUpdated > () ?) , super :: browser_protocol :: dom :: EventDocumentUpdated :: IDENTIFIER => CdpEvent :: DomDocumentUpdated (map . next_value :: < super :: browser_protocol :: dom :: EventDocumentUpdated > () ?) , super :: browser_protocol :: dom :: EventInlineStyleInvalidated :: IDENTIFIER => CdpEvent :: DomInlineStyleInvalidated (map . next_value :: < super :: browser_protocol :: dom :: EventInlineStyleInvalidated > () ?) , super :: browser_protocol :: dom :: EventPseudoElementAdded :: IDENTIFIER => CdpEvent :: DomPseudoElementAdded (Box :: new (map . next_value :: < super :: browser_protocol :: dom :: EventPseudoElementAdded > () ?)) , super :: browser_protocol :: dom :: EventPseudoElementRemoved :: IDENTIFIER => CdpEvent :: DomPseudoElementRemoved (map . next_value :: < super :: browser_protocol :: dom :: EventPseudoElementRemoved > () ?) , super :: browser_protocol :: dom :: EventSetChildNodes :: IDENTIFIER => CdpEvent :: DomSetChildNodes (map . next_value :: < super :: browser_protocol :: dom :: EventSetChildNodes > () ?) , super :: browser_protocol :: dom :: EventShadowRootPopped :: IDENTIFIER => CdpEvent :: DomShadowRootPopped (map . next_value :: < super :: browser_protocol :: dom :: EventShadowRootPopped > () ?) , super :: browser_protocol :: dom :: EventShadowRootPushed :: IDENTIFIER => CdpEvent :: DomShadowRootPushed (Box :: new (map . next_value :: < super :: browser_protocol :: dom :: EventShadowRootPushed > () ?)) , super :: browser_protocol :: dom_storage :: EventDomStorageItemAdded :: IDENTIFIER => CdpEvent :: DomStorageDomStorageItemAdded (map . next_value :: < super :: browser_protocol :: dom_storage :: EventDomStorageItemAdded > () ?) , super :: browser_protocol :: dom_storage :: EventDomStorageItemRemoved :: IDENTIFIER => CdpEvent :: DomStorageDomStorageItemRemoved (map . next_value :: < super :: browser_protocol :: dom_storage :: EventDomStorageItemRemoved > () ?) , super :: browser_protocol :: dom_storage :: EventDomStorageItemUpdated :: IDENTIFIER => CdpEvent :: DomStorageDomStorageItemUpdated (map . next_value :: < super :: browser_protocol :: dom_storage :: EventDomStorageItemUpdated > () ?) , super :: browser_protocol :: dom_storage :: EventDomStorageItemsCleared :: IDENTIFIER => CdpEvent :: DomStorageDomStorageItemsCleared (map . next_value :: < super :: browser_protocol :: dom_storage :: EventDomStorageItemsCleared > () ?) , super :: browser_protocol :: database :: EventAddDatabase :: IDENTIFIER => CdpEvent :: DatabaseAddDatabase (map . next_value :: < super :: browser_protocol :: database :: EventAddDatabase > () ?) , super :: browser_protocol :: emulation :: EventVirtualTimeBudgetExpired :: IDENTIFIER => CdpEvent :: EmulationVirtualTimeBudgetExpired (map . next_value :: < super :: browser_protocol :: emulation :: EventVirtualTimeBudgetExpired > () ?) , super :: browser_protocol :: inspector :: EventDetached :: IDENTIFIER => CdpEvent :: InspectorDetached (map . next_value :: < super :: browser_protocol :: inspector :: EventDetached > () ?) , super :: browser_protocol :: inspector :: EventTargetCrashed :: IDENTIFIER => CdpEvent :: InspectorTargetCrashed (map . next_value :: < super :: browser_protocol :: inspector :: EventTargetCrashed > () ?) , super :: browser_protocol :: inspector :: EventTargetReloadedAfterCrash :: IDENTIFIER => CdpEvent :: InspectorTargetReloadedAfterCrash (map . next_value :: < super :: browser_protocol :: inspector :: EventTargetReloadedAfterCrash > () ?) , super :: browser_protocol :: layer_tree :: EventLayerPainted :: IDENTIFIER => CdpEvent :: LayerTreeLayerPainted (map . next_value :: < super :: browser_protocol :: layer_tree :: EventLayerPainted > () ?) , super :: browser_protocol :: layer_tree :: EventLayerTreeDidChange :: IDENTIFIER => CdpEvent :: LayerTreeLayerTreeDidChange (map . next_value :: < super :: browser_protocol :: layer_tree :: EventLayerTreeDidChange > () ?) , super :: browser_protocol :: log :: EventEntryAdded :: IDENTIFIER => CdpEvent :: LogEntryAdded (Box :: new (map . next_value :: < super :: browser_protocol :: log :: EventEntryAdded > () ?)) , super :: browser_protocol :: network :: EventDataReceived :: IDENTIFIER => CdpEvent :: NetworkDataReceived (map . next_value :: < super :: browser_protocol :: network :: EventDataReceived > () ?) , super :: browser_protocol :: network :: EventEventSourceMessageReceived :: IDENTIFIER => CdpEvent :: NetworkEventSourceMessageReceived (map . next_value :: < super :: browser_protocol :: network :: EventEventSourceMessageReceived > () ?) , super :: browser_protocol :: network :: EventLoadingFailed :: IDENTIFIER => CdpEvent :: NetworkLoadingFailed (map . next_value :: < super :: browser_protocol :: network :: EventLoadingFailed > () ?) , super :: browser_protocol :: network :: EventLoadingFinished :: IDENTIFIER => CdpEvent :: NetworkLoadingFinished (map . next_value :: < super :: browser_protocol :: network :: EventLoadingFinished > () ?) , super :: browser_protocol :: network :: EventRequestServedFromCache :: IDENTIFIER => CdpEvent :: NetworkRequestServedFromCache (map . next_value :: < super :: browser_protocol :: network :: EventRequestServedFromCache > () ?) , super :: browser_protocol :: network :: EventRequestWillBeSent :: IDENTIFIER => CdpEvent :: NetworkRequestWillBeSent (Box :: new (map . next_value :: < super :: browser_protocol :: network :: EventRequestWillBeSent > () ?)) , super :: browser_protocol :: network :: EventResourceChangedPriority :: IDENTIFIER => CdpEvent :: NetworkResourceChangedPriority (map . next_value :: < super :: browser_protocol :: network :: EventResourceChangedPriority > () ?) , super :: browser_protocol :: network :: EventSignedExchangeReceived :: IDENTIFIER => CdpEvent :: NetworkSignedExchangeReceived (Box :: new (map . next_value :: < super :: browser_protocol :: network :: EventSignedExchangeReceived > () ?)) , super :: browser_protocol :: network :: EventResponseReceived :: IDENTIFIER => CdpEvent :: NetworkResponseReceived (Box :: new (map . next_value :: < super :: browser_protocol :: network :: EventResponseReceived > () ?)) , super :: browser_protocol :: network :: EventWebSocketClosed :: IDENTIFIER => CdpEvent :: NetworkWebSocketClosed (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketClosed > () ?) , super :: browser_protocol :: network :: EventWebSocketCreated :: IDENTIFIER => CdpEvent :: NetworkWebSocketCreated (Box :: new (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketCreated > () ?)) , super :: browser_protocol :: network :: EventWebSocketFrameError :: IDENTIFIER => CdpEvent :: NetworkWebSocketFrameError (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketFrameError > () ?) , super :: browser_protocol :: network :: EventWebSocketFrameReceived :: IDENTIFIER => CdpEvent :: NetworkWebSocketFrameReceived (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketFrameReceived > () ?) , super :: browser_protocol :: network :: EventWebSocketFrameSent :: IDENTIFIER => CdpEvent :: NetworkWebSocketFrameSent (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketFrameSent > () ?) , super :: browser_protocol :: network :: EventWebSocketHandshakeResponseReceived :: IDENTIFIER => CdpEvent :: NetworkWebSocketHandshakeResponseReceived (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketHandshakeResponseReceived > () ?) , super :: browser_protocol :: network :: EventWebSocketWillSendHandshakeRequest :: IDENTIFIER => CdpEvent :: NetworkWebSocketWillSendHandshakeRequest (map . next_value :: < super :: browser_protocol :: network :: EventWebSocketWillSendHandshakeRequest > () ?) , super :: browser_protocol :: network :: EventRequestWillBeSentExtraInfo :: IDENTIFIER => CdpEvent :: NetworkRequestWillBeSentExtraInfo (map . next_value :: < super :: browser_protocol :: network :: EventRequestWillBeSentExtraInfo > () ?) , super :: browser_protocol :: network :: EventResponseReceivedExtraInfo :: IDENTIFIER => CdpEvent :: NetworkResponseReceivedExtraInfo (map . next_value :: < super :: browser_protocol :: network :: EventResponseReceivedExtraInfo > () ?) , super :: browser_protocol :: overlay :: EventInspectNodeRequested :: IDENTIFIER => CdpEvent :: OverlayInspectNodeRequested (map . next_value :: < super :: browser_protocol :: overlay :: EventInspectNodeRequested > () ?) , super :: browser_protocol :: overlay :: EventNodeHighlightRequested :: IDENTIFIER => CdpEvent :: OverlayNodeHighlightRequested (map . next_value :: < super :: browser_protocol :: overlay :: EventNodeHighlightRequested > () ?) , super :: browser_protocol :: overlay :: EventScreenshotRequested :: IDENTIFIER => CdpEvent :: OverlayScreenshotRequested (map . next_value :: < super :: browser_protocol :: overlay :: EventScreenshotRequested > () ?) , super :: browser_protocol :: overlay :: EventInspectModeCanceled :: IDENTIFIER => CdpEvent :: OverlayInspectModeCanceled (map . next_value :: < super :: browser_protocol :: overlay :: EventInspectModeCanceled > () ?) , super :: browser_protocol :: page :: EventDomContentEventFired :: IDENTIFIER => CdpEvent :: PageDomContentEventFired (map . next_value :: < super :: browser_protocol :: page :: EventDomContentEventFired > () ?) , super :: browser_protocol :: page :: EventFileChooserOpened :: IDENTIFIER => CdpEvent :: PageFileChooserOpened (map . next_value :: < super :: browser_protocol :: page :: EventFileChooserOpened > () ?) , super :: browser_protocol :: page :: EventFrameAttached :: IDENTIFIER => CdpEvent :: PageFrameAttached (map . next_value :: < super :: browser_protocol :: page :: EventFrameAttached > () ?) , super :: browser_protocol :: page :: EventFrameDetached :: IDENTIFIER => CdpEvent :: PageFrameDetached (map . next_value :: < super :: browser_protocol :: page :: EventFrameDetached > () ?) , super :: browser_protocol :: page :: EventFrameNavigated :: IDENTIFIER => CdpEvent :: PageFrameNavigated (Box :: new (map . next_value :: < super :: browser_protocol :: page :: EventFrameNavigated > () ?)) , super :: browser_protocol :: page :: EventFrameResized :: IDENTIFIER => CdpEvent :: PageFrameResized (map . next_value :: < super :: browser_protocol :: page :: EventFrameResized > () ?) , super :: browser_protocol :: page :: EventFrameRequestedNavigation :: IDENTIFIER => CdpEvent :: PageFrameRequestedNavigation (map . next_value :: < super :: browser_protocol :: page :: EventFrameRequestedNavigation > () ?) , super :: browser_protocol :: page :: EventFrameStartedLoading :: IDENTIFIER => CdpEvent :: PageFrameStartedLoading (map . next_value :: < super :: browser_protocol :: page :: EventFrameStartedLoading > () ?) , super :: browser_protocol :: page :: EventFrameStoppedLoading :: IDENTIFIER => CdpEvent :: PageFrameStoppedLoading (map . next_value :: < super :: browser_protocol :: page :: EventFrameStoppedLoading > () ?) , super :: browser_protocol :: page :: EventDownloadWillBegin :: IDENTIFIER => CdpEvent :: PageDownloadWillBegin (map . next_value :: < super :: browser_protocol :: page :: EventDownloadWillBegin > () ?) , super :: browser_protocol :: page :: EventDownloadProgress :: IDENTIFIER => CdpEvent :: PageDownloadProgress (map . next_value :: < super :: browser_protocol :: page :: EventDownloadProgress > () ?) , super :: browser_protocol :: page :: EventInterstitialHidden :: IDENTIFIER => CdpEvent :: PageInterstitialHidden (map . next_value :: < super :: browser_protocol :: page :: EventInterstitialHidden > () ?) , super :: browser_protocol :: page :: EventInterstitialShown :: IDENTIFIER => CdpEvent :: PageInterstitialShown (map . next_value :: < super :: browser_protocol :: page :: EventInterstitialShown > () ?) , super :: browser_protocol :: page :: EventJavascriptDialogClosed :: IDENTIFIER => CdpEvent :: PageJavascriptDialogClosed (map . next_value :: < super :: browser_protocol :: page :: EventJavascriptDialogClosed > () ?) , super :: browser_protocol :: page :: EventJavascriptDialogOpening :: IDENTIFIER => CdpEvent :: PageJavascriptDialogOpening (map . next_value :: < super :: browser_protocol :: page :: EventJavascriptDialogOpening > () ?) , super :: browser_protocol :: page :: EventLifecycleEvent :: IDENTIFIER => CdpEvent :: PageLifecycleEvent (map . next_value :: < super :: browser_protocol :: page :: EventLifecycleEvent > () ?) , super :: browser_protocol :: page :: EventLoadEventFired :: IDENTIFIER => CdpEvent :: PageLoadEventFired (map . next_value :: < super :: browser_protocol :: page :: EventLoadEventFired > () ?) , super :: browser_protocol :: page :: EventNavigatedWithinDocument :: IDENTIFIER => CdpEvent :: PageNavigatedWithinDocument (map . next_value :: < super :: browser_protocol :: page :: EventNavigatedWithinDocument > () ?) , super :: browser_protocol :: page :: EventScreencastFrame :: IDENTIFIER => CdpEvent :: PageScreencastFrame (map . next_value :: < super :: browser_protocol :: page :: EventScreencastFrame > () ?) , super :: browser_protocol :: page :: EventScreencastVisibilityChanged :: IDENTIFIER => CdpEvent :: PageScreencastVisibilityChanged (map . next_value :: < super :: browser_protocol :: page :: EventScreencastVisibilityChanged > () ?) , super :: browser_protocol :: page :: EventWindowOpen :: IDENTIFIER => CdpEvent :: PageWindowOpen (map . next_value :: < super :: browser_protocol :: page :: EventWindowOpen > () ?) , super :: browser_protocol :: page :: EventCompilationCacheProduced :: IDENTIFIER => CdpEvent :: PageCompilationCacheProduced (map . next_value :: < super :: browser_protocol :: page :: EventCompilationCacheProduced > () ?) , super :: browser_protocol :: performance :: EventMetrics :: IDENTIFIER => CdpEvent :: PerformanceMetrics (map . next_value :: < super :: browser_protocol :: performance :: EventMetrics > () ?) , super :: browser_protocol :: security :: EventVisibleSecurityStateChanged :: IDENTIFIER => CdpEvent :: SecurityVisibleSecurityStateChanged (Box :: new (map . next_value :: < super :: browser_protocol :: security :: EventVisibleSecurityStateChanged > () ?)) , super :: browser_protocol :: security :: EventSecurityStateChanged :: IDENTIFIER => CdpEvent :: SecuritySecurityStateChanged (map . next_value :: < super :: browser_protocol :: security :: EventSecurityStateChanged > () ?) , super :: browser_protocol :: service_worker :: EventWorkerErrorReported :: IDENTIFIER => CdpEvent :: ServiceWorkerWorkerErrorReported (map . next_value :: < super :: browser_protocol :: service_worker :: EventWorkerErrorReported > () ?) , super :: browser_protocol :: service_worker :: EventWorkerRegistrationUpdated :: IDENTIFIER => CdpEvent :: ServiceWorkerWorkerRegistrationUpdated (map . next_value :: < super :: browser_protocol :: service_worker :: EventWorkerRegistrationUpdated > () ?) , super :: browser_protocol :: service_worker :: EventWorkerVersionUpdated :: IDENTIFIER => CdpEvent :: ServiceWorkerWorkerVersionUpdated (map . next_value :: < super :: browser_protocol :: service_worker :: EventWorkerVersionUpdated > () ?) , super :: browser_protocol :: storage :: EventCacheStorageContentUpdated :: IDENTIFIER => CdpEvent :: StorageCacheStorageContentUpdated (map . next_value :: < super :: browser_protocol :: storage :: EventCacheStorageContentUpdated > () ?) , super :: browser_protocol :: storage :: EventCacheStorageListUpdated :: IDENTIFIER => CdpEvent :: StorageCacheStorageListUpdated (map . next_value :: < super :: browser_protocol :: storage :: EventCacheStorageListUpdated > () ?) , super :: browser_protocol :: storage :: EventIndexedDbContentUpdated :: IDENTIFIER => CdpEvent :: StorageIndexedDbContentUpdated (map . next_value :: < super :: browser_protocol :: storage :: EventIndexedDbContentUpdated > () ?) , super :: browser_protocol :: storage :: EventIndexedDbListUpdated :: IDENTIFIER => CdpEvent :: StorageIndexedDbListUpdated (map . next_value :: < super :: browser_protocol :: storage :: EventIndexedDbListUpdated > () ?) , super :: browser_protocol :: target :: EventAttachedToTarget :: IDENTIFIER => CdpEvent :: TargetAttachedToTarget (map . next_value :: < super :: browser_protocol :: target :: EventAttachedToTarget > () ?) , super :: browser_protocol :: target :: EventDetachedFromTarget :: IDENTIFIER => CdpEvent :: TargetDetachedFromTarget (map . next_value :: < super :: browser_protocol :: target :: EventDetachedFromTarget > () ?) , super :: browser_protocol :: target :: EventReceivedMessageFromTarget :: IDENTIFIER => CdpEvent :: TargetReceivedMessageFromTarget (map . next_value :: < super :: browser_protocol :: target :: EventReceivedMessageFromTarget > () ?) , super :: browser_protocol :: target :: EventTargetCreated :: IDENTIFIER => CdpEvent :: TargetTargetCreated (map . next_value :: < super :: browser_protocol :: target :: EventTargetCreated > () ?) , super :: browser_protocol :: target :: EventTargetDestroyed :: IDENTIFIER => CdpEvent :: TargetTargetDestroyed (map . next_value :: < super :: browser_protocol :: target :: EventTargetDestroyed > () ?) , super :: browser_protocol :: target :: EventTargetCrashed :: IDENTIFIER => CdpEvent :: TargetTargetCrashed (map . next_value :: < super :: browser_protocol :: target :: EventTargetCrashed > () ?) , super :: browser_protocol :: target :: EventTargetInfoChanged :: IDENTIFIER => CdpEvent :: TargetTargetInfoChanged (map . next_value :: < super :: browser_protocol :: target :: EventTargetInfoChanged > () ?) , super :: browser_protocol :: tethering :: EventAccepted :: IDENTIFIER => CdpEvent :: TetheringAccepted (map . next_value :: < super :: browser_protocol :: tethering :: EventAccepted > () ?) , super :: browser_protocol :: tracing :: EventBufferUsage :: IDENTIFIER => CdpEvent :: TracingBufferUsage (map . next_value :: < super :: browser_protocol :: tracing :: EventBufferUsage > () ?) , super :: browser_protocol :: tracing :: EventDataCollected :: IDENTIFIER => CdpEvent :: TracingDataCollected (map . next_value :: < super :: browser_protocol :: tracing :: EventDataCollected > () ?) , super :: browser_protocol :: tracing :: EventTracingComplete :: IDENTIFIER => CdpEvent :: TracingTracingComplete (map . next_value :: < super :: browser_protocol :: tracing :: EventTracingComplete > () ?) , super :: browser_protocol :: fetch :: EventRequestPaused :: IDENTIFIER => CdpEvent :: FetchRequestPaused (Box :: new (map . next_value :: < super :: browser_protocol :: fetch :: EventRequestPaused > () ?)) , super :: browser_protocol :: fetch :: EventAuthRequired :: IDENTIFIER => CdpEvent :: FetchAuthRequired (Box :: new (map . next_value :: < super :: browser_protocol :: fetch :: EventAuthRequired > () ?)) , super :: browser_protocol :: web_audio :: EventContextCreated :: IDENTIFIER => CdpEvent :: WebAudioContextCreated (map . next_value :: < super :: browser_protocol :: web_audio :: EventContextCreated > () ?) , super :: browser_protocol :: web_audio :: EventContextWillBeDestroyed :: IDENTIFIER => CdpEvent :: WebAudioContextWillBeDestroyed (map . next_value :: < super :: browser_protocol :: web_audio :: EventContextWillBeDestroyed > () ?) , super :: browser_protocol :: web_audio :: EventContextChanged :: IDENTIFIER => CdpEvent :: WebAudioContextChanged (map . next_value :: < super :: browser_protocol :: web_audio :: EventContextChanged > () ?) , super :: browser_protocol :: web_audio :: EventAudioListenerCreated :: IDENTIFIER => CdpEvent :: WebAudioAudioListenerCreated (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioListenerCreated > () ?) , super :: browser_protocol :: web_audio :: EventAudioListenerWillBeDestroyed :: IDENTIFIER => CdpEvent :: WebAudioAudioListenerWillBeDestroyed (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioListenerWillBeDestroyed > () ?) , super :: browser_protocol :: web_audio :: EventAudioNodeCreated :: IDENTIFIER => CdpEvent :: WebAudioAudioNodeCreated (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioNodeCreated > () ?) , super :: browser_protocol :: web_audio :: EventAudioNodeWillBeDestroyed :: IDENTIFIER => CdpEvent :: WebAudioAudioNodeWillBeDestroyed (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioNodeWillBeDestroyed > () ?) , super :: browser_protocol :: web_audio :: EventAudioParamCreated :: IDENTIFIER => CdpEvent :: WebAudioAudioParamCreated (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioParamCreated > () ?) , super :: browser_protocol :: web_audio :: EventAudioParamWillBeDestroyed :: IDENTIFIER => CdpEvent :: WebAudioAudioParamWillBeDestroyed (map . next_value :: < super :: browser_protocol :: web_audio :: EventAudioParamWillBeDestroyed > () ?) , super :: browser_protocol :: web_audio :: EventNodesConnected :: IDENTIFIER => CdpEvent :: WebAudioNodesConnected (map . next_value :: < super :: browser_protocol :: web_audio :: EventNodesConnected > () ?) , super :: browser_protocol :: web_audio :: EventNodesDisconnected :: IDENTIFIER => CdpEvent :: WebAudioNodesDisconnected (map . next_value :: < super :: browser_protocol :: web_audio :: EventNodesDisconnected > () ?) , super :: browser_protocol :: web_audio :: EventNodeParamConnected :: IDENTIFIER => CdpEvent :: WebAudioNodeParamConnected (map . next_value :: < super :: browser_protocol :: web_audio :: EventNodeParamConnected > () ?) , super :: browser_protocol :: web_audio :: EventNodeParamDisconnected :: IDENTIFIER => CdpEvent :: WebAudioNodeParamDisconnected (map . next_value :: < super :: browser_protocol :: web_audio :: EventNodeParamDisconnected > () ?) , super :: browser_protocol :: media :: EventPlayerPropertiesChanged :: IDENTIFIER => CdpEvent :: MediaPlayerPropertiesChanged (map . next_value :: < super :: browser_protocol :: media :: EventPlayerPropertiesChanged > () ?) , super :: browser_protocol :: media :: EventPlayerEventsAdded :: IDENTIFIER => CdpEvent :: MediaPlayerEventsAdded (map . next_value :: < super :: browser_protocol :: media :: EventPlayerEventsAdded > () ?) , super :: browser_protocol :: media :: EventPlayerMessagesLogged :: IDENTIFIER => CdpEvent :: MediaPlayerMessagesLogged (map . next_value :: < super :: browser_protocol :: media :: EventPlayerMessagesLogged > () ?) , super :: browser_protocol :: media :: EventPlayerErrorsRaised :: IDENTIFIER => CdpEvent :: MediaPlayerErrorsRaised (map . next_value :: < super :: browser_protocol :: media :: EventPlayerErrorsRaised > () ?) , super :: browser_protocol :: media :: EventPlayersCreated :: IDENTIFIER => CdpEvent :: MediaPlayersCreated (map . next_value :: < super :: browser_protocol :: media :: EventPlayersCreated > () ?) , _ => CdpEvent :: Other (map . next_value :: < serde_json :: Value > () ?) }) ;
                            }
                        }
                    }
                    let method = method.ok_or_else(|| de::Error::missing_field("method"))?;
                    let params = params.ok_or_else(|| de::Error::missing_field("params"))?;
                    Ok(CdpEventMessage {
                        method: ::std::borrow::Cow::Owned(method),
                        session_id,
                        params,
                    })
                }
            }
            const FIELDS: &[&str] = &["method", "sessionId", "params"];
            deserializer.deserialize_struct("CdpEventMessage", FIELDS, MessageVisitor)
        }
    }
    impl std::convert::TryInto<chromiumoxide_types::CdpJsonEventMessage> for CdpEventMessage {
        type Error = serde_json::Error;
        fn try_into(self) -> Result<chromiumoxide_types::CdpJsonEventMessage, Self::Error> {
            use chromiumoxide_types::Method;
            Ok(chromiumoxide_types::CdpJsonEventMessage {
                method: self.identifier(),
                session_id: self.session_id,
                params: self.params.into_json()?,
            })
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::debugger::EventBreakpointResolved {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DebuggerBreakpointResolved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::debugger::EventBreakpointResolved> for CdpEvent {
        fn from(el: super::js_protocol::debugger::EventBreakpointResolved) -> CdpEvent {
            CdpEvent::DebuggerBreakpointResolved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::debugger::EventPaused {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DebuggerPaused(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::debugger::EventPaused> for CdpEvent {
        fn from(el: super::js_protocol::debugger::EventPaused) -> CdpEvent {
            CdpEvent::DebuggerPaused(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::debugger::EventResumed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DebuggerResumed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::debugger::EventResumed> for CdpEvent {
        fn from(el: super::js_protocol::debugger::EventResumed) -> CdpEvent {
            CdpEvent::DebuggerResumed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::debugger::EventScriptFailedToParse {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DebuggerScriptFailedToParse(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::debugger::EventScriptFailedToParse> for CdpEvent {
        fn from(el: super::js_protocol::debugger::EventScriptFailedToParse) -> CdpEvent {
            CdpEvent::DebuggerScriptFailedToParse(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::debugger::EventScriptParsed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DebuggerScriptParsed(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::debugger::EventScriptParsed> for CdpEvent {
        fn from(el: super::js_protocol::debugger::EventScriptParsed) -> CdpEvent {
            CdpEvent::DebuggerScriptParsed(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::HeapProfilerAddHeapSnapshotChunk(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk> for CdpEvent {
        fn from(el: super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk) -> CdpEvent {
            CdpEvent::HeapProfilerAddHeapSnapshotChunk(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::heap_profiler::EventHeapStatsUpdate {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::HeapProfilerHeapStatsUpdate(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::heap_profiler::EventHeapStatsUpdate> for CdpEvent {
        fn from(el: super::js_protocol::heap_profiler::EventHeapStatsUpdate) -> CdpEvent {
            CdpEvent::HeapProfilerHeapStatsUpdate(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::heap_profiler::EventLastSeenObjectId {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::HeapProfilerLastSeenObjectId(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::heap_profiler::EventLastSeenObjectId> for CdpEvent {
        fn from(el: super::js_protocol::heap_profiler::EventLastSeenObjectId) -> CdpEvent {
            CdpEvent::HeapProfilerLastSeenObjectId(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::HeapProfilerReportHeapSnapshotProgress(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress> for CdpEvent {
        fn from(
            el: super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress,
        ) -> CdpEvent {
            CdpEvent::HeapProfilerReportHeapSnapshotProgress(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::heap_profiler::EventResetProfiles {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::HeapProfilerResetProfiles(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::heap_profiler::EventResetProfiles> for CdpEvent {
        fn from(el: super::js_protocol::heap_profiler::EventResetProfiles) -> CdpEvent {
            CdpEvent::HeapProfilerResetProfiles(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::profiler::EventConsoleProfileFinished {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ProfilerConsoleProfileFinished(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::profiler::EventConsoleProfileFinished> for CdpEvent {
        fn from(el: super::js_protocol::profiler::EventConsoleProfileFinished) -> CdpEvent {
            CdpEvent::ProfilerConsoleProfileFinished(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::profiler::EventConsoleProfileStarted {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ProfilerConsoleProfileStarted(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::profiler::EventConsoleProfileStarted> for CdpEvent {
        fn from(el: super::js_protocol::profiler::EventConsoleProfileStarted) -> CdpEvent {
            CdpEvent::ProfilerConsoleProfileStarted(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ProfilerPreciseCoverageDeltaUpdate(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate> for CdpEvent {
        fn from(el: super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate) -> CdpEvent {
            CdpEvent::ProfilerPreciseCoverageDeltaUpdate(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventBindingCalled {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeBindingCalled(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventBindingCalled> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventBindingCalled) -> CdpEvent {
            CdpEvent::RuntimeBindingCalled(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventConsoleApiCalled {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeConsoleApiCalled(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventConsoleApiCalled> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventConsoleApiCalled) -> CdpEvent {
            CdpEvent::RuntimeConsoleApiCalled(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventExceptionRevoked {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeExceptionRevoked(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventExceptionRevoked> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventExceptionRevoked) -> CdpEvent {
            CdpEvent::RuntimeExceptionRevoked(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventExceptionThrown {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeExceptionThrown(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventExceptionThrown> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventExceptionThrown) -> CdpEvent {
            CdpEvent::RuntimeExceptionThrown(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventExecutionContextCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeExecutionContextCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventExecutionContextCreated> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventExecutionContextCreated) -> CdpEvent {
            CdpEvent::RuntimeExecutionContextCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::js_protocol::runtime::EventExecutionContextDestroyed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeExecutionContextDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventExecutionContextDestroyed> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventExecutionContextDestroyed) -> CdpEvent {
            CdpEvent::RuntimeExecutionContextDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::js_protocol::runtime::EventExecutionContextsCleared
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeExecutionContextsCleared(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventExecutionContextsCleared> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventExecutionContextsCleared) -> CdpEvent {
            CdpEvent::RuntimeExecutionContextsCleared(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::js_protocol::runtime::EventInspectRequested {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::RuntimeInspectRequested(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::js_protocol::runtime::EventInspectRequested> for CdpEvent {
        fn from(el: super::js_protocol::runtime::EventInspectRequested) -> CdpEvent {
            CdpEvent::RuntimeInspectRequested(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::animation::EventAnimationCanceled
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::AnimationAnimationCanceled(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::animation::EventAnimationCanceled> for CdpEvent {
        fn from(el: super::browser_protocol::animation::EventAnimationCanceled) -> CdpEvent {
            CdpEvent::AnimationAnimationCanceled(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::animation::EventAnimationCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::AnimationAnimationCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::animation::EventAnimationCreated> for CdpEvent {
        fn from(el: super::browser_protocol::animation::EventAnimationCreated) -> CdpEvent {
            CdpEvent::AnimationAnimationCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::animation::EventAnimationStarted {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::AnimationAnimationStarted(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::animation::EventAnimationStarted> for CdpEvent {
        fn from(el: super::browser_protocol::animation::EventAnimationStarted) -> CdpEvent {
            CdpEvent::AnimationAnimationStarted(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated>
        for CdpEvent
    {
        fn from(
            el: super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated,
        ) -> CdpEvent {
            CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::application_cache::EventNetworkStateUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ApplicationCacheNetworkStateUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::application_cache::EventNetworkStateUpdated> for CdpEvent {
        fn from(
            el: super::browser_protocol::application_cache::EventNetworkStateUpdated,
        ) -> CdpEvent {
            CdpEvent::ApplicationCacheNetworkStateUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::audits::EventIssueAdded {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::AuditsIssueAdded(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::audits::EventIssueAdded> for CdpEvent {
        fn from(el: super::browser_protocol::audits::EventIssueAdded) -> CdpEvent {
            CdpEvent::AuditsIssueAdded(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::background_service::EventRecordingStateChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::BackgroundServiceRecordingStateChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::background_service::EventRecordingStateChanged> for CdpEvent {
        fn from(
            el: super::browser_protocol::background_service::EventRecordingStateChanged,
        ) -> CdpEvent {
            CdpEvent::BackgroundServiceRecordingStateChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::background_service::EventBackgroundServiceEventReceived
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::BackgroundServiceBackgroundServiceEventReceived(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::background_service::EventBackgroundServiceEventReceived>
        for CdpEvent
    {
        fn from(
            el: super::browser_protocol::background_service::EventBackgroundServiceEventReceived,
        ) -> CdpEvent {
            CdpEvent::BackgroundServiceBackgroundServiceEventReceived(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::css::EventFontsUpdated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CssFontsUpdated(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::css::EventFontsUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::css::EventFontsUpdated) -> CdpEvent {
            CdpEvent::CssFontsUpdated(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::css::EventMediaQueryResultChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CssMediaQueryResultChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::css::EventMediaQueryResultChanged> for CdpEvent {
        fn from(el: super::browser_protocol::css::EventMediaQueryResultChanged) -> CdpEvent {
            CdpEvent::CssMediaQueryResultChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::css::EventStyleSheetAdded {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CssStyleSheetAdded(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::css::EventStyleSheetAdded> for CdpEvent {
        fn from(el: super::browser_protocol::css::EventStyleSheetAdded) -> CdpEvent {
            CdpEvent::CssStyleSheetAdded(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::css::EventStyleSheetChanged {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CssStyleSheetChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::css::EventStyleSheetChanged> for CdpEvent {
        fn from(el: super::browser_protocol::css::EventStyleSheetChanged) -> CdpEvent {
            CdpEvent::CssStyleSheetChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::css::EventStyleSheetRemoved {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CssStyleSheetRemoved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::css::EventStyleSheetRemoved> for CdpEvent {
        fn from(el: super::browser_protocol::css::EventStyleSheetRemoved) -> CdpEvent {
            CdpEvent::CssStyleSheetRemoved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::cast::EventSinksUpdated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CastSinksUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::cast::EventSinksUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::cast::EventSinksUpdated) -> CdpEvent {
            CdpEvent::CastSinksUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::cast::EventIssueUpdated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::CastIssueUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::cast::EventIssueUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::cast::EventIssueUpdated) -> CdpEvent {
            CdpEvent::CastIssueUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventAttributeModified {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomAttributeModified(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventAttributeModified> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventAttributeModified) -> CdpEvent {
            CdpEvent::DomAttributeModified(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventAttributeRemoved {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomAttributeRemoved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventAttributeRemoved> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventAttributeRemoved) -> CdpEvent {
            CdpEvent::DomAttributeRemoved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventCharacterDataModified {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomCharacterDataModified(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventCharacterDataModified> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventCharacterDataModified) -> CdpEvent {
            CdpEvent::DomCharacterDataModified(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventChildNodeCountUpdated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomChildNodeCountUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventChildNodeCountUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventChildNodeCountUpdated) -> CdpEvent {
            CdpEvent::DomChildNodeCountUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventChildNodeInserted {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomChildNodeInserted(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventChildNodeInserted> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventChildNodeInserted) -> CdpEvent {
            CdpEvent::DomChildNodeInserted(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventChildNodeRemoved {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomChildNodeRemoved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventChildNodeRemoved> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventChildNodeRemoved) -> CdpEvent {
            CdpEvent::DomChildNodeRemoved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::dom::EventDistributedNodesUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomDistributedNodesUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventDistributedNodesUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventDistributedNodesUpdated) -> CdpEvent {
            CdpEvent::DomDistributedNodesUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventDocumentUpdated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomDocumentUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventDocumentUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventDocumentUpdated) -> CdpEvent {
            CdpEvent::DomDocumentUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventInlineStyleInvalidated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomInlineStyleInvalidated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventInlineStyleInvalidated> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventInlineStyleInvalidated) -> CdpEvent {
            CdpEvent::DomInlineStyleInvalidated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventPseudoElementAdded {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomPseudoElementAdded(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventPseudoElementAdded> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventPseudoElementAdded) -> CdpEvent {
            CdpEvent::DomPseudoElementAdded(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventPseudoElementRemoved {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomPseudoElementRemoved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventPseudoElementRemoved> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventPseudoElementRemoved) -> CdpEvent {
            CdpEvent::DomPseudoElementRemoved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventSetChildNodes {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomSetChildNodes(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventSetChildNodes> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventSetChildNodes) -> CdpEvent {
            CdpEvent::DomSetChildNodes(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventShadowRootPopped {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomShadowRootPopped(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventShadowRootPopped> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventShadowRootPopped) -> CdpEvent {
            CdpEvent::DomShadowRootPopped(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::dom::EventShadowRootPushed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomShadowRootPushed(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom::EventShadowRootPushed> for CdpEvent {
        fn from(el: super::browser_protocol::dom::EventShadowRootPushed) -> CdpEvent {
            CdpEvent::DomShadowRootPushed(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::dom_storage::EventDomStorageItemAdded
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomStorageDomStorageItemAdded(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom_storage::EventDomStorageItemAdded> for CdpEvent {
        fn from(el: super::browser_protocol::dom_storage::EventDomStorageItemAdded) -> CdpEvent {
            CdpEvent::DomStorageDomStorageItemAdded(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::dom_storage::EventDomStorageItemRemoved
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomStorageDomStorageItemRemoved(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom_storage::EventDomStorageItemRemoved> for CdpEvent {
        fn from(el: super::browser_protocol::dom_storage::EventDomStorageItemRemoved) -> CdpEvent {
            CdpEvent::DomStorageDomStorageItemRemoved(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::dom_storage::EventDomStorageItemUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomStorageDomStorageItemUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom_storage::EventDomStorageItemUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::dom_storage::EventDomStorageItemUpdated) -> CdpEvent {
            CdpEvent::DomStorageDomStorageItemUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::dom_storage::EventDomStorageItemsCleared
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DomStorageDomStorageItemsCleared(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::dom_storage::EventDomStorageItemsCleared> for CdpEvent {
        fn from(el: super::browser_protocol::dom_storage::EventDomStorageItemsCleared) -> CdpEvent {
            CdpEvent::DomStorageDomStorageItemsCleared(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::database::EventAddDatabase {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::DatabaseAddDatabase(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::database::EventAddDatabase> for CdpEvent {
        fn from(el: super::browser_protocol::database::EventAddDatabase) -> CdpEvent {
            CdpEvent::DatabaseAddDatabase(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::emulation::EventVirtualTimeBudgetExpired
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::EmulationVirtualTimeBudgetExpired(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::emulation::EventVirtualTimeBudgetExpired> for CdpEvent {
        fn from(el: super::browser_protocol::emulation::EventVirtualTimeBudgetExpired) -> CdpEvent {
            CdpEvent::EmulationVirtualTimeBudgetExpired(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::inspector::EventDetached {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::InspectorDetached(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::inspector::EventDetached> for CdpEvent {
        fn from(el: super::browser_protocol::inspector::EventDetached) -> CdpEvent {
            CdpEvent::InspectorDetached(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::inspector::EventTargetCrashed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::InspectorTargetCrashed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::inspector::EventTargetCrashed> for CdpEvent {
        fn from(el: super::browser_protocol::inspector::EventTargetCrashed) -> CdpEvent {
            CdpEvent::InspectorTargetCrashed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::inspector::EventTargetReloadedAfterCrash
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::InspectorTargetReloadedAfterCrash(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::inspector::EventTargetReloadedAfterCrash> for CdpEvent {
        fn from(el: super::browser_protocol::inspector::EventTargetReloadedAfterCrash) -> CdpEvent {
            CdpEvent::InspectorTargetReloadedAfterCrash(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::layer_tree::EventLayerPainted {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::LayerTreeLayerPainted(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::layer_tree::EventLayerPainted> for CdpEvent {
        fn from(el: super::browser_protocol::layer_tree::EventLayerPainted) -> CdpEvent {
            CdpEvent::LayerTreeLayerPainted(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::layer_tree::EventLayerTreeDidChange
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::LayerTreeLayerTreeDidChange(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::layer_tree::EventLayerTreeDidChange> for CdpEvent {
        fn from(el: super::browser_protocol::layer_tree::EventLayerTreeDidChange) -> CdpEvent {
            CdpEvent::LayerTreeLayerTreeDidChange(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::log::EventEntryAdded {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::LogEntryAdded(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::log::EventEntryAdded> for CdpEvent {
        fn from(el: super::browser_protocol::log::EventEntryAdded) -> CdpEvent {
            CdpEvent::LogEntryAdded(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventDataReceived {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkDataReceived(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventDataReceived> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventDataReceived) -> CdpEvent {
            CdpEvent::NetworkDataReceived(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventEventSourceMessageReceived
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkEventSourceMessageReceived(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventEventSourceMessageReceived> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventEventSourceMessageReceived) -> CdpEvent {
            CdpEvent::NetworkEventSourceMessageReceived(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventLoadingFailed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkLoadingFailed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventLoadingFailed> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventLoadingFailed) -> CdpEvent {
            CdpEvent::NetworkLoadingFailed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventLoadingFinished {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkLoadingFinished(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventLoadingFinished> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventLoadingFinished) -> CdpEvent {
            CdpEvent::NetworkLoadingFinished(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventRequestServedFromCache
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkRequestServedFromCache(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventRequestServedFromCache> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventRequestServedFromCache) -> CdpEvent {
            CdpEvent::NetworkRequestServedFromCache(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventRequestWillBeSent {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkRequestWillBeSent(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventRequestWillBeSent> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventRequestWillBeSent) -> CdpEvent {
            CdpEvent::NetworkRequestWillBeSent(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventResourceChangedPriority
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkResourceChangedPriority(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventResourceChangedPriority> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventResourceChangedPriority) -> CdpEvent {
            CdpEvent::NetworkResourceChangedPriority(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventSignedExchangeReceived
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkSignedExchangeReceived(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventSignedExchangeReceived> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventSignedExchangeReceived) -> CdpEvent {
            CdpEvent::NetworkSignedExchangeReceived(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventResponseReceived {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkResponseReceived(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventResponseReceived> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventResponseReceived) -> CdpEvent {
            CdpEvent::NetworkResponseReceived(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventWebSocketClosed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketClosed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketClosed> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventWebSocketClosed) -> CdpEvent {
            CdpEvent::NetworkWebSocketClosed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventWebSocketCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketCreated(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketCreated> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventWebSocketCreated) -> CdpEvent {
            CdpEvent::NetworkWebSocketCreated(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventWebSocketFrameError
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketFrameError(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketFrameError> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventWebSocketFrameError) -> CdpEvent {
            CdpEvent::NetworkWebSocketFrameError(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventWebSocketFrameReceived
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketFrameReceived(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketFrameReceived> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventWebSocketFrameReceived) -> CdpEvent {
            CdpEvent::NetworkWebSocketFrameReceived(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::network::EventWebSocketFrameSent {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketFrameSent(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketFrameSent> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventWebSocketFrameSent) -> CdpEvent {
            CdpEvent::NetworkWebSocketFrameSent(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventWebSocketHandshakeResponseReceived
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketHandshakeResponseReceived(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketHandshakeResponseReceived> for CdpEvent {
        fn from(
            el: super::browser_protocol::network::EventWebSocketHandshakeResponseReceived,
        ) -> CdpEvent {
            CdpEvent::NetworkWebSocketHandshakeResponseReceived(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkWebSocketWillSendHandshakeRequest(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest> for CdpEvent {
        fn from(
            el: super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest,
        ) -> CdpEvent {
            CdpEvent::NetworkWebSocketWillSendHandshakeRequest(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventRequestWillBeSentExtraInfo
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkRequestWillBeSentExtraInfo(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventRequestWillBeSentExtraInfo> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventRequestWillBeSentExtraInfo) -> CdpEvent {
            CdpEvent::NetworkRequestWillBeSentExtraInfo(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::network::EventResponseReceivedExtraInfo
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::NetworkResponseReceivedExtraInfo(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::network::EventResponseReceivedExtraInfo> for CdpEvent {
        fn from(el: super::browser_protocol::network::EventResponseReceivedExtraInfo) -> CdpEvent {
            CdpEvent::NetworkResponseReceivedExtraInfo(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::overlay::EventInspectNodeRequested
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::OverlayInspectNodeRequested(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::overlay::EventInspectNodeRequested> for CdpEvent {
        fn from(el: super::browser_protocol::overlay::EventInspectNodeRequested) -> CdpEvent {
            CdpEvent::OverlayInspectNodeRequested(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::overlay::EventNodeHighlightRequested
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::OverlayNodeHighlightRequested(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::overlay::EventNodeHighlightRequested> for CdpEvent {
        fn from(el: super::browser_protocol::overlay::EventNodeHighlightRequested) -> CdpEvent {
            CdpEvent::OverlayNodeHighlightRequested(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::overlay::EventScreenshotRequested
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::OverlayScreenshotRequested(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::overlay::EventScreenshotRequested> for CdpEvent {
        fn from(el: super::browser_protocol::overlay::EventScreenshotRequested) -> CdpEvent {
            CdpEvent::OverlayScreenshotRequested(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::overlay::EventInspectModeCanceled
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::OverlayInspectModeCanceled(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::overlay::EventInspectModeCanceled> for CdpEvent {
        fn from(el: super::browser_protocol::overlay::EventInspectModeCanceled) -> CdpEvent {
            CdpEvent::OverlayInspectModeCanceled(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventDomContentEventFired {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageDomContentEventFired(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventDomContentEventFired> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventDomContentEventFired) -> CdpEvent {
            CdpEvent::PageDomContentEventFired(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFileChooserOpened {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFileChooserOpened(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFileChooserOpened> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFileChooserOpened) -> CdpEvent {
            CdpEvent::PageFileChooserOpened(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameAttached {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameAttached(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameAttached> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameAttached) -> CdpEvent {
            CdpEvent::PageFrameAttached(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameDetached {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameDetached(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameDetached> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameDetached) -> CdpEvent {
            CdpEvent::PageFrameDetached(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameNavigated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameNavigated(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameNavigated> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameNavigated) -> CdpEvent {
            CdpEvent::PageFrameNavigated(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameResized {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameResized(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameResized> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameResized) -> CdpEvent {
            CdpEvent::PageFrameResized(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventFrameRequestedNavigation
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameRequestedNavigation(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameRequestedNavigation> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameRequestedNavigation) -> CdpEvent {
            CdpEvent::PageFrameRequestedNavigation(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameStartedLoading {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameStartedLoading(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameStartedLoading> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameStartedLoading) -> CdpEvent {
            CdpEvent::PageFrameStartedLoading(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventFrameStoppedLoading {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageFrameStoppedLoading(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventFrameStoppedLoading> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventFrameStoppedLoading) -> CdpEvent {
            CdpEvent::PageFrameStoppedLoading(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventDownloadWillBegin {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageDownloadWillBegin(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventDownloadWillBegin> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventDownloadWillBegin) -> CdpEvent {
            CdpEvent::PageDownloadWillBegin(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventDownloadProgress {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageDownloadProgress(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventDownloadProgress> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventDownloadProgress) -> CdpEvent {
            CdpEvent::PageDownloadProgress(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventInterstitialHidden {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageInterstitialHidden(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventInterstitialHidden> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventInterstitialHidden) -> CdpEvent {
            CdpEvent::PageInterstitialHidden(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventInterstitialShown {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageInterstitialShown(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventInterstitialShown> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventInterstitialShown) -> CdpEvent {
            CdpEvent::PageInterstitialShown(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventJavascriptDialogClosed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageJavascriptDialogClosed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventJavascriptDialogClosed> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventJavascriptDialogClosed) -> CdpEvent {
            CdpEvent::PageJavascriptDialogClosed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventJavascriptDialogOpening
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageJavascriptDialogOpening(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventJavascriptDialogOpening> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventJavascriptDialogOpening) -> CdpEvent {
            CdpEvent::PageJavascriptDialogOpening(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventLifecycleEvent {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageLifecycleEvent(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventLifecycleEvent> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventLifecycleEvent) -> CdpEvent {
            CdpEvent::PageLifecycleEvent(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventLoadEventFired {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageLoadEventFired(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventLoadEventFired> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventLoadEventFired) -> CdpEvent {
            CdpEvent::PageLoadEventFired(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventNavigatedWithinDocument
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageNavigatedWithinDocument(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventNavigatedWithinDocument> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventNavigatedWithinDocument) -> CdpEvent {
            CdpEvent::PageNavigatedWithinDocument(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventScreencastFrame {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageScreencastFrame(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventScreencastFrame> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventScreencastFrame) -> CdpEvent {
            CdpEvent::PageScreencastFrame(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventScreencastVisibilityChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageScreencastVisibilityChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventScreencastVisibilityChanged> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventScreencastVisibilityChanged) -> CdpEvent {
            CdpEvent::PageScreencastVisibilityChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::page::EventWindowOpen {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageWindowOpen(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventWindowOpen> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventWindowOpen) -> CdpEvent {
            CdpEvent::PageWindowOpen(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::page::EventCompilationCacheProduced
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PageCompilationCacheProduced(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::page::EventCompilationCacheProduced> for CdpEvent {
        fn from(el: super::browser_protocol::page::EventCompilationCacheProduced) -> CdpEvent {
            CdpEvent::PageCompilationCacheProduced(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::performance::EventMetrics {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::PerformanceMetrics(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::performance::EventMetrics> for CdpEvent {
        fn from(el: super::browser_protocol::performance::EventMetrics) -> CdpEvent {
            CdpEvent::PerformanceMetrics(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::security::EventVisibleSecurityStateChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::SecurityVisibleSecurityStateChanged(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::security::EventVisibleSecurityStateChanged> for CdpEvent {
        fn from(
            el: super::browser_protocol::security::EventVisibleSecurityStateChanged,
        ) -> CdpEvent {
            CdpEvent::SecurityVisibleSecurityStateChanged(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::security::EventSecurityStateChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::SecuritySecurityStateChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::security::EventSecurityStateChanged> for CdpEvent {
        fn from(el: super::browser_protocol::security::EventSecurityStateChanged) -> CdpEvent {
            CdpEvent::SecuritySecurityStateChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::service_worker::EventWorkerErrorReported
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ServiceWorkerWorkerErrorReported(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::service_worker::EventWorkerErrorReported> for CdpEvent {
        fn from(el: super::browser_protocol::service_worker::EventWorkerErrorReported) -> CdpEvent {
            CdpEvent::ServiceWorkerWorkerErrorReported(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::service_worker::EventWorkerRegistrationUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ServiceWorkerWorkerRegistrationUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::service_worker::EventWorkerRegistrationUpdated> for CdpEvent {
        fn from(
            el: super::browser_protocol::service_worker::EventWorkerRegistrationUpdated,
        ) -> CdpEvent {
            CdpEvent::ServiceWorkerWorkerRegistrationUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::service_worker::EventWorkerVersionUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::ServiceWorkerWorkerVersionUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::service_worker::EventWorkerVersionUpdated> for CdpEvent {
        fn from(
            el: super::browser_protocol::service_worker::EventWorkerVersionUpdated,
        ) -> CdpEvent {
            CdpEvent::ServiceWorkerWorkerVersionUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::storage::EventCacheStorageContentUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::StorageCacheStorageContentUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::storage::EventCacheStorageContentUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::storage::EventCacheStorageContentUpdated) -> CdpEvent {
            CdpEvent::StorageCacheStorageContentUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::storage::EventCacheStorageListUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::StorageCacheStorageListUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::storage::EventCacheStorageListUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::storage::EventCacheStorageListUpdated) -> CdpEvent {
            CdpEvent::StorageCacheStorageListUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::storage::EventIndexedDbContentUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::StorageIndexedDbContentUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::storage::EventIndexedDbContentUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::storage::EventIndexedDbContentUpdated) -> CdpEvent {
            CdpEvent::StorageIndexedDbContentUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::storage::EventIndexedDbListUpdated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::StorageIndexedDbListUpdated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::storage::EventIndexedDbListUpdated> for CdpEvent {
        fn from(el: super::browser_protocol::storage::EventIndexedDbListUpdated) -> CdpEvent {
            CdpEvent::StorageIndexedDbListUpdated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventAttachedToTarget {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetAttachedToTarget(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventAttachedToTarget> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventAttachedToTarget) -> CdpEvent {
            CdpEvent::TargetAttachedToTarget(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventDetachedFromTarget {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetDetachedFromTarget(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventDetachedFromTarget> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventDetachedFromTarget) -> CdpEvent {
            CdpEvent::TargetDetachedFromTarget(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::target::EventReceivedMessageFromTarget
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetReceivedMessageFromTarget(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventReceivedMessageFromTarget> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventReceivedMessageFromTarget) -> CdpEvent {
            CdpEvent::TargetReceivedMessageFromTarget(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventTargetCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetTargetCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventTargetCreated> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventTargetCreated) -> CdpEvent {
            CdpEvent::TargetTargetCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventTargetDestroyed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetTargetDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventTargetDestroyed> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventTargetDestroyed) -> CdpEvent {
            CdpEvent::TargetTargetDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventTargetCrashed {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetTargetCrashed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventTargetCrashed> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventTargetCrashed) -> CdpEvent {
            CdpEvent::TargetTargetCrashed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::target::EventTargetInfoChanged {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TargetTargetInfoChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::target::EventTargetInfoChanged> for CdpEvent {
        fn from(el: super::browser_protocol::target::EventTargetInfoChanged) -> CdpEvent {
            CdpEvent::TargetTargetInfoChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::tethering::EventAccepted {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TetheringAccepted(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::tethering::EventAccepted> for CdpEvent {
        fn from(el: super::browser_protocol::tethering::EventAccepted) -> CdpEvent {
            CdpEvent::TetheringAccepted(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::tracing::EventBufferUsage {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TracingBufferUsage(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::tracing::EventBufferUsage> for CdpEvent {
        fn from(el: super::browser_protocol::tracing::EventBufferUsage) -> CdpEvent {
            CdpEvent::TracingBufferUsage(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::tracing::EventDataCollected {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TracingDataCollected(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::tracing::EventDataCollected> for CdpEvent {
        fn from(el: super::browser_protocol::tracing::EventDataCollected) -> CdpEvent {
            CdpEvent::TracingDataCollected(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::tracing::EventTracingComplete {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::TracingTracingComplete(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::tracing::EventTracingComplete> for CdpEvent {
        fn from(el: super::browser_protocol::tracing::EventTracingComplete) -> CdpEvent {
            CdpEvent::TracingTracingComplete(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::fetch::EventRequestPaused {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::FetchRequestPaused(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::fetch::EventRequestPaused> for CdpEvent {
        fn from(el: super::browser_protocol::fetch::EventRequestPaused) -> CdpEvent {
            CdpEvent::FetchRequestPaused(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::fetch::EventAuthRequired {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::FetchAuthRequired(val) => Ok(*val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::fetch::EventAuthRequired> for CdpEvent {
        fn from(el: super::browser_protocol::fetch::EventAuthRequired) -> CdpEvent {
            CdpEvent::FetchAuthRequired(Box::new(el))
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::web_audio::EventContextCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioContextCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventContextCreated> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventContextCreated) -> CdpEvent {
            CdpEvent::WebAudioContextCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventContextWillBeDestroyed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioContextWillBeDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventContextWillBeDestroyed> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventContextWillBeDestroyed) -> CdpEvent {
            CdpEvent::WebAudioContextWillBeDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::web_audio::EventContextChanged {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioContextChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventContextChanged> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventContextChanged) -> CdpEvent {
            CdpEvent::WebAudioContextChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventAudioListenerCreated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioListenerCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioListenerCreated> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventAudioListenerCreated) -> CdpEvent {
            CdpEvent::WebAudioAudioListenerCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioListenerWillBeDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed> for CdpEvent {
        fn from(
            el: super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed,
        ) -> CdpEvent {
            CdpEvent::WebAudioAudioListenerWillBeDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::web_audio::EventAudioNodeCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioNodeCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioNodeCreated> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventAudioNodeCreated) -> CdpEvent {
            CdpEvent::WebAudioAudioNodeCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioNodeWillBeDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed) -> CdpEvent {
            CdpEvent::WebAudioAudioNodeWillBeDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventAudioParamCreated
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioParamCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioParamCreated> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventAudioParamCreated) -> CdpEvent {
            CdpEvent::WebAudioAudioParamCreated(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioAudioParamWillBeDestroyed(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed> for CdpEvent {
        fn from(
            el: super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed,
        ) -> CdpEvent {
            CdpEvent::WebAudioAudioParamWillBeDestroyed(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::web_audio::EventNodesConnected {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioNodesConnected(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventNodesConnected> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventNodesConnected) -> CdpEvent {
            CdpEvent::WebAudioNodesConnected(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventNodesDisconnected
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioNodesDisconnected(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventNodesDisconnected> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventNodesDisconnected) -> CdpEvent {
            CdpEvent::WebAudioNodesDisconnected(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventNodeParamConnected
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioNodeParamConnected(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventNodeParamConnected> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventNodeParamConnected) -> CdpEvent {
            CdpEvent::WebAudioNodeParamConnected(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::web_audio::EventNodeParamDisconnected
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::WebAudioNodeParamDisconnected(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::web_audio::EventNodeParamDisconnected> for CdpEvent {
        fn from(el: super::browser_protocol::web_audio::EventNodeParamDisconnected) -> CdpEvent {
            CdpEvent::WebAudioNodeParamDisconnected(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent>
        for super::browser_protocol::media::EventPlayerPropertiesChanged
    {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::MediaPlayerPropertiesChanged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::media::EventPlayerPropertiesChanged> for CdpEvent {
        fn from(el: super::browser_protocol::media::EventPlayerPropertiesChanged) -> CdpEvent {
            CdpEvent::MediaPlayerPropertiesChanged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::media::EventPlayerEventsAdded {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::MediaPlayerEventsAdded(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::media::EventPlayerEventsAdded> for CdpEvent {
        fn from(el: super::browser_protocol::media::EventPlayerEventsAdded) -> CdpEvent {
            CdpEvent::MediaPlayerEventsAdded(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::media::EventPlayerMessagesLogged {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::MediaPlayerMessagesLogged(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::media::EventPlayerMessagesLogged> for CdpEvent {
        fn from(el: super::browser_protocol::media::EventPlayerMessagesLogged) -> CdpEvent {
            CdpEvent::MediaPlayerMessagesLogged(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::media::EventPlayerErrorsRaised {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::MediaPlayerErrorsRaised(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::media::EventPlayerErrorsRaised> for CdpEvent {
        fn from(el: super::browser_protocol::media::EventPlayerErrorsRaised) -> CdpEvent {
            CdpEvent::MediaPlayerErrorsRaised(el)
        }
    }
    impl std::convert::TryFrom<CdpEvent> for super::browser_protocol::media::EventPlayersCreated {
        type Error = CdpEvent;
        fn try_from(event: CdpEvent) -> Result<Self, Self::Error> {
            match event {
                CdpEvent::MediaPlayersCreated(val) => Ok(val),
                _ => Err(event),
            }
        }
    }
    impl From<super::browser_protocol::media::EventPlayersCreated> for CdpEvent {
        fn from(el: super::browser_protocol::media::EventPlayersCreated) -> CdpEvent {
            CdpEvent::MediaPlayersCreated(el)
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::debugger::EventBreakpointResolved {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::debugger::EventBreakpointResolved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::debugger::EventPaused {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::debugger::EventPaused {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::debugger::EventResumed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::debugger::EventResumed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::debugger::EventScriptFailedToParse {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::debugger::EventScriptFailedToParse {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::debugger::EventScriptParsed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::debugger::EventScriptParsed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::heap_profiler::EventAddHeapSnapshotChunk {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::heap_profiler::EventHeapStatsUpdate {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::heap_profiler::EventHeapStatsUpdate {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::heap_profiler::EventLastSeenObjectId {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::heap_profiler::EventLastSeenObjectId {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::heap_profiler::EventReportHeapSnapshotProgress {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::heap_profiler::EventResetProfiles {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::heap_profiler::EventResetProfiles {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::profiler::EventConsoleProfileFinished {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::profiler::EventConsoleProfileFinished {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::profiler::EventConsoleProfileStarted {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::profiler::EventConsoleProfileStarted {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::profiler::EventPreciseCoverageDeltaUpdate {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventBindingCalled {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventBindingCalled {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventConsoleApiCalled {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventConsoleApiCalled {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventExceptionRevoked {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventExceptionRevoked {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventExceptionThrown {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventExceptionThrown {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventExecutionContextCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventExecutionContextCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventExecutionContextDestroyed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventExecutionContextDestroyed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventExecutionContextsCleared {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventExecutionContextsCleared {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::js_protocol::runtime::EventInspectRequested {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::js_protocol::runtime::EventInspectRequested {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::animation::EventAnimationCanceled {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::animation::EventAnimationCanceled {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::animation::EventAnimationCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::animation::EventAnimationCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::animation::EventAnimationStarted {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::animation::EventAnimationStarted {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::application_cache::EventApplicationCacheStatusUpdated
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::application_cache::EventNetworkStateUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::application_cache::EventNetworkStateUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::audits::EventIssueAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::audits::EventIssueAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::background_service::EventRecordingStateChanged
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::background_service::EventRecordingStateChanged
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::background_service::EventBackgroundServiceEventReceived
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::background_service::EventBackgroundServiceEventReceived
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::css::EventFontsUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::css::EventFontsUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::css::EventMediaQueryResultChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::css::EventMediaQueryResultChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::css::EventStyleSheetAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::css::EventStyleSheetAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::css::EventStyleSheetChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::css::EventStyleSheetChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::css::EventStyleSheetRemoved {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::css::EventStyleSheetRemoved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::cast::EventSinksUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::cast::EventSinksUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::cast::EventIssueUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::cast::EventIssueUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventAttributeModified {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventAttributeModified {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventAttributeRemoved {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventAttributeRemoved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventCharacterDataModified {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventCharacterDataModified {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventChildNodeCountUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventChildNodeCountUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventChildNodeInserted {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventChildNodeInserted {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventChildNodeRemoved {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventChildNodeRemoved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventDistributedNodesUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventDistributedNodesUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventDocumentUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventDocumentUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventInlineStyleInvalidated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventInlineStyleInvalidated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventPseudoElementAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventPseudoElementAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventPseudoElementRemoved {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventPseudoElementRemoved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventSetChildNodes {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventSetChildNodes {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventShadowRootPopped {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventShadowRootPopped {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom::EventShadowRootPushed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom::EventShadowRootPushed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::dom_storage::EventDomStorageItemAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom_storage::EventDomStorageItemAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::dom_storage::EventDomStorageItemRemoved
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom_storage::EventDomStorageItemRemoved {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::dom_storage::EventDomStorageItemUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom_storage::EventDomStorageItemUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::dom_storage::EventDomStorageItemsCleared
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::dom_storage::EventDomStorageItemsCleared {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::database::EventAddDatabase {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::database::EventAddDatabase {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::emulation::EventVirtualTimeBudgetExpired
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::emulation::EventVirtualTimeBudgetExpired {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::inspector::EventDetached {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::inspector::EventDetached {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::inspector::EventTargetCrashed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::inspector::EventTargetCrashed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::inspector::EventTargetReloadedAfterCrash
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::inspector::EventTargetReloadedAfterCrash {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::layer_tree::EventLayerPainted {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::layer_tree::EventLayerPainted {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::layer_tree::EventLayerTreeDidChange {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::layer_tree::EventLayerTreeDidChange {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::log::EventEntryAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::log::EventEntryAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventDataReceived {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventDataReceived {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::network::EventEventSourceMessageReceived
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventEventSourceMessageReceived {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventLoadingFailed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventLoadingFailed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventLoadingFinished {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventLoadingFinished {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventRequestServedFromCache {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventRequestServedFromCache {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventRequestWillBeSent {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventRequestWillBeSent {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventResourceChangedPriority {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventResourceChangedPriority {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventSignedExchangeReceived {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventSignedExchangeReceived {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventResponseReceived {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventResponseReceived {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventWebSocketClosed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventWebSocketClosed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventWebSocketCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventWebSocketCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventWebSocketFrameError {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventWebSocketFrameError {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventWebSocketFrameReceived {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventWebSocketFrameReceived {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::network::EventWebSocketFrameSent {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventWebSocketFrameSent {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::network::EventWebSocketHandshakeResponseReceived
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::network::EventWebSocketHandshakeResponseReceived
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::network::EventWebSocketWillSendHandshakeRequest
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::network::EventRequestWillBeSentExtraInfo
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventRequestWillBeSentExtraInfo {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::network::EventResponseReceivedExtraInfo
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::network::EventResponseReceivedExtraInfo {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::overlay::EventInspectNodeRequested {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::overlay::EventInspectNodeRequested {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::overlay::EventNodeHighlightRequested {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::overlay::EventNodeHighlightRequested {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::overlay::EventScreenshotRequested {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::overlay::EventScreenshotRequested {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::overlay::EventInspectModeCanceled {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::overlay::EventInspectModeCanceled {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventDomContentEventFired {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventDomContentEventFired {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFileChooserOpened {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFileChooserOpened {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameAttached {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameAttached {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameDetached {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameDetached {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameNavigated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameNavigated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameResized {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameResized {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameRequestedNavigation {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameRequestedNavigation {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameStartedLoading {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameStartedLoading {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventFrameStoppedLoading {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventFrameStoppedLoading {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventDownloadWillBegin {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventDownloadWillBegin {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventDownloadProgress {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventDownloadProgress {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventInterstitialHidden {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventInterstitialHidden {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventInterstitialShown {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventInterstitialShown {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventJavascriptDialogClosed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventJavascriptDialogClosed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventJavascriptDialogOpening {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventJavascriptDialogOpening {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventLifecycleEvent {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventLifecycleEvent {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventLoadEventFired {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventLoadEventFired {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventNavigatedWithinDocument {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventNavigatedWithinDocument {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventScreencastFrame {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventScreencastFrame {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::page::EventScreencastVisibilityChanged
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventScreencastVisibilityChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventWindowOpen {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventWindowOpen {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::page::EventCompilationCacheProduced {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::page::EventCompilationCacheProduced {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::performance::EventMetrics {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::performance::EventMetrics {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::security::EventVisibleSecurityStateChanged
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::security::EventVisibleSecurityStateChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::security::EventSecurityStateChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::security::EventSecurityStateChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::service_worker::EventWorkerErrorReported
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::service_worker::EventWorkerErrorReported {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::service_worker::EventWorkerRegistrationUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::service_worker::EventWorkerRegistrationUpdated
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::service_worker::EventWorkerVersionUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::service_worker::EventWorkerVersionUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::storage::EventCacheStorageContentUpdated
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::storage::EventCacheStorageContentUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::storage::EventCacheStorageListUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::storage::EventCacheStorageListUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::storage::EventIndexedDbContentUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::storage::EventIndexedDbContentUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::storage::EventIndexedDbListUpdated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::storage::EventIndexedDbListUpdated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventAttachedToTarget {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventAttachedToTarget {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventDetachedFromTarget {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventDetachedFromTarget {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::target::EventReceivedMessageFromTarget
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventReceivedMessageFromTarget {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventTargetCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventTargetCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventTargetDestroyed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventTargetDestroyed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventTargetCrashed {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventTargetCrashed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::target::EventTargetInfoChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::target::EventTargetInfoChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::tethering::EventAccepted {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::tethering::EventAccepted {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::tracing::EventBufferUsage {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::tracing::EventBufferUsage {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::tracing::EventDataCollected {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::tracing::EventDataCollected {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::tracing::EventTracingComplete {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::tracing::EventTracingComplete {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::fetch::EventRequestPaused {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::fetch::EventRequestPaused {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::fetch::EventAuthRequired {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::fetch::EventAuthRequired {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventContextCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventContextCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::web_audio::EventContextWillBeDestroyed
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventContextWillBeDestroyed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventContextChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventContextChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventAudioListenerCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventAudioListenerCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind
        for super::browser_protocol::web_audio::EventAudioListenerWillBeDestroyed
    {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventAudioNodeCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventAudioNodeCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventAudioNodeWillBeDestroyed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventAudioParamCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventAudioParamCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent
        for super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed
    {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventAudioParamWillBeDestroyed {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventNodesConnected {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventNodesConnected {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventNodesDisconnected {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventNodesDisconnected {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventNodeParamConnected {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventNodeParamConnected {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::web_audio::EventNodeParamDisconnected {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::web_audio::EventNodeParamDisconnected {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::media::EventPlayerPropertiesChanged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::media::EventPlayerPropertiesChanged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::media::EventPlayerEventsAdded {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::media::EventPlayerEventsAdded {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::media::EventPlayerMessagesLogged {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::media::EventPlayerMessagesLogged {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::media::EventPlayerErrorsRaised {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::media::EventPlayerErrorsRaised {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    impl super::sealed::SealedEvent for super::browser_protocol::media::EventPlayersCreated {
        fn as_any(&self) -> &dyn ::std::any::Any {
            self
        }
    }
    impl super::IntoEventKind for super::browser_protocol::media::EventPlayersCreated {
        fn event_kind() -> super::EventKind
        where
            Self: Sized + 'static,
        {
            super::EventKind::BuiltIn
        }
    }
    #[macro_export]
    #[doc(hidden)]
    macro_rules! consume_event {
        (match $ ev : ident { $ builtin : expr , $ custom : expr }) => {{
            match $ev {
                CdpEvent::DebuggerBreakpointResolved(event) => {
                    $builtin(event);
                }
                CdpEvent::DebuggerPaused(event) => {
                    $builtin(event);
                }
                CdpEvent::DebuggerResumed(event) => {
                    $builtin(event);
                }
                CdpEvent::DebuggerScriptFailedToParse(event) => {
                    $builtin(*event);
                }
                CdpEvent::DebuggerScriptParsed(event) => {
                    $builtin(*event);
                }
                CdpEvent::HeapProfilerAddHeapSnapshotChunk(event) => {
                    $builtin(event);
                }
                CdpEvent::HeapProfilerHeapStatsUpdate(event) => {
                    $builtin(event);
                }
                CdpEvent::HeapProfilerLastSeenObjectId(event) => {
                    $builtin(event);
                }
                CdpEvent::HeapProfilerReportHeapSnapshotProgress(event) => {
                    $builtin(event);
                }
                CdpEvent::HeapProfilerResetProfiles(event) => {
                    $builtin(event);
                }
                CdpEvent::ProfilerConsoleProfileFinished(event) => {
                    $builtin(event);
                }
                CdpEvent::ProfilerConsoleProfileStarted(event) => {
                    $builtin(event);
                }
                CdpEvent::ProfilerPreciseCoverageDeltaUpdate(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeBindingCalled(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeConsoleApiCalled(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeExceptionRevoked(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeExceptionThrown(event) => {
                    $builtin(*event);
                }
                CdpEvent::RuntimeExecutionContextCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeExecutionContextDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeExecutionContextsCleared(event) => {
                    $builtin(event);
                }
                CdpEvent::RuntimeInspectRequested(event) => {
                    $builtin(*event);
                }
                CdpEvent::AnimationAnimationCanceled(event) => {
                    $builtin(event);
                }
                CdpEvent::AnimationAnimationCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::AnimationAnimationStarted(event) => {
                    $builtin(*event);
                }
                CdpEvent::ApplicationCacheApplicationCacheStatusUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::ApplicationCacheNetworkStateUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::AuditsIssueAdded(event) => {
                    $builtin(*event);
                }
                CdpEvent::BackgroundServiceRecordingStateChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::BackgroundServiceBackgroundServiceEventReceived(event) => {
                    $builtin(event);
                }
                CdpEvent::CssFontsUpdated(event) => {
                    $builtin(*event);
                }
                CdpEvent::CssMediaQueryResultChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::CssStyleSheetAdded(event) => {
                    $builtin(event);
                }
                CdpEvent::CssStyleSheetChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::CssStyleSheetRemoved(event) => {
                    $builtin(event);
                }
                CdpEvent::CastSinksUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::CastIssueUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomAttributeModified(event) => {
                    $builtin(event);
                }
                CdpEvent::DomAttributeRemoved(event) => {
                    $builtin(event);
                }
                CdpEvent::DomCharacterDataModified(event) => {
                    $builtin(event);
                }
                CdpEvent::DomChildNodeCountUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomChildNodeInserted(event) => {
                    $builtin(*event);
                }
                CdpEvent::DomChildNodeRemoved(event) => {
                    $builtin(event);
                }
                CdpEvent::DomDistributedNodesUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomDocumentUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomInlineStyleInvalidated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomPseudoElementAdded(event) => {
                    $builtin(*event);
                }
                CdpEvent::DomPseudoElementRemoved(event) => {
                    $builtin(event);
                }
                CdpEvent::DomSetChildNodes(event) => {
                    $builtin(event);
                }
                CdpEvent::DomShadowRootPopped(event) => {
                    $builtin(event);
                }
                CdpEvent::DomShadowRootPushed(event) => {
                    $builtin(*event);
                }
                CdpEvent::DomStorageDomStorageItemAdded(event) => {
                    $builtin(event);
                }
                CdpEvent::DomStorageDomStorageItemRemoved(event) => {
                    $builtin(event);
                }
                CdpEvent::DomStorageDomStorageItemUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::DomStorageDomStorageItemsCleared(event) => {
                    $builtin(event);
                }
                CdpEvent::DatabaseAddDatabase(event) => {
                    $builtin(event);
                }
                CdpEvent::EmulationVirtualTimeBudgetExpired(event) => {
                    $builtin(event);
                }
                CdpEvent::InspectorDetached(event) => {
                    $builtin(event);
                }
                CdpEvent::InspectorTargetCrashed(event) => {
                    $builtin(event);
                }
                CdpEvent::InspectorTargetReloadedAfterCrash(event) => {
                    $builtin(event);
                }
                CdpEvent::LayerTreeLayerPainted(event) => {
                    $builtin(event);
                }
                CdpEvent::LayerTreeLayerTreeDidChange(event) => {
                    $builtin(event);
                }
                CdpEvent::LogEntryAdded(event) => {
                    $builtin(*event);
                }
                CdpEvent::NetworkDataReceived(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkEventSourceMessageReceived(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkLoadingFailed(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkLoadingFinished(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkRequestServedFromCache(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkRequestWillBeSent(event) => {
                    $builtin(*event);
                }
                CdpEvent::NetworkResourceChangedPriority(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkSignedExchangeReceived(event) => {
                    $builtin(*event);
                }
                CdpEvent::NetworkResponseReceived(event) => {
                    $builtin(*event);
                }
                CdpEvent::NetworkWebSocketClosed(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkWebSocketCreated(event) => {
                    $builtin(*event);
                }
                CdpEvent::NetworkWebSocketFrameError(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkWebSocketFrameReceived(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkWebSocketFrameSent(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkWebSocketHandshakeResponseReceived(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkWebSocketWillSendHandshakeRequest(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkRequestWillBeSentExtraInfo(event) => {
                    $builtin(event);
                }
                CdpEvent::NetworkResponseReceivedExtraInfo(event) => {
                    $builtin(event);
                }
                CdpEvent::OverlayInspectNodeRequested(event) => {
                    $builtin(event);
                }
                CdpEvent::OverlayNodeHighlightRequested(event) => {
                    $builtin(event);
                }
                CdpEvent::OverlayScreenshotRequested(event) => {
                    $builtin(event);
                }
                CdpEvent::OverlayInspectModeCanceled(event) => {
                    $builtin(event);
                }
                CdpEvent::PageDomContentEventFired(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFileChooserOpened(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameAttached(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameDetached(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameNavigated(event) => {
                    $builtin(*event);
                }
                CdpEvent::PageFrameResized(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameRequestedNavigation(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameStartedLoading(event) => {
                    $builtin(event);
                }
                CdpEvent::PageFrameStoppedLoading(event) => {
                    $builtin(event);
                }
                CdpEvent::PageDownloadWillBegin(event) => {
                    $builtin(event);
                }
                CdpEvent::PageDownloadProgress(event) => {
                    $builtin(event);
                }
                CdpEvent::PageInterstitialHidden(event) => {
                    $builtin(event);
                }
                CdpEvent::PageInterstitialShown(event) => {
                    $builtin(event);
                }
                CdpEvent::PageJavascriptDialogClosed(event) => {
                    $builtin(event);
                }
                CdpEvent::PageJavascriptDialogOpening(event) => {
                    $builtin(event);
                }
                CdpEvent::PageLifecycleEvent(event) => {
                    $builtin(event);
                }
                CdpEvent::PageLoadEventFired(event) => {
                    $builtin(event);
                }
                CdpEvent::PageNavigatedWithinDocument(event) => {
                    $builtin(event);
                }
                CdpEvent::PageScreencastFrame(event) => {
                    $builtin(event);
                }
                CdpEvent::PageScreencastVisibilityChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::PageWindowOpen(event) => {
                    $builtin(event);
                }
                CdpEvent::PageCompilationCacheProduced(event) => {
                    $builtin(event);
                }
                CdpEvent::PerformanceMetrics(event) => {
                    $builtin(event);
                }
                CdpEvent::SecurityVisibleSecurityStateChanged(event) => {
                    $builtin(*event);
                }
                CdpEvent::SecuritySecurityStateChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::ServiceWorkerWorkerErrorReported(event) => {
                    $builtin(event);
                }
                CdpEvent::ServiceWorkerWorkerRegistrationUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::ServiceWorkerWorkerVersionUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::StorageCacheStorageContentUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::StorageCacheStorageListUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::StorageIndexedDbContentUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::StorageIndexedDbListUpdated(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetAttachedToTarget(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetDetachedFromTarget(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetReceivedMessageFromTarget(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetTargetCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetTargetDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetTargetCrashed(event) => {
                    $builtin(event);
                }
                CdpEvent::TargetTargetInfoChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::TetheringAccepted(event) => {
                    $builtin(event);
                }
                CdpEvent::TracingBufferUsage(event) => {
                    $builtin(event);
                }
                CdpEvent::TracingDataCollected(event) => {
                    $builtin(event);
                }
                CdpEvent::TracingTracingComplete(event) => {
                    $builtin(event);
                }
                CdpEvent::FetchRequestPaused(event) => {
                    $builtin(*event);
                }
                CdpEvent::FetchAuthRequired(event) => {
                    $builtin(*event);
                }
                CdpEvent::WebAudioContextCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioContextWillBeDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioContextChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioListenerCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioListenerWillBeDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioNodeCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioNodeWillBeDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioParamCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioAudioParamWillBeDestroyed(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioNodesConnected(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioNodesDisconnected(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioNodeParamConnected(event) => {
                    $builtin(event);
                }
                CdpEvent::WebAudioNodeParamDisconnected(event) => {
                    $builtin(event);
                }
                CdpEvent::MediaPlayerPropertiesChanged(event) => {
                    $builtin(event);
                }
                CdpEvent::MediaPlayerEventsAdded(event) => {
                    $builtin(event);
                }
                CdpEvent::MediaPlayerMessagesLogged(event) => {
                    $builtin(event);
                }
                CdpEvent::MediaPlayerErrorsRaised(event) => {
                    $builtin(event);
                }
                CdpEvent::MediaPlayersCreated(event) => {
                    $builtin(event);
                }
                CdpEvent::Other(json) => {
                    $custom(json);
                }
            }
        }};
    }
}
#[allow(clippy::wrong_self_convention)]
pub mod js_protocol {
    #[doc = r" The version of this protocol definition"]
    pub const VERSION: &str = "1.3";
    #[doc = "Debugger domain exposes JavaScript debugging capabilities. It allows setting and removing\nbreakpoints, stepping through execution, exploring stack traces, etc."]
    pub mod debugger {
        use serde::{Deserialize, Serialize};
        #[doc = "Breakpoint identifier.\n[BreakpointId](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-BreakpointId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct BreakpointId(String);
        impl BreakpointId {
            pub fn new(val: impl Into<String>) -> Self {
                BreakpointId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for BreakpointId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<BreakpointId> for String {
            fn from(el: BreakpointId) -> String {
                el.0
            }
        }
        impl From<String> for BreakpointId {
            fn from(expr: String) -> Self {
                BreakpointId(expr)
            }
        }
        impl std::borrow::Borrow<str> for BreakpointId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl BreakpointId {
            pub const IDENTIFIER: &'static str = "Debugger.BreakpointId";
        }
        #[doc = "Call frame identifier.\n[CallFrameId](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-CallFrameId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct CallFrameId(String);
        impl CallFrameId {
            pub fn new(val: impl Into<String>) -> Self {
                CallFrameId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for CallFrameId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<CallFrameId> for String {
            fn from(el: CallFrameId) -> String {
                el.0
            }
        }
        impl From<String> for CallFrameId {
            fn from(expr: String) -> Self {
                CallFrameId(expr)
            }
        }
        impl std::borrow::Borrow<str> for CallFrameId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl CallFrameId {
            pub const IDENTIFIER: &'static str = "Debugger.CallFrameId";
        }
        #[doc = "Location in the source code.\n[Location](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-Location)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct Location {
            #[doc = "Script identifier as reported in the `Debugger.scriptParsed`."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "Line number in the script (0-based)."]
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[doc = "Column number in the script (0-based)."]
            #[serde(rename = "columnNumber")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub column_number: Option<i64>,
        }
        impl Location {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                line_number: impl Into<i64>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    line_number: line_number.into(),
                    column_number: None,
                }
            }
        }
        impl Location {
            pub fn builder() -> LocationBuilder {
                LocationBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct LocationBuilder {
            script_id: Option<super::runtime::ScriptId>,
            line_number: Option<i64>,
            column_number: Option<i64>,
        }
        impl LocationBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn build(self) -> Result<Location, String> {
                Ok(Location {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number,
                })
            }
        }
        impl Location {
            pub const IDENTIFIER: &'static str = "Debugger.Location";
        }
        #[doc = "Location in the source code.\n[ScriptPosition](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-ScriptPosition)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ScriptPosition {
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[serde(rename = "columnNumber")]
            pub column_number: i64,
        }
        impl ScriptPosition {
            pub fn new(line_number: impl Into<i64>, column_number: impl Into<i64>) -> Self {
                Self {
                    line_number: line_number.into(),
                    column_number: column_number.into(),
                }
            }
        }
        impl ScriptPosition {
            pub fn builder() -> ScriptPositionBuilder {
                ScriptPositionBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ScriptPositionBuilder {
            line_number: Option<i64>,
            column_number: Option<i64>,
        }
        impl ScriptPositionBuilder {
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn build(self) -> Result<ScriptPosition, String> {
                Ok(ScriptPosition {
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(column_number))
                    })?,
                })
            }
        }
        impl ScriptPosition {
            pub const IDENTIFIER: &'static str = "Debugger.ScriptPosition";
        }
        #[doc = "Location range within one script.\n[LocationRange](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-LocationRange)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct LocationRange {
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[serde(rename = "start")]
            pub start: ScriptPosition,
            #[serde(rename = "end")]
            pub end: ScriptPosition,
        }
        impl LocationRange {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                start: impl Into<ScriptPosition>,
                end: impl Into<ScriptPosition>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    start: start.into(),
                    end: end.into(),
                }
            }
        }
        impl LocationRange {
            pub fn builder() -> LocationRangeBuilder {
                LocationRangeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct LocationRangeBuilder {
            script_id: Option<super::runtime::ScriptId>,
            start: Option<ScriptPosition>,
            end: Option<ScriptPosition>,
        }
        impl LocationRangeBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn start(mut self, start: impl Into<ScriptPosition>) -> Self {
                self.start = Some(start.into());
                self
            }
            pub fn end(mut self, end: impl Into<ScriptPosition>) -> Self {
                self.end = Some(end.into());
                self
            }
            pub fn build(self) -> Result<LocationRange, String> {
                Ok(LocationRange {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    start: self.start.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(start))
                    })?,
                    end: self
                        .end
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(end)))?,
                })
            }
        }
        impl LocationRange {
            pub const IDENTIFIER: &'static str = "Debugger.LocationRange";
        }
        #[doc = "JavaScript call frame. Array of call frames form the call stack.\n[CallFrame](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-CallFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CallFrame {
            #[doc = "Call frame identifier. This identifier is only valid while the virtual machine is paused."]
            #[serde(rename = "callFrameId")]
            pub call_frame_id: CallFrameId,
            #[doc = "Name of the JavaScript function called on this call frame."]
            #[serde(rename = "functionName")]
            pub function_name: String,
            #[doc = "Location in the source code."]
            #[serde(rename = "functionLocation")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub function_location: Option<Location>,
            #[doc = "Location in the source code."]
            #[serde(rename = "location")]
            pub location: Location,
            #[doc = "JavaScript script name or url."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Scope chain for this call frame."]
            #[serde(rename = "scopeChain")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub scope_chain: Vec<Scope>,
            #[doc = "`this` object for this call frame."]
            #[serde(rename = "this")]
            pub this: super::runtime::RemoteObject,
            #[doc = "The value being returned, if the function is at return point."]
            #[serde(rename = "returnValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_value: Option<super::runtime::RemoteObject>,
        }
        impl CallFrame {
            pub fn builder() -> CallFrameBuilder {
                CallFrameBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CallFrameBuilder {
            call_frame_id: Option<CallFrameId>,
            function_name: Option<String>,
            function_location: Option<Location>,
            location: Option<Location>,
            url: Option<String>,
            scope_chain: Option<Vec<Scope>>,
            this: Option<super::runtime::RemoteObject>,
            return_value: Option<super::runtime::RemoteObject>,
        }
        impl CallFrameBuilder {
            pub fn call_frame_id(mut self, call_frame_id: impl Into<CallFrameId>) -> Self {
                self.call_frame_id = Some(call_frame_id.into());
                self
            }
            pub fn function_name(mut self, function_name: impl Into<String>) -> Self {
                self.function_name = Some(function_name.into());
                self
            }
            pub fn function_location(mut self, function_location: impl Into<Location>) -> Self {
                self.function_location = Some(function_location.into());
                self
            }
            pub fn location(mut self, location: impl Into<Location>) -> Self {
                self.location = Some(location.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn scope_chain(mut self, scope_chain: impl Into<Scope>) -> Self {
                let v = self.scope_chain.get_or_insert(Vec::new());
                v.push(scope_chain.into());
                self
            }
            pub fn scope_chains<I, S>(mut self, scope_chains: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<Scope>,
            {
                let v = self.scope_chain.get_or_insert(Vec::new());
                for val in scope_chains {
                    v.push(val.into());
                }
                self
            }
            pub fn this(mut self, this: impl Into<super::runtime::RemoteObject>) -> Self {
                self.this = Some(this.into());
                self
            }
            pub fn return_value(
                mut self,
                return_value: impl Into<super::runtime::RemoteObject>,
            ) -> Self {
                self.return_value = Some(return_value.into());
                self
            }
            pub fn build(self) -> Result<CallFrame, String> {
                Ok(CallFrame {
                    call_frame_id: self.call_frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame_id))
                    })?,
                    function_name: self.function_name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(function_name))
                    })?,
                    function_location: self.function_location,
                    location: self.location.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(location))
                    })?,
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    scope_chain: self.scope_chain.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(scope_chain))
                    })?,
                    this: self.this.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(this))
                    })?,
                    return_value: self.return_value,
                })
            }
        }
        impl CallFrame {
            pub const IDENTIFIER: &'static str = "Debugger.CallFrame";
        }
        #[doc = "Scope description.\n[Scope](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-Scope)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct Scope {
            #[doc = "Scope type."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: ScopeType,
            #[doc = "Object representing the scope. For `global` and `with` scopes it represents the actual\nobject; for the rest of the scopes, it is artificial transient object enumerating scope\nvariables as its properties."]
            #[serde(rename = "object")]
            pub object: super::runtime::RemoteObject,
            #[serde(rename = "name")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub name: Option<String>,
            #[doc = "Location in the source code where scope starts"]
            #[serde(rename = "startLocation")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub start_location: Option<Location>,
            #[doc = "Location in the source code where scope ends"]
            #[serde(rename = "endLocation")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub end_location: Option<Location>,
        }
        #[doc = "Scope type."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ScopeType {
            #[serde(rename = "global")]
            Global,
            #[serde(rename = "local")]
            Local,
            #[serde(rename = "with")]
            With,
            #[serde(rename = "closure")]
            Closure,
            #[serde(rename = "catch")]
            Catch,
            #[serde(rename = "block")]
            Block,
            #[serde(rename = "script")]
            Script,
            #[serde(rename = "eval")]
            Eval,
            #[serde(rename = "module")]
            Module,
            #[serde(rename = "wasm-expression-stack")]
            WasmExpressionStack,
        }
        impl AsRef<str> for ScopeType {
            fn as_ref(&self) -> &str {
                match self {
                    ScopeType::Global => "global",
                    ScopeType::Local => "local",
                    ScopeType::With => "with",
                    ScopeType::Closure => "closure",
                    ScopeType::Catch => "catch",
                    ScopeType::Block => "block",
                    ScopeType::Script => "script",
                    ScopeType::Eval => "eval",
                    ScopeType::Module => "module",
                    ScopeType::WasmExpressionStack => "wasm-expression-stack",
                }
            }
        }
        impl ::std::str::FromStr for ScopeType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "global" | "Global" => Ok(ScopeType::Global),
                    "local" | "Local" => Ok(ScopeType::Local),
                    "with" | "With" => Ok(ScopeType::With),
                    "closure" | "Closure" => Ok(ScopeType::Closure),
                    "catch" | "Catch" => Ok(ScopeType::Catch),
                    "block" | "Block" => Ok(ScopeType::Block),
                    "script" | "Script" => Ok(ScopeType::Script),
                    "eval" | "Eval" => Ok(ScopeType::Eval),
                    "module" | "Module" => Ok(ScopeType::Module),
                    "wasm-expression-stack" | "WasmExpressionStack" => {
                        Ok(ScopeType::WasmExpressionStack)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        impl Scope {
            pub fn new(
                r#type: impl Into<ScopeType>,
                object: impl Into<super::runtime::RemoteObject>,
            ) -> Self {
                Self {
                    r#type: r#type.into(),
                    object: object.into(),
                    name: None,
                    start_location: None,
                    end_location: None,
                }
            }
        }
        impl Scope {
            pub fn builder() -> ScopeBuilder {
                ScopeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ScopeBuilder {
            r#type: Option<ScopeType>,
            object: Option<super::runtime::RemoteObject>,
            name: Option<String>,
            start_location: Option<Location>,
            end_location: Option<Location>,
        }
        impl ScopeBuilder {
            pub fn r#type(mut self, r#type: impl Into<ScopeType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn object(mut self, object: impl Into<super::runtime::RemoteObject>) -> Self {
                self.object = Some(object.into());
                self
            }
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn start_location(mut self, start_location: impl Into<Location>) -> Self {
                self.start_location = Some(start_location.into());
                self
            }
            pub fn end_location(mut self, end_location: impl Into<Location>) -> Self {
                self.end_location = Some(end_location.into());
                self
            }
            pub fn build(self) -> Result<Scope, String> {
                Ok(Scope {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    object: self.object.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object))
                    })?,
                    name: self.name,
                    start_location: self.start_location,
                    end_location: self.end_location,
                })
            }
        }
        impl Scope {
            pub const IDENTIFIER: &'static str = "Debugger.Scope";
        }
        #[doc = "Search match for resource.\n[SearchMatch](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-SearchMatch)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SearchMatch {
            #[doc = "Line number in resource content."]
            #[serde(rename = "lineNumber")]
            pub line_number: f64,
            #[doc = "Line with match content."]
            #[serde(rename = "lineContent")]
            pub line_content: String,
        }
        impl SearchMatch {
            pub fn new(line_number: impl Into<f64>, line_content: impl Into<String>) -> Self {
                Self {
                    line_number: line_number.into(),
                    line_content: line_content.into(),
                }
            }
        }
        impl SearchMatch {
            pub fn builder() -> SearchMatchBuilder {
                SearchMatchBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SearchMatchBuilder {
            line_number: Option<f64>,
            line_content: Option<String>,
        }
        impl SearchMatchBuilder {
            pub fn line_number(mut self, line_number: impl Into<f64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn line_content(mut self, line_content: impl Into<String>) -> Self {
                self.line_content = Some(line_content.into());
                self
            }
            pub fn build(self) -> Result<SearchMatch, String> {
                Ok(SearchMatch {
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    line_content: self.line_content.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_content))
                    })?,
                })
            }
        }
        impl SearchMatch {
            pub const IDENTIFIER: &'static str = "Debugger.SearchMatch";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct BreakLocation {
            #[doc = "Script identifier as reported in the `Debugger.scriptParsed`."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "Line number in the script (0-based)."]
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[doc = "Column number in the script (0-based)."]
            #[serde(rename = "columnNumber")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub column_number: Option<i64>,
            #[serde(rename = "type")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub r#type: Option<BreakLocationType>,
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum BreakLocationType {
            #[serde(rename = "debuggerStatement")]
            DebuggerStatement,
            #[serde(rename = "call")]
            Call,
            #[serde(rename = "return")]
            Return,
        }
        impl AsRef<str> for BreakLocationType {
            fn as_ref(&self) -> &str {
                match self {
                    BreakLocationType::DebuggerStatement => "debuggerStatement",
                    BreakLocationType::Call => "call",
                    BreakLocationType::Return => "return",
                }
            }
        }
        impl ::std::str::FromStr for BreakLocationType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "debuggerStatement" | "DebuggerStatement" | "debuggerstatement" => {
                        Ok(BreakLocationType::DebuggerStatement)
                    }
                    "call" | "Call" => Ok(BreakLocationType::Call),
                    "return" | "Return" => Ok(BreakLocationType::Return),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl BreakLocation {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                line_number: impl Into<i64>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    line_number: line_number.into(),
                    column_number: None,
                    r#type: None,
                }
            }
        }
        impl BreakLocation {
            pub fn builder() -> BreakLocationBuilder {
                BreakLocationBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct BreakLocationBuilder {
            script_id: Option<super::runtime::ScriptId>,
            line_number: Option<i64>,
            column_number: Option<i64>,
            r#type: Option<BreakLocationType>,
        }
        impl BreakLocationBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn r#type(mut self, r#type: impl Into<BreakLocationType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn build(self) -> Result<BreakLocation, String> {
                Ok(BreakLocation {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number,
                    r#type: self.r#type,
                })
            }
        }
        impl BreakLocation {
            pub const IDENTIFIER: &'static str = "Debugger.BreakLocation";
        }
        #[doc = "Enum of possible script languages."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ScriptLanguage {
            #[serde(rename = "JavaScript")]
            JavaScript,
            #[serde(rename = "WebAssembly")]
            WebAssembly,
        }
        impl AsRef<str> for ScriptLanguage {
            fn as_ref(&self) -> &str {
                match self {
                    ScriptLanguage::JavaScript => "JavaScript",
                    ScriptLanguage::WebAssembly => "WebAssembly",
                }
            }
        }
        impl ::std::str::FromStr for ScriptLanguage {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "JavaScript" | "javascript" => Ok(ScriptLanguage::JavaScript),
                    "WebAssembly" | "webassembly" => Ok(ScriptLanguage::WebAssembly),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Debug symbols available for a wasm script.\n[DebugSymbols](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#type-DebugSymbols)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct DebugSymbols {
            #[doc = "Type of the debug symbols."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: DebugSymbolsType,
            #[doc = "URL of the external symbol source."]
            #[serde(rename = "externalURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub external_url: Option<String>,
        }
        #[doc = "Type of the debug symbols."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum DebugSymbolsType {
            #[serde(rename = "None")]
            None,
            #[serde(rename = "SourceMap")]
            SourceMap,
            #[serde(rename = "EmbeddedDWARF")]
            EmbeddedDwarf,
            #[serde(rename = "ExternalDWARF")]
            ExternalDwarf,
        }
        impl AsRef<str> for DebugSymbolsType {
            fn as_ref(&self) -> &str {
                match self {
                    DebugSymbolsType::None => "None",
                    DebugSymbolsType::SourceMap => "SourceMap",
                    DebugSymbolsType::EmbeddedDwarf => "EmbeddedDWARF",
                    DebugSymbolsType::ExternalDwarf => "ExternalDWARF",
                }
            }
        }
        impl ::std::str::FromStr for DebugSymbolsType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "None" | "none" => Ok(DebugSymbolsType::None),
                    "SourceMap" | "sourcemap" => Ok(DebugSymbolsType::SourceMap),
                    "EmbeddedDWARF" | "EmbeddedDwarf" | "embeddeddwarf" => {
                        Ok(DebugSymbolsType::EmbeddedDwarf)
                    }
                    "ExternalDWARF" | "ExternalDwarf" | "externaldwarf" => {
                        Ok(DebugSymbolsType::ExternalDwarf)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        impl DebugSymbols {
            pub fn new(r#type: impl Into<DebugSymbolsType>) -> Self {
                Self {
                    r#type: r#type.into(),
                    external_url: None,
                }
            }
        }
        impl DebugSymbols {
            pub fn builder() -> DebugSymbolsBuilder {
                DebugSymbolsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct DebugSymbolsBuilder {
            r#type: Option<DebugSymbolsType>,
            external_url: Option<String>,
        }
        impl DebugSymbolsBuilder {
            pub fn r#type(mut self, r#type: impl Into<DebugSymbolsType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn external_url(mut self, external_url: impl Into<String>) -> Self {
                self.external_url = Some(external_url.into());
                self
            }
            pub fn build(self) -> Result<DebugSymbols, String> {
                Ok(DebugSymbols {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    external_url: self.external_url,
                })
            }
        }
        impl DebugSymbols {
            pub const IDENTIFIER: &'static str = "Debugger.DebugSymbols";
        }
        #[doc = "Continues execution until specific location is reached.\n[continueToLocation](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-continueToLocation)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ContinueToLocationParams {
            #[doc = "Location to continue to."]
            #[serde(rename = "location")]
            pub location: Location,
            #[serde(rename = "targetCallFrames")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub target_call_frames: Option<ContinueToLocationTargetCallFrames>,
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ContinueToLocationTargetCallFrames {
            #[serde(rename = "any")]
            Any,
            #[serde(rename = "current")]
            Current,
        }
        impl AsRef<str> for ContinueToLocationTargetCallFrames {
            fn as_ref(&self) -> &str {
                match self {
                    ContinueToLocationTargetCallFrames::Any => "any",
                    ContinueToLocationTargetCallFrames::Current => "current",
                }
            }
        }
        impl ::std::str::FromStr for ContinueToLocationTargetCallFrames {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "any" | "Any" => Ok(ContinueToLocationTargetCallFrames::Any),
                    "current" | "Current" => Ok(ContinueToLocationTargetCallFrames::Current),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl ContinueToLocationParams {
            pub fn new(location: impl Into<Location>) -> Self {
                Self {
                    location: location.into(),
                    target_call_frames: None,
                }
            }
        }
        impl ContinueToLocationParams {
            pub fn builder() -> ContinueToLocationParamsBuilder {
                ContinueToLocationParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ContinueToLocationParamsBuilder {
            location: Option<Location>,
            target_call_frames: Option<ContinueToLocationTargetCallFrames>,
        }
        impl ContinueToLocationParamsBuilder {
            pub fn location(mut self, location: impl Into<Location>) -> Self {
                self.location = Some(location.into());
                self
            }
            pub fn target_call_frames(
                mut self,
                target_call_frames: impl Into<ContinueToLocationTargetCallFrames>,
            ) -> Self {
                self.target_call_frames = Some(target_call_frames.into());
                self
            }
            pub fn build(self) -> Result<ContinueToLocationParams, String> {
                Ok(ContinueToLocationParams {
                    location: self.location.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(location))
                    })?,
                    target_call_frames: self.target_call_frames,
                })
            }
        }
        impl ContinueToLocationParams {
            pub const IDENTIFIER: &'static str = "Debugger.continueToLocation";
        }
        impl chromiumoxide_types::Method for ContinueToLocationParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ContinueToLocationParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Continues execution until specific location is reached.\n[continueToLocation](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-continueToLocation)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ContinueToLocationReturns {}
        impl chromiumoxide_types::Command for ContinueToLocationParams {
            type Response = ContinueToLocationReturns;
        }
        #[doc = "Disables debugger for given page.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Debugger.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables debugger for given page.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[doc = "Enables debugger for the given page. Clients should not assume that the debugging has been\nenabled until the result for this command is received.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {
            #[doc = "The maximum size in bytes of collected scripts (not referenced by other heap objects)\nthe debugger can hold. Puts no limit if paramter is omitted."]
            #[serde(rename = "maxScriptsCacheSize")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub max_scripts_cache_size: Option<f64>,
        }
        impl EnableParams {
            pub fn builder() -> EnableParamsBuilder {
                EnableParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EnableParamsBuilder {
            max_scripts_cache_size: Option<f64>,
        }
        impl EnableParamsBuilder {
            pub fn max_scripts_cache_size(
                mut self,
                max_scripts_cache_size: impl Into<f64>,
            ) -> Self {
                self.max_scripts_cache_size = Some(max_scripts_cache_size.into());
                self
            }
            pub fn build(self) -> EnableParams {
                EnableParams {
                    max_scripts_cache_size: self.max_scripts_cache_size,
                }
            }
        }
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Debugger.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables debugger for the given page. Clients should not assume that the debugging has been\nenabled until the result for this command is received.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EnableReturns {
            #[doc = "Unique identifier of the debugger."]
            #[serde(rename = "debuggerId")]
            pub debugger_id: super::runtime::UniqueDebuggerId,
        }
        impl EnableReturns {
            pub fn new(debugger_id: impl Into<super::runtime::UniqueDebuggerId>) -> Self {
                Self {
                    debugger_id: debugger_id.into(),
                }
            }
        }
        impl EnableReturns {
            pub fn builder() -> EnableReturnsBuilder {
                EnableReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EnableReturnsBuilder {
            debugger_id: Option<super::runtime::UniqueDebuggerId>,
        }
        impl EnableReturnsBuilder {
            pub fn debugger_id(
                mut self,
                debugger_id: impl Into<super::runtime::UniqueDebuggerId>,
            ) -> Self {
                self.debugger_id = Some(debugger_id.into());
                self
            }
            pub fn build(self) -> Result<EnableReturns, String> {
                Ok(EnableReturns {
                    debugger_id: self.debugger_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(debugger_id))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Evaluates expression on a given call frame.\n[evaluateOnCallFrame](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-evaluateOnCallFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EvaluateOnCallFrameParams {
            #[doc = "Call frame identifier to evaluate on."]
            #[serde(rename = "callFrameId")]
            pub call_frame_id: CallFrameId,
            #[doc = "Expression to evaluate."]
            #[serde(rename = "expression")]
            pub expression: String,
            #[doc = "String object group name to put result into (allows rapid releasing resulting object handles\nusing `releaseObjectGroup`)."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
            #[doc = "Specifies whether command line API should be available to the evaluated expression, defaults\nto false."]
            #[serde(rename = "includeCommandLineAPI")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub include_command_line_api: Option<bool>,
            #[doc = "In silent mode exceptions thrown during evaluation are not reported and do not pause\nexecution. Overrides `setPauseOnException` state."]
            #[serde(rename = "silent")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub silent: Option<bool>,
            #[doc = "Whether the result is expected to be a JSON object that should be sent by value."]
            #[serde(rename = "returnByValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_by_value: Option<bool>,
            #[doc = "Whether preview should be generated for the result."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
            #[doc = "Whether to throw an exception if side effect cannot be ruled out during evaluation."]
            #[serde(rename = "throwOnSideEffect")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub throw_on_side_effect: Option<bool>,
            #[doc = "Terminate execution after timing out (number of milliseconds)."]
            #[serde(rename = "timeout")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub timeout: Option<super::runtime::TimeDelta>,
        }
        impl EvaluateOnCallFrameParams {
            pub fn new(
                call_frame_id: impl Into<CallFrameId>,
                expression: impl Into<String>,
            ) -> Self {
                Self {
                    call_frame_id: call_frame_id.into(),
                    expression: expression.into(),
                    object_group: None,
                    include_command_line_api: None,
                    silent: None,
                    return_by_value: None,
                    generate_preview: None,
                    throw_on_side_effect: None,
                    timeout: None,
                }
            }
        }
        impl EvaluateOnCallFrameParams {
            pub fn builder() -> EvaluateOnCallFrameParamsBuilder {
                EvaluateOnCallFrameParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EvaluateOnCallFrameParamsBuilder {
            call_frame_id: Option<CallFrameId>,
            expression: Option<String>,
            object_group: Option<String>,
            include_command_line_api: Option<bool>,
            silent: Option<bool>,
            return_by_value: Option<bool>,
            generate_preview: Option<bool>,
            throw_on_side_effect: Option<bool>,
            timeout: Option<super::runtime::TimeDelta>,
        }
        impl EvaluateOnCallFrameParamsBuilder {
            pub fn call_frame_id(mut self, call_frame_id: impl Into<CallFrameId>) -> Self {
                self.call_frame_id = Some(call_frame_id.into());
                self
            }
            pub fn expression(mut self, expression: impl Into<String>) -> Self {
                self.expression = Some(expression.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn include_command_line_api(
                mut self,
                include_command_line_api: impl Into<bool>,
            ) -> Self {
                self.include_command_line_api = Some(include_command_line_api.into());
                self
            }
            pub fn silent(mut self, silent: impl Into<bool>) -> Self {
                self.silent = Some(silent.into());
                self
            }
            pub fn return_by_value(mut self, return_by_value: impl Into<bool>) -> Self {
                self.return_by_value = Some(return_by_value.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn throw_on_side_effect(mut self, throw_on_side_effect: impl Into<bool>) -> Self {
                self.throw_on_side_effect = Some(throw_on_side_effect.into());
                self
            }
            pub fn timeout(mut self, timeout: impl Into<super::runtime::TimeDelta>) -> Self {
                self.timeout = Some(timeout.into());
                self
            }
            pub fn build(self) -> Result<EvaluateOnCallFrameParams, String> {
                Ok(EvaluateOnCallFrameParams {
                    call_frame_id: self.call_frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame_id))
                    })?,
                    expression: self.expression.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(expression))
                    })?,
                    object_group: self.object_group,
                    include_command_line_api: self.include_command_line_api,
                    silent: self.silent,
                    return_by_value: self.return_by_value,
                    generate_preview: self.generate_preview,
                    throw_on_side_effect: self.throw_on_side_effect,
                    timeout: self.timeout,
                })
            }
        }
        impl EvaluateOnCallFrameParams {
            pub const IDENTIFIER: &'static str = "Debugger.evaluateOnCallFrame";
        }
        impl chromiumoxide_types::Method for EvaluateOnCallFrameParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EvaluateOnCallFrameParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Evaluates expression on a given call frame.\n[evaluateOnCallFrame](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-evaluateOnCallFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EvaluateOnCallFrameReturns {
            #[doc = "Object wrapper for the evaluation result."]
            #[serde(rename = "result")]
            pub result: super::runtime::RemoteObject,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl EvaluateOnCallFrameReturns {
            pub fn new(result: impl Into<super::runtime::RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                }
            }
        }
        impl EvaluateOnCallFrameReturns {
            pub fn builder() -> EvaluateOnCallFrameReturnsBuilder {
                EvaluateOnCallFrameReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EvaluateOnCallFrameReturnsBuilder {
            result: Option<super::runtime::RemoteObject>,
            exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl EvaluateOnCallFrameReturnsBuilder {
            pub fn result(mut self, result: impl Into<super::runtime::RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<super::runtime::ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<EvaluateOnCallFrameReturns, String> {
                Ok(EvaluateOnCallFrameReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for EvaluateOnCallFrameParams {
            type Response = EvaluateOnCallFrameReturns;
        }
        #[doc = "Execute a Wasm Evaluator module on a given call frame.\n[executeWasmEvaluator](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-executeWasmEvaluator)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ExecuteWasmEvaluatorParams {
            #[doc = "WebAssembly call frame identifier to evaluate on."]
            #[serde(rename = "callFrameId")]
            pub call_frame_id: CallFrameId,
            #[doc = "Code of the evaluator module."]
            #[serde(rename = "evaluator")]
            pub evaluator: chromiumoxide_types::Binary,
            #[doc = "Terminate execution after timing out (number of milliseconds)."]
            #[serde(rename = "timeout")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub timeout: Option<super::runtime::TimeDelta>,
        }
        impl ExecuteWasmEvaluatorParams {
            pub fn new(
                call_frame_id: impl Into<CallFrameId>,
                evaluator: impl Into<chromiumoxide_types::Binary>,
            ) -> Self {
                Self {
                    call_frame_id: call_frame_id.into(),
                    evaluator: evaluator.into(),
                    timeout: None,
                }
            }
        }
        impl ExecuteWasmEvaluatorParams {
            pub fn builder() -> ExecuteWasmEvaluatorParamsBuilder {
                ExecuteWasmEvaluatorParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ExecuteWasmEvaluatorParamsBuilder {
            call_frame_id: Option<CallFrameId>,
            evaluator: Option<chromiumoxide_types::Binary>,
            timeout: Option<super::runtime::TimeDelta>,
        }
        impl ExecuteWasmEvaluatorParamsBuilder {
            pub fn call_frame_id(mut self, call_frame_id: impl Into<CallFrameId>) -> Self {
                self.call_frame_id = Some(call_frame_id.into());
                self
            }
            pub fn evaluator(mut self, evaluator: impl Into<chromiumoxide_types::Binary>) -> Self {
                self.evaluator = Some(evaluator.into());
                self
            }
            pub fn timeout(mut self, timeout: impl Into<super::runtime::TimeDelta>) -> Self {
                self.timeout = Some(timeout.into());
                self
            }
            pub fn build(self) -> Result<ExecuteWasmEvaluatorParams, String> {
                Ok(ExecuteWasmEvaluatorParams {
                    call_frame_id: self.call_frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame_id))
                    })?,
                    evaluator: self.evaluator.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(evaluator))
                    })?,
                    timeout: self.timeout,
                })
            }
        }
        impl ExecuteWasmEvaluatorParams {
            pub const IDENTIFIER: &'static str = "Debugger.executeWasmEvaluator";
        }
        impl chromiumoxide_types::Method for ExecuteWasmEvaluatorParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ExecuteWasmEvaluatorParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Execute a Wasm Evaluator module on a given call frame.\n[executeWasmEvaluator](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-executeWasmEvaluator)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ExecuteWasmEvaluatorReturns {
            #[doc = "Object wrapper for the evaluation result."]
            #[serde(rename = "result")]
            pub result: super::runtime::RemoteObject,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl ExecuteWasmEvaluatorReturns {
            pub fn new(result: impl Into<super::runtime::RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                }
            }
        }
        impl ExecuteWasmEvaluatorReturns {
            pub fn builder() -> ExecuteWasmEvaluatorReturnsBuilder {
                ExecuteWasmEvaluatorReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ExecuteWasmEvaluatorReturnsBuilder {
            result: Option<super::runtime::RemoteObject>,
            exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl ExecuteWasmEvaluatorReturnsBuilder {
            pub fn result(mut self, result: impl Into<super::runtime::RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<super::runtime::ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<ExecuteWasmEvaluatorReturns, String> {
                Ok(ExecuteWasmEvaluatorReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for ExecuteWasmEvaluatorParams {
            type Response = ExecuteWasmEvaluatorReturns;
        }
        #[doc = "Returns possible locations for breakpoint. scriptId in start and end range locations should be\nthe same.\n[getPossibleBreakpoints](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getPossibleBreakpoints)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPossibleBreakpointsParams {
            #[doc = "Start of range to search possible breakpoint locations in."]
            #[serde(rename = "start")]
            pub start: Location,
            #[doc = "End of range to search possible breakpoint locations in (excluding). When not specified, end\nof scripts is used as end of range."]
            #[serde(rename = "end")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub end: Option<Location>,
            #[doc = "Only consider locations which are in the same (non-nested) function as start."]
            #[serde(rename = "restrictToFunction")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub restrict_to_function: Option<bool>,
        }
        impl GetPossibleBreakpointsParams {
            pub fn new(start: impl Into<Location>) -> Self {
                Self {
                    start: start.into(),
                    end: None,
                    restrict_to_function: None,
                }
            }
        }
        impl GetPossibleBreakpointsParams {
            pub fn builder() -> GetPossibleBreakpointsParamsBuilder {
                GetPossibleBreakpointsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPossibleBreakpointsParamsBuilder {
            start: Option<Location>,
            end: Option<Location>,
            restrict_to_function: Option<bool>,
        }
        impl GetPossibleBreakpointsParamsBuilder {
            pub fn start(mut self, start: impl Into<Location>) -> Self {
                self.start = Some(start.into());
                self
            }
            pub fn end(mut self, end: impl Into<Location>) -> Self {
                self.end = Some(end.into());
                self
            }
            pub fn restrict_to_function(mut self, restrict_to_function: impl Into<bool>) -> Self {
                self.restrict_to_function = Some(restrict_to_function.into());
                self
            }
            pub fn build(self) -> Result<GetPossibleBreakpointsParams, String> {
                Ok(GetPossibleBreakpointsParams {
                    start: self.start.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(start))
                    })?,
                    end: self.end,
                    restrict_to_function: self.restrict_to_function,
                })
            }
        }
        impl GetPossibleBreakpointsParams {
            pub const IDENTIFIER: &'static str = "Debugger.getPossibleBreakpoints";
        }
        impl chromiumoxide_types::Method for GetPossibleBreakpointsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetPossibleBreakpointsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns possible locations for breakpoint. scriptId in start and end range locations should be\nthe same.\n[getPossibleBreakpoints](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getPossibleBreakpoints)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPossibleBreakpointsReturns {
            #[doc = "List of the possible breakpoint locations."]
            #[serde(rename = "locations")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub locations: Vec<BreakLocation>,
        }
        impl GetPossibleBreakpointsReturns {
            pub fn new(locations: Vec<BreakLocation>) -> Self {
                Self { locations }
            }
        }
        impl GetPossibleBreakpointsReturns {
            pub fn builder() -> GetPossibleBreakpointsReturnsBuilder {
                GetPossibleBreakpointsReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPossibleBreakpointsReturnsBuilder {
            locations: Option<Vec<BreakLocation>>,
        }
        impl GetPossibleBreakpointsReturnsBuilder {
            pub fn location(mut self, location: impl Into<BreakLocation>) -> Self {
                let v = self.locations.get_or_insert(Vec::new());
                v.push(location.into());
                self
            }
            pub fn locations<I, S>(mut self, locations: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<BreakLocation>,
            {
                let v = self.locations.get_or_insert(Vec::new());
                for val in locations {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetPossibleBreakpointsReturns, String> {
                Ok(GetPossibleBreakpointsReturns {
                    locations: self.locations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(locations))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetPossibleBreakpointsParams {
            type Response = GetPossibleBreakpointsReturns;
        }
        #[doc = "Returns source for the script with given id.\n[getScriptSource](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getScriptSource)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetScriptSourceParams {
            #[doc = "Id of the script to get source for."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
        }
        impl GetScriptSourceParams {
            pub fn new(script_id: impl Into<super::runtime::ScriptId>) -> Self {
                Self {
                    script_id: script_id.into(),
                }
            }
        }
        impl GetScriptSourceParams {
            pub fn builder() -> GetScriptSourceParamsBuilder {
                GetScriptSourceParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetScriptSourceParamsBuilder {
            script_id: Option<super::runtime::ScriptId>,
        }
        impl GetScriptSourceParamsBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn build(self) -> Result<GetScriptSourceParams, String> {
                Ok(GetScriptSourceParams {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                })
            }
        }
        impl GetScriptSourceParams {
            pub const IDENTIFIER: &'static str = "Debugger.getScriptSource";
        }
        impl chromiumoxide_types::Method for GetScriptSourceParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetScriptSourceParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns source for the script with given id.\n[getScriptSource](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getScriptSource)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetScriptSourceReturns {
            #[doc = "Script source (empty in case of Wasm bytecode)."]
            #[serde(rename = "scriptSource")]
            pub script_source: String,
            #[doc = "Wasm bytecode."]
            #[serde(rename = "bytecode")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub bytecode: Option<chromiumoxide_types::Binary>,
        }
        impl GetScriptSourceReturns {
            pub fn new(script_source: impl Into<String>) -> Self {
                Self {
                    script_source: script_source.into(),
                    bytecode: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for GetScriptSourceReturns {
            fn from(url: T) -> Self {
                GetScriptSourceReturns::new(url)
            }
        }
        impl GetScriptSourceReturns {
            pub fn builder() -> GetScriptSourceReturnsBuilder {
                GetScriptSourceReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetScriptSourceReturnsBuilder {
            script_source: Option<String>,
            bytecode: Option<chromiumoxide_types::Binary>,
        }
        impl GetScriptSourceReturnsBuilder {
            pub fn script_source(mut self, script_source: impl Into<String>) -> Self {
                self.script_source = Some(script_source.into());
                self
            }
            pub fn bytecode(mut self, bytecode: impl Into<chromiumoxide_types::Binary>) -> Self {
                self.bytecode = Some(bytecode.into());
                self
            }
            pub fn build(self) -> Result<GetScriptSourceReturns, String> {
                Ok(GetScriptSourceReturns {
                    script_source: self.script_source.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_source))
                    })?,
                    bytecode: self.bytecode,
                })
            }
        }
        impl chromiumoxide_types::Command for GetScriptSourceParams {
            type Response = GetScriptSourceReturns;
        }
        #[doc = "Returns stack trace with given `stackTraceId`.\n[getStackTrace](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getStackTrace)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetStackTraceParams {
            #[serde(rename = "stackTraceId")]
            pub stack_trace_id: super::runtime::StackTraceId,
        }
        impl GetStackTraceParams {
            pub fn new(stack_trace_id: impl Into<super::runtime::StackTraceId>) -> Self {
                Self {
                    stack_trace_id: stack_trace_id.into(),
                }
            }
        }
        impl GetStackTraceParams {
            pub fn builder() -> GetStackTraceParamsBuilder {
                GetStackTraceParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetStackTraceParamsBuilder {
            stack_trace_id: Option<super::runtime::StackTraceId>,
        }
        impl GetStackTraceParamsBuilder {
            pub fn stack_trace_id(
                mut self,
                stack_trace_id: impl Into<super::runtime::StackTraceId>,
            ) -> Self {
                self.stack_trace_id = Some(stack_trace_id.into());
                self
            }
            pub fn build(self) -> Result<GetStackTraceParams, String> {
                Ok(GetStackTraceParams {
                    stack_trace_id: self.stack_trace_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(stack_trace_id))
                    })?,
                })
            }
        }
        impl GetStackTraceParams {
            pub const IDENTIFIER: &'static str = "Debugger.getStackTrace";
        }
        impl chromiumoxide_types::Method for GetStackTraceParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetStackTraceParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns stack trace with given `stackTraceId`.\n[getStackTrace](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-getStackTrace)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetStackTraceReturns {
            #[serde(rename = "stackTrace")]
            pub stack_trace: super::runtime::StackTrace,
        }
        impl GetStackTraceReturns {
            pub fn new(stack_trace: impl Into<super::runtime::StackTrace>) -> Self {
                Self {
                    stack_trace: stack_trace.into(),
                }
            }
        }
        impl GetStackTraceReturns {
            pub fn builder() -> GetStackTraceReturnsBuilder {
                GetStackTraceReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetStackTraceReturnsBuilder {
            stack_trace: Option<super::runtime::StackTrace>,
        }
        impl GetStackTraceReturnsBuilder {
            pub fn stack_trace(
                mut self,
                stack_trace: impl Into<super::runtime::StackTrace>,
            ) -> Self {
                self.stack_trace = Some(stack_trace.into());
                self
            }
            pub fn build(self) -> Result<GetStackTraceReturns, String> {
                Ok(GetStackTraceReturns {
                    stack_trace: self.stack_trace.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(stack_trace))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetStackTraceParams {
            type Response = GetStackTraceReturns;
        }
        #[doc = "Stops on the next JavaScript statement.\n[pause](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-pause)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct PauseParams {}
        impl PauseParams {
            pub const IDENTIFIER: &'static str = "Debugger.pause";
        }
        impl chromiumoxide_types::Method for PauseParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for PauseParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Stops on the next JavaScript statement.\n[pause](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-pause)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct PauseReturns {}
        impl chromiumoxide_types::Command for PauseParams {
            type Response = PauseReturns;
        }
        #[doc = "Removes JavaScript breakpoint.\n[removeBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-removeBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RemoveBreakpointParams {
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
        }
        impl RemoveBreakpointParams {
            pub fn new(breakpoint_id: impl Into<BreakpointId>) -> Self {
                Self {
                    breakpoint_id: breakpoint_id.into(),
                }
            }
        }
        impl RemoveBreakpointParams {
            pub fn builder() -> RemoveBreakpointParamsBuilder {
                RemoveBreakpointParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RemoveBreakpointParamsBuilder {
            breakpoint_id: Option<BreakpointId>,
        }
        impl RemoveBreakpointParamsBuilder {
            pub fn breakpoint_id(mut self, breakpoint_id: impl Into<BreakpointId>) -> Self {
                self.breakpoint_id = Some(breakpoint_id.into());
                self
            }
            pub fn build(self) -> Result<RemoveBreakpointParams, String> {
                Ok(RemoveBreakpointParams {
                    breakpoint_id: self.breakpoint_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(breakpoint_id))
                    })?,
                })
            }
        }
        impl RemoveBreakpointParams {
            pub const IDENTIFIER: &'static str = "Debugger.removeBreakpoint";
        }
        impl chromiumoxide_types::Method for RemoveBreakpointParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for RemoveBreakpointParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Removes JavaScript breakpoint.\n[removeBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-removeBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct RemoveBreakpointReturns {}
        impl chromiumoxide_types::Command for RemoveBreakpointParams {
            type Response = RemoveBreakpointReturns;
        }
        #[doc = "Restarts particular call frame from the beginning.\n[restartFrame](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-restartFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RestartFrameParams {
            #[doc = "Call frame identifier to evaluate on."]
            #[serde(rename = "callFrameId")]
            pub call_frame_id: CallFrameId,
        }
        impl RestartFrameParams {
            pub fn new(call_frame_id: impl Into<CallFrameId>) -> Self {
                Self {
                    call_frame_id: call_frame_id.into(),
                }
            }
        }
        impl RestartFrameParams {
            pub fn builder() -> RestartFrameParamsBuilder {
                RestartFrameParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RestartFrameParamsBuilder {
            call_frame_id: Option<CallFrameId>,
        }
        impl RestartFrameParamsBuilder {
            pub fn call_frame_id(mut self, call_frame_id: impl Into<CallFrameId>) -> Self {
                self.call_frame_id = Some(call_frame_id.into());
                self
            }
            pub fn build(self) -> Result<RestartFrameParams, String> {
                Ok(RestartFrameParams {
                    call_frame_id: self.call_frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame_id))
                    })?,
                })
            }
        }
        impl RestartFrameParams {
            pub const IDENTIFIER: &'static str = "Debugger.restartFrame";
        }
        impl chromiumoxide_types::Method for RestartFrameParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for RestartFrameParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Restarts particular call frame from the beginning.\n[restartFrame](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-restartFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RestartFrameReturns {
            #[doc = "New stack trace."]
            #[serde(rename = "callFrames")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub call_frames: Vec<CallFrame>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace: Option<super::runtime::StackTrace>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTraceId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace_id: Option<super::runtime::StackTraceId>,
        }
        impl RestartFrameReturns {
            pub fn new(call_frames: Vec<CallFrame>) -> Self {
                Self {
                    call_frames,
                    async_stack_trace: None,
                    async_stack_trace_id: None,
                }
            }
        }
        impl RestartFrameReturns {
            pub fn builder() -> RestartFrameReturnsBuilder {
                RestartFrameReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RestartFrameReturnsBuilder {
            call_frames: Option<Vec<CallFrame>>,
            async_stack_trace: Option<super::runtime::StackTrace>,
            async_stack_trace_id: Option<super::runtime::StackTraceId>,
        }
        impl RestartFrameReturnsBuilder {
            pub fn call_frame(mut self, call_frame: impl Into<CallFrame>) -> Self {
                let v = self.call_frames.get_or_insert(Vec::new());
                v.push(call_frame.into());
                self
            }
            pub fn call_frames<I, S>(mut self, call_frames: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CallFrame>,
            {
                let v = self.call_frames.get_or_insert(Vec::new());
                for val in call_frames {
                    v.push(val.into());
                }
                self
            }
            pub fn async_stack_trace(
                mut self,
                async_stack_trace: impl Into<super::runtime::StackTrace>,
            ) -> Self {
                self.async_stack_trace = Some(async_stack_trace.into());
                self
            }
            pub fn async_stack_trace_id(
                mut self,
                async_stack_trace_id: impl Into<super::runtime::StackTraceId>,
            ) -> Self {
                self.async_stack_trace_id = Some(async_stack_trace_id.into());
                self
            }
            pub fn build(self) -> Result<RestartFrameReturns, String> {
                Ok(RestartFrameReturns {
                    call_frames: self.call_frames.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frames))
                    })?,
                    async_stack_trace: self.async_stack_trace,
                    async_stack_trace_id: self.async_stack_trace_id,
                })
            }
        }
        impl chromiumoxide_types::Command for RestartFrameParams {
            type Response = RestartFrameReturns;
        }
        #[doc = "Resumes JavaScript execution.\n[resume](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-resume)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ResumeParams {
            #[doc = "Set to true to terminate execution upon resuming execution. In contrast\nto Runtime.terminateExecution, this will allows to execute further\nJavaScript (i.e. via evaluation) until execution of the paused code\nis actually resumed, at which point termination is triggered.\nIf execution is currently not paused, this parameter has no effect."]
            #[serde(rename = "terminateOnResume")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub terminate_on_resume: Option<bool>,
        }
        impl ResumeParams {
            pub fn builder() -> ResumeParamsBuilder {
                ResumeParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ResumeParamsBuilder {
            terminate_on_resume: Option<bool>,
        }
        impl ResumeParamsBuilder {
            pub fn terminate_on_resume(mut self, terminate_on_resume: impl Into<bool>) -> Self {
                self.terminate_on_resume = Some(terminate_on_resume.into());
                self
            }
            pub fn build(self) -> ResumeParams {
                ResumeParams {
                    terminate_on_resume: self.terminate_on_resume,
                }
            }
        }
        impl ResumeParams {
            pub const IDENTIFIER: &'static str = "Debugger.resume";
        }
        impl chromiumoxide_types::Method for ResumeParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ResumeParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Resumes JavaScript execution.\n[resume](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-resume)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ResumeReturns {}
        impl chromiumoxide_types::Command for ResumeParams {
            type Response = ResumeReturns;
        }
        #[doc = "Searches for given string in script content.\n[searchInContent](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-searchInContent)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SearchInContentParams {
            #[doc = "Id of the script to search in."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "String to search for."]
            #[serde(rename = "query")]
            pub query: String,
            #[doc = "If true, search is case sensitive."]
            #[serde(rename = "caseSensitive")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub case_sensitive: Option<bool>,
            #[doc = "If true, treats string parameter as regex."]
            #[serde(rename = "isRegex")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub is_regex: Option<bool>,
        }
        impl SearchInContentParams {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                query: impl Into<String>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    query: query.into(),
                    case_sensitive: None,
                    is_regex: None,
                }
            }
        }
        impl SearchInContentParams {
            pub fn builder() -> SearchInContentParamsBuilder {
                SearchInContentParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SearchInContentParamsBuilder {
            script_id: Option<super::runtime::ScriptId>,
            query: Option<String>,
            case_sensitive: Option<bool>,
            is_regex: Option<bool>,
        }
        impl SearchInContentParamsBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn query(mut self, query: impl Into<String>) -> Self {
                self.query = Some(query.into());
                self
            }
            pub fn case_sensitive(mut self, case_sensitive: impl Into<bool>) -> Self {
                self.case_sensitive = Some(case_sensitive.into());
                self
            }
            pub fn is_regex(mut self, is_regex: impl Into<bool>) -> Self {
                self.is_regex = Some(is_regex.into());
                self
            }
            pub fn build(self) -> Result<SearchInContentParams, String> {
                Ok(SearchInContentParams {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    query: self.query.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(query))
                    })?,
                    case_sensitive: self.case_sensitive,
                    is_regex: self.is_regex,
                })
            }
        }
        impl SearchInContentParams {
            pub const IDENTIFIER: &'static str = "Debugger.searchInContent";
        }
        impl chromiumoxide_types::Method for SearchInContentParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SearchInContentParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Searches for given string in script content.\n[searchInContent](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-searchInContent)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SearchInContentReturns {
            #[doc = "List of search matches."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<SearchMatch>,
        }
        impl SearchInContentReturns {
            pub fn new(result: Vec<SearchMatch>) -> Self {
                Self { result }
            }
        }
        impl SearchInContentReturns {
            pub fn builder() -> SearchInContentReturnsBuilder {
                SearchInContentReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SearchInContentReturnsBuilder {
            result: Option<Vec<SearchMatch>>,
        }
        impl SearchInContentReturnsBuilder {
            pub fn result(mut self, result: impl Into<SearchMatch>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<SearchMatch>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SearchInContentReturns, String> {
                Ok(SearchInContentReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for SearchInContentParams {
            type Response = SearchInContentReturns;
        }
        #[doc = "Enables or disables async call stacks tracking.\n[setAsyncCallStackDepth](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setAsyncCallStackDepth)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetAsyncCallStackDepthParams {
            #[doc = "Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async\ncall stacks (default)."]
            #[serde(rename = "maxDepth")]
            pub max_depth: i64,
        }
        impl SetAsyncCallStackDepthParams {
            pub fn new(max_depth: impl Into<i64>) -> Self {
                Self {
                    max_depth: max_depth.into(),
                }
            }
        }
        impl SetAsyncCallStackDepthParams {
            pub fn builder() -> SetAsyncCallStackDepthParamsBuilder {
                SetAsyncCallStackDepthParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetAsyncCallStackDepthParamsBuilder {
            max_depth: Option<i64>,
        }
        impl SetAsyncCallStackDepthParamsBuilder {
            pub fn max_depth(mut self, max_depth: impl Into<i64>) -> Self {
                self.max_depth = Some(max_depth.into());
                self
            }
            pub fn build(self) -> Result<SetAsyncCallStackDepthParams, String> {
                Ok(SetAsyncCallStackDepthParams {
                    max_depth: self.max_depth.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(max_depth))
                    })?,
                })
            }
        }
        impl SetAsyncCallStackDepthParams {
            pub const IDENTIFIER: &'static str = "Debugger.setAsyncCallStackDepth";
        }
        impl chromiumoxide_types::Method for SetAsyncCallStackDepthParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetAsyncCallStackDepthParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables or disables async call stacks tracking.\n[setAsyncCallStackDepth](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setAsyncCallStackDepth)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetAsyncCallStackDepthReturns {}
        impl chromiumoxide_types::Command for SetAsyncCallStackDepthParams {
            type Response = SetAsyncCallStackDepthReturns;
        }
        #[doc = "Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in\nscripts with url matching one of the patterns. VM will try to leave blackboxed script by\nperforming 'step in' several times, finally resorting to 'step out' if unsuccessful.\n[setBlackboxPatterns](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBlackboxPatterns)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBlackboxPatternsParams {
            #[doc = "Array of regexps that will be used to check script url for blackbox state."]
            #[serde(rename = "patterns")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub patterns: Vec<String>,
        }
        impl SetBlackboxPatternsParams {
            pub fn new(patterns: Vec<String>) -> Self {
                Self { patterns }
            }
        }
        impl SetBlackboxPatternsParams {
            pub fn builder() -> SetBlackboxPatternsParamsBuilder {
                SetBlackboxPatternsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBlackboxPatternsParamsBuilder {
            patterns: Option<Vec<String>>,
        }
        impl SetBlackboxPatternsParamsBuilder {
            pub fn pattern(mut self, pattern: impl Into<String>) -> Self {
                let v = self.patterns.get_or_insert(Vec::new());
                v.push(pattern.into());
                self
            }
            pub fn patterns<I, S>(mut self, patterns: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<String>,
            {
                let v = self.patterns.get_or_insert(Vec::new());
                for val in patterns {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SetBlackboxPatternsParams, String> {
                Ok(SetBlackboxPatternsParams {
                    patterns: self.patterns.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(patterns))
                    })?,
                })
            }
        }
        impl SetBlackboxPatternsParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBlackboxPatterns";
        }
        impl chromiumoxide_types::Method for SetBlackboxPatternsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBlackboxPatternsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in\nscripts with url matching one of the patterns. VM will try to leave blackboxed script by\nperforming 'step in' several times, finally resorting to 'step out' if unsuccessful.\n[setBlackboxPatterns](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBlackboxPatterns)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetBlackboxPatternsReturns {}
        impl chromiumoxide_types::Command for SetBlackboxPatternsParams {
            type Response = SetBlackboxPatternsReturns;
        }
        #[doc = "Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted\nscripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.\nPositions array contains positions where blackbox state is changed. First interval isn't\nblackboxed. Array should be sorted.\n[setBlackboxedRanges](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBlackboxedRanges)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBlackboxedRangesParams {
            #[doc = "Id of the script."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[serde(rename = "positions")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub positions: Vec<ScriptPosition>,
        }
        impl SetBlackboxedRangesParams {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                positions: Vec<ScriptPosition>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    positions,
                }
            }
        }
        impl SetBlackboxedRangesParams {
            pub fn builder() -> SetBlackboxedRangesParamsBuilder {
                SetBlackboxedRangesParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBlackboxedRangesParamsBuilder {
            script_id: Option<super::runtime::ScriptId>,
            positions: Option<Vec<ScriptPosition>>,
        }
        impl SetBlackboxedRangesParamsBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn position(mut self, position: impl Into<ScriptPosition>) -> Self {
                let v = self.positions.get_or_insert(Vec::new());
                v.push(position.into());
                self
            }
            pub fn positions<I, S>(mut self, positions: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ScriptPosition>,
            {
                let v = self.positions.get_or_insert(Vec::new());
                for val in positions {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SetBlackboxedRangesParams, String> {
                Ok(SetBlackboxedRangesParams {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    positions: self.positions.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(positions))
                    })?,
                })
            }
        }
        impl SetBlackboxedRangesParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBlackboxedRanges";
        }
        impl chromiumoxide_types::Method for SetBlackboxedRangesParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBlackboxedRangesParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted\nscripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.\nPositions array contains positions where blackbox state is changed. First interval isn't\nblackboxed. Array should be sorted.\n[setBlackboxedRanges](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBlackboxedRanges)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetBlackboxedRangesReturns {}
        impl chromiumoxide_types::Command for SetBlackboxedRangesParams {
            type Response = SetBlackboxedRangesReturns;
        }
        #[doc = "Sets JavaScript breakpoint at a given location.\n[setBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointParams {
            #[doc = "Location to set breakpoint in."]
            #[serde(rename = "location")]
            pub location: Location,
            #[doc = "Expression to use as a breakpoint condition. When specified, debugger will only stop on the\nbreakpoint if this expression evaluates to true."]
            #[serde(rename = "condition")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub condition: Option<String>,
        }
        impl SetBreakpointParams {
            pub fn new(location: impl Into<Location>) -> Self {
                Self {
                    location: location.into(),
                    condition: None,
                }
            }
        }
        impl SetBreakpointParams {
            pub fn builder() -> SetBreakpointParamsBuilder {
                SetBreakpointParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointParamsBuilder {
            location: Option<Location>,
            condition: Option<String>,
        }
        impl SetBreakpointParamsBuilder {
            pub fn location(mut self, location: impl Into<Location>) -> Self {
                self.location = Some(location.into());
                self
            }
            pub fn condition(mut self, condition: impl Into<String>) -> Self {
                self.condition = Some(condition.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointParams, String> {
                Ok(SetBreakpointParams {
                    location: self.location.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(location))
                    })?,
                    condition: self.condition,
                })
            }
        }
        impl SetBreakpointParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBreakpoint";
        }
        impl chromiumoxide_types::Method for SetBreakpointParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBreakpointParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets JavaScript breakpoint at a given location.\n[setBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointReturns {
            #[doc = "Id of the created breakpoint for further reference."]
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
            #[doc = "Location this breakpoint resolved into."]
            #[serde(rename = "actualLocation")]
            pub actual_location: Location,
        }
        impl SetBreakpointReturns {
            pub fn new(
                breakpoint_id: impl Into<BreakpointId>,
                actual_location: impl Into<Location>,
            ) -> Self {
                Self {
                    breakpoint_id: breakpoint_id.into(),
                    actual_location: actual_location.into(),
                }
            }
        }
        impl SetBreakpointReturns {
            pub fn builder() -> SetBreakpointReturnsBuilder {
                SetBreakpointReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointReturnsBuilder {
            breakpoint_id: Option<BreakpointId>,
            actual_location: Option<Location>,
        }
        impl SetBreakpointReturnsBuilder {
            pub fn breakpoint_id(mut self, breakpoint_id: impl Into<BreakpointId>) -> Self {
                self.breakpoint_id = Some(breakpoint_id.into());
                self
            }
            pub fn actual_location(mut self, actual_location: impl Into<Location>) -> Self {
                self.actual_location = Some(actual_location.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointReturns, String> {
                Ok(SetBreakpointReturns {
                    breakpoint_id: self.breakpoint_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(breakpoint_id))
                    })?,
                    actual_location: self.actual_location.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(actual_location))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for SetBreakpointParams {
            type Response = SetBreakpointReturns;
        }
        #[doc = "Sets instrumentation breakpoint.\n[setInstrumentationBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setInstrumentationBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetInstrumentationBreakpointParams {
            #[doc = "Instrumentation name."]
            #[serde(rename = "instrumentation")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub instrumentation: SetInstrumentationBreakpointInstrumentation,
        }
        #[doc = "Instrumentation name."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum SetInstrumentationBreakpointInstrumentation {
            #[serde(rename = "beforeScriptExecution")]
            BeforeScriptExecution,
            #[serde(rename = "beforeScriptWithSourceMapExecution")]
            BeforeScriptWithSourceMapExecution,
        }
        impl AsRef<str> for SetInstrumentationBreakpointInstrumentation {
            fn as_ref(&self) -> &str {
                match self { SetInstrumentationBreakpointInstrumentation :: BeforeScriptExecution => "beforeScriptExecution" , SetInstrumentationBreakpointInstrumentation :: BeforeScriptWithSourceMapExecution => "beforeScriptWithSourceMapExecution" }
            }
        }
        impl ::std::str::FromStr for SetInstrumentationBreakpointInstrumentation {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s { "beforeScriptExecution" | "BeforeScriptExecution" | "beforescriptexecution" => Ok (SetInstrumentationBreakpointInstrumentation :: BeforeScriptExecution) , "beforeScriptWithSourceMapExecution" | "BeforeScriptWithSourceMapExecution" | "beforescriptwithsourcemapexecution" => Ok (SetInstrumentationBreakpointInstrumentation :: BeforeScriptWithSourceMapExecution) , _ => Err (s . to_string ()) }
            }
        }
        impl SetInstrumentationBreakpointParams {
            pub fn new(
                instrumentation: impl Into<SetInstrumentationBreakpointInstrumentation>,
            ) -> Self {
                Self {
                    instrumentation: instrumentation.into(),
                }
            }
        }
        impl SetInstrumentationBreakpointParams {
            pub fn builder() -> SetInstrumentationBreakpointParamsBuilder {
                SetInstrumentationBreakpointParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetInstrumentationBreakpointParamsBuilder {
            instrumentation: Option<SetInstrumentationBreakpointInstrumentation>,
        }
        impl SetInstrumentationBreakpointParamsBuilder {
            pub fn instrumentation(
                mut self,
                instrumentation: impl Into<SetInstrumentationBreakpointInstrumentation>,
            ) -> Self {
                self.instrumentation = Some(instrumentation.into());
                self
            }
            pub fn build(self) -> Result<SetInstrumentationBreakpointParams, String> {
                Ok(SetInstrumentationBreakpointParams {
                    instrumentation: self.instrumentation.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(instrumentation))
                    })?,
                })
            }
        }
        impl SetInstrumentationBreakpointParams {
            pub const IDENTIFIER: &'static str = "Debugger.setInstrumentationBreakpoint";
        }
        impl chromiumoxide_types::Method for SetInstrumentationBreakpointParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetInstrumentationBreakpointParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets instrumentation breakpoint.\n[setInstrumentationBreakpoint](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setInstrumentationBreakpoint)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetInstrumentationBreakpointReturns {
            #[doc = "Id of the created breakpoint for further reference."]
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
        }
        impl SetInstrumentationBreakpointReturns {
            pub fn new(breakpoint_id: impl Into<BreakpointId>) -> Self {
                Self {
                    breakpoint_id: breakpoint_id.into(),
                }
            }
        }
        impl SetInstrumentationBreakpointReturns {
            pub fn builder() -> SetInstrumentationBreakpointReturnsBuilder {
                SetInstrumentationBreakpointReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetInstrumentationBreakpointReturnsBuilder {
            breakpoint_id: Option<BreakpointId>,
        }
        impl SetInstrumentationBreakpointReturnsBuilder {
            pub fn breakpoint_id(mut self, breakpoint_id: impl Into<BreakpointId>) -> Self {
                self.breakpoint_id = Some(breakpoint_id.into());
                self
            }
            pub fn build(self) -> Result<SetInstrumentationBreakpointReturns, String> {
                Ok(SetInstrumentationBreakpointReturns {
                    breakpoint_id: self.breakpoint_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(breakpoint_id))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for SetInstrumentationBreakpointParams {
            type Response = SetInstrumentationBreakpointReturns;
        }
        #[doc = "Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this\ncommand is issued, all existing parsed scripts will have breakpoints resolved and returned in\n`locations` property. Further matching script parsing will result in subsequent\n`breakpointResolved` events issued. This logical breakpoint will survive page reloads.\n[setBreakpointByUrl](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointByUrl)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointByUrlParams {
            #[doc = "Line number to set breakpoint at."]
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[doc = "URL of the resources to set breakpoint on."]
            #[serde(rename = "url")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub url: Option<String>,
            #[doc = "Regex pattern for the URLs of the resources to set breakpoints on. Either `url` or\n`urlRegex` must be specified."]
            #[serde(rename = "urlRegex")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub url_regex: Option<String>,
            #[doc = "Script hash of the resources to set breakpoint on."]
            #[serde(rename = "scriptHash")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub script_hash: Option<String>,
            #[doc = "Offset in the line to set breakpoint at."]
            #[serde(rename = "columnNumber")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub column_number: Option<i64>,
            #[doc = "Expression to use as a breakpoint condition. When specified, debugger will only stop on the\nbreakpoint if this expression evaluates to true."]
            #[serde(rename = "condition")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub condition: Option<String>,
        }
        impl SetBreakpointByUrlParams {
            pub fn new(line_number: impl Into<i64>) -> Self {
                Self {
                    line_number: line_number.into(),
                    url: None,
                    url_regex: None,
                    script_hash: None,
                    column_number: None,
                    condition: None,
                }
            }
        }
        impl SetBreakpointByUrlParams {
            pub fn builder() -> SetBreakpointByUrlParamsBuilder {
                SetBreakpointByUrlParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointByUrlParamsBuilder {
            line_number: Option<i64>,
            url: Option<String>,
            url_regex: Option<String>,
            script_hash: Option<String>,
            column_number: Option<i64>,
            condition: Option<String>,
        }
        impl SetBreakpointByUrlParamsBuilder {
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn url_regex(mut self, url_regex: impl Into<String>) -> Self {
                self.url_regex = Some(url_regex.into());
                self
            }
            pub fn script_hash(mut self, script_hash: impl Into<String>) -> Self {
                self.script_hash = Some(script_hash.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn condition(mut self, condition: impl Into<String>) -> Self {
                self.condition = Some(condition.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointByUrlParams, String> {
                Ok(SetBreakpointByUrlParams {
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    url: self.url,
                    url_regex: self.url_regex,
                    script_hash: self.script_hash,
                    column_number: self.column_number,
                    condition: self.condition,
                })
            }
        }
        impl SetBreakpointByUrlParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBreakpointByUrl";
        }
        impl chromiumoxide_types::Method for SetBreakpointByUrlParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBreakpointByUrlParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this\ncommand is issued, all existing parsed scripts will have breakpoints resolved and returned in\n`locations` property. Further matching script parsing will result in subsequent\n`breakpointResolved` events issued. This logical breakpoint will survive page reloads.\n[setBreakpointByUrl](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointByUrl)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointByUrlReturns {
            #[doc = "Id of the created breakpoint for further reference."]
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
            #[doc = "List of the locations this breakpoint resolved into upon addition."]
            #[serde(rename = "locations")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub locations: Vec<Location>,
        }
        impl SetBreakpointByUrlReturns {
            pub fn new(breakpoint_id: impl Into<BreakpointId>, locations: Vec<Location>) -> Self {
                Self {
                    breakpoint_id: breakpoint_id.into(),
                    locations,
                }
            }
        }
        impl SetBreakpointByUrlReturns {
            pub fn builder() -> SetBreakpointByUrlReturnsBuilder {
                SetBreakpointByUrlReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointByUrlReturnsBuilder {
            breakpoint_id: Option<BreakpointId>,
            locations: Option<Vec<Location>>,
        }
        impl SetBreakpointByUrlReturnsBuilder {
            pub fn breakpoint_id(mut self, breakpoint_id: impl Into<BreakpointId>) -> Self {
                self.breakpoint_id = Some(breakpoint_id.into());
                self
            }
            pub fn location(mut self, location: impl Into<Location>) -> Self {
                let v = self.locations.get_or_insert(Vec::new());
                v.push(location.into());
                self
            }
            pub fn locations<I, S>(mut self, locations: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<Location>,
            {
                let v = self.locations.get_or_insert(Vec::new());
                for val in locations {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SetBreakpointByUrlReturns, String> {
                Ok(SetBreakpointByUrlReturns {
                    breakpoint_id: self.breakpoint_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(breakpoint_id))
                    })?,
                    locations: self.locations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(locations))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for SetBreakpointByUrlParams {
            type Response = SetBreakpointByUrlReturns;
        }
        #[doc = "Sets JavaScript breakpoint before each call to the given function.\nIf another function was created from the same source as a given one,\ncalling it will also trigger the breakpoint.\n[setBreakpointOnFunctionCall](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointOnFunctionCall)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointOnFunctionCallParams {
            #[doc = "Function object id."]
            #[serde(rename = "objectId")]
            pub object_id: super::runtime::RemoteObjectId,
            #[doc = "Expression to use as a breakpoint condition. When specified, debugger will\nstop on the breakpoint if this expression evaluates to true."]
            #[serde(rename = "condition")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub condition: Option<String>,
        }
        impl SetBreakpointOnFunctionCallParams {
            pub fn new(object_id: impl Into<super::runtime::RemoteObjectId>) -> Self {
                Self {
                    object_id: object_id.into(),
                    condition: None,
                }
            }
        }
        impl SetBreakpointOnFunctionCallParams {
            pub fn builder() -> SetBreakpointOnFunctionCallParamsBuilder {
                SetBreakpointOnFunctionCallParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointOnFunctionCallParamsBuilder {
            object_id: Option<super::runtime::RemoteObjectId>,
            condition: Option<String>,
        }
        impl SetBreakpointOnFunctionCallParamsBuilder {
            pub fn object_id(
                mut self,
                object_id: impl Into<super::runtime::RemoteObjectId>,
            ) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn condition(mut self, condition: impl Into<String>) -> Self {
                self.condition = Some(condition.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointOnFunctionCallParams, String> {
                Ok(SetBreakpointOnFunctionCallParams {
                    object_id: self.object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_id))
                    })?,
                    condition: self.condition,
                })
            }
        }
        impl SetBreakpointOnFunctionCallParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBreakpointOnFunctionCall";
        }
        impl chromiumoxide_types::Method for SetBreakpointOnFunctionCallParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBreakpointOnFunctionCallParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets JavaScript breakpoint before each call to the given function.\nIf another function was created from the same source as a given one,\ncalling it will also trigger the breakpoint.\n[setBreakpointOnFunctionCall](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointOnFunctionCall)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointOnFunctionCallReturns {
            #[doc = "Id of the created breakpoint for further reference."]
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
        }
        impl SetBreakpointOnFunctionCallReturns {
            pub fn new(breakpoint_id: impl Into<BreakpointId>) -> Self {
                Self {
                    breakpoint_id: breakpoint_id.into(),
                }
            }
        }
        impl SetBreakpointOnFunctionCallReturns {
            pub fn builder() -> SetBreakpointOnFunctionCallReturnsBuilder {
                SetBreakpointOnFunctionCallReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointOnFunctionCallReturnsBuilder {
            breakpoint_id: Option<BreakpointId>,
        }
        impl SetBreakpointOnFunctionCallReturnsBuilder {
            pub fn breakpoint_id(mut self, breakpoint_id: impl Into<BreakpointId>) -> Self {
                self.breakpoint_id = Some(breakpoint_id.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointOnFunctionCallReturns, String> {
                Ok(SetBreakpointOnFunctionCallReturns {
                    breakpoint_id: self.breakpoint_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(breakpoint_id))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for SetBreakpointOnFunctionCallParams {
            type Response = SetBreakpointOnFunctionCallReturns;
        }
        #[doc = "Activates / deactivates all breakpoints on the page.\n[setBreakpointsActive](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointsActive)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetBreakpointsActiveParams {
            #[doc = "New value for breakpoints active state."]
            #[serde(rename = "active")]
            pub active: bool,
        }
        impl SetBreakpointsActiveParams {
            pub fn new(active: impl Into<bool>) -> Self {
                Self {
                    active: active.into(),
                }
            }
        }
        impl SetBreakpointsActiveParams {
            pub fn builder() -> SetBreakpointsActiveParamsBuilder {
                SetBreakpointsActiveParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetBreakpointsActiveParamsBuilder {
            active: Option<bool>,
        }
        impl SetBreakpointsActiveParamsBuilder {
            pub fn active(mut self, active: impl Into<bool>) -> Self {
                self.active = Some(active.into());
                self
            }
            pub fn build(self) -> Result<SetBreakpointsActiveParams, String> {
                Ok(SetBreakpointsActiveParams {
                    active: self.active.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(active))
                    })?,
                })
            }
        }
        impl SetBreakpointsActiveParams {
            pub const IDENTIFIER: &'static str = "Debugger.setBreakpointsActive";
        }
        impl chromiumoxide_types::Method for SetBreakpointsActiveParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetBreakpointsActiveParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Activates / deactivates all breakpoints on the page.\n[setBreakpointsActive](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setBreakpointsActive)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetBreakpointsActiveReturns {}
        impl chromiumoxide_types::Command for SetBreakpointsActiveParams {
            type Response = SetBreakpointsActiveReturns;
        }
        #[doc = "Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions or\nno exceptions. Initial pause on exceptions state is `none`.\n[setPauseOnExceptions](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setPauseOnExceptions)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetPauseOnExceptionsParams {
            #[doc = "Pause on exceptions mode."]
            #[serde(rename = "state")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub state: SetPauseOnExceptionsState,
        }
        #[doc = "Pause on exceptions mode."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum SetPauseOnExceptionsState {
            #[serde(rename = "none")]
            None,
            #[serde(rename = "uncaught")]
            Uncaught,
            #[serde(rename = "all")]
            All,
        }
        impl AsRef<str> for SetPauseOnExceptionsState {
            fn as_ref(&self) -> &str {
                match self {
                    SetPauseOnExceptionsState::None => "none",
                    SetPauseOnExceptionsState::Uncaught => "uncaught",
                    SetPauseOnExceptionsState::All => "all",
                }
            }
        }
        impl ::std::str::FromStr for SetPauseOnExceptionsState {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "none" | "None" => Ok(SetPauseOnExceptionsState::None),
                    "uncaught" | "Uncaught" => Ok(SetPauseOnExceptionsState::Uncaught),
                    "all" | "All" => Ok(SetPauseOnExceptionsState::All),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl SetPauseOnExceptionsParams {
            pub fn new(state: impl Into<SetPauseOnExceptionsState>) -> Self {
                Self {
                    state: state.into(),
                }
            }
        }
        impl SetPauseOnExceptionsParams {
            pub fn builder() -> SetPauseOnExceptionsParamsBuilder {
                SetPauseOnExceptionsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetPauseOnExceptionsParamsBuilder {
            state: Option<SetPauseOnExceptionsState>,
        }
        impl SetPauseOnExceptionsParamsBuilder {
            pub fn state(mut self, state: impl Into<SetPauseOnExceptionsState>) -> Self {
                self.state = Some(state.into());
                self
            }
            pub fn build(self) -> Result<SetPauseOnExceptionsParams, String> {
                Ok(SetPauseOnExceptionsParams {
                    state: self.state.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(state))
                    })?,
                })
            }
        }
        impl SetPauseOnExceptionsParams {
            pub const IDENTIFIER: &'static str = "Debugger.setPauseOnExceptions";
        }
        impl chromiumoxide_types::Method for SetPauseOnExceptionsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetPauseOnExceptionsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions or\nno exceptions. Initial pause on exceptions state is `none`.\n[setPauseOnExceptions](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setPauseOnExceptions)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetPauseOnExceptionsReturns {}
        impl chromiumoxide_types::Command for SetPauseOnExceptionsParams {
            type Response = SetPauseOnExceptionsReturns;
        }
        #[doc = "Changes return value in top frame. Available only at return break position.\n[setReturnValue](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setReturnValue)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetReturnValueParams {
            #[doc = "New return value."]
            #[serde(rename = "newValue")]
            pub new_value: super::runtime::CallArgument,
        }
        impl SetReturnValueParams {
            pub fn new(new_value: impl Into<super::runtime::CallArgument>) -> Self {
                Self {
                    new_value: new_value.into(),
                }
            }
        }
        impl SetReturnValueParams {
            pub fn builder() -> SetReturnValueParamsBuilder {
                SetReturnValueParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetReturnValueParamsBuilder {
            new_value: Option<super::runtime::CallArgument>,
        }
        impl SetReturnValueParamsBuilder {
            pub fn new_value(mut self, new_value: impl Into<super::runtime::CallArgument>) -> Self {
                self.new_value = Some(new_value.into());
                self
            }
            pub fn build(self) -> Result<SetReturnValueParams, String> {
                Ok(SetReturnValueParams {
                    new_value: self.new_value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(new_value))
                    })?,
                })
            }
        }
        impl SetReturnValueParams {
            pub const IDENTIFIER: &'static str = "Debugger.setReturnValue";
        }
        impl chromiumoxide_types::Method for SetReturnValueParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetReturnValueParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Changes return value in top frame. Available only at return break position.\n[setReturnValue](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setReturnValue)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetReturnValueReturns {}
        impl chromiumoxide_types::Command for SetReturnValueParams {
            type Response = SetReturnValueReturns;
        }
        #[doc = "Edits JavaScript source live.\n[setScriptSource](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setScriptSource)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetScriptSourceParams {
            #[doc = "Id of the script to edit."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "New content of the script."]
            #[serde(rename = "scriptSource")]
            pub script_source: String,
            #[doc = "If true the change will not actually be applied. Dry run may be used to get result\ndescription without actually modifying the code."]
            #[serde(rename = "dryRun")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub dry_run: Option<bool>,
        }
        impl SetScriptSourceParams {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                script_source: impl Into<String>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    script_source: script_source.into(),
                    dry_run: None,
                }
            }
        }
        impl SetScriptSourceParams {
            pub fn builder() -> SetScriptSourceParamsBuilder {
                SetScriptSourceParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetScriptSourceParamsBuilder {
            script_id: Option<super::runtime::ScriptId>,
            script_source: Option<String>,
            dry_run: Option<bool>,
        }
        impl SetScriptSourceParamsBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn script_source(mut self, script_source: impl Into<String>) -> Self {
                self.script_source = Some(script_source.into());
                self
            }
            pub fn dry_run(mut self, dry_run: impl Into<bool>) -> Self {
                self.dry_run = Some(dry_run.into());
                self
            }
            pub fn build(self) -> Result<SetScriptSourceParams, String> {
                Ok(SetScriptSourceParams {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    script_source: self.script_source.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_source))
                    })?,
                    dry_run: self.dry_run,
                })
            }
        }
        impl SetScriptSourceParams {
            pub const IDENTIFIER: &'static str = "Debugger.setScriptSource";
        }
        impl chromiumoxide_types::Method for SetScriptSourceParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetScriptSourceParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Edits JavaScript source live.\n[setScriptSource](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setScriptSource)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetScriptSourceReturns {
            #[doc = "New stack trace in case editing has happened while VM was stopped."]
            #[serde(rename = "callFrames")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub call_frames: Option<Vec<CallFrame>>,
            #[doc = "Whether current call stack  was modified after applying the changes."]
            #[serde(rename = "stackChanged")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub stack_changed: Option<bool>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace: Option<super::runtime::StackTrace>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTraceId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace_id: Option<super::runtime::StackTraceId>,
            #[doc = "Exception details if any."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl SetScriptSourceReturns {
            pub fn builder() -> SetScriptSourceReturnsBuilder {
                SetScriptSourceReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetScriptSourceReturnsBuilder {
            call_frames: Option<Vec<CallFrame>>,
            stack_changed: Option<bool>,
            async_stack_trace: Option<super::runtime::StackTrace>,
            async_stack_trace_id: Option<super::runtime::StackTraceId>,
            exception_details: Option<super::runtime::ExceptionDetails>,
        }
        impl SetScriptSourceReturnsBuilder {
            pub fn call_frame(mut self, call_frame: impl Into<CallFrame>) -> Self {
                let v = self.call_frames.get_or_insert(Vec::new());
                v.push(call_frame.into());
                self
            }
            pub fn call_frames<I, S>(mut self, call_frames: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CallFrame>,
            {
                let v = self.call_frames.get_or_insert(Vec::new());
                for val in call_frames {
                    v.push(val.into());
                }
                self
            }
            pub fn stack_changed(mut self, stack_changed: impl Into<bool>) -> Self {
                self.stack_changed = Some(stack_changed.into());
                self
            }
            pub fn async_stack_trace(
                mut self,
                async_stack_trace: impl Into<super::runtime::StackTrace>,
            ) -> Self {
                self.async_stack_trace = Some(async_stack_trace.into());
                self
            }
            pub fn async_stack_trace_id(
                mut self,
                async_stack_trace_id: impl Into<super::runtime::StackTraceId>,
            ) -> Self {
                self.async_stack_trace_id = Some(async_stack_trace_id.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<super::runtime::ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> SetScriptSourceReturns {
                SetScriptSourceReturns {
                    call_frames: self.call_frames,
                    stack_changed: self.stack_changed,
                    async_stack_trace: self.async_stack_trace,
                    async_stack_trace_id: self.async_stack_trace_id,
                    exception_details: self.exception_details,
                }
            }
        }
        impl chromiumoxide_types::Command for SetScriptSourceParams {
            type Response = SetScriptSourceReturns;
        }
        #[doc = "Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).\n[setSkipAllPauses](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setSkipAllPauses)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetSkipAllPausesParams {
            #[doc = "New value for skip pauses state."]
            #[serde(rename = "skip")]
            pub skip: bool,
        }
        impl SetSkipAllPausesParams {
            pub fn new(skip: impl Into<bool>) -> Self {
                Self { skip: skip.into() }
            }
        }
        impl SetSkipAllPausesParams {
            pub fn builder() -> SetSkipAllPausesParamsBuilder {
                SetSkipAllPausesParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetSkipAllPausesParamsBuilder {
            skip: Option<bool>,
        }
        impl SetSkipAllPausesParamsBuilder {
            pub fn skip(mut self, skip: impl Into<bool>) -> Self {
                self.skip = Some(skip.into());
                self
            }
            pub fn build(self) -> Result<SetSkipAllPausesParams, String> {
                Ok(SetSkipAllPausesParams {
                    skip: self.skip.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(skip))
                    })?,
                })
            }
        }
        impl SetSkipAllPausesParams {
            pub const IDENTIFIER: &'static str = "Debugger.setSkipAllPauses";
        }
        impl chromiumoxide_types::Method for SetSkipAllPausesParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetSkipAllPausesParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).\n[setSkipAllPauses](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setSkipAllPauses)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetSkipAllPausesReturns {}
        impl chromiumoxide_types::Command for SetSkipAllPausesParams {
            type Response = SetSkipAllPausesReturns;
        }
        #[doc = "Changes value of variable in a callframe. Object-based scopes are not supported and must be\nmutated manually.\n[setVariableValue](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setVariableValue)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetVariableValueParams {
            #[doc = "0-based number of scope as was listed in scope chain. Only 'local', 'closure' and 'catch'\nscope types are allowed. Other scopes could be manipulated manually."]
            #[serde(rename = "scopeNumber")]
            pub scope_number: i64,
            #[doc = "Variable name."]
            #[serde(rename = "variableName")]
            pub variable_name: String,
            #[doc = "New variable value."]
            #[serde(rename = "newValue")]
            pub new_value: super::runtime::CallArgument,
            #[doc = "Id of callframe that holds variable."]
            #[serde(rename = "callFrameId")]
            pub call_frame_id: CallFrameId,
        }
        impl SetVariableValueParams {
            pub fn new(
                scope_number: impl Into<i64>,
                variable_name: impl Into<String>,
                new_value: impl Into<super::runtime::CallArgument>,
                call_frame_id: impl Into<CallFrameId>,
            ) -> Self {
                Self {
                    scope_number: scope_number.into(),
                    variable_name: variable_name.into(),
                    new_value: new_value.into(),
                    call_frame_id: call_frame_id.into(),
                }
            }
        }
        impl SetVariableValueParams {
            pub fn builder() -> SetVariableValueParamsBuilder {
                SetVariableValueParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetVariableValueParamsBuilder {
            scope_number: Option<i64>,
            variable_name: Option<String>,
            new_value: Option<super::runtime::CallArgument>,
            call_frame_id: Option<CallFrameId>,
        }
        impl SetVariableValueParamsBuilder {
            pub fn scope_number(mut self, scope_number: impl Into<i64>) -> Self {
                self.scope_number = Some(scope_number.into());
                self
            }
            pub fn variable_name(mut self, variable_name: impl Into<String>) -> Self {
                self.variable_name = Some(variable_name.into());
                self
            }
            pub fn new_value(mut self, new_value: impl Into<super::runtime::CallArgument>) -> Self {
                self.new_value = Some(new_value.into());
                self
            }
            pub fn call_frame_id(mut self, call_frame_id: impl Into<CallFrameId>) -> Self {
                self.call_frame_id = Some(call_frame_id.into());
                self
            }
            pub fn build(self) -> Result<SetVariableValueParams, String> {
                Ok(SetVariableValueParams {
                    scope_number: self.scope_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(scope_number))
                    })?,
                    variable_name: self.variable_name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(variable_name))
                    })?,
                    new_value: self.new_value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(new_value))
                    })?,
                    call_frame_id: self.call_frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame_id))
                    })?,
                })
            }
        }
        impl SetVariableValueParams {
            pub const IDENTIFIER: &'static str = "Debugger.setVariableValue";
        }
        impl chromiumoxide_types::Method for SetVariableValueParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetVariableValueParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Changes value of variable in a callframe. Object-based scopes are not supported and must be\nmutated manually.\n[setVariableValue](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-setVariableValue)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetVariableValueReturns {}
        impl chromiumoxide_types::Command for SetVariableValueParams {
            type Response = SetVariableValueReturns;
        }
        #[doc = "Steps into the function call.\n[stepInto](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepInto)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepIntoParams {
            #[doc = "Debugger will pause on the execution of the first async task which was scheduled\nbefore next pause."]
            #[serde(rename = "breakOnAsyncCall")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub break_on_async_call: Option<bool>,
            #[doc = "The skipList specifies location ranges that should be skipped on step into."]
            #[serde(rename = "skipList")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub skip_list: Option<Vec<LocationRange>>,
        }
        impl StepIntoParams {
            pub fn builder() -> StepIntoParamsBuilder {
                StepIntoParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StepIntoParamsBuilder {
            break_on_async_call: Option<bool>,
            skip_list: Option<Vec<LocationRange>>,
        }
        impl StepIntoParamsBuilder {
            pub fn break_on_async_call(mut self, break_on_async_call: impl Into<bool>) -> Self {
                self.break_on_async_call = Some(break_on_async_call.into());
                self
            }
            pub fn skip_list(mut self, skip_list: impl Into<LocationRange>) -> Self {
                let v = self.skip_list.get_or_insert(Vec::new());
                v.push(skip_list.into());
                self
            }
            pub fn skip_lists<I, S>(mut self, skip_lists: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<LocationRange>,
            {
                let v = self.skip_list.get_or_insert(Vec::new());
                for val in skip_lists {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> StepIntoParams {
                StepIntoParams {
                    break_on_async_call: self.break_on_async_call,
                    skip_list: self.skip_list,
                }
            }
        }
        impl StepIntoParams {
            pub const IDENTIFIER: &'static str = "Debugger.stepInto";
        }
        impl chromiumoxide_types::Method for StepIntoParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StepIntoParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Steps into the function call.\n[stepInto](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepInto)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepIntoReturns {}
        impl chromiumoxide_types::Command for StepIntoParams {
            type Response = StepIntoReturns;
        }
        #[doc = "Steps out of the function call.\n[stepOut](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepOut)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepOutParams {}
        impl StepOutParams {
            pub const IDENTIFIER: &'static str = "Debugger.stepOut";
        }
        impl chromiumoxide_types::Method for StepOutParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StepOutParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Steps out of the function call.\n[stepOut](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepOut)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepOutReturns {}
        impl chromiumoxide_types::Command for StepOutParams {
            type Response = StepOutReturns;
        }
        #[doc = "Steps over the statement.\n[stepOver](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepOver)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepOverParams {
            #[doc = "The skipList specifies location ranges that should be skipped on step over."]
            #[serde(rename = "skipList")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub skip_list: Option<Vec<LocationRange>>,
        }
        impl StepOverParams {
            pub fn builder() -> StepOverParamsBuilder {
                StepOverParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StepOverParamsBuilder {
            skip_list: Option<Vec<LocationRange>>,
        }
        impl StepOverParamsBuilder {
            pub fn skip_list(mut self, skip_list: impl Into<LocationRange>) -> Self {
                let v = self.skip_list.get_or_insert(Vec::new());
                v.push(skip_list.into());
                self
            }
            pub fn skip_lists<I, S>(mut self, skip_lists: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<LocationRange>,
            {
                let v = self.skip_list.get_or_insert(Vec::new());
                for val in skip_lists {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> StepOverParams {
                StepOverParams {
                    skip_list: self.skip_list,
                }
            }
        }
        impl StepOverParams {
            pub const IDENTIFIER: &'static str = "Debugger.stepOver";
        }
        impl chromiumoxide_types::Method for StepOverParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StepOverParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Steps over the statement.\n[stepOver](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#method-stepOver)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StepOverReturns {}
        impl chromiumoxide_types::Command for StepOverParams {
            type Response = StepOverReturns;
        }
        #[doc = "Fired when breakpoint is resolved to an actual script and location.\n[breakpointResolved](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#event-breakpointResolved)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventBreakpointResolved {
            #[doc = "Breakpoint unique identifier."]
            #[serde(rename = "breakpointId")]
            pub breakpoint_id: BreakpointId,
            #[doc = "Actual breakpoint location."]
            #[serde(rename = "location")]
            pub location: Location,
        }
        impl EventBreakpointResolved {
            pub const IDENTIFIER: &'static str = "Debugger.breakpointResolved";
        }
        impl chromiumoxide_types::Method for EventBreakpointResolved {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventBreakpointResolved {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fired when the virtual machine stopped on breakpoint or exception or any other stop criteria.\n[paused](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#event-paused)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventPaused {
            #[doc = "Call stack the virtual machine stopped on."]
            #[serde(rename = "callFrames")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub call_frames: Vec<CallFrame>,
            #[doc = "Pause reason."]
            #[serde(rename = "reason")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub reason: PausedReason,
            #[doc = "Object containing break-specific auxiliary properties."]
            #[serde(rename = "data")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub data: Option<serde_json::Value>,
            #[doc = "Hit breakpoints IDs"]
            #[serde(rename = "hitBreakpoints")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub hit_breakpoints: Option<Vec<String>>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace: Option<super::runtime::StackTrace>,
            #[doc = "Async stack trace, if any."]
            #[serde(rename = "asyncStackTraceId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub async_stack_trace_id: Option<super::runtime::StackTraceId>,
        }
        #[doc = "Pause reason."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum PausedReason {
            #[serde(rename = "ambiguous")]
            Ambiguous,
            #[serde(rename = "assert")]
            Assert,
            #[serde(rename = "debugCommand")]
            DebugCommand,
            #[serde(rename = "DOM")]
            Dom,
            #[serde(rename = "EventListener")]
            EventListener,
            #[serde(rename = "exception")]
            Exception,
            #[serde(rename = "instrumentation")]
            Instrumentation,
            #[serde(rename = "OOM")]
            Oom,
            #[serde(rename = "other")]
            Other,
            #[serde(rename = "promiseRejection")]
            PromiseRejection,
            #[serde(rename = "XHR")]
            Xhr,
            #[serde(rename = "Break on start")]
            BreakOnStart,
        }
        impl AsRef<str> for PausedReason {
            fn as_ref(&self) -> &str {
                match self {
                    PausedReason::Ambiguous => "ambiguous",
                    PausedReason::Assert => "assert",
                    PausedReason::DebugCommand => "debugCommand",
                    PausedReason::Dom => "DOM",
                    PausedReason::EventListener => "EventListener",
                    PausedReason::Exception => "exception",
                    PausedReason::Instrumentation => "instrumentation",
                    PausedReason::Oom => "OOM",
                    PausedReason::Other => "other",
                    PausedReason::PromiseRejection => "promiseRejection",
                    PausedReason::Xhr => "XHR",
                    PausedReason::BreakOnStart => "Break on start",
                }
            }
        }
        impl ::std::str::FromStr for PausedReason {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "ambiguous" | "Ambiguous" => Ok(PausedReason::Ambiguous),
                    "assert" | "Assert" => Ok(PausedReason::Assert),
                    "debugCommand" | "DebugCommand" | "debugcommand" => {
                        Ok(PausedReason::DebugCommand)
                    }
                    "DOM" | "Dom" | "dom" => Ok(PausedReason::Dom),
                    "EventListener" | "eventlistener" => Ok(PausedReason::EventListener),
                    "exception" | "Exception" => Ok(PausedReason::Exception),
                    "instrumentation" | "Instrumentation" => Ok(PausedReason::Instrumentation),
                    "OOM" | "Oom" | "oom" => Ok(PausedReason::Oom),
                    "other" | "Other" => Ok(PausedReason::Other),
                    "promiseRejection" | "PromiseRejection" | "promiserejection" => {
                        Ok(PausedReason::PromiseRejection)
                    }
                    "XHR" | "Xhr" | "xhr" => Ok(PausedReason::Xhr),
                    "Break on start" | "BreakOnStart" | "break on start" => {
                        Ok(PausedReason::BreakOnStart)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        impl EventPaused {
            pub const IDENTIFIER: &'static str = "Debugger.paused";
        }
        impl chromiumoxide_types::Method for EventPaused {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventPaused {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fired when the virtual machine resumed execution.\n[resumed](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#event-resumed)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EventResumed {}
        impl EventResumed {
            pub const IDENTIFIER: &'static str = "Debugger.resumed";
        }
        impl chromiumoxide_types::Method for EventResumed {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventResumed {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fired when virtual machine fails to parse the script.\n[scriptFailedToParse](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#event-scriptFailedToParse)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventScriptFailedToParse {
            #[doc = "Identifier of the script parsed."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "URL or name of the script parsed (if any)."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Line offset of the script within the resource with given URL (for script tags)."]
            #[serde(rename = "startLine")]
            pub start_line: i64,
            #[doc = "Column offset of the script within the resource with given URL."]
            #[serde(rename = "startColumn")]
            pub start_column: i64,
            #[doc = "Last line of the script."]
            #[serde(rename = "endLine")]
            pub end_line: i64,
            #[doc = "Length of the last line of the script."]
            #[serde(rename = "endColumn")]
            pub end_column: i64,
            #[doc = "Specifies script creation context."]
            #[serde(rename = "executionContextId")]
            pub execution_context_id: super::runtime::ExecutionContextId,
            #[doc = "Content hash of the script."]
            #[serde(rename = "hash")]
            pub hash: String,
            #[doc = "Embedder-specific auxiliary data."]
            #[serde(rename = "executionContextAuxData")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_aux_data: Option<serde_json::Value>,
            #[doc = "URL of source map associated with script (if any)."]
            #[serde(rename = "sourceMapURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub source_map_url: Option<String>,
            #[doc = "True, if this script has sourceURL."]
            #[serde(rename = "hasSourceURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub has_source_url: Option<bool>,
            #[doc = "True, if this script is ES6 module."]
            #[serde(rename = "isModule")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub is_module: Option<bool>,
            #[doc = "This script length."]
            #[serde(rename = "length")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub length: Option<i64>,
            #[doc = "JavaScript top stack frame of where the script parsed event was triggered if available."]
            #[serde(rename = "stackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub stack_trace: Option<super::runtime::StackTrace>,
            #[doc = "If the scriptLanguage is WebAssembly, the code section offset in the module."]
            #[serde(rename = "codeOffset")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub code_offset: Option<i64>,
            #[doc = "The language of the script."]
            #[serde(rename = "scriptLanguage")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub script_language: Option<super::debugger::ScriptLanguage>,
            #[doc = "The name the embedder supplied for this script."]
            #[serde(rename = "embedderName")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub embedder_name: Option<String>,
        }
        impl EventScriptFailedToParse {
            pub const IDENTIFIER: &'static str = "Debugger.scriptFailedToParse";
        }
        impl chromiumoxide_types::Method for EventScriptFailedToParse {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventScriptFailedToParse {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fired when virtual machine parses script. This event is also fired for all known and uncollected\nscripts upon enabling debugger.\n[scriptParsed](https://chromedevtools.github.io/devtools-protocol/tot/Debugger/#event-scriptParsed)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventScriptParsed {
            #[doc = "Identifier of the script parsed."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "URL or name of the script parsed (if any)."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Line offset of the script within the resource with given URL (for script tags)."]
            #[serde(rename = "startLine")]
            pub start_line: i64,
            #[doc = "Column offset of the script within the resource with given URL."]
            #[serde(rename = "startColumn")]
            pub start_column: i64,
            #[doc = "Last line of the script."]
            #[serde(rename = "endLine")]
            pub end_line: i64,
            #[doc = "Length of the last line of the script."]
            #[serde(rename = "endColumn")]
            pub end_column: i64,
            #[doc = "Specifies script creation context."]
            #[serde(rename = "executionContextId")]
            pub execution_context_id: super::runtime::ExecutionContextId,
            #[doc = "Content hash of the script."]
            #[serde(rename = "hash")]
            pub hash: String,
            #[doc = "Embedder-specific auxiliary data."]
            #[serde(rename = "executionContextAuxData")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_aux_data: Option<serde_json::Value>,
            #[doc = "True, if this script is generated as a result of the live edit operation."]
            #[serde(rename = "isLiveEdit")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub is_live_edit: Option<bool>,
            #[doc = "URL of source map associated with script (if any)."]
            #[serde(rename = "sourceMapURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub source_map_url: Option<String>,
            #[doc = "True, if this script has sourceURL."]
            #[serde(rename = "hasSourceURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub has_source_url: Option<bool>,
            #[doc = "True, if this script is ES6 module."]
            #[serde(rename = "isModule")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub is_module: Option<bool>,
            #[doc = "This script length."]
            #[serde(rename = "length")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub length: Option<i64>,
            #[doc = "JavaScript top stack frame of where the script parsed event was triggered if available."]
            #[serde(rename = "stackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub stack_trace: Option<super::runtime::StackTrace>,
            #[doc = "If the scriptLanguage is WebAssembly, the code section offset in the module."]
            #[serde(rename = "codeOffset")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub code_offset: Option<i64>,
            #[doc = "The language of the script."]
            #[serde(rename = "scriptLanguage")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub script_language: Option<super::debugger::ScriptLanguage>,
            #[doc = "If the scriptLanguage is WebASsembly, the source of debug symbols for the module."]
            #[serde(rename = "debugSymbols")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub debug_symbols: Option<super::debugger::DebugSymbols>,
            #[doc = "The name the embedder supplied for this script."]
            #[serde(rename = "embedderName")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub embedder_name: Option<String>,
        }
        impl EventScriptParsed {
            pub const IDENTIFIER: &'static str = "Debugger.scriptParsed";
        }
        impl chromiumoxide_types::Method for EventScriptParsed {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventScriptParsed {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    pub mod heap_profiler {
        use serde::{Deserialize, Serialize};
        #[doc = "Heap snapshot object id.\n[HeapSnapshotObjectId](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-HeapSnapshotObjectId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct HeapSnapshotObjectId(String);
        impl HeapSnapshotObjectId {
            pub fn new(val: impl Into<String>) -> Self {
                HeapSnapshotObjectId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for HeapSnapshotObjectId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<HeapSnapshotObjectId> for String {
            fn from(el: HeapSnapshotObjectId) -> String {
                el.0
            }
        }
        impl From<String> for HeapSnapshotObjectId {
            fn from(expr: String) -> Self {
                HeapSnapshotObjectId(expr)
            }
        }
        impl std::borrow::Borrow<str> for HeapSnapshotObjectId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl HeapSnapshotObjectId {
            pub const IDENTIFIER: &'static str = "HeapProfiler.HeapSnapshotObjectId";
        }
        #[doc = "Sampling Heap Profile node. Holds callsite information, allocation statistics and child nodes.\n[SamplingHeapProfileNode](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfileNode)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SamplingHeapProfileNode {
            #[doc = "Function location."]
            #[serde(rename = "callFrame")]
            pub call_frame: super::runtime::CallFrame,
            #[doc = "Allocations size in bytes for the node excluding children."]
            #[serde(rename = "selfSize")]
            pub self_size: f64,
            #[doc = "Node id. Ids are unique across all profiles collected between startSampling and stopSampling."]
            #[serde(rename = "id")]
            pub id: i64,
            #[doc = "Child nodes."]
            #[serde(rename = "children")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub children: Vec<SamplingHeapProfileNode>,
        }
        impl SamplingHeapProfileNode {
            pub fn new(
                call_frame: impl Into<super::runtime::CallFrame>,
                self_size: impl Into<f64>,
                id: impl Into<i64>,
                children: Vec<SamplingHeapProfileNode>,
            ) -> Self {
                Self {
                    call_frame: call_frame.into(),
                    self_size: self_size.into(),
                    id: id.into(),
                    children,
                }
            }
        }
        impl SamplingHeapProfileNode {
            pub fn builder() -> SamplingHeapProfileNodeBuilder {
                SamplingHeapProfileNodeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SamplingHeapProfileNodeBuilder {
            call_frame: Option<super::runtime::CallFrame>,
            self_size: Option<f64>,
            id: Option<i64>,
            children: Option<Vec<SamplingHeapProfileNode>>,
        }
        impl SamplingHeapProfileNodeBuilder {
            pub fn call_frame(mut self, call_frame: impl Into<super::runtime::CallFrame>) -> Self {
                self.call_frame = Some(call_frame.into());
                self
            }
            pub fn self_size(mut self, self_size: impl Into<f64>) -> Self {
                self.self_size = Some(self_size.into());
                self
            }
            pub fn id(mut self, id: impl Into<i64>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn children(mut self, children: impl Into<SamplingHeapProfileNode>) -> Self {
                let v = self.children.get_or_insert(Vec::new());
                v.push(children.into());
                self
            }
            pub fn childrens<I, S>(mut self, childrens: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<SamplingHeapProfileNode>,
            {
                let v = self.children.get_or_insert(Vec::new());
                for val in childrens {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SamplingHeapProfileNode, String> {
                Ok(SamplingHeapProfileNode {
                    call_frame: self.call_frame.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame))
                    })?,
                    self_size: self.self_size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(self_size))
                    })?,
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                    children: self.children.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(children))
                    })?,
                })
            }
        }
        impl SamplingHeapProfileNode {
            pub const IDENTIFIER: &'static str = "HeapProfiler.SamplingHeapProfileNode";
        }
        #[doc = "A single sample from a sampling profile.\n[SamplingHeapProfileSample](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfileSample)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SamplingHeapProfileSample {
            #[doc = "Allocation size in bytes attributed to the sample."]
            #[serde(rename = "size")]
            pub size: f64,
            #[doc = "Id of the corresponding profile tree node."]
            #[serde(rename = "nodeId")]
            pub node_id: i64,
            #[doc = "Time-ordered sample ordinal number. It is unique across all profiles retrieved\nbetween startSampling and stopSampling."]
            #[serde(rename = "ordinal")]
            pub ordinal: f64,
        }
        impl SamplingHeapProfileSample {
            pub fn new(
                size: impl Into<f64>,
                node_id: impl Into<i64>,
                ordinal: impl Into<f64>,
            ) -> Self {
                Self {
                    size: size.into(),
                    node_id: node_id.into(),
                    ordinal: ordinal.into(),
                }
            }
        }
        impl SamplingHeapProfileSample {
            pub fn builder() -> SamplingHeapProfileSampleBuilder {
                SamplingHeapProfileSampleBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SamplingHeapProfileSampleBuilder {
            size: Option<f64>,
            node_id: Option<i64>,
            ordinal: Option<f64>,
        }
        impl SamplingHeapProfileSampleBuilder {
            pub fn size(mut self, size: impl Into<f64>) -> Self {
                self.size = Some(size.into());
                self
            }
            pub fn node_id(mut self, node_id: impl Into<i64>) -> Self {
                self.node_id = Some(node_id.into());
                self
            }
            pub fn ordinal(mut self, ordinal: impl Into<f64>) -> Self {
                self.ordinal = Some(ordinal.into());
                self
            }
            pub fn build(self) -> Result<SamplingHeapProfileSample, String> {
                Ok(SamplingHeapProfileSample {
                    size: self.size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(size))
                    })?,
                    node_id: self.node_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(node_id))
                    })?,
                    ordinal: self.ordinal.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(ordinal))
                    })?,
                })
            }
        }
        impl SamplingHeapProfileSample {
            pub const IDENTIFIER: &'static str = "HeapProfiler.SamplingHeapProfileSample";
        }
        #[doc = "Sampling profile.\n[SamplingHeapProfile](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfile)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SamplingHeapProfile {
            #[serde(rename = "head")]
            pub head: SamplingHeapProfileNode,
            #[serde(rename = "samples")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub samples: Vec<SamplingHeapProfileSample>,
        }
        impl SamplingHeapProfile {
            pub fn new(
                head: impl Into<SamplingHeapProfileNode>,
                samples: Vec<SamplingHeapProfileSample>,
            ) -> Self {
                Self {
                    head: head.into(),
                    samples,
                }
            }
        }
        impl SamplingHeapProfile {
            pub fn builder() -> SamplingHeapProfileBuilder {
                SamplingHeapProfileBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SamplingHeapProfileBuilder {
            head: Option<SamplingHeapProfileNode>,
            samples: Option<Vec<SamplingHeapProfileSample>>,
        }
        impl SamplingHeapProfileBuilder {
            pub fn head(mut self, head: impl Into<SamplingHeapProfileNode>) -> Self {
                self.head = Some(head.into());
                self
            }
            pub fn sample(mut self, sample: impl Into<SamplingHeapProfileSample>) -> Self {
                let v = self.samples.get_or_insert(Vec::new());
                v.push(sample.into());
                self
            }
            pub fn samples<I, S>(mut self, samples: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<SamplingHeapProfileSample>,
            {
                let v = self.samples.get_or_insert(Vec::new());
                for val in samples {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<SamplingHeapProfile, String> {
                Ok(SamplingHeapProfile {
                    head: self.head.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(head))
                    })?,
                    samples: self.samples.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(samples))
                    })?,
                })
            }
        }
        impl SamplingHeapProfile {
            pub const IDENTIFIER: &'static str = "HeapProfiler.SamplingHeapProfile";
        }
        #[doc = "Enables console to refer to the node with given id via $x (see Command Line API for more details\n$x functions).\n[addInspectedHeapObject](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#method-addInspectedHeapObject)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AddInspectedHeapObjectParams {
            #[doc = "Heap snapshot object id to be accessible by means of $x command line API."]
            #[serde(rename = "heapObjectId")]
            pub heap_object_id: HeapSnapshotObjectId,
        }
        impl AddInspectedHeapObjectParams {
            pub fn new(heap_object_id: impl Into<HeapSnapshotObjectId>) -> Self {
                Self {
                    heap_object_id: heap_object_id.into(),
                }
            }
        }
        impl AddInspectedHeapObjectParams {
            pub fn builder() -> AddInspectedHeapObjectParamsBuilder {
                AddInspectedHeapObjectParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AddInspectedHeapObjectParamsBuilder {
            heap_object_id: Option<HeapSnapshotObjectId>,
        }
        impl AddInspectedHeapObjectParamsBuilder {
            pub fn heap_object_id(
                mut self,
                heap_object_id: impl Into<HeapSnapshotObjectId>,
            ) -> Self {
                self.heap_object_id = Some(heap_object_id.into());
                self
            }
            pub fn build(self) -> Result<AddInspectedHeapObjectParams, String> {
                Ok(AddInspectedHeapObjectParams {
                    heap_object_id: self.heap_object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(heap_object_id))
                    })?,
                })
            }
        }
        impl AddInspectedHeapObjectParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.addInspectedHeapObject";
        }
        impl chromiumoxide_types::Method for AddInspectedHeapObjectParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for AddInspectedHeapObjectParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables console to refer to the node with given id via $x (see Command Line API for more details\n$x functions).\n[addInspectedHeapObject](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#method-addInspectedHeapObject)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct AddInspectedHeapObjectReturns {}
        impl chromiumoxide_types::Command for AddInspectedHeapObjectParams {
            type Response = AddInspectedHeapObjectReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct CollectGarbageParams {}
        impl CollectGarbageParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.collectGarbage";
        }
        impl chromiumoxide_types::Method for CollectGarbageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for CollectGarbageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct CollectGarbageReturns {}
        impl chromiumoxide_types::Command for CollectGarbageParams {
            type Response = CollectGarbageReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetHeapObjectIdParams {
            #[doc = "Identifier of the object to get heap object id for."]
            #[serde(rename = "objectId")]
            pub object_id: super::runtime::RemoteObjectId,
        }
        impl GetHeapObjectIdParams {
            pub fn new(object_id: impl Into<super::runtime::RemoteObjectId>) -> Self {
                Self {
                    object_id: object_id.into(),
                }
            }
        }
        impl GetHeapObjectIdParams {
            pub fn builder() -> GetHeapObjectIdParamsBuilder {
                GetHeapObjectIdParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetHeapObjectIdParamsBuilder {
            object_id: Option<super::runtime::RemoteObjectId>,
        }
        impl GetHeapObjectIdParamsBuilder {
            pub fn object_id(
                mut self,
                object_id: impl Into<super::runtime::RemoteObjectId>,
            ) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn build(self) -> Result<GetHeapObjectIdParams, String> {
                Ok(GetHeapObjectIdParams {
                    object_id: self.object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_id))
                    })?,
                })
            }
        }
        impl GetHeapObjectIdParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.getHeapObjectId";
        }
        impl chromiumoxide_types::Method for GetHeapObjectIdParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetHeapObjectIdParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetHeapObjectIdReturns {
            #[doc = "Id of the heap snapshot object corresponding to the passed remote object id."]
            #[serde(rename = "heapSnapshotObjectId")]
            pub heap_snapshot_object_id: HeapSnapshotObjectId,
        }
        impl GetHeapObjectIdReturns {
            pub fn new(heap_snapshot_object_id: impl Into<HeapSnapshotObjectId>) -> Self {
                Self {
                    heap_snapshot_object_id: heap_snapshot_object_id.into(),
                }
            }
        }
        impl GetHeapObjectIdReturns {
            pub fn builder() -> GetHeapObjectIdReturnsBuilder {
                GetHeapObjectIdReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetHeapObjectIdReturnsBuilder {
            heap_snapshot_object_id: Option<HeapSnapshotObjectId>,
        }
        impl GetHeapObjectIdReturnsBuilder {
            pub fn heap_snapshot_object_id(
                mut self,
                heap_snapshot_object_id: impl Into<HeapSnapshotObjectId>,
            ) -> Self {
                self.heap_snapshot_object_id = Some(heap_snapshot_object_id.into());
                self
            }
            pub fn build(self) -> Result<GetHeapObjectIdReturns, String> {
                Ok(GetHeapObjectIdReturns {
                    heap_snapshot_object_id: self.heap_snapshot_object_id.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(heap_snapshot_object_id)
                        )
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetHeapObjectIdParams {
            type Response = GetHeapObjectIdReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetObjectByHeapObjectIdParams {
            #[serde(rename = "objectId")]
            pub object_id: HeapSnapshotObjectId,
            #[doc = "Symbolic group name that can be used to release multiple objects."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
        }
        impl GetObjectByHeapObjectIdParams {
            pub fn new(object_id: impl Into<HeapSnapshotObjectId>) -> Self {
                Self {
                    object_id: object_id.into(),
                    object_group: None,
                }
            }
        }
        impl GetObjectByHeapObjectIdParams {
            pub fn builder() -> GetObjectByHeapObjectIdParamsBuilder {
                GetObjectByHeapObjectIdParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetObjectByHeapObjectIdParamsBuilder {
            object_id: Option<HeapSnapshotObjectId>,
            object_group: Option<String>,
        }
        impl GetObjectByHeapObjectIdParamsBuilder {
            pub fn object_id(mut self, object_id: impl Into<HeapSnapshotObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn build(self) -> Result<GetObjectByHeapObjectIdParams, String> {
                Ok(GetObjectByHeapObjectIdParams {
                    object_id: self.object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_id))
                    })?,
                    object_group: self.object_group,
                })
            }
        }
        impl GetObjectByHeapObjectIdParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.getObjectByHeapObjectId";
        }
        impl chromiumoxide_types::Method for GetObjectByHeapObjectIdParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetObjectByHeapObjectIdParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetObjectByHeapObjectIdReturns {
            #[doc = "Evaluation result."]
            #[serde(rename = "result")]
            pub result: super::runtime::RemoteObject,
        }
        impl GetObjectByHeapObjectIdReturns {
            pub fn new(result: impl Into<super::runtime::RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                }
            }
        }
        impl GetObjectByHeapObjectIdReturns {
            pub fn builder() -> GetObjectByHeapObjectIdReturnsBuilder {
                GetObjectByHeapObjectIdReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetObjectByHeapObjectIdReturnsBuilder {
            result: Option<super::runtime::RemoteObject>,
        }
        impl GetObjectByHeapObjectIdReturnsBuilder {
            pub fn result(mut self, result: impl Into<super::runtime::RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn build(self) -> Result<GetObjectByHeapObjectIdReturns, String> {
                Ok(GetObjectByHeapObjectIdReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetObjectByHeapObjectIdParams {
            type Response = GetObjectByHeapObjectIdReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetSamplingProfileParams {}
        impl GetSamplingProfileParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.getSamplingProfile";
        }
        impl chromiumoxide_types::Method for GetSamplingProfileParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetSamplingProfileParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetSamplingProfileReturns {
            #[doc = "Return the sampling profile being collected."]
            #[serde(rename = "profile")]
            pub profile: SamplingHeapProfile,
        }
        impl GetSamplingProfileReturns {
            pub fn new(profile: impl Into<SamplingHeapProfile>) -> Self {
                Self {
                    profile: profile.into(),
                }
            }
        }
        impl GetSamplingProfileReturns {
            pub fn builder() -> GetSamplingProfileReturnsBuilder {
                GetSamplingProfileReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetSamplingProfileReturnsBuilder {
            profile: Option<SamplingHeapProfile>,
        }
        impl GetSamplingProfileReturnsBuilder {
            pub fn profile(mut self, profile: impl Into<SamplingHeapProfile>) -> Self {
                self.profile = Some(profile.into());
                self
            }
            pub fn build(self) -> Result<GetSamplingProfileReturns, String> {
                Ok(GetSamplingProfileReturns {
                    profile: self.profile.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(profile))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetSamplingProfileParams {
            type Response = GetSamplingProfileReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartSamplingParams {
            #[doc = "Average sample interval in bytes. Poisson distribution is used for the intervals. The\ndefault value is 32768 bytes."]
            #[serde(rename = "samplingInterval")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub sampling_interval: Option<f64>,
        }
        impl StartSamplingParams {
            pub fn builder() -> StartSamplingParamsBuilder {
                StartSamplingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StartSamplingParamsBuilder {
            sampling_interval: Option<f64>,
        }
        impl StartSamplingParamsBuilder {
            pub fn sampling_interval(mut self, sampling_interval: impl Into<f64>) -> Self {
                self.sampling_interval = Some(sampling_interval.into());
                self
            }
            pub fn build(self) -> StartSamplingParams {
                StartSamplingParams {
                    sampling_interval: self.sampling_interval,
                }
            }
        }
        impl StartSamplingParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.startSampling";
        }
        impl chromiumoxide_types::Method for StartSamplingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartSamplingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartSamplingReturns {}
        impl chromiumoxide_types::Command for StartSamplingParams {
            type Response = StartSamplingReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartTrackingHeapObjectsParams {
            #[serde(rename = "trackAllocations")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub track_allocations: Option<bool>,
        }
        impl StartTrackingHeapObjectsParams {
            pub fn builder() -> StartTrackingHeapObjectsParamsBuilder {
                StartTrackingHeapObjectsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StartTrackingHeapObjectsParamsBuilder {
            track_allocations: Option<bool>,
        }
        impl StartTrackingHeapObjectsParamsBuilder {
            pub fn track_allocations(mut self, track_allocations: impl Into<bool>) -> Self {
                self.track_allocations = Some(track_allocations.into());
                self
            }
            pub fn build(self) -> StartTrackingHeapObjectsParams {
                StartTrackingHeapObjectsParams {
                    track_allocations: self.track_allocations,
                }
            }
        }
        impl StartTrackingHeapObjectsParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.startTrackingHeapObjects";
        }
        impl chromiumoxide_types::Method for StartTrackingHeapObjectsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartTrackingHeapObjectsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartTrackingHeapObjectsReturns {}
        impl chromiumoxide_types::Command for StartTrackingHeapObjectsParams {
            type Response = StartTrackingHeapObjectsReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopSamplingParams {}
        impl StopSamplingParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.stopSampling";
        }
        impl chromiumoxide_types::Method for StopSamplingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopSamplingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StopSamplingReturns {
            #[doc = "Recorded sampling heap profile."]
            #[serde(rename = "profile")]
            pub profile: SamplingHeapProfile,
        }
        impl StopSamplingReturns {
            pub fn new(profile: impl Into<SamplingHeapProfile>) -> Self {
                Self {
                    profile: profile.into(),
                }
            }
        }
        impl StopSamplingReturns {
            pub fn builder() -> StopSamplingReturnsBuilder {
                StopSamplingReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StopSamplingReturnsBuilder {
            profile: Option<SamplingHeapProfile>,
        }
        impl StopSamplingReturnsBuilder {
            pub fn profile(mut self, profile: impl Into<SamplingHeapProfile>) -> Self {
                self.profile = Some(profile.into());
                self
            }
            pub fn build(self) -> Result<StopSamplingReturns, String> {
                Ok(StopSamplingReturns {
                    profile: self.profile.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(profile))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for StopSamplingParams {
            type Response = StopSamplingReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopTrackingHeapObjectsParams {
            #[doc = "If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken\nwhen the tracking is stopped."]
            #[serde(rename = "reportProgress")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub report_progress: Option<bool>,
            #[serde(rename = "treatGlobalObjectsAsRoots")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub treat_global_objects_as_roots: Option<bool>,
        }
        impl StopTrackingHeapObjectsParams {
            pub fn builder() -> StopTrackingHeapObjectsParamsBuilder {
                StopTrackingHeapObjectsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StopTrackingHeapObjectsParamsBuilder {
            report_progress: Option<bool>,
            treat_global_objects_as_roots: Option<bool>,
        }
        impl StopTrackingHeapObjectsParamsBuilder {
            pub fn report_progress(mut self, report_progress: impl Into<bool>) -> Self {
                self.report_progress = Some(report_progress.into());
                self
            }
            pub fn treat_global_objects_as_roots(
                mut self,
                treat_global_objects_as_roots: impl Into<bool>,
            ) -> Self {
                self.treat_global_objects_as_roots = Some(treat_global_objects_as_roots.into());
                self
            }
            pub fn build(self) -> StopTrackingHeapObjectsParams {
                StopTrackingHeapObjectsParams {
                    report_progress: self.report_progress,
                    treat_global_objects_as_roots: self.treat_global_objects_as_roots,
                }
            }
        }
        impl StopTrackingHeapObjectsParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.stopTrackingHeapObjects";
        }
        impl chromiumoxide_types::Method for StopTrackingHeapObjectsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopTrackingHeapObjectsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopTrackingHeapObjectsReturns {}
        impl chromiumoxide_types::Command for StopTrackingHeapObjectsParams {
            type Response = StopTrackingHeapObjectsReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TakeHeapSnapshotParams {
            #[doc = "If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken."]
            #[serde(rename = "reportProgress")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub report_progress: Option<bool>,
            #[doc = "If true, a raw snapshot without artifical roots will be generated"]
            #[serde(rename = "treatGlobalObjectsAsRoots")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub treat_global_objects_as_roots: Option<bool>,
        }
        impl TakeHeapSnapshotParams {
            pub fn builder() -> TakeHeapSnapshotParamsBuilder {
                TakeHeapSnapshotParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct TakeHeapSnapshotParamsBuilder {
            report_progress: Option<bool>,
            treat_global_objects_as_roots: Option<bool>,
        }
        impl TakeHeapSnapshotParamsBuilder {
            pub fn report_progress(mut self, report_progress: impl Into<bool>) -> Self {
                self.report_progress = Some(report_progress.into());
                self
            }
            pub fn treat_global_objects_as_roots(
                mut self,
                treat_global_objects_as_roots: impl Into<bool>,
            ) -> Self {
                self.treat_global_objects_as_roots = Some(treat_global_objects_as_roots.into());
                self
            }
            pub fn build(self) -> TakeHeapSnapshotParams {
                TakeHeapSnapshotParams {
                    report_progress: self.report_progress,
                    treat_global_objects_as_roots: self.treat_global_objects_as_roots,
                }
            }
        }
        impl TakeHeapSnapshotParams {
            pub const IDENTIFIER: &'static str = "HeapProfiler.takeHeapSnapshot";
        }
        impl chromiumoxide_types::Method for TakeHeapSnapshotParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for TakeHeapSnapshotParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TakeHeapSnapshotReturns {}
        impl chromiumoxide_types::Command for TakeHeapSnapshotParams {
            type Response = TakeHeapSnapshotReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventAddHeapSnapshotChunk {
            #[serde(rename = "chunk")]
            pub chunk: String,
        }
        impl EventAddHeapSnapshotChunk {
            pub const IDENTIFIER: &'static str = "HeapProfiler.addHeapSnapshotChunk";
        }
        impl chromiumoxide_types::Method for EventAddHeapSnapshotChunk {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventAddHeapSnapshotChunk {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "If heap objects tracking has been started then backend may send update for one or more fragments\n[heapStatsUpdate](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-heapStatsUpdate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventHeapStatsUpdate {
            #[doc = "An array of triplets. Each triplet describes a fragment. The first integer is the fragment\nindex, the second integer is a total count of objects for the fragment, the third integer is\na total size of the objects for the fragment."]
            #[serde(rename = "statsUpdate")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub stats_update: Vec<i64>,
        }
        impl EventHeapStatsUpdate {
            pub const IDENTIFIER: &'static str = "HeapProfiler.heapStatsUpdate";
        }
        impl chromiumoxide_types::Method for EventHeapStatsUpdate {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventHeapStatsUpdate {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "If heap objects tracking has been started then backend regularly sends a current value for last\nseen object id and corresponding timestamp. If the were changes in the heap since last event\nthen one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.\n[lastSeenObjectId](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-lastSeenObjectId)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventLastSeenObjectId {
            #[serde(rename = "lastSeenObjectId")]
            pub last_seen_object_id: i64,
            #[serde(rename = "timestamp")]
            pub timestamp: f64,
        }
        impl EventLastSeenObjectId {
            pub const IDENTIFIER: &'static str = "HeapProfiler.lastSeenObjectId";
        }
        impl chromiumoxide_types::Method for EventLastSeenObjectId {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventLastSeenObjectId {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventReportHeapSnapshotProgress {
            #[serde(rename = "done")]
            pub done: i64,
            #[serde(rename = "total")]
            pub total: i64,
            #[serde(rename = "finished")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub finished: Option<bool>,
        }
        impl EventReportHeapSnapshotProgress {
            pub const IDENTIFIER: &'static str = "HeapProfiler.reportHeapSnapshotProgress";
        }
        impl chromiumoxide_types::Method for EventReportHeapSnapshotProgress {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventReportHeapSnapshotProgress {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EventResetProfiles {}
        impl EventResetProfiles {
            pub const IDENTIFIER: &'static str = "HeapProfiler.resetProfiles";
        }
        impl chromiumoxide_types::Method for EventResetProfiles {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventResetProfiles {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    pub mod profiler {
        use serde::{Deserialize, Serialize};
        #[doc = "Profile node. Holds callsite information, execution statistics and child nodes.\n[ProfileNode](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-ProfileNode)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ProfileNode {
            #[doc = "Unique id of the node."]
            #[serde(rename = "id")]
            pub id: i64,
            #[doc = "Function location."]
            #[serde(rename = "callFrame")]
            pub call_frame: super::runtime::CallFrame,
            #[doc = "Number of samples where this node was on top of the call stack."]
            #[serde(rename = "hitCount")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub hit_count: Option<i64>,
            #[doc = "Child node ids."]
            #[serde(rename = "children")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub children: Option<Vec<i64>>,
            #[doc = "The reason of being not optimized. The function may be deoptimized or marked as don't\noptimize."]
            #[serde(rename = "deoptReason")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub deopt_reason: Option<String>,
            #[doc = "An array of source position ticks."]
            #[serde(rename = "positionTicks")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub position_ticks: Option<Vec<PositionTickInfo>>,
        }
        impl ProfileNode {
            pub fn new(
                id: impl Into<i64>,
                call_frame: impl Into<super::runtime::CallFrame>,
            ) -> Self {
                Self {
                    id: id.into(),
                    call_frame: call_frame.into(),
                    hit_count: None,
                    children: None,
                    deopt_reason: None,
                    position_ticks: None,
                }
            }
        }
        impl ProfileNode {
            pub fn builder() -> ProfileNodeBuilder {
                ProfileNodeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ProfileNodeBuilder {
            id: Option<i64>,
            call_frame: Option<super::runtime::CallFrame>,
            hit_count: Option<i64>,
            children: Option<Vec<i64>>,
            deopt_reason: Option<String>,
            position_ticks: Option<Vec<PositionTickInfo>>,
        }
        impl ProfileNodeBuilder {
            pub fn id(mut self, id: impl Into<i64>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn call_frame(mut self, call_frame: impl Into<super::runtime::CallFrame>) -> Self {
                self.call_frame = Some(call_frame.into());
                self
            }
            pub fn hit_count(mut self, hit_count: impl Into<i64>) -> Self {
                self.hit_count = Some(hit_count.into());
                self
            }
            pub fn children(mut self, children: impl Into<i64>) -> Self {
                let v = self.children.get_or_insert(Vec::new());
                v.push(children.into());
                self
            }
            pub fn childrens<I, S>(mut self, childrens: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<i64>,
            {
                let v = self.children.get_or_insert(Vec::new());
                for val in childrens {
                    v.push(val.into());
                }
                self
            }
            pub fn deopt_reason(mut self, deopt_reason: impl Into<String>) -> Self {
                self.deopt_reason = Some(deopt_reason.into());
                self
            }
            pub fn position_tick(mut self, position_tick: impl Into<PositionTickInfo>) -> Self {
                let v = self.position_ticks.get_or_insert(Vec::new());
                v.push(position_tick.into());
                self
            }
            pub fn position_ticks<I, S>(mut self, position_ticks: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<PositionTickInfo>,
            {
                let v = self.position_ticks.get_or_insert(Vec::new());
                for val in position_ticks {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ProfileNode, String> {
                Ok(ProfileNode {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                    call_frame: self.call_frame.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frame))
                    })?,
                    hit_count: self.hit_count,
                    children: self.children,
                    deopt_reason: self.deopt_reason,
                    position_ticks: self.position_ticks,
                })
            }
        }
        impl ProfileNode {
            pub const IDENTIFIER: &'static str = "Profiler.ProfileNode";
        }
        #[doc = "Profile.\n[Profile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-Profile)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct Profile {
            #[doc = "The list of profile nodes. First item is the root node."]
            #[serde(rename = "nodes")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub nodes: Vec<ProfileNode>,
            #[doc = "Profiling start timestamp in microseconds."]
            #[serde(rename = "startTime")]
            pub start_time: f64,
            #[doc = "Profiling end timestamp in microseconds."]
            #[serde(rename = "endTime")]
            pub end_time: f64,
            #[doc = "Ids of samples top nodes."]
            #[serde(rename = "samples")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub samples: Option<Vec<i64>>,
            #[doc = "Time intervals between adjacent samples in microseconds. The first delta is relative to the\nprofile startTime."]
            #[serde(rename = "timeDeltas")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub time_deltas: Option<Vec<i64>>,
        }
        impl Profile {
            pub fn new(
                nodes: Vec<ProfileNode>,
                start_time: impl Into<f64>,
                end_time: impl Into<f64>,
            ) -> Self {
                Self {
                    nodes,
                    start_time: start_time.into(),
                    end_time: end_time.into(),
                    samples: None,
                    time_deltas: None,
                }
            }
        }
        impl Profile {
            pub fn builder() -> ProfileBuilder {
                ProfileBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ProfileBuilder {
            nodes: Option<Vec<ProfileNode>>,
            start_time: Option<f64>,
            end_time: Option<f64>,
            samples: Option<Vec<i64>>,
            time_deltas: Option<Vec<i64>>,
        }
        impl ProfileBuilder {
            pub fn node(mut self, node: impl Into<ProfileNode>) -> Self {
                let v = self.nodes.get_or_insert(Vec::new());
                v.push(node.into());
                self
            }
            pub fn nodes<I, S>(mut self, nodes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ProfileNode>,
            {
                let v = self.nodes.get_or_insert(Vec::new());
                for val in nodes {
                    v.push(val.into());
                }
                self
            }
            pub fn start_time(mut self, start_time: impl Into<f64>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn end_time(mut self, end_time: impl Into<f64>) -> Self {
                self.end_time = Some(end_time.into());
                self
            }
            pub fn sample(mut self, sample: impl Into<i64>) -> Self {
                let v = self.samples.get_or_insert(Vec::new());
                v.push(sample.into());
                self
            }
            pub fn samples<I, S>(mut self, samples: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<i64>,
            {
                let v = self.samples.get_or_insert(Vec::new());
                for val in samples {
                    v.push(val.into());
                }
                self
            }
            pub fn time_delta(mut self, time_delta: impl Into<i64>) -> Self {
                let v = self.time_deltas.get_or_insert(Vec::new());
                v.push(time_delta.into());
                self
            }
            pub fn time_deltas<I, S>(mut self, time_deltas: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<i64>,
            {
                let v = self.time_deltas.get_or_insert(Vec::new());
                for val in time_deltas {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<Profile, String> {
                Ok(Profile {
                    nodes: self.nodes.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(nodes))
                    })?,
                    start_time: self.start_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(start_time))
                    })?,
                    end_time: self.end_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(end_time))
                    })?,
                    samples: self.samples,
                    time_deltas: self.time_deltas,
                })
            }
        }
        impl Profile {
            pub const IDENTIFIER: &'static str = "Profiler.Profile";
        }
        #[doc = "Specifies a number of samples attributed to a certain source position.\n[PositionTickInfo](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-PositionTickInfo)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct PositionTickInfo {
            #[doc = "Source line number (1-based)."]
            #[serde(rename = "line")]
            pub line: i64,
            #[doc = "Number of samples attributed to the source line."]
            #[serde(rename = "ticks")]
            pub ticks: i64,
        }
        impl PositionTickInfo {
            pub fn new(line: impl Into<i64>, ticks: impl Into<i64>) -> Self {
                Self {
                    line: line.into(),
                    ticks: ticks.into(),
                }
            }
        }
        impl PositionTickInfo {
            pub fn builder() -> PositionTickInfoBuilder {
                PositionTickInfoBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct PositionTickInfoBuilder {
            line: Option<i64>,
            ticks: Option<i64>,
        }
        impl PositionTickInfoBuilder {
            pub fn line(mut self, line: impl Into<i64>) -> Self {
                self.line = Some(line.into());
                self
            }
            pub fn ticks(mut self, ticks: impl Into<i64>) -> Self {
                self.ticks = Some(ticks.into());
                self
            }
            pub fn build(self) -> Result<PositionTickInfo, String> {
                Ok(PositionTickInfo {
                    line: self.line.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line))
                    })?,
                    ticks: self.ticks.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(ticks))
                    })?,
                })
            }
        }
        impl PositionTickInfo {
            pub const IDENTIFIER: &'static str = "Profiler.PositionTickInfo";
        }
        #[doc = "Coverage data for a source range.\n[CoverageRange](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-CoverageRange)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CoverageRange {
            #[doc = "JavaScript script source offset for the range start."]
            #[serde(rename = "startOffset")]
            pub start_offset: i64,
            #[doc = "JavaScript script source offset for the range end."]
            #[serde(rename = "endOffset")]
            pub end_offset: i64,
            #[doc = "Collected execution count of the source range."]
            #[serde(rename = "count")]
            pub count: i64,
        }
        impl CoverageRange {
            pub fn new(
                start_offset: impl Into<i64>,
                end_offset: impl Into<i64>,
                count: impl Into<i64>,
            ) -> Self {
                Self {
                    start_offset: start_offset.into(),
                    end_offset: end_offset.into(),
                    count: count.into(),
                }
            }
        }
        impl CoverageRange {
            pub fn builder() -> CoverageRangeBuilder {
                CoverageRangeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CoverageRangeBuilder {
            start_offset: Option<i64>,
            end_offset: Option<i64>,
            count: Option<i64>,
        }
        impl CoverageRangeBuilder {
            pub fn start_offset(mut self, start_offset: impl Into<i64>) -> Self {
                self.start_offset = Some(start_offset.into());
                self
            }
            pub fn end_offset(mut self, end_offset: impl Into<i64>) -> Self {
                self.end_offset = Some(end_offset.into());
                self
            }
            pub fn count(mut self, count: impl Into<i64>) -> Self {
                self.count = Some(count.into());
                self
            }
            pub fn build(self) -> Result<CoverageRange, String> {
                Ok(CoverageRange {
                    start_offset: self.start_offset.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(start_offset))
                    })?,
                    end_offset: self.end_offset.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(end_offset))
                    })?,
                    count: self.count.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(count))
                    })?,
                })
            }
        }
        impl CoverageRange {
            pub const IDENTIFIER: &'static str = "Profiler.CoverageRange";
        }
        #[doc = "Coverage data for a JavaScript function.\n[FunctionCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-FunctionCoverage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct FunctionCoverage {
            #[doc = "JavaScript function name."]
            #[serde(rename = "functionName")]
            pub function_name: String,
            #[doc = "Source ranges inside the function with coverage data."]
            #[serde(rename = "ranges")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub ranges: Vec<CoverageRange>,
            #[doc = "Whether coverage data for this function has block granularity."]
            #[serde(rename = "isBlockCoverage")]
            pub is_block_coverage: bool,
        }
        impl FunctionCoverage {
            pub fn new(
                function_name: impl Into<String>,
                ranges: Vec<CoverageRange>,
                is_block_coverage: impl Into<bool>,
            ) -> Self {
                Self {
                    function_name: function_name.into(),
                    ranges,
                    is_block_coverage: is_block_coverage.into(),
                }
            }
        }
        impl FunctionCoverage {
            pub fn builder() -> FunctionCoverageBuilder {
                FunctionCoverageBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct FunctionCoverageBuilder {
            function_name: Option<String>,
            ranges: Option<Vec<CoverageRange>>,
            is_block_coverage: Option<bool>,
        }
        impl FunctionCoverageBuilder {
            pub fn function_name(mut self, function_name: impl Into<String>) -> Self {
                self.function_name = Some(function_name.into());
                self
            }
            pub fn range(mut self, range: impl Into<CoverageRange>) -> Self {
                let v = self.ranges.get_or_insert(Vec::new());
                v.push(range.into());
                self
            }
            pub fn ranges<I, S>(mut self, ranges: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CoverageRange>,
            {
                let v = self.ranges.get_or_insert(Vec::new());
                for val in ranges {
                    v.push(val.into());
                }
                self
            }
            pub fn is_block_coverage(mut self, is_block_coverage: impl Into<bool>) -> Self {
                self.is_block_coverage = Some(is_block_coverage.into());
                self
            }
            pub fn build(self) -> Result<FunctionCoverage, String> {
                Ok(FunctionCoverage {
                    function_name: self.function_name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(function_name))
                    })?,
                    ranges: self.ranges.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(ranges))
                    })?,
                    is_block_coverage: self.is_block_coverage.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(is_block_coverage)
                        )
                    })?,
                })
            }
        }
        impl FunctionCoverage {
            pub const IDENTIFIER: &'static str = "Profiler.FunctionCoverage";
        }
        #[doc = "Coverage data for a JavaScript script.\n[ScriptCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-ScriptCoverage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ScriptCoverage {
            #[doc = "JavaScript script id."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "JavaScript script name or url."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Functions contained in the script that has coverage data."]
            #[serde(rename = "functions")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub functions: Vec<FunctionCoverage>,
        }
        impl ScriptCoverage {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                url: impl Into<String>,
                functions: Vec<FunctionCoverage>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    url: url.into(),
                    functions,
                }
            }
        }
        impl ScriptCoverage {
            pub fn builder() -> ScriptCoverageBuilder {
                ScriptCoverageBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ScriptCoverageBuilder {
            script_id: Option<super::runtime::ScriptId>,
            url: Option<String>,
            functions: Option<Vec<FunctionCoverage>>,
        }
        impl ScriptCoverageBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn function(mut self, function: impl Into<FunctionCoverage>) -> Self {
                let v = self.functions.get_or_insert(Vec::new());
                v.push(function.into());
                self
            }
            pub fn functions<I, S>(mut self, functions: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<FunctionCoverage>,
            {
                let v = self.functions.get_or_insert(Vec::new());
                for val in functions {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ScriptCoverage, String> {
                Ok(ScriptCoverage {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    functions: self.functions.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(functions))
                    })?,
                })
            }
        }
        impl ScriptCoverage {
            pub const IDENTIFIER: &'static str = "Profiler.ScriptCoverage";
        }
        #[doc = "Describes a type collected during runtime.\n[TypeObject](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-TypeObject)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct TypeObject {
            #[doc = "Name of a type collected with type profiling."]
            #[serde(rename = "name")]
            pub name: String,
        }
        impl TypeObject {
            pub fn new(name: impl Into<String>) -> Self {
                Self { name: name.into() }
            }
        }
        impl<T: Into<String>> From<T> for TypeObject {
            fn from(url: T) -> Self {
                TypeObject::new(url)
            }
        }
        impl TypeObject {
            pub fn builder() -> TypeObjectBuilder {
                TypeObjectBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct TypeObjectBuilder {
            name: Option<String>,
        }
        impl TypeObjectBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn build(self) -> Result<TypeObject, String> {
                Ok(TypeObject {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                })
            }
        }
        impl TypeObject {
            pub const IDENTIFIER: &'static str = "Profiler.TypeObject";
        }
        #[doc = "Source offset and types for a parameter or return value.\n[TypeProfileEntry](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-TypeProfileEntry)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct TypeProfileEntry {
            #[doc = "Source offset of the parameter or end of function for return values."]
            #[serde(rename = "offset")]
            pub offset: i64,
            #[doc = "The types for this parameter or return value."]
            #[serde(rename = "types")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub types: Vec<TypeObject>,
        }
        impl TypeProfileEntry {
            pub fn new(offset: impl Into<i64>, types: Vec<TypeObject>) -> Self {
                Self {
                    offset: offset.into(),
                    types,
                }
            }
        }
        impl TypeProfileEntry {
            pub fn builder() -> TypeProfileEntryBuilder {
                TypeProfileEntryBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct TypeProfileEntryBuilder {
            offset: Option<i64>,
            types: Option<Vec<TypeObject>>,
        }
        impl TypeProfileEntryBuilder {
            pub fn offset(mut self, offset: impl Into<i64>) -> Self {
                self.offset = Some(offset.into());
                self
            }
            pub fn r#type(mut self, r#type: impl Into<TypeObject>) -> Self {
                let v = self.types.get_or_insert(Vec::new());
                v.push(r#type.into());
                self
            }
            pub fn types<I, S>(mut self, types: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<TypeObject>,
            {
                let v = self.types.get_or_insert(Vec::new());
                for val in types {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<TypeProfileEntry, String> {
                Ok(TypeProfileEntry {
                    offset: self.offset.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(offset))
                    })?,
                    types: self.types.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(types))
                    })?,
                })
            }
        }
        impl TypeProfileEntry {
            pub const IDENTIFIER: &'static str = "Profiler.TypeProfileEntry";
        }
        #[doc = "Type profile data collected during runtime for a JavaScript script.\n[ScriptTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-ScriptTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ScriptTypeProfile {
            #[doc = "JavaScript script id."]
            #[serde(rename = "scriptId")]
            pub script_id: super::runtime::ScriptId,
            #[doc = "JavaScript script name or url."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Type profile entries for parameters and return values of the functions in the script."]
            #[serde(rename = "entries")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub entries: Vec<TypeProfileEntry>,
        }
        impl ScriptTypeProfile {
            pub fn new(
                script_id: impl Into<super::runtime::ScriptId>,
                url: impl Into<String>,
                entries: Vec<TypeProfileEntry>,
            ) -> Self {
                Self {
                    script_id: script_id.into(),
                    url: url.into(),
                    entries,
                }
            }
        }
        impl ScriptTypeProfile {
            pub fn builder() -> ScriptTypeProfileBuilder {
                ScriptTypeProfileBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ScriptTypeProfileBuilder {
            script_id: Option<super::runtime::ScriptId>,
            url: Option<String>,
            entries: Option<Vec<TypeProfileEntry>>,
        }
        impl ScriptTypeProfileBuilder {
            pub fn script_id(mut self, script_id: impl Into<super::runtime::ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn entrie(mut self, entrie: impl Into<TypeProfileEntry>) -> Self {
                let v = self.entries.get_or_insert(Vec::new());
                v.push(entrie.into());
                self
            }
            pub fn entries<I, S>(mut self, entries: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<TypeProfileEntry>,
            {
                let v = self.entries.get_or_insert(Vec::new());
                for val in entries {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ScriptTypeProfile, String> {
                Ok(ScriptTypeProfile {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    entries: self.entries.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(entries))
                    })?,
                })
            }
        }
        impl ScriptTypeProfile {
            pub const IDENTIFIER: &'static str = "Profiler.ScriptTypeProfile";
        }
        #[doc = "Collected counter information.\n[CounterInfo](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-CounterInfo)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CounterInfo {
            #[doc = "Counter name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "Counter value."]
            #[serde(rename = "value")]
            pub value: i64,
        }
        impl CounterInfo {
            pub fn new(name: impl Into<String>, value: impl Into<i64>) -> Self {
                Self {
                    name: name.into(),
                    value: value.into(),
                }
            }
        }
        impl CounterInfo {
            pub fn builder() -> CounterInfoBuilder {
                CounterInfoBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CounterInfoBuilder {
            name: Option<String>,
            value: Option<i64>,
        }
        impl CounterInfoBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<i64>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn build(self) -> Result<CounterInfo, String> {
                Ok(CounterInfo {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(value))
                    })?,
                })
            }
        }
        impl CounterInfo {
            pub const IDENTIFIER: &'static str = "Profiler.CounterInfo";
        }
        #[doc = "Runtime call counter information.\n[RuntimeCallCounterInfo](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#type-RuntimeCallCounterInfo)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RuntimeCallCounterInfo {
            #[doc = "Counter name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "Counter value."]
            #[serde(rename = "value")]
            pub value: f64,
            #[doc = "Counter time in seconds."]
            #[serde(rename = "time")]
            pub time: f64,
        }
        impl RuntimeCallCounterInfo {
            pub fn new(
                name: impl Into<String>,
                value: impl Into<f64>,
                time: impl Into<f64>,
            ) -> Self {
                Self {
                    name: name.into(),
                    value: value.into(),
                    time: time.into(),
                }
            }
        }
        impl RuntimeCallCounterInfo {
            pub fn builder() -> RuntimeCallCounterInfoBuilder {
                RuntimeCallCounterInfoBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RuntimeCallCounterInfoBuilder {
            name: Option<String>,
            value: Option<f64>,
            time: Option<f64>,
        }
        impl RuntimeCallCounterInfoBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<f64>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn time(mut self, time: impl Into<f64>) -> Self {
                self.time = Some(time.into());
                self
            }
            pub fn build(self) -> Result<RuntimeCallCounterInfo, String> {
                Ok(RuntimeCallCounterInfo {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(value))
                    })?,
                    time: self.time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(time))
                    })?,
                })
            }
        }
        impl RuntimeCallCounterInfo {
            pub const IDENTIFIER: &'static str = "Profiler.RuntimeCallCounterInfo";
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Profiler.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Profiler.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Collect coverage data for the current isolate. The coverage data may be incomplete due to\ngarbage collection.\n[getBestEffortCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getBestEffortCoverage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetBestEffortCoverageParams {}
        impl GetBestEffortCoverageParams {
            pub const IDENTIFIER: &'static str = "Profiler.getBestEffortCoverage";
        }
        impl chromiumoxide_types::Method for GetBestEffortCoverageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetBestEffortCoverageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Collect coverage data for the current isolate. The coverage data may be incomplete due to\ngarbage collection.\n[getBestEffortCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getBestEffortCoverage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetBestEffortCoverageReturns {
            #[doc = "Coverage data for the current isolate."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<ScriptCoverage>,
        }
        impl GetBestEffortCoverageReturns {
            pub fn new(result: Vec<ScriptCoverage>) -> Self {
                Self { result }
            }
        }
        impl GetBestEffortCoverageReturns {
            pub fn builder() -> GetBestEffortCoverageReturnsBuilder {
                GetBestEffortCoverageReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetBestEffortCoverageReturnsBuilder {
            result: Option<Vec<ScriptCoverage>>,
        }
        impl GetBestEffortCoverageReturnsBuilder {
            pub fn result(mut self, result: impl Into<ScriptCoverage>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ScriptCoverage>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetBestEffortCoverageReturns, String> {
                Ok(GetBestEffortCoverageReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetBestEffortCoverageParams {
            type Response = GetBestEffortCoverageReturns;
        }
        #[doc = "Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.\n[setSamplingInterval](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-setSamplingInterval)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetSamplingIntervalParams {
            #[doc = "New sampling interval in microseconds."]
            #[serde(rename = "interval")]
            pub interval: i64,
        }
        impl SetSamplingIntervalParams {
            pub fn new(interval: impl Into<i64>) -> Self {
                Self {
                    interval: interval.into(),
                }
            }
        }
        impl SetSamplingIntervalParams {
            pub fn builder() -> SetSamplingIntervalParamsBuilder {
                SetSamplingIntervalParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetSamplingIntervalParamsBuilder {
            interval: Option<i64>,
        }
        impl SetSamplingIntervalParamsBuilder {
            pub fn interval(mut self, interval: impl Into<i64>) -> Self {
                self.interval = Some(interval.into());
                self
            }
            pub fn build(self) -> Result<SetSamplingIntervalParams, String> {
                Ok(SetSamplingIntervalParams {
                    interval: self.interval.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(interval))
                    })?,
                })
            }
        }
        impl SetSamplingIntervalParams {
            pub const IDENTIFIER: &'static str = "Profiler.setSamplingInterval";
        }
        impl chromiumoxide_types::Method for SetSamplingIntervalParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetSamplingIntervalParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.\n[setSamplingInterval](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-setSamplingInterval)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetSamplingIntervalReturns {}
        impl chromiumoxide_types::Command for SetSamplingIntervalParams {
            type Response = SetSamplingIntervalReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartParams {}
        impl StartParams {
            pub const IDENTIFIER: &'static str = "Profiler.start";
        }
        impl chromiumoxide_types::Method for StartParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartReturns {}
        impl chromiumoxide_types::Command for StartParams {
            type Response = StartReturns;
        }
        #[doc = "Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code\ncoverage may be incomplete. Enabling prevents running optimized code and resets execution\ncounters.\n[startPreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-startPreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartPreciseCoverageParams {
            #[doc = "Collect accurate call counts beyond simple 'covered' or 'not covered'."]
            #[serde(rename = "callCount")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub call_count: Option<bool>,
            #[doc = "Collect block-based coverage."]
            #[serde(rename = "detailed")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub detailed: Option<bool>,
            #[doc = "Allow the backend to send updates on its own initiative"]
            #[serde(rename = "allowTriggeredUpdates")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub allow_triggered_updates: Option<bool>,
        }
        impl StartPreciseCoverageParams {
            pub fn builder() -> StartPreciseCoverageParamsBuilder {
                StartPreciseCoverageParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StartPreciseCoverageParamsBuilder {
            call_count: Option<bool>,
            detailed: Option<bool>,
            allow_triggered_updates: Option<bool>,
        }
        impl StartPreciseCoverageParamsBuilder {
            pub fn call_count(mut self, call_count: impl Into<bool>) -> Self {
                self.call_count = Some(call_count.into());
                self
            }
            pub fn detailed(mut self, detailed: impl Into<bool>) -> Self {
                self.detailed = Some(detailed.into());
                self
            }
            pub fn allow_triggered_updates(
                mut self,
                allow_triggered_updates: impl Into<bool>,
            ) -> Self {
                self.allow_triggered_updates = Some(allow_triggered_updates.into());
                self
            }
            pub fn build(self) -> StartPreciseCoverageParams {
                StartPreciseCoverageParams {
                    call_count: self.call_count,
                    detailed: self.detailed,
                    allow_triggered_updates: self.allow_triggered_updates,
                }
            }
        }
        impl StartPreciseCoverageParams {
            pub const IDENTIFIER: &'static str = "Profiler.startPreciseCoverage";
        }
        impl chromiumoxide_types::Method for StartPreciseCoverageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartPreciseCoverageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code\ncoverage may be incomplete. Enabling prevents running optimized code and resets execution\ncounters.\n[startPreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-startPreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StartPreciseCoverageReturns {
            #[doc = "Monotonically increasing time (in seconds) when the coverage update was taken in the backend."]
            #[serde(rename = "timestamp")]
            pub timestamp: f64,
        }
        impl StartPreciseCoverageReturns {
            pub fn new(timestamp: impl Into<f64>) -> Self {
                Self {
                    timestamp: timestamp.into(),
                }
            }
        }
        impl StartPreciseCoverageReturns {
            pub fn builder() -> StartPreciseCoverageReturnsBuilder {
                StartPreciseCoverageReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StartPreciseCoverageReturnsBuilder {
            timestamp: Option<f64>,
        }
        impl StartPreciseCoverageReturnsBuilder {
            pub fn timestamp(mut self, timestamp: impl Into<f64>) -> Self {
                self.timestamp = Some(timestamp.into());
                self
            }
            pub fn build(self) -> Result<StartPreciseCoverageReturns, String> {
                Ok(StartPreciseCoverageReturns {
                    timestamp: self.timestamp.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(timestamp))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for StartPreciseCoverageParams {
            type Response = StartPreciseCoverageReturns;
        }
        #[doc = "Enable type profile.\n[startTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-startTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartTypeProfileParams {}
        impl StartTypeProfileParams {
            pub const IDENTIFIER: &'static str = "Profiler.startTypeProfile";
        }
        impl chromiumoxide_types::Method for StartTypeProfileParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartTypeProfileParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enable type profile.\n[startTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-startTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartTypeProfileReturns {}
        impl chromiumoxide_types::Command for StartTypeProfileParams {
            type Response = StartTypeProfileReturns;
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopParams {}
        impl StopParams {
            pub const IDENTIFIER: &'static str = "Profiler.stop";
        }
        impl chromiumoxide_types::Method for StopParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StopReturns {
            #[doc = "Recorded profile."]
            #[serde(rename = "profile")]
            pub profile: Profile,
        }
        impl StopReturns {
            pub fn new(profile: impl Into<Profile>) -> Self {
                Self {
                    profile: profile.into(),
                }
            }
        }
        impl StopReturns {
            pub fn builder() -> StopReturnsBuilder {
                StopReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StopReturnsBuilder {
            profile: Option<Profile>,
        }
        impl StopReturnsBuilder {
            pub fn profile(mut self, profile: impl Into<Profile>) -> Self {
                self.profile = Some(profile.into());
                self
            }
            pub fn build(self) -> Result<StopReturns, String> {
                Ok(StopReturns {
                    profile: self.profile.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(profile))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for StopParams {
            type Response = StopReturns;
        }
        #[doc = "Disable precise code coverage. Disabling releases unnecessary execution count records and allows\nexecuting optimized code.\n[stopPreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-stopPreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopPreciseCoverageParams {}
        impl StopPreciseCoverageParams {
            pub const IDENTIFIER: &'static str = "Profiler.stopPreciseCoverage";
        }
        impl chromiumoxide_types::Method for StopPreciseCoverageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopPreciseCoverageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disable precise code coverage. Disabling releases unnecessary execution count records and allows\nexecuting optimized code.\n[stopPreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-stopPreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopPreciseCoverageReturns {}
        impl chromiumoxide_types::Command for StopPreciseCoverageParams {
            type Response = StopPreciseCoverageReturns;
        }
        #[doc = "Disable type profile. Disabling releases type profile data collected so far.\n[stopTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-stopTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopTypeProfileParams {}
        impl StopTypeProfileParams {
            pub const IDENTIFIER: &'static str = "Profiler.stopTypeProfile";
        }
        impl chromiumoxide_types::Method for StopTypeProfileParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopTypeProfileParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disable type profile. Disabling releases type profile data collected so far.\n[stopTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-stopTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopTypeProfileReturns {}
        impl chromiumoxide_types::Command for StopTypeProfileParams {
            type Response = StopTypeProfileReturns;
        }
        #[doc = "Collect coverage data for the current isolate, and resets execution counters. Precise code\ncoverage needs to have started.\n[takePreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-takePreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TakePreciseCoverageParams {}
        impl TakePreciseCoverageParams {
            pub const IDENTIFIER: &'static str = "Profiler.takePreciseCoverage";
        }
        impl chromiumoxide_types::Method for TakePreciseCoverageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for TakePreciseCoverageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Collect coverage data for the current isolate, and resets execution counters. Precise code\ncoverage needs to have started.\n[takePreciseCoverage](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-takePreciseCoverage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct TakePreciseCoverageReturns {
            #[doc = "Coverage data for the current isolate."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<ScriptCoverage>,
            #[doc = "Monotonically increasing time (in seconds) when the coverage update was taken in the backend."]
            #[serde(rename = "timestamp")]
            pub timestamp: f64,
        }
        impl TakePreciseCoverageReturns {
            pub fn new(result: Vec<ScriptCoverage>, timestamp: impl Into<f64>) -> Self {
                Self {
                    result,
                    timestamp: timestamp.into(),
                }
            }
        }
        impl TakePreciseCoverageReturns {
            pub fn builder() -> TakePreciseCoverageReturnsBuilder {
                TakePreciseCoverageReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct TakePreciseCoverageReturnsBuilder {
            result: Option<Vec<ScriptCoverage>>,
            timestamp: Option<f64>,
        }
        impl TakePreciseCoverageReturnsBuilder {
            pub fn result(mut self, result: impl Into<ScriptCoverage>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ScriptCoverage>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn timestamp(mut self, timestamp: impl Into<f64>) -> Self {
                self.timestamp = Some(timestamp.into());
                self
            }
            pub fn build(self) -> Result<TakePreciseCoverageReturns, String> {
                Ok(TakePreciseCoverageReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    timestamp: self.timestamp.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(timestamp))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for TakePreciseCoverageParams {
            type Response = TakePreciseCoverageReturns;
        }
        #[doc = "Collect type profile.\n[takeTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-takeTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TakeTypeProfileParams {}
        impl TakeTypeProfileParams {
            pub const IDENTIFIER: &'static str = "Profiler.takeTypeProfile";
        }
        impl chromiumoxide_types::Method for TakeTypeProfileParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for TakeTypeProfileParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Collect type profile.\n[takeTypeProfile](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-takeTypeProfile)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct TakeTypeProfileReturns {
            #[doc = "Type profile for all scripts since startTypeProfile() was turned on."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<ScriptTypeProfile>,
        }
        impl TakeTypeProfileReturns {
            pub fn new(result: Vec<ScriptTypeProfile>) -> Self {
                Self { result }
            }
        }
        impl TakeTypeProfileReturns {
            pub fn builder() -> TakeTypeProfileReturnsBuilder {
                TakeTypeProfileReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct TakeTypeProfileReturnsBuilder {
            result: Option<Vec<ScriptTypeProfile>>,
        }
        impl TakeTypeProfileReturnsBuilder {
            pub fn result(mut self, result: impl Into<ScriptTypeProfile>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ScriptTypeProfile>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<TakeTypeProfileReturns, String> {
                Ok(TakeTypeProfileReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for TakeTypeProfileParams {
            type Response = TakeTypeProfileReturns;
        }
        #[doc = "Enable counters collection.\n[enableCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-enableCounters)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableCountersParams {}
        impl EnableCountersParams {
            pub const IDENTIFIER: &'static str = "Profiler.enableCounters";
        }
        impl chromiumoxide_types::Method for EnableCountersParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableCountersParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enable counters collection.\n[enableCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-enableCounters)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableCountersReturns {}
        impl chromiumoxide_types::Command for EnableCountersParams {
            type Response = EnableCountersReturns;
        }
        #[doc = "Disable counters collection.\n[disableCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-disableCounters)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableCountersParams {}
        impl DisableCountersParams {
            pub const IDENTIFIER: &'static str = "Profiler.disableCounters";
        }
        impl chromiumoxide_types::Method for DisableCountersParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableCountersParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disable counters collection.\n[disableCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-disableCounters)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableCountersReturns {}
        impl chromiumoxide_types::Command for DisableCountersParams {
            type Response = DisableCountersReturns;
        }
        #[doc = "Retrieve counters.\n[getCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getCounters)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetCountersParams {}
        impl GetCountersParams {
            pub const IDENTIFIER: &'static str = "Profiler.getCounters";
        }
        impl chromiumoxide_types::Method for GetCountersParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetCountersParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Retrieve counters.\n[getCounters](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getCounters)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetCountersReturns {
            #[doc = "Collected counters information."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<CounterInfo>,
        }
        impl GetCountersReturns {
            pub fn new(result: Vec<CounterInfo>) -> Self {
                Self { result }
            }
        }
        impl GetCountersReturns {
            pub fn builder() -> GetCountersReturnsBuilder {
                GetCountersReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetCountersReturnsBuilder {
            result: Option<Vec<CounterInfo>>,
        }
        impl GetCountersReturnsBuilder {
            pub fn result(mut self, result: impl Into<CounterInfo>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CounterInfo>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetCountersReturns, String> {
                Ok(GetCountersReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetCountersParams {
            type Response = GetCountersReturns;
        }
        #[doc = "Enable run time call stats collection.\n[enableRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-enableRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableRuntimeCallStatsParams {}
        impl EnableRuntimeCallStatsParams {
            pub const IDENTIFIER: &'static str = "Profiler.enableRuntimeCallStats";
        }
        impl chromiumoxide_types::Method for EnableRuntimeCallStatsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableRuntimeCallStatsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enable run time call stats collection.\n[enableRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-enableRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableRuntimeCallStatsReturns {}
        impl chromiumoxide_types::Command for EnableRuntimeCallStatsParams {
            type Response = EnableRuntimeCallStatsReturns;
        }
        #[doc = "Disable run time call stats collection.\n[disableRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-disableRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableRuntimeCallStatsParams {}
        impl DisableRuntimeCallStatsParams {
            pub const IDENTIFIER: &'static str = "Profiler.disableRuntimeCallStats";
        }
        impl chromiumoxide_types::Method for DisableRuntimeCallStatsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableRuntimeCallStatsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disable run time call stats collection.\n[disableRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-disableRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableRuntimeCallStatsReturns {}
        impl chromiumoxide_types::Command for DisableRuntimeCallStatsParams {
            type Response = DisableRuntimeCallStatsReturns;
        }
        #[doc = "Retrieve run time call stats.\n[getRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetRuntimeCallStatsParams {}
        impl GetRuntimeCallStatsParams {
            pub const IDENTIFIER: &'static str = "Profiler.getRuntimeCallStats";
        }
        impl chromiumoxide_types::Method for GetRuntimeCallStatsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetRuntimeCallStatsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Retrieve run time call stats.\n[getRuntimeCallStats](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#method-getRuntimeCallStats)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetRuntimeCallStatsReturns {
            #[doc = "Collected runtime call counter information."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<RuntimeCallCounterInfo>,
        }
        impl GetRuntimeCallStatsReturns {
            pub fn new(result: Vec<RuntimeCallCounterInfo>) -> Self {
                Self { result }
            }
        }
        impl GetRuntimeCallStatsReturns {
            pub fn builder() -> GetRuntimeCallStatsReturnsBuilder {
                GetRuntimeCallStatsReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetRuntimeCallStatsReturnsBuilder {
            result: Option<Vec<RuntimeCallCounterInfo>>,
        }
        impl GetRuntimeCallStatsReturnsBuilder {
            pub fn result(mut self, result: impl Into<RuntimeCallCounterInfo>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<RuntimeCallCounterInfo>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetRuntimeCallStatsReturns, String> {
                Ok(GetRuntimeCallStatsReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetRuntimeCallStatsParams {
            type Response = GetRuntimeCallStatsReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventConsoleProfileFinished {
            #[serde(rename = "id")]
            pub id: String,
            #[doc = "Location of console.profileEnd()."]
            #[serde(rename = "location")]
            pub location: super::debugger::Location,
            #[serde(rename = "profile")]
            pub profile: Profile,
            #[doc = "Profile title passed as an argument to console.profile()."]
            #[serde(rename = "title")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub title: Option<String>,
        }
        impl EventConsoleProfileFinished {
            pub const IDENTIFIER: &'static str = "Profiler.consoleProfileFinished";
        }
        impl chromiumoxide_types::Method for EventConsoleProfileFinished {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventConsoleProfileFinished {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sent when new profile recording is started using console.profile() call.\n[consoleProfileStarted](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#event-consoleProfileStarted)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventConsoleProfileStarted {
            #[serde(rename = "id")]
            pub id: String,
            #[doc = "Location of console.profile()."]
            #[serde(rename = "location")]
            pub location: super::debugger::Location,
            #[doc = "Profile title passed as an argument to console.profile()."]
            #[serde(rename = "title")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub title: Option<String>,
        }
        impl EventConsoleProfileStarted {
            pub const IDENTIFIER: &'static str = "Profiler.consoleProfileStarted";
        }
        impl chromiumoxide_types::Method for EventConsoleProfileStarted {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventConsoleProfileStarted {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Reports coverage delta since the last poll (either from an event like this, or from\n`takePreciseCoverage` for the current isolate. May only be sent if precise code\ncoverage has been started. This event can be trigged by the embedder to, for example,\ntrigger collection of coverage data immediatelly at a certain point in time.\n[preciseCoverageDeltaUpdate](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#event-preciseCoverageDeltaUpdate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventPreciseCoverageDeltaUpdate {
            #[doc = "Monotonically increasing time (in seconds) when the coverage update was taken in the backend."]
            #[serde(rename = "timestamp")]
            pub timestamp: f64,
            #[doc = "Identifier for distinguishing coverage events."]
            #[serde(rename = "occassion")]
            pub occassion: String,
            #[doc = "Coverage data for the current isolate."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<ScriptCoverage>,
        }
        impl EventPreciseCoverageDeltaUpdate {
            pub const IDENTIFIER: &'static str = "Profiler.preciseCoverageDeltaUpdate";
        }
        impl chromiumoxide_types::Method for EventPreciseCoverageDeltaUpdate {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventPreciseCoverageDeltaUpdate {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    #[doc = "Runtime domain exposes JavaScript runtime by means of remote evaluation and mirror objects.\nEvaluation results are returned as mirror object that expose object type, string representation\nand unique identifier that can be used for further object reference. Original objects are\nmaintained in memory unless they are either explicitly released or are released along with the\nother objects in their object group."]
    pub mod runtime {
        use serde::{Deserialize, Serialize};
        #[doc = "Unique script identifier.\n[ScriptId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-ScriptId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct ScriptId(String);
        impl ScriptId {
            pub fn new(val: impl Into<String>) -> Self {
                ScriptId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for ScriptId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<ScriptId> for String {
            fn from(el: ScriptId) -> String {
                el.0
            }
        }
        impl From<String> for ScriptId {
            fn from(expr: String) -> Self {
                ScriptId(expr)
            }
        }
        impl std::borrow::Borrow<str> for ScriptId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl ScriptId {
            pub const IDENTIFIER: &'static str = "Runtime.ScriptId";
        }
        #[doc = "Unique object identifier.\n[RemoteObjectId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-RemoteObjectId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct RemoteObjectId(String);
        impl RemoteObjectId {
            pub fn new(val: impl Into<String>) -> Self {
                RemoteObjectId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for RemoteObjectId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<RemoteObjectId> for String {
            fn from(el: RemoteObjectId) -> String {
                el.0
            }
        }
        impl From<String> for RemoteObjectId {
            fn from(expr: String) -> Self {
                RemoteObjectId(expr)
            }
        }
        impl std::borrow::Borrow<str> for RemoteObjectId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl RemoteObjectId {
            pub const IDENTIFIER: &'static str = "Runtime.RemoteObjectId";
        }
        #[doc = "Primitive value which cannot be JSON-stringified. Includes values `-0`, `NaN`, `Infinity`,\n`-Infinity`, and bigint literals.\n[UnserializableValue](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-UnserializableValue)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct UnserializableValue(String);
        impl UnserializableValue {
            pub fn new(val: impl Into<String>) -> Self {
                UnserializableValue(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for UnserializableValue {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<UnserializableValue> for String {
            fn from(el: UnserializableValue) -> String {
                el.0
            }
        }
        impl From<String> for UnserializableValue {
            fn from(expr: String) -> Self {
                UnserializableValue(expr)
            }
        }
        impl UnserializableValue {
            pub const IDENTIFIER: &'static str = "Runtime.UnserializableValue";
        }
        #[doc = "Mirror object referencing original JavaScript object.\n[RemoteObject](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-RemoteObject)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RemoteObject {
            #[doc = "Object type."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: RemoteObjectType,
            #[doc = "Object subtype hint. Specified for `object` or `wasm` type values only."]
            #[serde(rename = "subtype")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub subtype: Option<RemoteObjectSubtype>,
            #[doc = "Object class (constructor) name. Specified for `object` type values only."]
            #[serde(rename = "className")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub class_name: Option<String>,
            #[doc = "Remote object value in case of primitive values or JSON values (if it was requested)."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<serde_json::Value>,
            #[doc = "Primitive value which can not be JSON-stringified does not have `value`, but gets this\nproperty."]
            #[serde(rename = "unserializableValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub unserializable_value: Option<UnserializableValue>,
            #[doc = "String representation of the object."]
            #[serde(rename = "description")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub description: Option<String>,
            #[doc = "Unique object identifier (for non-primitive values)."]
            #[serde(rename = "objectId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_id: Option<RemoteObjectId>,
            #[doc = "Preview containing abbreviated property values. Specified for `object` type values only."]
            #[serde(rename = "preview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub preview: Option<ObjectPreview>,
            #[serde(rename = "customPreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub custom_preview: Option<CustomPreview>,
        }
        #[doc = "Object type."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum RemoteObjectType {
            #[serde(rename = "object")]
            Object,
            #[serde(rename = "function")]
            Function,
            #[serde(rename = "undefined")]
            Undefined,
            #[serde(rename = "string")]
            String,
            #[serde(rename = "number")]
            Number,
            #[serde(rename = "boolean")]
            Boolean,
            #[serde(rename = "symbol")]
            Symbol,
            #[serde(rename = "bigint")]
            Bigint,
            #[serde(rename = "wasm")]
            Wasm,
        }
        impl AsRef<str> for RemoteObjectType {
            fn as_ref(&self) -> &str {
                match self {
                    RemoteObjectType::Object => "object",
                    RemoteObjectType::Function => "function",
                    RemoteObjectType::Undefined => "undefined",
                    RemoteObjectType::String => "string",
                    RemoteObjectType::Number => "number",
                    RemoteObjectType::Boolean => "boolean",
                    RemoteObjectType::Symbol => "symbol",
                    RemoteObjectType::Bigint => "bigint",
                    RemoteObjectType::Wasm => "wasm",
                }
            }
        }
        impl ::std::str::FromStr for RemoteObjectType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "object" | "Object" => Ok(RemoteObjectType::Object),
                    "function" | "Function" => Ok(RemoteObjectType::Function),
                    "undefined" | "Undefined" => Ok(RemoteObjectType::Undefined),
                    "string" | "String" => Ok(RemoteObjectType::String),
                    "number" | "Number" => Ok(RemoteObjectType::Number),
                    "boolean" | "Boolean" => Ok(RemoteObjectType::Boolean),
                    "symbol" | "Symbol" => Ok(RemoteObjectType::Symbol),
                    "bigint" | "Bigint" => Ok(RemoteObjectType::Bigint),
                    "wasm" | "Wasm" => Ok(RemoteObjectType::Wasm),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Object subtype hint. Specified for `object` or `wasm` type values only."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum RemoteObjectSubtype {
            #[serde(rename = "array")]
            Array,
            #[serde(rename = "null")]
            Null,
            #[serde(rename = "node")]
            Node,
            #[serde(rename = "regexp")]
            Regexp,
            #[serde(rename = "date")]
            Date,
            #[serde(rename = "map")]
            Map,
            #[serde(rename = "set")]
            Set,
            #[serde(rename = "weakmap")]
            Weakmap,
            #[serde(rename = "weakset")]
            Weakset,
            #[serde(rename = "iterator")]
            Iterator,
            #[serde(rename = "generator")]
            Generator,
            #[serde(rename = "error")]
            Error,
            #[serde(rename = "proxy")]
            Proxy,
            #[serde(rename = "promise")]
            Promise,
            #[serde(rename = "typedarray")]
            Typedarray,
            #[serde(rename = "arraybuffer")]
            Arraybuffer,
            #[serde(rename = "dataview")]
            Dataview,
            #[serde(rename = "i32")]
            I32,
            #[serde(rename = "i64")]
            I64,
            #[serde(rename = "f32")]
            F32,
            #[serde(rename = "f64")]
            F64,
            #[serde(rename = "v128")]
            V128,
            #[serde(rename = "externref")]
            Externref,
        }
        impl AsRef<str> for RemoteObjectSubtype {
            fn as_ref(&self) -> &str {
                match self {
                    RemoteObjectSubtype::Array => "array",
                    RemoteObjectSubtype::Null => "null",
                    RemoteObjectSubtype::Node => "node",
                    RemoteObjectSubtype::Regexp => "regexp",
                    RemoteObjectSubtype::Date => "date",
                    RemoteObjectSubtype::Map => "map",
                    RemoteObjectSubtype::Set => "set",
                    RemoteObjectSubtype::Weakmap => "weakmap",
                    RemoteObjectSubtype::Weakset => "weakset",
                    RemoteObjectSubtype::Iterator => "iterator",
                    RemoteObjectSubtype::Generator => "generator",
                    RemoteObjectSubtype::Error => "error",
                    RemoteObjectSubtype::Proxy => "proxy",
                    RemoteObjectSubtype::Promise => "promise",
                    RemoteObjectSubtype::Typedarray => "typedarray",
                    RemoteObjectSubtype::Arraybuffer => "arraybuffer",
                    RemoteObjectSubtype::Dataview => "dataview",
                    RemoteObjectSubtype::I32 => "i32",
                    RemoteObjectSubtype::I64 => "i64",
                    RemoteObjectSubtype::F32 => "f32",
                    RemoteObjectSubtype::F64 => "f64",
                    RemoteObjectSubtype::V128 => "v128",
                    RemoteObjectSubtype::Externref => "externref",
                }
            }
        }
        impl ::std::str::FromStr for RemoteObjectSubtype {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "array" | "Array" => Ok(RemoteObjectSubtype::Array),
                    "null" | "Null" => Ok(RemoteObjectSubtype::Null),
                    "node" | "Node" => Ok(RemoteObjectSubtype::Node),
                    "regexp" | "Regexp" => Ok(RemoteObjectSubtype::Regexp),
                    "date" | "Date" => Ok(RemoteObjectSubtype::Date),
                    "map" | "Map" => Ok(RemoteObjectSubtype::Map),
                    "set" | "Set" => Ok(RemoteObjectSubtype::Set),
                    "weakmap" | "Weakmap" => Ok(RemoteObjectSubtype::Weakmap),
                    "weakset" | "Weakset" => Ok(RemoteObjectSubtype::Weakset),
                    "iterator" | "Iterator" => Ok(RemoteObjectSubtype::Iterator),
                    "generator" | "Generator" => Ok(RemoteObjectSubtype::Generator),
                    "error" | "Error" => Ok(RemoteObjectSubtype::Error),
                    "proxy" | "Proxy" => Ok(RemoteObjectSubtype::Proxy),
                    "promise" | "Promise" => Ok(RemoteObjectSubtype::Promise),
                    "typedarray" | "Typedarray" => Ok(RemoteObjectSubtype::Typedarray),
                    "arraybuffer" | "Arraybuffer" => Ok(RemoteObjectSubtype::Arraybuffer),
                    "dataview" | "Dataview" => Ok(RemoteObjectSubtype::Dataview),
                    "i32" | "I32" => Ok(RemoteObjectSubtype::I32),
                    "i64" | "I64" => Ok(RemoteObjectSubtype::I64),
                    "f32" | "F32" => Ok(RemoteObjectSubtype::F32),
                    "f64" | "F64" => Ok(RemoteObjectSubtype::F64),
                    "v128" | "V128" => Ok(RemoteObjectSubtype::V128),
                    "externref" | "Externref" => Ok(RemoteObjectSubtype::Externref),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl RemoteObject {
            pub fn new(r#type: impl Into<RemoteObjectType>) -> Self {
                Self {
                    r#type: r#type.into(),
                    subtype: None,
                    class_name: None,
                    value: None,
                    unserializable_value: None,
                    description: None,
                    object_id: None,
                    preview: None,
                    custom_preview: None,
                }
            }
        }
        impl RemoteObject {
            pub fn builder() -> RemoteObjectBuilder {
                RemoteObjectBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RemoteObjectBuilder {
            r#type: Option<RemoteObjectType>,
            subtype: Option<RemoteObjectSubtype>,
            class_name: Option<String>,
            value: Option<serde_json::Value>,
            unserializable_value: Option<UnserializableValue>,
            description: Option<String>,
            object_id: Option<RemoteObjectId>,
            preview: Option<ObjectPreview>,
            custom_preview: Option<CustomPreview>,
        }
        impl RemoteObjectBuilder {
            pub fn r#type(mut self, r#type: impl Into<RemoteObjectType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn subtype(mut self, subtype: impl Into<RemoteObjectSubtype>) -> Self {
                self.subtype = Some(subtype.into());
                self
            }
            pub fn class_name(mut self, class_name: impl Into<String>) -> Self {
                self.class_name = Some(class_name.into());
                self
            }
            pub fn value(mut self, value: impl Into<serde_json::Value>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn unserializable_value(
                mut self,
                unserializable_value: impl Into<UnserializableValue>,
            ) -> Self {
                self.unserializable_value = Some(unserializable_value.into());
                self
            }
            pub fn description(mut self, description: impl Into<String>) -> Self {
                self.description = Some(description.into());
                self
            }
            pub fn object_id(mut self, object_id: impl Into<RemoteObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn preview(mut self, preview: impl Into<ObjectPreview>) -> Self {
                self.preview = Some(preview.into());
                self
            }
            pub fn custom_preview(mut self, custom_preview: impl Into<CustomPreview>) -> Self {
                self.custom_preview = Some(custom_preview.into());
                self
            }
            pub fn build(self) -> Result<RemoteObject, String> {
                Ok(RemoteObject {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    subtype: self.subtype,
                    class_name: self.class_name,
                    value: self.value,
                    unserializable_value: self.unserializable_value,
                    description: self.description,
                    object_id: self.object_id,
                    preview: self.preview,
                    custom_preview: self.custom_preview,
                })
            }
        }
        impl RemoteObject {
            pub const IDENTIFIER: &'static str = "Runtime.RemoteObject";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CustomPreview {
            #[doc = "The JSON-stringified result of formatter.header(object, config) call.\nIt contains json ML array that represents RemoteObject."]
            #[serde(rename = "header")]
            pub header: String,
            #[doc = "If formatter returns true as a result of formatter.hasBody call then bodyGetterId will\ncontain RemoteObjectId for the function that returns result of formatter.body(object, config) call.\nThe result value is json ML array."]
            #[serde(rename = "bodyGetterId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub body_getter_id: Option<RemoteObjectId>,
        }
        impl CustomPreview {
            pub fn new(header: impl Into<String>) -> Self {
                Self {
                    header: header.into(),
                    body_getter_id: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for CustomPreview {
            fn from(url: T) -> Self {
                CustomPreview::new(url)
            }
        }
        impl CustomPreview {
            pub fn builder() -> CustomPreviewBuilder {
                CustomPreviewBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CustomPreviewBuilder {
            header: Option<String>,
            body_getter_id: Option<RemoteObjectId>,
        }
        impl CustomPreviewBuilder {
            pub fn header(mut self, header: impl Into<String>) -> Self {
                self.header = Some(header.into());
                self
            }
            pub fn body_getter_id(mut self, body_getter_id: impl Into<RemoteObjectId>) -> Self {
                self.body_getter_id = Some(body_getter_id.into());
                self
            }
            pub fn build(self) -> Result<CustomPreview, String> {
                Ok(CustomPreview {
                    header: self.header.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(header))
                    })?,
                    body_getter_id: self.body_getter_id,
                })
            }
        }
        impl CustomPreview {
            pub const IDENTIFIER: &'static str = "Runtime.CustomPreview";
        }
        #[doc = "Object containing abbreviated remote object value.\n[ObjectPreview](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-ObjectPreview)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ObjectPreview {
            #[doc = "Object type."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: ObjectPreviewType,
            #[doc = "Object subtype hint. Specified for `object` type values only."]
            #[serde(rename = "subtype")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub subtype: Option<ObjectPreviewSubtype>,
            #[doc = "String representation of the object."]
            #[serde(rename = "description")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub description: Option<String>,
            #[doc = "True iff some of the properties or entries of the original object did not fit."]
            #[serde(rename = "overflow")]
            pub overflow: bool,
            #[doc = "List of the properties."]
            #[serde(rename = "properties")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub properties: Vec<PropertyPreview>,
            #[doc = "List of the entries. Specified for `map` and `set` subtype values only."]
            #[serde(rename = "entries")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub entries: Option<Vec<EntryPreview>>,
        }
        #[doc = "Object type."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ObjectPreviewType {
            #[serde(rename = "object")]
            Object,
            #[serde(rename = "function")]
            Function,
            #[serde(rename = "undefined")]
            Undefined,
            #[serde(rename = "string")]
            String,
            #[serde(rename = "number")]
            Number,
            #[serde(rename = "boolean")]
            Boolean,
            #[serde(rename = "symbol")]
            Symbol,
            #[serde(rename = "bigint")]
            Bigint,
        }
        impl AsRef<str> for ObjectPreviewType {
            fn as_ref(&self) -> &str {
                match self {
                    ObjectPreviewType::Object => "object",
                    ObjectPreviewType::Function => "function",
                    ObjectPreviewType::Undefined => "undefined",
                    ObjectPreviewType::String => "string",
                    ObjectPreviewType::Number => "number",
                    ObjectPreviewType::Boolean => "boolean",
                    ObjectPreviewType::Symbol => "symbol",
                    ObjectPreviewType::Bigint => "bigint",
                }
            }
        }
        impl ::std::str::FromStr for ObjectPreviewType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "object" | "Object" => Ok(ObjectPreviewType::Object),
                    "function" | "Function" => Ok(ObjectPreviewType::Function),
                    "undefined" | "Undefined" => Ok(ObjectPreviewType::Undefined),
                    "string" | "String" => Ok(ObjectPreviewType::String),
                    "number" | "Number" => Ok(ObjectPreviewType::Number),
                    "boolean" | "Boolean" => Ok(ObjectPreviewType::Boolean),
                    "symbol" | "Symbol" => Ok(ObjectPreviewType::Symbol),
                    "bigint" | "Bigint" => Ok(ObjectPreviewType::Bigint),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Object subtype hint. Specified for `object` type values only."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ObjectPreviewSubtype {
            #[serde(rename = "array")]
            Array,
            #[serde(rename = "null")]
            Null,
            #[serde(rename = "node")]
            Node,
            #[serde(rename = "regexp")]
            Regexp,
            #[serde(rename = "date")]
            Date,
            #[serde(rename = "map")]
            Map,
            #[serde(rename = "set")]
            Set,
            #[serde(rename = "weakmap")]
            Weakmap,
            #[serde(rename = "weakset")]
            Weakset,
            #[serde(rename = "iterator")]
            Iterator,
            #[serde(rename = "generator")]
            Generator,
            #[serde(rename = "error")]
            Error,
        }
        impl AsRef<str> for ObjectPreviewSubtype {
            fn as_ref(&self) -> &str {
                match self {
                    ObjectPreviewSubtype::Array => "array",
                    ObjectPreviewSubtype::Null => "null",
                    ObjectPreviewSubtype::Node => "node",
                    ObjectPreviewSubtype::Regexp => "regexp",
                    ObjectPreviewSubtype::Date => "date",
                    ObjectPreviewSubtype::Map => "map",
                    ObjectPreviewSubtype::Set => "set",
                    ObjectPreviewSubtype::Weakmap => "weakmap",
                    ObjectPreviewSubtype::Weakset => "weakset",
                    ObjectPreviewSubtype::Iterator => "iterator",
                    ObjectPreviewSubtype::Generator => "generator",
                    ObjectPreviewSubtype::Error => "error",
                }
            }
        }
        impl ::std::str::FromStr for ObjectPreviewSubtype {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "array" | "Array" => Ok(ObjectPreviewSubtype::Array),
                    "null" | "Null" => Ok(ObjectPreviewSubtype::Null),
                    "node" | "Node" => Ok(ObjectPreviewSubtype::Node),
                    "regexp" | "Regexp" => Ok(ObjectPreviewSubtype::Regexp),
                    "date" | "Date" => Ok(ObjectPreviewSubtype::Date),
                    "map" | "Map" => Ok(ObjectPreviewSubtype::Map),
                    "set" | "Set" => Ok(ObjectPreviewSubtype::Set),
                    "weakmap" | "Weakmap" => Ok(ObjectPreviewSubtype::Weakmap),
                    "weakset" | "Weakset" => Ok(ObjectPreviewSubtype::Weakset),
                    "iterator" | "Iterator" => Ok(ObjectPreviewSubtype::Iterator),
                    "generator" | "Generator" => Ok(ObjectPreviewSubtype::Generator),
                    "error" | "Error" => Ok(ObjectPreviewSubtype::Error),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl ObjectPreview {
            pub fn new(
                r#type: impl Into<ObjectPreviewType>,
                overflow: impl Into<bool>,
                properties: Vec<PropertyPreview>,
            ) -> Self {
                Self {
                    r#type: r#type.into(),
                    overflow: overflow.into(),
                    properties,
                    subtype: None,
                    description: None,
                    entries: None,
                }
            }
        }
        impl ObjectPreview {
            pub fn builder() -> ObjectPreviewBuilder {
                ObjectPreviewBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ObjectPreviewBuilder {
            r#type: Option<ObjectPreviewType>,
            subtype: Option<ObjectPreviewSubtype>,
            description: Option<String>,
            overflow: Option<bool>,
            properties: Option<Vec<PropertyPreview>>,
            entries: Option<Vec<EntryPreview>>,
        }
        impl ObjectPreviewBuilder {
            pub fn r#type(mut self, r#type: impl Into<ObjectPreviewType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn subtype(mut self, subtype: impl Into<ObjectPreviewSubtype>) -> Self {
                self.subtype = Some(subtype.into());
                self
            }
            pub fn description(mut self, description: impl Into<String>) -> Self {
                self.description = Some(description.into());
                self
            }
            pub fn overflow(mut self, overflow: impl Into<bool>) -> Self {
                self.overflow = Some(overflow.into());
                self
            }
            pub fn propertie(mut self, propertie: impl Into<PropertyPreview>) -> Self {
                let v = self.properties.get_or_insert(Vec::new());
                v.push(propertie.into());
                self
            }
            pub fn properties<I, S>(mut self, properties: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<PropertyPreview>,
            {
                let v = self.properties.get_or_insert(Vec::new());
                for val in properties {
                    v.push(val.into());
                }
                self
            }
            pub fn entrie(mut self, entrie: impl Into<EntryPreview>) -> Self {
                let v = self.entries.get_or_insert(Vec::new());
                v.push(entrie.into());
                self
            }
            pub fn entries<I, S>(mut self, entries: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<EntryPreview>,
            {
                let v = self.entries.get_or_insert(Vec::new());
                for val in entries {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ObjectPreview, String> {
                Ok(ObjectPreview {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    subtype: self.subtype,
                    description: self.description,
                    overflow: self.overflow.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(overflow))
                    })?,
                    properties: self.properties.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(properties))
                    })?,
                    entries: self.entries,
                })
            }
        }
        impl ObjectPreview {
            pub const IDENTIFIER: &'static str = "Runtime.ObjectPreview";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct PropertyPreview {
            #[doc = "Property name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "Object type. Accessor means that the property itself is an accessor property."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: PropertyPreviewType,
            #[doc = "User-friendly property value string."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<String>,
            #[doc = "Nested value preview."]
            #[serde(rename = "valuePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value_preview: Option<ObjectPreview>,
            #[doc = "Object subtype hint. Specified for `object` type values only."]
            #[serde(rename = "subtype")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub subtype: Option<PropertyPreviewSubtype>,
        }
        #[doc = "Object type. Accessor means that the property itself is an accessor property."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum PropertyPreviewType {
            #[serde(rename = "object")]
            Object,
            #[serde(rename = "function")]
            Function,
            #[serde(rename = "undefined")]
            Undefined,
            #[serde(rename = "string")]
            String,
            #[serde(rename = "number")]
            Number,
            #[serde(rename = "boolean")]
            Boolean,
            #[serde(rename = "symbol")]
            Symbol,
            #[serde(rename = "accessor")]
            Accessor,
            #[serde(rename = "bigint")]
            Bigint,
        }
        impl AsRef<str> for PropertyPreviewType {
            fn as_ref(&self) -> &str {
                match self {
                    PropertyPreviewType::Object => "object",
                    PropertyPreviewType::Function => "function",
                    PropertyPreviewType::Undefined => "undefined",
                    PropertyPreviewType::String => "string",
                    PropertyPreviewType::Number => "number",
                    PropertyPreviewType::Boolean => "boolean",
                    PropertyPreviewType::Symbol => "symbol",
                    PropertyPreviewType::Accessor => "accessor",
                    PropertyPreviewType::Bigint => "bigint",
                }
            }
        }
        impl ::std::str::FromStr for PropertyPreviewType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "object" | "Object" => Ok(PropertyPreviewType::Object),
                    "function" | "Function" => Ok(PropertyPreviewType::Function),
                    "undefined" | "Undefined" => Ok(PropertyPreviewType::Undefined),
                    "string" | "String" => Ok(PropertyPreviewType::String),
                    "number" | "Number" => Ok(PropertyPreviewType::Number),
                    "boolean" | "Boolean" => Ok(PropertyPreviewType::Boolean),
                    "symbol" | "Symbol" => Ok(PropertyPreviewType::Symbol),
                    "accessor" | "Accessor" => Ok(PropertyPreviewType::Accessor),
                    "bigint" | "Bigint" => Ok(PropertyPreviewType::Bigint),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Object subtype hint. Specified for `object` type values only."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum PropertyPreviewSubtype {
            #[serde(rename = "array")]
            Array,
            #[serde(rename = "null")]
            Null,
            #[serde(rename = "node")]
            Node,
            #[serde(rename = "regexp")]
            Regexp,
            #[serde(rename = "date")]
            Date,
            #[serde(rename = "map")]
            Map,
            #[serde(rename = "set")]
            Set,
            #[serde(rename = "weakmap")]
            Weakmap,
            #[serde(rename = "weakset")]
            Weakset,
            #[serde(rename = "iterator")]
            Iterator,
            #[serde(rename = "generator")]
            Generator,
            #[serde(rename = "error")]
            Error,
        }
        impl AsRef<str> for PropertyPreviewSubtype {
            fn as_ref(&self) -> &str {
                match self {
                    PropertyPreviewSubtype::Array => "array",
                    PropertyPreviewSubtype::Null => "null",
                    PropertyPreviewSubtype::Node => "node",
                    PropertyPreviewSubtype::Regexp => "regexp",
                    PropertyPreviewSubtype::Date => "date",
                    PropertyPreviewSubtype::Map => "map",
                    PropertyPreviewSubtype::Set => "set",
                    PropertyPreviewSubtype::Weakmap => "weakmap",
                    PropertyPreviewSubtype::Weakset => "weakset",
                    PropertyPreviewSubtype::Iterator => "iterator",
                    PropertyPreviewSubtype::Generator => "generator",
                    PropertyPreviewSubtype::Error => "error",
                }
            }
        }
        impl ::std::str::FromStr for PropertyPreviewSubtype {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "array" | "Array" => Ok(PropertyPreviewSubtype::Array),
                    "null" | "Null" => Ok(PropertyPreviewSubtype::Null),
                    "node" | "Node" => Ok(PropertyPreviewSubtype::Node),
                    "regexp" | "Regexp" => Ok(PropertyPreviewSubtype::Regexp),
                    "date" | "Date" => Ok(PropertyPreviewSubtype::Date),
                    "map" | "Map" => Ok(PropertyPreviewSubtype::Map),
                    "set" | "Set" => Ok(PropertyPreviewSubtype::Set),
                    "weakmap" | "Weakmap" => Ok(PropertyPreviewSubtype::Weakmap),
                    "weakset" | "Weakset" => Ok(PropertyPreviewSubtype::Weakset),
                    "iterator" | "Iterator" => Ok(PropertyPreviewSubtype::Iterator),
                    "generator" | "Generator" => Ok(PropertyPreviewSubtype::Generator),
                    "error" | "Error" => Ok(PropertyPreviewSubtype::Error),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl PropertyPreview {
            pub fn new(name: impl Into<String>, r#type: impl Into<PropertyPreviewType>) -> Self {
                Self {
                    name: name.into(),
                    r#type: r#type.into(),
                    value: None,
                    value_preview: None,
                    subtype: None,
                }
            }
        }
        impl PropertyPreview {
            pub fn builder() -> PropertyPreviewBuilder {
                PropertyPreviewBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct PropertyPreviewBuilder {
            name: Option<String>,
            r#type: Option<PropertyPreviewType>,
            value: Option<String>,
            value_preview: Option<ObjectPreview>,
            subtype: Option<PropertyPreviewSubtype>,
        }
        impl PropertyPreviewBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn r#type(mut self, r#type: impl Into<PropertyPreviewType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn value(mut self, value: impl Into<String>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn value_preview(mut self, value_preview: impl Into<ObjectPreview>) -> Self {
                self.value_preview = Some(value_preview.into());
                self
            }
            pub fn subtype(mut self, subtype: impl Into<PropertyPreviewSubtype>) -> Self {
                self.subtype = Some(subtype.into());
                self
            }
            pub fn build(self) -> Result<PropertyPreview, String> {
                Ok(PropertyPreview {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    value: self.value,
                    value_preview: self.value_preview,
                    subtype: self.subtype,
                })
            }
        }
        impl PropertyPreview {
            pub const IDENTIFIER: &'static str = "Runtime.PropertyPreview";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EntryPreview {
            #[doc = "Preview of the key. Specified for map-like collection entries."]
            #[serde(rename = "key")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub key: Option<ObjectPreview>,
            #[doc = "Preview of the value."]
            #[serde(rename = "value")]
            pub value: ObjectPreview,
        }
        impl EntryPreview {
            pub fn new(value: impl Into<ObjectPreview>) -> Self {
                Self {
                    value: value.into(),
                    key: None,
                }
            }
        }
        impl EntryPreview {
            pub fn builder() -> EntryPreviewBuilder {
                EntryPreviewBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EntryPreviewBuilder {
            key: Option<ObjectPreview>,
            value: Option<ObjectPreview>,
        }
        impl EntryPreviewBuilder {
            pub fn key(mut self, key: impl Into<ObjectPreview>) -> Self {
                self.key = Some(key.into());
                self
            }
            pub fn value(mut self, value: impl Into<ObjectPreview>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn build(self) -> Result<EntryPreview, String> {
                Ok(EntryPreview {
                    key: self.key,
                    value: self.value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(value))
                    })?,
                })
            }
        }
        impl EntryPreview {
            pub const IDENTIFIER: &'static str = "Runtime.EntryPreview";
        }
        #[doc = "Object property descriptor.\n[PropertyDescriptor](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-PropertyDescriptor)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct PropertyDescriptor {
            #[doc = "Property name or symbol description."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "The value associated with the property."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<RemoteObject>,
            #[doc = "True if the value associated with the property may be changed (data descriptors only)."]
            #[serde(rename = "writable")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub writable: Option<bool>,
            #[doc = "A function which serves as a getter for the property, or `undefined` if there is no getter\n(accessor descriptors only)."]
            #[serde(rename = "get")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub get: Option<RemoteObject>,
            #[doc = "A function which serves as a setter for the property, or `undefined` if there is no setter\n(accessor descriptors only)."]
            #[serde(rename = "set")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub set: Option<RemoteObject>,
            #[doc = "True if the type of this property descriptor may be changed and if the property may be\ndeleted from the corresponding object."]
            #[serde(rename = "configurable")]
            pub configurable: bool,
            #[doc = "True if this property shows up during enumeration of the properties on the corresponding\nobject."]
            #[serde(rename = "enumerable")]
            pub enumerable: bool,
            #[doc = "True if the result was thrown during the evaluation."]
            #[serde(rename = "wasThrown")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub was_thrown: Option<bool>,
            #[doc = "True if the property is owned for the object."]
            #[serde(rename = "isOwn")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub is_own: Option<bool>,
            #[doc = "Property symbol object, if the property is of the `symbol` type."]
            #[serde(rename = "symbol")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub symbol: Option<RemoteObject>,
        }
        impl PropertyDescriptor {
            pub fn new(
                name: impl Into<String>,
                configurable: impl Into<bool>,
                enumerable: impl Into<bool>,
            ) -> Self {
                Self {
                    name: name.into(),
                    configurable: configurable.into(),
                    enumerable: enumerable.into(),
                    value: None,
                    writable: None,
                    get: None,
                    set: None,
                    was_thrown: None,
                    is_own: None,
                    symbol: None,
                }
            }
        }
        impl PropertyDescriptor {
            pub fn builder() -> PropertyDescriptorBuilder {
                PropertyDescriptorBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct PropertyDescriptorBuilder {
            name: Option<String>,
            value: Option<RemoteObject>,
            writable: Option<bool>,
            get: Option<RemoteObject>,
            set: Option<RemoteObject>,
            configurable: Option<bool>,
            enumerable: Option<bool>,
            was_thrown: Option<bool>,
            is_own: Option<bool>,
            symbol: Option<RemoteObject>,
        }
        impl PropertyDescriptorBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<RemoteObject>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn writable(mut self, writable: impl Into<bool>) -> Self {
                self.writable = Some(writable.into());
                self
            }
            pub fn get(mut self, get: impl Into<RemoteObject>) -> Self {
                self.get = Some(get.into());
                self
            }
            pub fn set(mut self, set: impl Into<RemoteObject>) -> Self {
                self.set = Some(set.into());
                self
            }
            pub fn configurable(mut self, configurable: impl Into<bool>) -> Self {
                self.configurable = Some(configurable.into());
                self
            }
            pub fn enumerable(mut self, enumerable: impl Into<bool>) -> Self {
                self.enumerable = Some(enumerable.into());
                self
            }
            pub fn was_thrown(mut self, was_thrown: impl Into<bool>) -> Self {
                self.was_thrown = Some(was_thrown.into());
                self
            }
            pub fn is_own(mut self, is_own: impl Into<bool>) -> Self {
                self.is_own = Some(is_own.into());
                self
            }
            pub fn symbol(mut self, symbol: impl Into<RemoteObject>) -> Self {
                self.symbol = Some(symbol.into());
                self
            }
            pub fn build(self) -> Result<PropertyDescriptor, String> {
                Ok(PropertyDescriptor {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value,
                    writable: self.writable,
                    get: self.get,
                    set: self.set,
                    configurable: self.configurable.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(configurable))
                    })?,
                    enumerable: self.enumerable.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(enumerable))
                    })?,
                    was_thrown: self.was_thrown,
                    is_own: self.is_own,
                    symbol: self.symbol,
                })
            }
        }
        impl PropertyDescriptor {
            pub const IDENTIFIER: &'static str = "Runtime.PropertyDescriptor";
        }
        #[doc = "Object internal property descriptor. This property isn't normally visible in JavaScript code.\n[InternalPropertyDescriptor](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-InternalPropertyDescriptor)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct InternalPropertyDescriptor {
            #[doc = "Conventional property name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "The value associated with the property."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<RemoteObject>,
        }
        impl InternalPropertyDescriptor {
            pub fn new(name: impl Into<String>) -> Self {
                Self {
                    name: name.into(),
                    value: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for InternalPropertyDescriptor {
            fn from(url: T) -> Self {
                InternalPropertyDescriptor::new(url)
            }
        }
        impl InternalPropertyDescriptor {
            pub fn builder() -> InternalPropertyDescriptorBuilder {
                InternalPropertyDescriptorBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct InternalPropertyDescriptorBuilder {
            name: Option<String>,
            value: Option<RemoteObject>,
        }
        impl InternalPropertyDescriptorBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<RemoteObject>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn build(self) -> Result<InternalPropertyDescriptor, String> {
                Ok(InternalPropertyDescriptor {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value,
                })
            }
        }
        impl InternalPropertyDescriptor {
            pub const IDENTIFIER: &'static str = "Runtime.InternalPropertyDescriptor";
        }
        #[doc = "Object private field descriptor.\n[PrivatePropertyDescriptor](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-PrivatePropertyDescriptor)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct PrivatePropertyDescriptor {
            #[doc = "Private property name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "The value associated with the private property."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<RemoteObject>,
            #[doc = "A function which serves as a getter for the private property,\nor `undefined` if there is no getter (accessor descriptors only)."]
            #[serde(rename = "get")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub get: Option<RemoteObject>,
            #[doc = "A function which serves as a setter for the private property,\nor `undefined` if there is no setter (accessor descriptors only)."]
            #[serde(rename = "set")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub set: Option<RemoteObject>,
        }
        impl PrivatePropertyDescriptor {
            pub fn new(name: impl Into<String>) -> Self {
                Self {
                    name: name.into(),
                    value: None,
                    get: None,
                    set: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for PrivatePropertyDescriptor {
            fn from(url: T) -> Self {
                PrivatePropertyDescriptor::new(url)
            }
        }
        impl PrivatePropertyDescriptor {
            pub fn builder() -> PrivatePropertyDescriptorBuilder {
                PrivatePropertyDescriptorBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct PrivatePropertyDescriptorBuilder {
            name: Option<String>,
            value: Option<RemoteObject>,
            get: Option<RemoteObject>,
            set: Option<RemoteObject>,
        }
        impl PrivatePropertyDescriptorBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<RemoteObject>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn get(mut self, get: impl Into<RemoteObject>) -> Self {
                self.get = Some(get.into());
                self
            }
            pub fn set(mut self, set: impl Into<RemoteObject>) -> Self {
                self.set = Some(set.into());
                self
            }
            pub fn build(self) -> Result<PrivatePropertyDescriptor, String> {
                Ok(PrivatePropertyDescriptor {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value,
                    get: self.get,
                    set: self.set,
                })
            }
        }
        impl PrivatePropertyDescriptor {
            pub const IDENTIFIER: &'static str = "Runtime.PrivatePropertyDescriptor";
        }
        #[doc = "Represents function call argument. Either remote object id `objectId`, primitive `value`,\nunserializable primitive value or neither of (for undefined) them should be specified.\n[CallArgument](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-CallArgument)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct CallArgument {
            #[doc = "Primitive value or serializable javascript object."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<serde_json::Value>,
            #[doc = "Primitive value which can not be JSON-stringified."]
            #[serde(rename = "unserializableValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub unserializable_value: Option<UnserializableValue>,
            #[doc = "Remote object handle."]
            #[serde(rename = "objectId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_id: Option<RemoteObjectId>,
        }
        impl CallArgument {
            pub fn builder() -> CallArgumentBuilder {
                CallArgumentBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CallArgumentBuilder {
            value: Option<serde_json::Value>,
            unserializable_value: Option<UnserializableValue>,
            object_id: Option<RemoteObjectId>,
        }
        impl CallArgumentBuilder {
            pub fn value(mut self, value: impl Into<serde_json::Value>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn unserializable_value(
                mut self,
                unserializable_value: impl Into<UnserializableValue>,
            ) -> Self {
                self.unserializable_value = Some(unserializable_value.into());
                self
            }
            pub fn object_id(mut self, object_id: impl Into<RemoteObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn build(self) -> CallArgument {
                CallArgument {
                    value: self.value,
                    unserializable_value: self.unserializable_value,
                    object_id: self.object_id,
                }
            }
        }
        impl CallArgument {
            pub const IDENTIFIER: &'static str = "Runtime.CallArgument";
        }
        #[doc = "Id of an execution context.\n[ExecutionContextId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-ExecutionContextId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Copy, Hash)]
        pub struct ExecutionContextId(i64);
        impl ExecutionContextId {
            pub fn new(val: impl Into<i64>) -> Self {
                ExecutionContextId(val.into())
            }
            pub fn inner(&self) -> &i64 {
                &self.0
            }
        }
        impl ExecutionContextId {
            pub const IDENTIFIER: &'static str = "Runtime.ExecutionContextId";
        }
        #[doc = "Description of an isolated world.\n[ExecutionContextDescription](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-ExecutionContextDescription)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ExecutionContextDescription {
            #[doc = "Unique id of the execution context. It can be used to specify in which execution context\nscript evaluation should be performed."]
            #[serde(rename = "id")]
            pub id: ExecutionContextId,
            #[doc = "Execution context origin."]
            #[serde(rename = "origin")]
            pub origin: String,
            #[doc = "Human readable name describing given context."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "Embedder-specific auxiliary data."]
            #[serde(rename = "auxData")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub aux_data: Option<serde_json::Value>,
        }
        impl ExecutionContextDescription {
            pub fn new(
                id: impl Into<ExecutionContextId>,
                origin: impl Into<String>,
                name: impl Into<String>,
            ) -> Self {
                Self {
                    id: id.into(),
                    origin: origin.into(),
                    name: name.into(),
                    aux_data: None,
                }
            }
        }
        impl ExecutionContextDescription {
            pub fn builder() -> ExecutionContextDescriptionBuilder {
                ExecutionContextDescriptionBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ExecutionContextDescriptionBuilder {
            id: Option<ExecutionContextId>,
            origin: Option<String>,
            name: Option<String>,
            aux_data: Option<serde_json::Value>,
        }
        impl ExecutionContextDescriptionBuilder {
            pub fn id(mut self, id: impl Into<ExecutionContextId>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn origin(mut self, origin: impl Into<String>) -> Self {
                self.origin = Some(origin.into());
                self
            }
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn aux_data(mut self, aux_data: impl Into<serde_json::Value>) -> Self {
                self.aux_data = Some(aux_data.into());
                self
            }
            pub fn build(self) -> Result<ExecutionContextDescription, String> {
                Ok(ExecutionContextDescription {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                    origin: self.origin.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(origin))
                    })?,
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    aux_data: self.aux_data,
                })
            }
        }
        impl ExecutionContextDescription {
            pub const IDENTIFIER: &'static str = "Runtime.ExecutionContextDescription";
        }
        #[doc = "Detailed information about exception (or error) that was thrown during script compilation or\nexecution.\n[ExceptionDetails](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-ExceptionDetails)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ExceptionDetails {
            #[doc = "Exception id."]
            #[serde(rename = "exceptionId")]
            pub exception_id: i64,
            #[doc = "Exception text, which should be used together with exception object when available."]
            #[serde(rename = "text")]
            pub text: String,
            #[doc = "Line number of the exception location (0-based)."]
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[doc = "Column number of the exception location (0-based)."]
            #[serde(rename = "columnNumber")]
            pub column_number: i64,
            #[doc = "Script ID of the exception location."]
            #[serde(rename = "scriptId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub script_id: Option<ScriptId>,
            #[doc = "URL of the exception location, to be used when the script was not reported."]
            #[serde(rename = "url")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub url: Option<String>,
            #[doc = "JavaScript stack trace if available."]
            #[serde(rename = "stackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub stack_trace: Option<StackTrace>,
            #[doc = "Exception object if available."]
            #[serde(rename = "exception")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception: Option<RemoteObject>,
            #[doc = "Identifier of the context where exception happened."]
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
        }
        impl ExceptionDetails {
            pub fn new(
                exception_id: impl Into<i64>,
                text: impl Into<String>,
                line_number: impl Into<i64>,
                column_number: impl Into<i64>,
            ) -> Self {
                Self {
                    exception_id: exception_id.into(),
                    text: text.into(),
                    line_number: line_number.into(),
                    column_number: column_number.into(),
                    script_id: None,
                    url: None,
                    stack_trace: None,
                    exception: None,
                    execution_context_id: None,
                }
            }
        }
        impl ExceptionDetails {
            pub fn builder() -> ExceptionDetailsBuilder {
                ExceptionDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ExceptionDetailsBuilder {
            exception_id: Option<i64>,
            text: Option<String>,
            line_number: Option<i64>,
            column_number: Option<i64>,
            script_id: Option<ScriptId>,
            url: Option<String>,
            stack_trace: Option<StackTrace>,
            exception: Option<RemoteObject>,
            execution_context_id: Option<ExecutionContextId>,
        }
        impl ExceptionDetailsBuilder {
            pub fn exception_id(mut self, exception_id: impl Into<i64>) -> Self {
                self.exception_id = Some(exception_id.into());
                self
            }
            pub fn text(mut self, text: impl Into<String>) -> Self {
                self.text = Some(text.into());
                self
            }
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn script_id(mut self, script_id: impl Into<ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn stack_trace(mut self, stack_trace: impl Into<StackTrace>) -> Self {
                self.stack_trace = Some(stack_trace.into());
                self
            }
            pub fn exception(mut self, exception: impl Into<RemoteObject>) -> Self {
                self.exception = Some(exception.into());
                self
            }
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn build(self) -> Result<ExceptionDetails, String> {
                Ok(ExceptionDetails {
                    exception_id: self.exception_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(exception_id))
                    })?,
                    text: self.text.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(text))
                    })?,
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(column_number))
                    })?,
                    script_id: self.script_id,
                    url: self.url,
                    stack_trace: self.stack_trace,
                    exception: self.exception,
                    execution_context_id: self.execution_context_id,
                })
            }
        }
        impl ExceptionDetails {
            pub const IDENTIFIER: &'static str = "Runtime.ExceptionDetails";
        }
        #[doc = "Number of milliseconds since epoch.\n[Timestamp](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-Timestamp)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct Timestamp(f64);
        impl Timestamp {
            pub fn new(val: impl Into<f64>) -> Self {
                Timestamp(val.into())
            }
            pub fn inner(&self) -> &f64 {
                &self.0
            }
        }
        impl Timestamp {
            pub const IDENTIFIER: &'static str = "Runtime.Timestamp";
        }
        #[doc = "Number of milliseconds.\n[TimeDelta](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-TimeDelta)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TimeDelta(f64);
        impl TimeDelta {
            pub fn new(val: impl Into<f64>) -> Self {
                TimeDelta(val.into())
            }
            pub fn inner(&self) -> &f64 {
                &self.0
            }
        }
        impl TimeDelta {
            pub const IDENTIFIER: &'static str = "Runtime.TimeDelta";
        }
        #[doc = "Stack entry for runtime errors and assertions.\n[CallFrame](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-CallFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CallFrame {
            #[doc = "JavaScript function name."]
            #[serde(rename = "functionName")]
            pub function_name: String,
            #[doc = "JavaScript script id."]
            #[serde(rename = "scriptId")]
            pub script_id: ScriptId,
            #[doc = "JavaScript script name or url."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "JavaScript script line number (0-based)."]
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[doc = "JavaScript script column number (0-based)."]
            #[serde(rename = "columnNumber")]
            pub column_number: i64,
        }
        impl CallFrame {
            pub fn builder() -> CallFrameBuilder {
                CallFrameBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CallFrameBuilder {
            function_name: Option<String>,
            script_id: Option<ScriptId>,
            url: Option<String>,
            line_number: Option<i64>,
            column_number: Option<i64>,
        }
        impl CallFrameBuilder {
            pub fn function_name(mut self, function_name: impl Into<String>) -> Self {
                self.function_name = Some(function_name.into());
                self
            }
            pub fn script_id(mut self, script_id: impl Into<ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn build(self) -> Result<CallFrame, String> {
                Ok(CallFrame {
                    function_name: self.function_name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(function_name))
                    })?,
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(column_number))
                    })?,
                })
            }
        }
        impl CallFrame {
            pub const IDENTIFIER: &'static str = "Runtime.CallFrame";
        }
        #[doc = "Call frames for assertions or error messages.\n[StackTrace](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-StackTrace)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StackTrace {
            #[doc = "String label of this stack trace. For async traces this may be a name of the function that\ninitiated the async call."]
            #[serde(rename = "description")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub description: Option<String>,
            #[doc = "JavaScript function name."]
            #[serde(rename = "callFrames")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub call_frames: Vec<CallFrame>,
            #[doc = "Asynchronous JavaScript stack trace that preceded this stack, if available."]
            #[serde(rename = "parent")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub parent: Option<Box<StackTrace>>,
            #[doc = "Asynchronous JavaScript stack trace that preceded this stack, if available."]
            #[serde(rename = "parentId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub parent_id: Option<StackTraceId>,
        }
        impl StackTrace {
            pub fn new(call_frames: Vec<CallFrame>) -> Self {
                Self {
                    call_frames,
                    description: None,
                    parent: None,
                    parent_id: None,
                }
            }
        }
        impl StackTrace {
            pub fn builder() -> StackTraceBuilder {
                StackTraceBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StackTraceBuilder {
            description: Option<String>,
            call_frames: Option<Vec<CallFrame>>,
            parent: Option<StackTrace>,
            parent_id: Option<StackTraceId>,
        }
        impl StackTraceBuilder {
            pub fn description(mut self, description: impl Into<String>) -> Self {
                self.description = Some(description.into());
                self
            }
            pub fn call_frame(mut self, call_frame: impl Into<CallFrame>) -> Self {
                let v = self.call_frames.get_or_insert(Vec::new());
                v.push(call_frame.into());
                self
            }
            pub fn call_frames<I, S>(mut self, call_frames: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CallFrame>,
            {
                let v = self.call_frames.get_or_insert(Vec::new());
                for val in call_frames {
                    v.push(val.into());
                }
                self
            }
            pub fn parent(mut self, parent: impl Into<StackTrace>) -> Self {
                self.parent = Some(parent.into());
                self
            }
            pub fn parent_id(mut self, parent_id: impl Into<StackTraceId>) -> Self {
                self.parent_id = Some(parent_id.into());
                self
            }
            pub fn build(self) -> Result<StackTrace, String> {
                Ok(StackTrace {
                    description: self.description,
                    call_frames: self.call_frames.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(call_frames))
                    })?,
                    parent: self.parent.map(Box::new),
                    parent_id: self.parent_id,
                })
            }
        }
        impl StackTrace {
            pub const IDENTIFIER: &'static str = "Runtime.StackTrace";
        }
        #[doc = "Unique identifier of current debugger.\n[UniqueDebuggerId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-UniqueDebuggerId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct UniqueDebuggerId(String);
        impl UniqueDebuggerId {
            pub fn new(val: impl Into<String>) -> Self {
                UniqueDebuggerId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for UniqueDebuggerId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<UniqueDebuggerId> for String {
            fn from(el: UniqueDebuggerId) -> String {
                el.0
            }
        }
        impl From<String> for UniqueDebuggerId {
            fn from(expr: String) -> Self {
                UniqueDebuggerId(expr)
            }
        }
        impl std::borrow::Borrow<str> for UniqueDebuggerId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl UniqueDebuggerId {
            pub const IDENTIFIER: &'static str = "Runtime.UniqueDebuggerId";
        }
        #[doc = "If `debuggerId` is set stack trace comes from another debugger and can be resolved there. This\nallows to track cross-debugger calls. See `Runtime.StackTrace` and `Debugger.paused` for usages.\n[StackTraceId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#type-StackTraceId)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StackTraceId {
            #[serde(rename = "id")]
            pub id: String,
            #[serde(rename = "debuggerId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub debugger_id: Option<UniqueDebuggerId>,
        }
        impl StackTraceId {
            pub fn new(id: impl Into<String>) -> Self {
                Self {
                    id: id.into(),
                    debugger_id: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for StackTraceId {
            fn from(url: T) -> Self {
                StackTraceId::new(url)
            }
        }
        impl StackTraceId {
            pub fn builder() -> StackTraceIdBuilder {
                StackTraceIdBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StackTraceIdBuilder {
            id: Option<String>,
            debugger_id: Option<UniqueDebuggerId>,
        }
        impl StackTraceIdBuilder {
            pub fn id(mut self, id: impl Into<String>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn debugger_id(mut self, debugger_id: impl Into<UniqueDebuggerId>) -> Self {
                self.debugger_id = Some(debugger_id.into());
                self
            }
            pub fn build(self) -> Result<StackTraceId, String> {
                Ok(StackTraceId {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                    debugger_id: self.debugger_id,
                })
            }
        }
        impl StackTraceId {
            pub const IDENTIFIER: &'static str = "Runtime.StackTraceId";
        }
        #[doc = "Add handler to promise with given promise object id.\n[awaitPromise](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-awaitPromise)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AwaitPromiseParams {
            #[doc = "Identifier of the promise."]
            #[serde(rename = "promiseObjectId")]
            pub promise_object_id: RemoteObjectId,
            #[doc = "Whether the result is expected to be a JSON object that should be sent by value."]
            #[serde(rename = "returnByValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_by_value: Option<bool>,
            #[doc = "Whether preview should be generated for the result."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
        }
        impl AwaitPromiseParams {
            pub fn new(promise_object_id: impl Into<RemoteObjectId>) -> Self {
                Self {
                    promise_object_id: promise_object_id.into(),
                    return_by_value: None,
                    generate_preview: None,
                }
            }
        }
        impl AwaitPromiseParams {
            pub fn builder() -> AwaitPromiseParamsBuilder {
                AwaitPromiseParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AwaitPromiseParamsBuilder {
            promise_object_id: Option<RemoteObjectId>,
            return_by_value: Option<bool>,
            generate_preview: Option<bool>,
        }
        impl AwaitPromiseParamsBuilder {
            pub fn promise_object_id(
                mut self,
                promise_object_id: impl Into<RemoteObjectId>,
            ) -> Self {
                self.promise_object_id = Some(promise_object_id.into());
                self
            }
            pub fn return_by_value(mut self, return_by_value: impl Into<bool>) -> Self {
                self.return_by_value = Some(return_by_value.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn build(self) -> Result<AwaitPromiseParams, String> {
                Ok(AwaitPromiseParams {
                    promise_object_id: self.promise_object_id.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(promise_object_id)
                        )
                    })?,
                    return_by_value: self.return_by_value,
                    generate_preview: self.generate_preview,
                })
            }
        }
        impl AwaitPromiseParams {
            pub const IDENTIFIER: &'static str = "Runtime.awaitPromise";
        }
        impl chromiumoxide_types::Method for AwaitPromiseParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for AwaitPromiseParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Add handler to promise with given promise object id.\n[awaitPromise](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-awaitPromise)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AwaitPromiseReturns {
            #[doc = "Promise result. Will contain rejected value if promise was rejected."]
            #[serde(rename = "result")]
            pub result: RemoteObject,
            #[doc = "Exception details if stack strace is available."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
        }
        impl AwaitPromiseReturns {
            pub fn new(result: impl Into<RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                }
            }
        }
        impl AwaitPromiseReturns {
            pub fn builder() -> AwaitPromiseReturnsBuilder {
                AwaitPromiseReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AwaitPromiseReturnsBuilder {
            result: Option<RemoteObject>,
            exception_details: Option<ExceptionDetails>,
        }
        impl AwaitPromiseReturnsBuilder {
            pub fn result(mut self, result: impl Into<RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<AwaitPromiseReturns, String> {
                Ok(AwaitPromiseReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for AwaitPromiseParams {
            type Response = AwaitPromiseReturns;
        }
        #[doc = "Calls function with given declaration on the given object. Object group of the result is\ninherited from the target object.\n[callFunctionOn](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-callFunctionOn)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CallFunctionOnParams {
            #[doc = "Declaration of the function to call."]
            #[serde(rename = "functionDeclaration")]
            pub function_declaration: String,
            #[doc = "Identifier of the object to call function on. Either objectId or executionContextId should\nbe specified."]
            #[serde(rename = "objectId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_id: Option<RemoteObjectId>,
            #[doc = "Call arguments. All call arguments must belong to the same JavaScript world as the target\nobject."]
            #[serde(rename = "arguments")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub arguments: Option<Vec<CallArgument>>,
            #[doc = "In silent mode exceptions thrown during evaluation are not reported and do not pause\nexecution. Overrides `setPauseOnException` state."]
            #[serde(rename = "silent")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub silent: Option<bool>,
            #[doc = "Whether the result is expected to be a JSON object which should be sent by value."]
            #[serde(rename = "returnByValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_by_value: Option<bool>,
            #[doc = "Whether preview should be generated for the result."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
            #[doc = "Whether execution should be treated as initiated by user in the UI."]
            #[serde(rename = "userGesture")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub user_gesture: Option<bool>,
            #[doc = "Whether execution should `await` for resulting value and return once awaited promise is\nresolved."]
            #[serde(rename = "awaitPromise")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub await_promise: Option<bool>,
            #[doc = "Specifies execution context which global object will be used to call function on. Either\nexecutionContextId or objectId should be specified."]
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
            #[doc = "Symbolic group name that can be used to release multiple objects. If objectGroup is not\nspecified and objectId is, objectGroup will be inherited from object."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
        }
        impl CallFunctionOnParams {
            pub fn new(function_declaration: impl Into<String>) -> Self {
                Self {
                    function_declaration: function_declaration.into(),
                    object_id: None,
                    arguments: None,
                    silent: None,
                    return_by_value: None,
                    generate_preview: None,
                    user_gesture: None,
                    await_promise: None,
                    execution_context_id: None,
                    object_group: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for CallFunctionOnParams {
            fn from(url: T) -> Self {
                CallFunctionOnParams::new(url)
            }
        }
        impl CallFunctionOnParams {
            pub fn builder() -> CallFunctionOnParamsBuilder {
                CallFunctionOnParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CallFunctionOnParamsBuilder {
            function_declaration: Option<String>,
            object_id: Option<RemoteObjectId>,
            arguments: Option<Vec<CallArgument>>,
            silent: Option<bool>,
            return_by_value: Option<bool>,
            generate_preview: Option<bool>,
            user_gesture: Option<bool>,
            await_promise: Option<bool>,
            execution_context_id: Option<ExecutionContextId>,
            object_group: Option<String>,
        }
        impl CallFunctionOnParamsBuilder {
            pub fn function_declaration(mut self, function_declaration: impl Into<String>) -> Self {
                self.function_declaration = Some(function_declaration.into());
                self
            }
            pub fn object_id(mut self, object_id: impl Into<RemoteObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn argument(mut self, argument: impl Into<CallArgument>) -> Self {
                let v = self.arguments.get_or_insert(Vec::new());
                v.push(argument.into());
                self
            }
            pub fn arguments<I, S>(mut self, arguments: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<CallArgument>,
            {
                let v = self.arguments.get_or_insert(Vec::new());
                for val in arguments {
                    v.push(val.into());
                }
                self
            }
            pub fn silent(mut self, silent: impl Into<bool>) -> Self {
                self.silent = Some(silent.into());
                self
            }
            pub fn return_by_value(mut self, return_by_value: impl Into<bool>) -> Self {
                self.return_by_value = Some(return_by_value.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn user_gesture(mut self, user_gesture: impl Into<bool>) -> Self {
                self.user_gesture = Some(user_gesture.into());
                self
            }
            pub fn await_promise(mut self, await_promise: impl Into<bool>) -> Self {
                self.await_promise = Some(await_promise.into());
                self
            }
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn build(self) -> Result<CallFunctionOnParams, String> {
                Ok(CallFunctionOnParams {
                    function_declaration: self.function_declaration.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(function_declaration)
                        )
                    })?,
                    object_id: self.object_id,
                    arguments: self.arguments,
                    silent: self.silent,
                    return_by_value: self.return_by_value,
                    generate_preview: self.generate_preview,
                    user_gesture: self.user_gesture,
                    await_promise: self.await_promise,
                    execution_context_id: self.execution_context_id,
                    object_group: self.object_group,
                })
            }
        }
        impl CallFunctionOnParams {
            pub const IDENTIFIER: &'static str = "Runtime.callFunctionOn";
        }
        impl chromiumoxide_types::Method for CallFunctionOnParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for CallFunctionOnParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Calls function with given declaration on the given object. Object group of the result is\ninherited from the target object.\n[callFunctionOn](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-callFunctionOn)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CallFunctionOnReturns {
            #[doc = "Call result."]
            #[serde(rename = "result")]
            pub result: RemoteObject,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
        }
        impl CallFunctionOnReturns {
            pub fn new(result: impl Into<RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                }
            }
        }
        impl CallFunctionOnReturns {
            pub fn builder() -> CallFunctionOnReturnsBuilder {
                CallFunctionOnReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CallFunctionOnReturnsBuilder {
            result: Option<RemoteObject>,
            exception_details: Option<ExceptionDetails>,
        }
        impl CallFunctionOnReturnsBuilder {
            pub fn result(mut self, result: impl Into<RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<CallFunctionOnReturns, String> {
                Ok(CallFunctionOnReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for CallFunctionOnParams {
            type Response = CallFunctionOnReturns;
        }
        #[doc = "Compiles expression.\n[compileScript](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-compileScript)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct CompileScriptParams {
            #[doc = "Expression to compile."]
            #[serde(rename = "expression")]
            pub expression: String,
            #[doc = "Source url to be set for the script."]
            #[serde(rename = "sourceURL")]
            pub source_url: String,
            #[doc = "Specifies whether the compiled script should be persisted."]
            #[serde(rename = "persistScript")]
            pub persist_script: bool,
            #[doc = "Specifies in which execution context to perform script run. If the parameter is omitted the\nevaluation will be performed in the context of the inspected page."]
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
        }
        impl CompileScriptParams {
            pub fn new(
                expression: impl Into<String>,
                source_url: impl Into<String>,
                persist_script: impl Into<bool>,
            ) -> Self {
                Self {
                    expression: expression.into(),
                    source_url: source_url.into(),
                    persist_script: persist_script.into(),
                    execution_context_id: None,
                }
            }
        }
        impl CompileScriptParams {
            pub fn builder() -> CompileScriptParamsBuilder {
                CompileScriptParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CompileScriptParamsBuilder {
            expression: Option<String>,
            source_url: Option<String>,
            persist_script: Option<bool>,
            execution_context_id: Option<ExecutionContextId>,
        }
        impl CompileScriptParamsBuilder {
            pub fn expression(mut self, expression: impl Into<String>) -> Self {
                self.expression = Some(expression.into());
                self
            }
            pub fn source_url(mut self, source_url: impl Into<String>) -> Self {
                self.source_url = Some(source_url.into());
                self
            }
            pub fn persist_script(mut self, persist_script: impl Into<bool>) -> Self {
                self.persist_script = Some(persist_script.into());
                self
            }
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn build(self) -> Result<CompileScriptParams, String> {
                Ok(CompileScriptParams {
                    expression: self.expression.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(expression))
                    })?,
                    source_url: self.source_url.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(source_url))
                    })?,
                    persist_script: self.persist_script.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(persist_script))
                    })?,
                    execution_context_id: self.execution_context_id,
                })
            }
        }
        impl CompileScriptParams {
            pub const IDENTIFIER: &'static str = "Runtime.compileScript";
        }
        impl chromiumoxide_types::Method for CompileScriptParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for CompileScriptParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Compiles expression.\n[compileScript](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-compileScript)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct CompileScriptReturns {
            #[doc = "Id of the script."]
            #[serde(rename = "scriptId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub script_id: Option<ScriptId>,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
        }
        impl CompileScriptReturns {
            pub fn builder() -> CompileScriptReturnsBuilder {
                CompileScriptReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct CompileScriptReturnsBuilder {
            script_id: Option<ScriptId>,
            exception_details: Option<ExceptionDetails>,
        }
        impl CompileScriptReturnsBuilder {
            pub fn script_id(mut self, script_id: impl Into<ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> CompileScriptReturns {
                CompileScriptReturns {
                    script_id: self.script_id,
                    exception_details: self.exception_details,
                }
            }
        }
        impl chromiumoxide_types::Command for CompileScriptParams {
            type Response = CompileScriptReturns;
        }
        #[doc = "Disables reporting of execution contexts creation.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Runtime.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables reporting of execution contexts creation.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[doc = "Discards collected exceptions and console API calls.\n[discardConsoleEntries](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-discardConsoleEntries)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DiscardConsoleEntriesParams {}
        impl DiscardConsoleEntriesParams {
            pub const IDENTIFIER: &'static str = "Runtime.discardConsoleEntries";
        }
        impl chromiumoxide_types::Method for DiscardConsoleEntriesParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DiscardConsoleEntriesParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Discards collected exceptions and console API calls.\n[discardConsoleEntries](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-discardConsoleEntries)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DiscardConsoleEntriesReturns {}
        impl chromiumoxide_types::Command for DiscardConsoleEntriesParams {
            type Response = DiscardConsoleEntriesReturns;
        }
        #[doc = "Enables reporting of execution contexts creation by means of `executionContextCreated` event.\nWhen the reporting gets enabled the event will be sent immediately for each existing execution\ncontext.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Runtime.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables reporting of execution contexts creation by means of `executionContextCreated` event.\nWhen the reporting gets enabled the event will be sent immediately for each existing execution\ncontext.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Evaluates expression on global object.\n[evaluate](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-evaluate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EvaluateParams {
            #[doc = "Expression to evaluate."]
            #[serde(rename = "expression")]
            pub expression: String,
            #[doc = "Symbolic group name that can be used to release multiple objects."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
            #[doc = "Determines whether Command Line API should be available during the evaluation."]
            #[serde(rename = "includeCommandLineAPI")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub include_command_line_api: Option<bool>,
            #[doc = "In silent mode exceptions thrown during evaluation are not reported and do not pause\nexecution. Overrides `setPauseOnException` state."]
            #[serde(rename = "silent")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub silent: Option<bool>,
            #[doc = "Specifies in which execution context to perform evaluation. If the parameter is omitted the\nevaluation will be performed in the context of the inspected page."]
            #[serde(rename = "contextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub context_id: Option<ExecutionContextId>,
            #[doc = "Whether the result is expected to be a JSON object that should be sent by value."]
            #[serde(rename = "returnByValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_by_value: Option<bool>,
            #[doc = "Whether preview should be generated for the result."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
            #[doc = "Whether execution should be treated as initiated by user in the UI."]
            #[serde(rename = "userGesture")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub user_gesture: Option<bool>,
            #[doc = "Whether execution should `await` for resulting value and return once awaited promise is\nresolved."]
            #[serde(rename = "awaitPromise")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub await_promise: Option<bool>,
            #[doc = "Whether to throw an exception if side effect cannot be ruled out during evaluation.\nThis implies `disableBreaks` below."]
            #[serde(rename = "throwOnSideEffect")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub throw_on_side_effect: Option<bool>,
            #[doc = "Terminate execution after timing out (number of milliseconds)."]
            #[serde(rename = "timeout")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub timeout: Option<TimeDelta>,
            #[doc = "Disable breakpoints during execution."]
            #[serde(rename = "disableBreaks")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub disable_breaks: Option<bool>,
            #[doc = "Setting this flag to true enables `let` re-declaration and top-level `await`.\nNote that `let` variables can only be re-declared if they originate from\n`replMode` themselves."]
            #[serde(rename = "replMode")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub repl_mode: Option<bool>,
            #[doc = "The Content Security Policy (CSP) for the target might block 'unsafe-eval'\nwhich includes eval(), Function(), setTimeout() and setInterval()\nwhen called with non-callable arguments. This flag bypasses CSP for this\nevaluation and allows unsafe-eval. Defaults to true."]
            #[serde(rename = "allowUnsafeEvalBlockedByCSP")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub allow_unsafe_eval_blocked_by_csp: Option<bool>,
            #[doc = r" This is a manually added field that is not part of the protocol definition, hence ignored during serde operations."]
            #[doc = r""]
            #[doc = r" If set to true, this field indicates, that if the command resulted in a response value of type `function` this, `EvaluateParams` command should be executed as a `CallFunctionOnParams` instead."]
            #[serde(skip)]
            pub eval_as_function_fallback: Option<bool>,
        }
        impl EvaluateParams {
            pub fn new(expression: impl Into<String>) -> Self {
                Self {
                    expression: expression.into(),
                    object_group: None,
                    include_command_line_api: None,
                    silent: None,
                    context_id: None,
                    return_by_value: None,
                    generate_preview: None,
                    user_gesture: None,
                    await_promise: None,
                    throw_on_side_effect: None,
                    timeout: None,
                    disable_breaks: None,
                    repl_mode: None,
                    allow_unsafe_eval_blocked_by_csp: None,
                    eval_as_function_fallback: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for EvaluateParams {
            fn from(url: T) -> Self {
                EvaluateParams::new(url)
            }
        }
        impl EvaluateParams {
            pub fn builder() -> EvaluateParamsBuilder {
                EvaluateParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EvaluateParamsBuilder {
            expression: Option<String>,
            object_group: Option<String>,
            include_command_line_api: Option<bool>,
            silent: Option<bool>,
            context_id: Option<ExecutionContextId>,
            return_by_value: Option<bool>,
            generate_preview: Option<bool>,
            user_gesture: Option<bool>,
            await_promise: Option<bool>,
            throw_on_side_effect: Option<bool>,
            timeout: Option<TimeDelta>,
            disable_breaks: Option<bool>,
            repl_mode: Option<bool>,
            allow_unsafe_eval_blocked_by_csp: Option<bool>,
            eval_as_function_fallback: Option<bool>,
        }
        impl EvaluateParamsBuilder {
            pub fn expression(mut self, expression: impl Into<String>) -> Self {
                self.expression = Some(expression.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn include_command_line_api(
                mut self,
                include_command_line_api: impl Into<bool>,
            ) -> Self {
                self.include_command_line_api = Some(include_command_line_api.into());
                self
            }
            pub fn silent(mut self, silent: impl Into<bool>) -> Self {
                self.silent = Some(silent.into());
                self
            }
            pub fn context_id(mut self, context_id: impl Into<ExecutionContextId>) -> Self {
                self.context_id = Some(context_id.into());
                self
            }
            pub fn return_by_value(mut self, return_by_value: impl Into<bool>) -> Self {
                self.return_by_value = Some(return_by_value.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn user_gesture(mut self, user_gesture: impl Into<bool>) -> Self {
                self.user_gesture = Some(user_gesture.into());
                self
            }
            pub fn await_promise(mut self, await_promise: impl Into<bool>) -> Self {
                self.await_promise = Some(await_promise.into());
                self
            }
            pub fn throw_on_side_effect(mut self, throw_on_side_effect: impl Into<bool>) -> Self {
                self.throw_on_side_effect = Some(throw_on_side_effect.into());
                self
            }
            pub fn timeout(mut self, timeout: impl Into<TimeDelta>) -> Self {
                self.timeout = Some(timeout.into());
                self
            }
            pub fn disable_breaks(mut self, disable_breaks: impl Into<bool>) -> Self {
                self.disable_breaks = Some(disable_breaks.into());
                self
            }
            pub fn repl_mode(mut self, repl_mode: impl Into<bool>) -> Self {
                self.repl_mode = Some(repl_mode.into());
                self
            }
            pub fn allow_unsafe_eval_blocked_by_csp(
                mut self,
                allow_unsafe_eval_blocked_by_csp: impl Into<bool>,
            ) -> Self {
                self.allow_unsafe_eval_blocked_by_csp =
                    Some(allow_unsafe_eval_blocked_by_csp.into());
                self
            }
            pub fn eval_as_function_fallback(
                mut self,
                eval_as_function_fallback: impl Into<bool>,
            ) -> Self {
                self.eval_as_function_fallback = Some(eval_as_function_fallback.into());
                self
            }
            pub fn build(self) -> Result<EvaluateParams, String> {
                Ok(EvaluateParams {
                    expression: self.expression.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(expression))
                    })?,
                    object_group: self.object_group,
                    include_command_line_api: self.include_command_line_api,
                    silent: self.silent,
                    context_id: self.context_id,
                    return_by_value: self.return_by_value,
                    generate_preview: self.generate_preview,
                    user_gesture: self.user_gesture,
                    await_promise: self.await_promise,
                    throw_on_side_effect: self.throw_on_side_effect,
                    timeout: self.timeout,
                    disable_breaks: self.disable_breaks,
                    repl_mode: self.repl_mode,
                    allow_unsafe_eval_blocked_by_csp: self.allow_unsafe_eval_blocked_by_csp,
                    eval_as_function_fallback: self.eval_as_function_fallback,
                })
            }
        }
        impl EvaluateParams {
            pub const IDENTIFIER: &'static str = "Runtime.evaluate";
        }
        impl chromiumoxide_types::Method for EvaluateParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EvaluateParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Evaluates expression on global object.\n[evaluate](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-evaluate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EvaluateReturns {
            #[doc = "Evaluation result."]
            #[serde(rename = "result")]
            pub result: RemoteObject,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
            #[doc = r" This is a manually added field that is not part of the protocol definition, hence ignored during serde operations."]
            #[doc = r""]
            #[doc = r" If set to true, this field indicates, that if the command resulted in a response value of type `function` this, `EvaluateParams` command should be executed as a `CallFunctionOnParams` instead."]
            #[serde(skip)]
            pub eval_as_function_fallback: Option<bool>,
        }
        impl EvaluateReturns {
            pub fn new(result: impl Into<RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                    eval_as_function_fallback: None,
                }
            }
        }
        impl EvaluateReturns {
            pub fn builder() -> EvaluateReturnsBuilder {
                EvaluateReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EvaluateReturnsBuilder {
            result: Option<RemoteObject>,
            exception_details: Option<ExceptionDetails>,
            eval_as_function_fallback: Option<bool>,
        }
        impl EvaluateReturnsBuilder {
            pub fn result(mut self, result: impl Into<RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn eval_as_function_fallback(
                mut self,
                eval_as_function_fallback: impl Into<bool>,
            ) -> Self {
                self.eval_as_function_fallback = Some(eval_as_function_fallback.into());
                self
            }
            pub fn build(self) -> Result<EvaluateReturns, String> {
                Ok(EvaluateReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                    eval_as_function_fallback: self.eval_as_function_fallback,
                })
            }
        }
        impl chromiumoxide_types::Command for EvaluateParams {
            type Response = EvaluateReturns;
        }
        #[doc = "Returns the isolate id.\n[getIsolateId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getIsolateId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetIsolateIdParams {}
        impl GetIsolateIdParams {
            pub const IDENTIFIER: &'static str = "Runtime.getIsolateId";
        }
        impl chromiumoxide_types::Method for GetIsolateIdParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetIsolateIdParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns the isolate id.\n[getIsolateId](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getIsolateId)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetIsolateIdReturns {
            #[doc = "The isolate id."]
            #[serde(rename = "id")]
            pub id: String,
        }
        impl GetIsolateIdReturns {
            pub fn new(id: impl Into<String>) -> Self {
                Self { id: id.into() }
            }
        }
        impl<T: Into<String>> From<T> for GetIsolateIdReturns {
            fn from(url: T) -> Self {
                GetIsolateIdReturns::new(url)
            }
        }
        impl GetIsolateIdReturns {
            pub fn builder() -> GetIsolateIdReturnsBuilder {
                GetIsolateIdReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetIsolateIdReturnsBuilder {
            id: Option<String>,
        }
        impl GetIsolateIdReturnsBuilder {
            pub fn id(mut self, id: impl Into<String>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn build(self) -> Result<GetIsolateIdReturns, String> {
                Ok(GetIsolateIdReturns {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetIsolateIdParams {
            type Response = GetIsolateIdReturns;
        }
        #[doc = "Returns the JavaScript heap usage.\nIt is the total usage of the corresponding isolate not scoped to a particular Runtime.\n[getHeapUsage](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getHeapUsage)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetHeapUsageParams {}
        impl GetHeapUsageParams {
            pub const IDENTIFIER: &'static str = "Runtime.getHeapUsage";
        }
        impl chromiumoxide_types::Method for GetHeapUsageParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetHeapUsageParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns the JavaScript heap usage.\nIt is the total usage of the corresponding isolate not scoped to a particular Runtime.\n[getHeapUsage](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getHeapUsage)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetHeapUsageReturns {
            #[doc = "Used heap size in bytes."]
            #[serde(rename = "usedSize")]
            pub used_size: f64,
            #[doc = "Allocated heap size in bytes."]
            #[serde(rename = "totalSize")]
            pub total_size: f64,
        }
        impl GetHeapUsageReturns {
            pub fn new(used_size: impl Into<f64>, total_size: impl Into<f64>) -> Self {
                Self {
                    used_size: used_size.into(),
                    total_size: total_size.into(),
                }
            }
        }
        impl GetHeapUsageReturns {
            pub fn builder() -> GetHeapUsageReturnsBuilder {
                GetHeapUsageReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetHeapUsageReturnsBuilder {
            used_size: Option<f64>,
            total_size: Option<f64>,
        }
        impl GetHeapUsageReturnsBuilder {
            pub fn used_size(mut self, used_size: impl Into<f64>) -> Self {
                self.used_size = Some(used_size.into());
                self
            }
            pub fn total_size(mut self, total_size: impl Into<f64>) -> Self {
                self.total_size = Some(total_size.into());
                self
            }
            pub fn build(self) -> Result<GetHeapUsageReturns, String> {
                Ok(GetHeapUsageReturns {
                    used_size: self.used_size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(used_size))
                    })?,
                    total_size: self.total_size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(total_size))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetHeapUsageParams {
            type Response = GetHeapUsageReturns;
        }
        #[doc = "Returns properties of a given object. Object group of the result is inherited from the target\nobject.\n[getProperties](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getProperties)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPropertiesParams {
            #[doc = "Identifier of the object to return properties for."]
            #[serde(rename = "objectId")]
            pub object_id: RemoteObjectId,
            #[doc = "If true, returns properties belonging only to the element itself, not to its prototype\nchain."]
            #[serde(rename = "ownProperties")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub own_properties: Option<bool>,
            #[doc = "If true, returns accessor properties (with getter/setter) only; internal properties are not\nreturned either."]
            #[serde(rename = "accessorPropertiesOnly")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub accessor_properties_only: Option<bool>,
            #[doc = "Whether preview should be generated for the results."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
        }
        impl GetPropertiesParams {
            pub fn new(object_id: impl Into<RemoteObjectId>) -> Self {
                Self {
                    object_id: object_id.into(),
                    own_properties: None,
                    accessor_properties_only: None,
                    generate_preview: None,
                }
            }
        }
        impl GetPropertiesParams {
            pub fn builder() -> GetPropertiesParamsBuilder {
                GetPropertiesParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPropertiesParamsBuilder {
            object_id: Option<RemoteObjectId>,
            own_properties: Option<bool>,
            accessor_properties_only: Option<bool>,
            generate_preview: Option<bool>,
        }
        impl GetPropertiesParamsBuilder {
            pub fn object_id(mut self, object_id: impl Into<RemoteObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn own_properties(mut self, own_properties: impl Into<bool>) -> Self {
                self.own_properties = Some(own_properties.into());
                self
            }
            pub fn accessor_properties_only(
                mut self,
                accessor_properties_only: impl Into<bool>,
            ) -> Self {
                self.accessor_properties_only = Some(accessor_properties_only.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn build(self) -> Result<GetPropertiesParams, String> {
                Ok(GetPropertiesParams {
                    object_id: self.object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_id))
                    })?,
                    own_properties: self.own_properties,
                    accessor_properties_only: self.accessor_properties_only,
                    generate_preview: self.generate_preview,
                })
            }
        }
        impl GetPropertiesParams {
            pub const IDENTIFIER: &'static str = "Runtime.getProperties";
        }
        impl chromiumoxide_types::Method for GetPropertiesParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetPropertiesParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns properties of a given object. Object group of the result is inherited from the target\nobject.\n[getProperties](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-getProperties)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPropertiesReturns {
            #[doc = "Object properties."]
            #[serde(rename = "result")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub result: Vec<PropertyDescriptor>,
            #[doc = "Internal object properties (only of the element itself)."]
            #[serde(rename = "internalProperties")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub internal_properties: Option<Vec<InternalPropertyDescriptor>>,
            #[doc = "Object private properties."]
            #[serde(rename = "privateProperties")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub private_properties: Option<Vec<PrivatePropertyDescriptor>>,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
        }
        impl GetPropertiesReturns {
            pub fn new(result: Vec<PropertyDescriptor>) -> Self {
                Self {
                    result,
                    internal_properties: None,
                    private_properties: None,
                    exception_details: None,
                }
            }
        }
        impl GetPropertiesReturns {
            pub fn builder() -> GetPropertiesReturnsBuilder {
                GetPropertiesReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPropertiesReturnsBuilder {
            result: Option<Vec<PropertyDescriptor>>,
            internal_properties: Option<Vec<InternalPropertyDescriptor>>,
            private_properties: Option<Vec<PrivatePropertyDescriptor>>,
            exception_details: Option<ExceptionDetails>,
        }
        impl GetPropertiesReturnsBuilder {
            pub fn result(mut self, result: impl Into<PropertyDescriptor>) -> Self {
                let v = self.result.get_or_insert(Vec::new());
                v.push(result.into());
                self
            }
            pub fn results<I, S>(mut self, results: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<PropertyDescriptor>,
            {
                let v = self.result.get_or_insert(Vec::new());
                for val in results {
                    v.push(val.into());
                }
                self
            }
            pub fn internal_propertie(
                mut self,
                internal_propertie: impl Into<InternalPropertyDescriptor>,
            ) -> Self {
                let v = self.internal_properties.get_or_insert(Vec::new());
                v.push(internal_propertie.into());
                self
            }
            pub fn internal_properties<I, S>(mut self, internal_properties: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<InternalPropertyDescriptor>,
            {
                let v = self.internal_properties.get_or_insert(Vec::new());
                for val in internal_properties {
                    v.push(val.into());
                }
                self
            }
            pub fn private_propertie(
                mut self,
                private_propertie: impl Into<PrivatePropertyDescriptor>,
            ) -> Self {
                let v = self.private_properties.get_or_insert(Vec::new());
                v.push(private_propertie.into());
                self
            }
            pub fn private_properties<I, S>(mut self, private_properties: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<PrivatePropertyDescriptor>,
            {
                let v = self.private_properties.get_or_insert(Vec::new());
                for val in private_properties {
                    v.push(val.into());
                }
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<GetPropertiesReturns, String> {
                Ok(GetPropertiesReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    internal_properties: self.internal_properties,
                    private_properties: self.private_properties,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for GetPropertiesParams {
            type Response = GetPropertiesReturns;
        }
        #[doc = "Returns all let, const and class variables from global scope.\n[globalLexicalScopeNames](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-globalLexicalScopeNames)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GlobalLexicalScopeNamesParams {
            #[doc = "Specifies in which execution context to lookup global scope variables."]
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
        }
        impl GlobalLexicalScopeNamesParams {
            pub fn builder() -> GlobalLexicalScopeNamesParamsBuilder {
                GlobalLexicalScopeNamesParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GlobalLexicalScopeNamesParamsBuilder {
            execution_context_id: Option<ExecutionContextId>,
        }
        impl GlobalLexicalScopeNamesParamsBuilder {
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn build(self) -> GlobalLexicalScopeNamesParams {
                GlobalLexicalScopeNamesParams {
                    execution_context_id: self.execution_context_id,
                }
            }
        }
        impl GlobalLexicalScopeNamesParams {
            pub const IDENTIFIER: &'static str = "Runtime.globalLexicalScopeNames";
        }
        impl chromiumoxide_types::Method for GlobalLexicalScopeNamesParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GlobalLexicalScopeNamesParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns all let, const and class variables from global scope.\n[globalLexicalScopeNames](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-globalLexicalScopeNames)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GlobalLexicalScopeNamesReturns {
            #[serde(rename = "names")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub names: Vec<String>,
        }
        impl GlobalLexicalScopeNamesReturns {
            pub fn new(names: Vec<String>) -> Self {
                Self { names }
            }
        }
        impl GlobalLexicalScopeNamesReturns {
            pub fn builder() -> GlobalLexicalScopeNamesReturnsBuilder {
                GlobalLexicalScopeNamesReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GlobalLexicalScopeNamesReturnsBuilder {
            names: Option<Vec<String>>,
        }
        impl GlobalLexicalScopeNamesReturnsBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                let v = self.names.get_or_insert(Vec::new());
                v.push(name.into());
                self
            }
            pub fn names<I, S>(mut self, names: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<String>,
            {
                let v = self.names.get_or_insert(Vec::new());
                for val in names {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GlobalLexicalScopeNamesReturns, String> {
                Ok(GlobalLexicalScopeNamesReturns {
                    names: self.names.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(names))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GlobalLexicalScopeNamesParams {
            type Response = GlobalLexicalScopeNamesReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct QueryObjectsParams {
            #[doc = "Identifier of the prototype to return objects for."]
            #[serde(rename = "prototypeObjectId")]
            pub prototype_object_id: RemoteObjectId,
            #[doc = "Symbolic group name that can be used to release the results."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
        }
        impl QueryObjectsParams {
            pub fn new(prototype_object_id: impl Into<RemoteObjectId>) -> Self {
                Self {
                    prototype_object_id: prototype_object_id.into(),
                    object_group: None,
                }
            }
        }
        impl QueryObjectsParams {
            pub fn builder() -> QueryObjectsParamsBuilder {
                QueryObjectsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct QueryObjectsParamsBuilder {
            prototype_object_id: Option<RemoteObjectId>,
            object_group: Option<String>,
        }
        impl QueryObjectsParamsBuilder {
            pub fn prototype_object_id(
                mut self,
                prototype_object_id: impl Into<RemoteObjectId>,
            ) -> Self {
                self.prototype_object_id = Some(prototype_object_id.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn build(self) -> Result<QueryObjectsParams, String> {
                Ok(QueryObjectsParams {
                    prototype_object_id: self.prototype_object_id.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(prototype_object_id)
                        )
                    })?,
                    object_group: self.object_group,
                })
            }
        }
        impl QueryObjectsParams {
            pub const IDENTIFIER: &'static str = "Runtime.queryObjects";
        }
        impl chromiumoxide_types::Method for QueryObjectsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for QueryObjectsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct QueryObjectsReturns {
            #[doc = "Array with objects."]
            #[serde(rename = "objects")]
            pub objects: RemoteObject,
        }
        impl QueryObjectsReturns {
            pub fn new(objects: impl Into<RemoteObject>) -> Self {
                Self {
                    objects: objects.into(),
                }
            }
        }
        impl QueryObjectsReturns {
            pub fn builder() -> QueryObjectsReturnsBuilder {
                QueryObjectsReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct QueryObjectsReturnsBuilder {
            objects: Option<RemoteObject>,
        }
        impl QueryObjectsReturnsBuilder {
            pub fn objects(mut self, objects: impl Into<RemoteObject>) -> Self {
                self.objects = Some(objects.into());
                self
            }
            pub fn build(self) -> Result<QueryObjectsReturns, String> {
                Ok(QueryObjectsReturns {
                    objects: self.objects.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(objects))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for QueryObjectsParams {
            type Response = QueryObjectsReturns;
        }
        #[doc = "Releases remote object with given id.\n[releaseObject](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-releaseObject)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ReleaseObjectParams {
            #[doc = "Identifier of the object to release."]
            #[serde(rename = "objectId")]
            pub object_id: RemoteObjectId,
        }
        impl ReleaseObjectParams {
            pub fn new(object_id: impl Into<RemoteObjectId>) -> Self {
                Self {
                    object_id: object_id.into(),
                }
            }
        }
        impl ReleaseObjectParams {
            pub fn builder() -> ReleaseObjectParamsBuilder {
                ReleaseObjectParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ReleaseObjectParamsBuilder {
            object_id: Option<RemoteObjectId>,
        }
        impl ReleaseObjectParamsBuilder {
            pub fn object_id(mut self, object_id: impl Into<RemoteObjectId>) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn build(self) -> Result<ReleaseObjectParams, String> {
                Ok(ReleaseObjectParams {
                    object_id: self.object_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_id))
                    })?,
                })
            }
        }
        impl ReleaseObjectParams {
            pub const IDENTIFIER: &'static str = "Runtime.releaseObject";
        }
        impl chromiumoxide_types::Method for ReleaseObjectParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ReleaseObjectParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Releases remote object with given id.\n[releaseObject](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-releaseObject)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ReleaseObjectReturns {}
        impl chromiumoxide_types::Command for ReleaseObjectParams {
            type Response = ReleaseObjectReturns;
        }
        #[doc = "Releases all remote objects that belong to a given group.\n[releaseObjectGroup](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-releaseObjectGroup)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ReleaseObjectGroupParams {
            #[doc = "Symbolic object group name."]
            #[serde(rename = "objectGroup")]
            pub object_group: String,
        }
        impl ReleaseObjectGroupParams {
            pub fn new(object_group: impl Into<String>) -> Self {
                Self {
                    object_group: object_group.into(),
                }
            }
        }
        impl<T: Into<String>> From<T> for ReleaseObjectGroupParams {
            fn from(url: T) -> Self {
                ReleaseObjectGroupParams::new(url)
            }
        }
        impl ReleaseObjectGroupParams {
            pub fn builder() -> ReleaseObjectGroupParamsBuilder {
                ReleaseObjectGroupParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ReleaseObjectGroupParamsBuilder {
            object_group: Option<String>,
        }
        impl ReleaseObjectGroupParamsBuilder {
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn build(self) -> Result<ReleaseObjectGroupParams, String> {
                Ok(ReleaseObjectGroupParams {
                    object_group: self.object_group.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(object_group))
                    })?,
                })
            }
        }
        impl ReleaseObjectGroupParams {
            pub const IDENTIFIER: &'static str = "Runtime.releaseObjectGroup";
        }
        impl chromiumoxide_types::Method for ReleaseObjectGroupParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ReleaseObjectGroupParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Releases all remote objects that belong to a given group.\n[releaseObjectGroup](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-releaseObjectGroup)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ReleaseObjectGroupReturns {}
        impl chromiumoxide_types::Command for ReleaseObjectGroupParams {
            type Response = ReleaseObjectGroupReturns;
        }
        #[doc = "Tells inspected instance to run if it was waiting for debugger to attach.\n[runIfWaitingForDebugger](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-runIfWaitingForDebugger)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct RunIfWaitingForDebuggerParams {}
        impl RunIfWaitingForDebuggerParams {
            pub const IDENTIFIER: &'static str = "Runtime.runIfWaitingForDebugger";
        }
        impl chromiumoxide_types::Method for RunIfWaitingForDebuggerParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for RunIfWaitingForDebuggerParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Tells inspected instance to run if it was waiting for debugger to attach.\n[runIfWaitingForDebugger](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-runIfWaitingForDebugger)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct RunIfWaitingForDebuggerReturns {}
        impl chromiumoxide_types::Command for RunIfWaitingForDebuggerParams {
            type Response = RunIfWaitingForDebuggerReturns;
        }
        #[doc = "Runs script with given id in a given context.\n[runScript](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-runScript)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RunScriptParams {
            #[doc = "Id of the script to run."]
            #[serde(rename = "scriptId")]
            pub script_id: ScriptId,
            #[doc = "Specifies in which execution context to perform script run. If the parameter is omitted the\nevaluation will be performed in the context of the inspected page."]
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
            #[doc = "Symbolic group name that can be used to release multiple objects."]
            #[serde(rename = "objectGroup")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_group: Option<String>,
            #[doc = "In silent mode exceptions thrown during evaluation are not reported and do not pause\nexecution. Overrides `setPauseOnException` state."]
            #[serde(rename = "silent")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub silent: Option<bool>,
            #[doc = "Determines whether Command Line API should be available during the evaluation."]
            #[serde(rename = "includeCommandLineAPI")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub include_command_line_api: Option<bool>,
            #[doc = "Whether the result is expected to be a JSON object which should be sent by value."]
            #[serde(rename = "returnByValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub return_by_value: Option<bool>,
            #[doc = "Whether preview should be generated for the result."]
            #[serde(rename = "generatePreview")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub generate_preview: Option<bool>,
            #[doc = "Whether execution should `await` for resulting value and return once awaited promise is\nresolved."]
            #[serde(rename = "awaitPromise")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub await_promise: Option<bool>,
        }
        impl RunScriptParams {
            pub fn new(script_id: impl Into<ScriptId>) -> Self {
                Self {
                    script_id: script_id.into(),
                    execution_context_id: None,
                    object_group: None,
                    silent: None,
                    include_command_line_api: None,
                    return_by_value: None,
                    generate_preview: None,
                    await_promise: None,
                }
            }
        }
        impl RunScriptParams {
            pub fn builder() -> RunScriptParamsBuilder {
                RunScriptParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RunScriptParamsBuilder {
            script_id: Option<ScriptId>,
            execution_context_id: Option<ExecutionContextId>,
            object_group: Option<String>,
            silent: Option<bool>,
            include_command_line_api: Option<bool>,
            return_by_value: Option<bool>,
            generate_preview: Option<bool>,
            await_promise: Option<bool>,
        }
        impl RunScriptParamsBuilder {
            pub fn script_id(mut self, script_id: impl Into<ScriptId>) -> Self {
                self.script_id = Some(script_id.into());
                self
            }
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn object_group(mut self, object_group: impl Into<String>) -> Self {
                self.object_group = Some(object_group.into());
                self
            }
            pub fn silent(mut self, silent: impl Into<bool>) -> Self {
                self.silent = Some(silent.into());
                self
            }
            pub fn include_command_line_api(
                mut self,
                include_command_line_api: impl Into<bool>,
            ) -> Self {
                self.include_command_line_api = Some(include_command_line_api.into());
                self
            }
            pub fn return_by_value(mut self, return_by_value: impl Into<bool>) -> Self {
                self.return_by_value = Some(return_by_value.into());
                self
            }
            pub fn generate_preview(mut self, generate_preview: impl Into<bool>) -> Self {
                self.generate_preview = Some(generate_preview.into());
                self
            }
            pub fn await_promise(mut self, await_promise: impl Into<bool>) -> Self {
                self.await_promise = Some(await_promise.into());
                self
            }
            pub fn build(self) -> Result<RunScriptParams, String> {
                Ok(RunScriptParams {
                    script_id: self.script_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(script_id))
                    })?,
                    execution_context_id: self.execution_context_id,
                    object_group: self.object_group,
                    silent: self.silent,
                    include_command_line_api: self.include_command_line_api,
                    return_by_value: self.return_by_value,
                    generate_preview: self.generate_preview,
                    await_promise: self.await_promise,
                })
            }
        }
        impl RunScriptParams {
            pub const IDENTIFIER: &'static str = "Runtime.runScript";
        }
        impl chromiumoxide_types::Method for RunScriptParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for RunScriptParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Runs script with given id in a given context.\n[runScript](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-runScript)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RunScriptReturns {
            #[doc = "Run result."]
            #[serde(rename = "result")]
            pub result: RemoteObject,
            #[doc = "Exception details."]
            #[serde(rename = "exceptionDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub exception_details: Option<ExceptionDetails>,
        }
        impl RunScriptReturns {
            pub fn new(result: impl Into<RemoteObject>) -> Self {
                Self {
                    result: result.into(),
                    exception_details: None,
                }
            }
        }
        impl RunScriptReturns {
            pub fn builder() -> RunScriptReturnsBuilder {
                RunScriptReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RunScriptReturnsBuilder {
            result: Option<RemoteObject>,
            exception_details: Option<ExceptionDetails>,
        }
        impl RunScriptReturnsBuilder {
            pub fn result(mut self, result: impl Into<RemoteObject>) -> Self {
                self.result = Some(result.into());
                self
            }
            pub fn exception_details(
                mut self,
                exception_details: impl Into<ExceptionDetails>,
            ) -> Self {
                self.exception_details = Some(exception_details.into());
                self
            }
            pub fn build(self) -> Result<RunScriptReturns, String> {
                Ok(RunScriptReturns {
                    result: self.result.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(result))
                    })?,
                    exception_details: self.exception_details,
                })
            }
        }
        impl chromiumoxide_types::Command for RunScriptParams {
            type Response = RunScriptReturns;
        }
        #[doc = "Enables or disables async call stacks tracking.\n[setAsyncCallStackDepth](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-setAsyncCallStackDepth)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetAsyncCallStackDepthParams {
            #[doc = "Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async\ncall stacks (default)."]
            #[serde(rename = "maxDepth")]
            pub max_depth: i64,
        }
        impl SetAsyncCallStackDepthParams {
            pub fn new(max_depth: impl Into<i64>) -> Self {
                Self {
                    max_depth: max_depth.into(),
                }
            }
        }
        impl SetAsyncCallStackDepthParams {
            pub fn builder() -> SetAsyncCallStackDepthParamsBuilder {
                SetAsyncCallStackDepthParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetAsyncCallStackDepthParamsBuilder {
            max_depth: Option<i64>,
        }
        impl SetAsyncCallStackDepthParamsBuilder {
            pub fn max_depth(mut self, max_depth: impl Into<i64>) -> Self {
                self.max_depth = Some(max_depth.into());
                self
            }
            pub fn build(self) -> Result<SetAsyncCallStackDepthParams, String> {
                Ok(SetAsyncCallStackDepthParams {
                    max_depth: self.max_depth.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(max_depth))
                    })?,
                })
            }
        }
        impl SetAsyncCallStackDepthParams {
            pub const IDENTIFIER: &'static str = "Runtime.setAsyncCallStackDepth";
        }
        impl chromiumoxide_types::Method for SetAsyncCallStackDepthParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetAsyncCallStackDepthParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables or disables async call stacks tracking.\n[setAsyncCallStackDepth](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-setAsyncCallStackDepth)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetAsyncCallStackDepthReturns {}
        impl chromiumoxide_types::Command for SetAsyncCallStackDepthParams {
            type Response = SetAsyncCallStackDepthReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetCustomObjectFormatterEnabledParams {
            #[serde(rename = "enabled")]
            pub enabled: bool,
        }
        impl SetCustomObjectFormatterEnabledParams {
            pub fn new(enabled: impl Into<bool>) -> Self {
                Self {
                    enabled: enabled.into(),
                }
            }
        }
        impl SetCustomObjectFormatterEnabledParams {
            pub fn builder() -> SetCustomObjectFormatterEnabledParamsBuilder {
                SetCustomObjectFormatterEnabledParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetCustomObjectFormatterEnabledParamsBuilder {
            enabled: Option<bool>,
        }
        impl SetCustomObjectFormatterEnabledParamsBuilder {
            pub fn enabled(mut self, enabled: impl Into<bool>) -> Self {
                self.enabled = Some(enabled.into());
                self
            }
            pub fn build(self) -> Result<SetCustomObjectFormatterEnabledParams, String> {
                Ok(SetCustomObjectFormatterEnabledParams {
                    enabled: self.enabled.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(enabled))
                    })?,
                })
            }
        }
        impl SetCustomObjectFormatterEnabledParams {
            pub const IDENTIFIER: &'static str = "Runtime.setCustomObjectFormatterEnabled";
        }
        impl chromiumoxide_types::Method for SetCustomObjectFormatterEnabledParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetCustomObjectFormatterEnabledParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetCustomObjectFormatterEnabledReturns {}
        impl chromiumoxide_types::Command for SetCustomObjectFormatterEnabledParams {
            type Response = SetCustomObjectFormatterEnabledReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetMaxCallStackSizeToCaptureParams {
            #[serde(rename = "size")]
            pub size: i64,
        }
        impl SetMaxCallStackSizeToCaptureParams {
            pub fn new(size: impl Into<i64>) -> Self {
                Self { size: size.into() }
            }
        }
        impl SetMaxCallStackSizeToCaptureParams {
            pub fn builder() -> SetMaxCallStackSizeToCaptureParamsBuilder {
                SetMaxCallStackSizeToCaptureParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetMaxCallStackSizeToCaptureParamsBuilder {
            size: Option<i64>,
        }
        impl SetMaxCallStackSizeToCaptureParamsBuilder {
            pub fn size(mut self, size: impl Into<i64>) -> Self {
                self.size = Some(size.into());
                self
            }
            pub fn build(self) -> Result<SetMaxCallStackSizeToCaptureParams, String> {
                Ok(SetMaxCallStackSizeToCaptureParams {
                    size: self.size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(size))
                    })?,
                })
            }
        }
        impl SetMaxCallStackSizeToCaptureParams {
            pub const IDENTIFIER: &'static str = "Runtime.setMaxCallStackSizeToCapture";
        }
        impl chromiumoxide_types::Method for SetMaxCallStackSizeToCaptureParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetMaxCallStackSizeToCaptureParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetMaxCallStackSizeToCaptureReturns {}
        impl chromiumoxide_types::Command for SetMaxCallStackSizeToCaptureParams {
            type Response = SetMaxCallStackSizeToCaptureReturns;
        }
        #[doc = "Terminate current or next JavaScript execution.\nWill cancel the termination when the outer-most script execution ends.\n[terminateExecution](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-terminateExecution)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TerminateExecutionParams {}
        impl TerminateExecutionParams {
            pub const IDENTIFIER: &'static str = "Runtime.terminateExecution";
        }
        impl chromiumoxide_types::Method for TerminateExecutionParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for TerminateExecutionParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Terminate current or next JavaScript execution.\nWill cancel the termination when the outer-most script execution ends.\n[terminateExecution](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-terminateExecution)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct TerminateExecutionReturns {}
        impl chromiumoxide_types::Command for TerminateExecutionParams {
            type Response = TerminateExecutionReturns;
        }
        #[doc = "If executionContextId is empty, adds binding with the given name on the\nglobal objects of all inspected contexts, including those created later,\nbindings survive reloads.\nIf executionContextId is specified, adds binding only on global object of\ngiven execution context.\nBinding function takes exactly one argument, this argument should be string,\nin case of any other input, function throws an exception.\nEach binding function call produces Runtime.bindingCalled notification.\n[addBinding](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-addBinding)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AddBindingParams {
            #[serde(rename = "name")]
            pub name: String,
            #[serde(rename = "executionContextId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub execution_context_id: Option<ExecutionContextId>,
        }
        impl AddBindingParams {
            pub fn new(name: impl Into<String>) -> Self {
                Self {
                    name: name.into(),
                    execution_context_id: None,
                }
            }
        }
        impl<T: Into<String>> From<T> for AddBindingParams {
            fn from(url: T) -> Self {
                AddBindingParams::new(url)
            }
        }
        impl AddBindingParams {
            pub fn builder() -> AddBindingParamsBuilder {
                AddBindingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AddBindingParamsBuilder {
            name: Option<String>,
            execution_context_id: Option<ExecutionContextId>,
        }
        impl AddBindingParamsBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn execution_context_id(
                mut self,
                execution_context_id: impl Into<ExecutionContextId>,
            ) -> Self {
                self.execution_context_id = Some(execution_context_id.into());
                self
            }
            pub fn build(self) -> Result<AddBindingParams, String> {
                Ok(AddBindingParams {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    execution_context_id: self.execution_context_id,
                })
            }
        }
        impl AddBindingParams {
            pub const IDENTIFIER: &'static str = "Runtime.addBinding";
        }
        impl chromiumoxide_types::Method for AddBindingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for AddBindingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "If executionContextId is empty, adds binding with the given name on the\nglobal objects of all inspected contexts, including those created later,\nbindings survive reloads.\nIf executionContextId is specified, adds binding only on global object of\ngiven execution context.\nBinding function takes exactly one argument, this argument should be string,\nin case of any other input, function throws an exception.\nEach binding function call produces Runtime.bindingCalled notification.\n[addBinding](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-addBinding)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct AddBindingReturns {}
        impl chromiumoxide_types::Command for AddBindingParams {
            type Response = AddBindingReturns;
        }
        #[doc = "This method does not remove binding function from global object but\nunsubscribes current runtime agent from Runtime.bindingCalled notifications.\n[removeBinding](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-removeBinding)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct RemoveBindingParams {
            #[serde(rename = "name")]
            pub name: String,
        }
        impl RemoveBindingParams {
            pub fn new(name: impl Into<String>) -> Self {
                Self { name: name.into() }
            }
        }
        impl<T: Into<String>> From<T> for RemoveBindingParams {
            fn from(url: T) -> Self {
                RemoveBindingParams::new(url)
            }
        }
        impl RemoveBindingParams {
            pub fn builder() -> RemoveBindingParamsBuilder {
                RemoveBindingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct RemoveBindingParamsBuilder {
            name: Option<String>,
        }
        impl RemoveBindingParamsBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn build(self) -> Result<RemoveBindingParams, String> {
                Ok(RemoveBindingParams {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                })
            }
        }
        impl RemoveBindingParams {
            pub const IDENTIFIER: &'static str = "Runtime.removeBinding";
        }
        impl chromiumoxide_types::Method for RemoveBindingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for RemoveBindingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "This method does not remove binding function from global object but\nunsubscribes current runtime agent from Runtime.bindingCalled notifications.\n[removeBinding](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#method-removeBinding)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct RemoveBindingReturns {}
        impl chromiumoxide_types::Command for RemoveBindingParams {
            type Response = RemoveBindingReturns;
        }
        #[doc = "Notification is issued every time when binding is called.\n[bindingCalled](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-bindingCalled)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventBindingCalled {
            #[serde(rename = "name")]
            pub name: String,
            #[serde(rename = "payload")]
            pub payload: String,
            #[doc = "Identifier of the context where the call was made."]
            #[serde(rename = "executionContextId")]
            pub execution_context_id: ExecutionContextId,
        }
        impl EventBindingCalled {
            pub const IDENTIFIER: &'static str = "Runtime.bindingCalled";
        }
        impl chromiumoxide_types::Method for EventBindingCalled {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventBindingCalled {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when console API was called.\n[consoleAPICalled](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-consoleAPICalled)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventConsoleApiCalled {
            #[doc = "Type of the call."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: ConsoleApiCalledType,
            #[doc = "Call arguments."]
            #[serde(rename = "args")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub args: Vec<RemoteObject>,
            #[doc = "Identifier of the context where the call was made."]
            #[serde(rename = "executionContextId")]
            pub execution_context_id: ExecutionContextId,
            #[doc = "Call timestamp."]
            #[serde(rename = "timestamp")]
            pub timestamp: Timestamp,
            #[doc = "Stack trace captured when the call was made. The async stack chain is automatically reported for\nthe following call types: `assert`, `error`, `trace`, `warning`. For other types the async call\nchain can be retrieved using `Debugger.getStackTrace` and `stackTrace.parentId` field."]
            #[serde(rename = "stackTrace")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub stack_trace: Option<StackTrace>,
            #[doc = "Console context descriptor for calls on non-default console context (not console.*):\n'anonymous#unique-logger-id' for call on unnamed context, 'name#unique-logger-id' for call\non named context."]
            #[serde(rename = "context")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub context: Option<String>,
        }
        #[doc = "Type of the call."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ConsoleApiCalledType {
            #[serde(rename = "log")]
            Log,
            #[serde(rename = "debug")]
            Debug,
            #[serde(rename = "info")]
            Info,
            #[serde(rename = "error")]
            Error,
            #[serde(rename = "warning")]
            Warning,
            #[serde(rename = "dir")]
            Dir,
            #[serde(rename = "dirxml")]
            Dirxml,
            #[serde(rename = "table")]
            Table,
            #[serde(rename = "trace")]
            Trace,
            #[serde(rename = "clear")]
            Clear,
            #[serde(rename = "startGroup")]
            StartGroup,
            #[serde(rename = "startGroupCollapsed")]
            StartGroupCollapsed,
            #[serde(rename = "endGroup")]
            EndGroup,
            #[serde(rename = "assert")]
            Assert,
            #[serde(rename = "profile")]
            Profile,
            #[serde(rename = "profileEnd")]
            ProfileEnd,
            #[serde(rename = "count")]
            Count,
            #[serde(rename = "timeEnd")]
            TimeEnd,
        }
        impl AsRef<str> for ConsoleApiCalledType {
            fn as_ref(&self) -> &str {
                match self {
                    ConsoleApiCalledType::Log => "log",
                    ConsoleApiCalledType::Debug => "debug",
                    ConsoleApiCalledType::Info => "info",
                    ConsoleApiCalledType::Error => "error",
                    ConsoleApiCalledType::Warning => "warning",
                    ConsoleApiCalledType::Dir => "dir",
                    ConsoleApiCalledType::Dirxml => "dirxml",
                    ConsoleApiCalledType::Table => "table",
                    ConsoleApiCalledType::Trace => "trace",
                    ConsoleApiCalledType::Clear => "clear",
                    ConsoleApiCalledType::StartGroup => "startGroup",
                    ConsoleApiCalledType::StartGroupCollapsed => "startGroupCollapsed",
                    ConsoleApiCalledType::EndGroup => "endGroup",
                    ConsoleApiCalledType::Assert => "assert",
                    ConsoleApiCalledType::Profile => "profile",
                    ConsoleApiCalledType::ProfileEnd => "profileEnd",
                    ConsoleApiCalledType::Count => "count",
                    ConsoleApiCalledType::TimeEnd => "timeEnd",
                }
            }
        }
        impl ::std::str::FromStr for ConsoleApiCalledType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "log" | "Log" => Ok(ConsoleApiCalledType::Log),
                    "debug" | "Debug" => Ok(ConsoleApiCalledType::Debug),
                    "info" | "Info" => Ok(ConsoleApiCalledType::Info),
                    "error" | "Error" => Ok(ConsoleApiCalledType::Error),
                    "warning" | "Warning" => Ok(ConsoleApiCalledType::Warning),
                    "dir" | "Dir" => Ok(ConsoleApiCalledType::Dir),
                    "dirxml" | "Dirxml" => Ok(ConsoleApiCalledType::Dirxml),
                    "table" | "Table" => Ok(ConsoleApiCalledType::Table),
                    "trace" | "Trace" => Ok(ConsoleApiCalledType::Trace),
                    "clear" | "Clear" => Ok(ConsoleApiCalledType::Clear),
                    "startGroup" | "StartGroup" | "startgroup" => {
                        Ok(ConsoleApiCalledType::StartGroup)
                    }
                    "startGroupCollapsed" | "StartGroupCollapsed" | "startgroupcollapsed" => {
                        Ok(ConsoleApiCalledType::StartGroupCollapsed)
                    }
                    "endGroup" | "EndGroup" | "endgroup" => Ok(ConsoleApiCalledType::EndGroup),
                    "assert" | "Assert" => Ok(ConsoleApiCalledType::Assert),
                    "profile" | "Profile" => Ok(ConsoleApiCalledType::Profile),
                    "profileEnd" | "ProfileEnd" | "profileend" => {
                        Ok(ConsoleApiCalledType::ProfileEnd)
                    }
                    "count" | "Count" => Ok(ConsoleApiCalledType::Count),
                    "timeEnd" | "TimeEnd" | "timeend" => Ok(ConsoleApiCalledType::TimeEnd),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl EventConsoleApiCalled {
            pub const IDENTIFIER: &'static str = "Runtime.consoleAPICalled";
        }
        impl chromiumoxide_types::Method for EventConsoleApiCalled {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventConsoleApiCalled {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when unhandled exception was revoked.\n[exceptionRevoked](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-exceptionRevoked)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventExceptionRevoked {
            #[doc = "Reason describing why exception was revoked."]
            #[serde(rename = "reason")]
            pub reason: String,
            #[doc = "The id of revoked exception, as reported in `exceptionThrown`."]
            #[serde(rename = "exceptionId")]
            pub exception_id: i64,
        }
        impl EventExceptionRevoked {
            pub const IDENTIFIER: &'static str = "Runtime.exceptionRevoked";
        }
        impl chromiumoxide_types::Method for EventExceptionRevoked {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventExceptionRevoked {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when exception was thrown and unhandled.\n[exceptionThrown](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-exceptionThrown)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventExceptionThrown {
            #[doc = "Timestamp of the exception."]
            #[serde(rename = "timestamp")]
            pub timestamp: Timestamp,
            #[serde(rename = "exceptionDetails")]
            pub exception_details: ExceptionDetails,
        }
        impl EventExceptionThrown {
            pub const IDENTIFIER: &'static str = "Runtime.exceptionThrown";
        }
        impl chromiumoxide_types::Method for EventExceptionThrown {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventExceptionThrown {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when new execution context is created.\n[executionContextCreated](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-executionContextCreated)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventExecutionContextCreated {
            #[doc = "A newly created execution context."]
            #[serde(rename = "context")]
            pub context: ExecutionContextDescription,
        }
        impl EventExecutionContextCreated {
            pub const IDENTIFIER: &'static str = "Runtime.executionContextCreated";
        }
        impl chromiumoxide_types::Method for EventExecutionContextCreated {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventExecutionContextCreated {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when execution context is destroyed.\n[executionContextDestroyed](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-executionContextDestroyed)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventExecutionContextDestroyed {
            #[doc = "Id of the destroyed context"]
            #[serde(rename = "executionContextId")]
            pub execution_context_id: ExecutionContextId,
        }
        impl EventExecutionContextDestroyed {
            pub const IDENTIFIER: &'static str = "Runtime.executionContextDestroyed";
        }
        impl chromiumoxide_types::Method for EventExecutionContextDestroyed {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventExecutionContextDestroyed {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when all executionContexts were cleared in browser\n[executionContextsCleared](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-executionContextsCleared)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EventExecutionContextsCleared {}
        impl EventExecutionContextsCleared {
            pub const IDENTIFIER: &'static str = "Runtime.executionContextsCleared";
        }
        impl chromiumoxide_types::Method for EventExecutionContextsCleared {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventExecutionContextsCleared {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Issued when object should be inspected (for example, as a result of inspect() command line API\ncall).\n[inspectRequested](https://chromedevtools.github.io/devtools-protocol/tot/Runtime/#event-inspectRequested)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventInspectRequested {
            #[serde(rename = "object")]
            pub object: RemoteObject,
            #[serde(rename = "hints")]
            pub hints: serde_json::Value,
        }
        impl EventInspectRequested {
            pub const IDENTIFIER: &'static str = "Runtime.inspectRequested";
        }
        impl chromiumoxide_types::Method for EventInspectRequested {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventInspectRequested {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
}
#[allow(clippy::wrong_self_convention)]
pub mod browser_protocol {
    #[doc = r" The version of this protocol definition"]
    pub const VERSION: &str = "1.3";
    pub mod accessibility {
        use serde::{Deserialize, Serialize};
        #[doc = "Unique accessibility node identifier.\n[AXNodeId](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#type-AXNodeId)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct AxNodeId(String);
        impl AxNodeId {
            pub fn new(val: impl Into<String>) -> Self {
                AxNodeId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for AxNodeId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<AxNodeId> for String {
            fn from(el: AxNodeId) -> String {
                el.0
            }
        }
        impl From<String> for AxNodeId {
            fn from(expr: String) -> Self {
                AxNodeId(expr)
            }
        }
        impl std::borrow::Borrow<str> for AxNodeId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl AxNodeId {
            pub const IDENTIFIER: &'static str = "Accessibility.AXNodeId";
        }
        #[doc = "Enum of possible property types."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum AxValueType {
            #[serde(rename = "boolean")]
            Boolean,
            #[serde(rename = "tristate")]
            Tristate,
            #[serde(rename = "booleanOrUndefined")]
            BooleanOrUndefined,
            #[serde(rename = "idref")]
            Idref,
            #[serde(rename = "idrefList")]
            IdrefList,
            #[serde(rename = "integer")]
            Integer,
            #[serde(rename = "node")]
            Node,
            #[serde(rename = "nodeList")]
            NodeList,
            #[serde(rename = "number")]
            Number,
            #[serde(rename = "string")]
            String,
            #[serde(rename = "computedString")]
            ComputedString,
            #[serde(rename = "token")]
            Token,
            #[serde(rename = "tokenList")]
            TokenList,
            #[serde(rename = "domRelation")]
            DomRelation,
            #[serde(rename = "role")]
            Role,
            #[serde(rename = "internalRole")]
            InternalRole,
            #[serde(rename = "valueUndefined")]
            ValueUndefined,
        }
        impl AsRef<str> for AxValueType {
            fn as_ref(&self) -> &str {
                match self {
                    AxValueType::Boolean => "boolean",
                    AxValueType::Tristate => "tristate",
                    AxValueType::BooleanOrUndefined => "booleanOrUndefined",
                    AxValueType::Idref => "idref",
                    AxValueType::IdrefList => "idrefList",
                    AxValueType::Integer => "integer",
                    AxValueType::Node => "node",
                    AxValueType::NodeList => "nodeList",
                    AxValueType::Number => "number",
                    AxValueType::String => "string",
                    AxValueType::ComputedString => "computedString",
                    AxValueType::Token => "token",
                    AxValueType::TokenList => "tokenList",
                    AxValueType::DomRelation => "domRelation",
                    AxValueType::Role => "role",
                    AxValueType::InternalRole => "internalRole",
                    AxValueType::ValueUndefined => "valueUndefined",
                }
            }
        }
        impl ::std::str::FromStr for AxValueType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "boolean" | "Boolean" => Ok(AxValueType::Boolean),
                    "tristate" | "Tristate" => Ok(AxValueType::Tristate),
                    "booleanOrUndefined" | "BooleanOrUndefined" | "booleanorundefined" => {
                        Ok(AxValueType::BooleanOrUndefined)
                    }
                    "idref" | "Idref" => Ok(AxValueType::Idref),
                    "idrefList" | "IdrefList" | "idreflist" => Ok(AxValueType::IdrefList),
                    "integer" | "Integer" => Ok(AxValueType::Integer),
                    "node" | "Node" => Ok(AxValueType::Node),
                    "nodeList" | "NodeList" | "nodelist" => Ok(AxValueType::NodeList),
                    "number" | "Number" => Ok(AxValueType::Number),
                    "string" | "String" => Ok(AxValueType::String),
                    "computedString" | "ComputedString" | "computedstring" => {
                        Ok(AxValueType::ComputedString)
                    }
                    "token" | "Token" => Ok(AxValueType::Token),
                    "tokenList" | "TokenList" | "tokenlist" => Ok(AxValueType::TokenList),
                    "domRelation" | "DomRelation" | "domrelation" => Ok(AxValueType::DomRelation),
                    "role" | "Role" => Ok(AxValueType::Role),
                    "internalRole" | "InternalRole" | "internalrole" => {
                        Ok(AxValueType::InternalRole)
                    }
                    "valueUndefined" | "ValueUndefined" | "valueundefined" => {
                        Ok(AxValueType::ValueUndefined)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Enum of possible property sources."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum AxValueSourceType {
            #[serde(rename = "attribute")]
            Attribute,
            #[serde(rename = "implicit")]
            Implicit,
            #[serde(rename = "style")]
            Style,
            #[serde(rename = "contents")]
            Contents,
            #[serde(rename = "placeholder")]
            Placeholder,
            #[serde(rename = "relatedElement")]
            RelatedElement,
        }
        impl AsRef<str> for AxValueSourceType {
            fn as_ref(&self) -> &str {
                match self {
                    AxValueSourceType::Attribute => "attribute",
                    AxValueSourceType::Implicit => "implicit",
                    AxValueSourceType::Style => "style",
                    AxValueSourceType::Contents => "contents",
                    AxValueSourceType::Placeholder => "placeholder",
                    AxValueSourceType::RelatedElement => "relatedElement",
                }
            }
        }
        impl ::std::str::FromStr for AxValueSourceType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "attribute" | "Attribute" => Ok(AxValueSourceType::Attribute),
                    "implicit" | "Implicit" => Ok(AxValueSourceType::Implicit),
                    "style" | "Style" => Ok(AxValueSourceType::Style),
                    "contents" | "Contents" => Ok(AxValueSourceType::Contents),
                    "placeholder" | "Placeholder" => Ok(AxValueSourceType::Placeholder),
                    "relatedElement" | "RelatedElement" | "relatedelement" => {
                        Ok(AxValueSourceType::RelatedElement)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Enum of possible native property sources (as a subtype of a particular AXValueSourceType)."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum AxValueNativeSourceType {
            #[serde(rename = "figcaption")]
            Figcaption,
            #[serde(rename = "label")]
            Label,
            #[serde(rename = "labelfor")]
            Labelfor,
            #[serde(rename = "labelwrapped")]
            Labelwrapped,
            #[serde(rename = "legend")]
            Legend,
            #[serde(rename = "tablecaption")]
            Tablecaption,
            #[serde(rename = "title")]
            Title,
            #[serde(rename = "other")]
            Other,
        }
        impl AsRef<str> for AxValueNativeSourceType {
            fn as_ref(&self) -> &str {
                match self {
                    AxValueNativeSourceType::Figcaption => "figcaption",
                    AxValueNativeSourceType::Label => "label",
                    AxValueNativeSourceType::Labelfor => "labelfor",
                    AxValueNativeSourceType::Labelwrapped => "labelwrapped",
                    AxValueNativeSourceType::Legend => "legend",
                    AxValueNativeSourceType::Tablecaption => "tablecaption",
                    AxValueNativeSourceType::Title => "title",
                    AxValueNativeSourceType::Other => "other",
                }
            }
        }
        impl ::std::str::FromStr for AxValueNativeSourceType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "figcaption" | "Figcaption" => Ok(AxValueNativeSourceType::Figcaption),
                    "label" | "Label" => Ok(AxValueNativeSourceType::Label),
                    "labelfor" | "Labelfor" => Ok(AxValueNativeSourceType::Labelfor),
                    "labelwrapped" | "Labelwrapped" => Ok(AxValueNativeSourceType::Labelwrapped),
                    "legend" | "Legend" => Ok(AxValueNativeSourceType::Legend),
                    "tablecaption" | "Tablecaption" => Ok(AxValueNativeSourceType::Tablecaption),
                    "title" | "Title" => Ok(AxValueNativeSourceType::Title),
                    "other" | "Other" => Ok(AxValueNativeSourceType::Other),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "A single source for a computed AX property.\n[AXValueSource](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#type-AXValueSource)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AxValueSource {
            #[doc = "What type of source this is."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: AxValueSourceType,
            #[doc = "The value of this property source."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<AxValue>,
            #[doc = "The name of the relevant attribute, if any."]
            #[serde(rename = "attribute")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub attribute: Option<String>,
            #[doc = "The value of the relevant attribute, if any."]
            #[serde(rename = "attributeValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub attribute_value: Option<AxValue>,
            #[doc = "Whether this source is superseded by a higher priority source."]
            #[serde(rename = "superseded")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub superseded: Option<bool>,
            #[doc = "The native markup source for this value, e.g. a <label> element."]
            #[serde(rename = "nativeSource")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub native_source: Option<AxValueNativeSourceType>,
            #[doc = "The value, such as a node or node list, of the native source."]
            #[serde(rename = "nativeSourceValue")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub native_source_value: Option<AxValue>,
            #[doc = "Whether the value for this property is invalid."]
            #[serde(rename = "invalid")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub invalid: Option<bool>,
            #[doc = "Reason for the value being invalid, if it is."]
            #[serde(rename = "invalidReason")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub invalid_reason: Option<String>,
        }
        impl AxValueSource {
            pub fn new(r#type: impl Into<AxValueSourceType>) -> Self {
                Self {
                    r#type: r#type.into(),
                    value: None,
                    attribute: None,
                    attribute_value: None,
                    superseded: None,
                    native_source: None,
                    native_source_value: None,
                    invalid: None,
                    invalid_reason: None,
                }
            }
        }
        impl AxValueSource {
            pub fn builder() -> AxValueSourceBuilder {
                AxValueSourceBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AxValueSourceBuilder {
            r#type: Option<AxValueSourceType>,
            value: Option<AxValue>,
            attribute: Option<String>,
            attribute_value: Option<AxValue>,
            superseded: Option<bool>,
            native_source: Option<AxValueNativeSourceType>,
            native_source_value: Option<AxValue>,
            invalid: Option<bool>,
            invalid_reason: Option<String>,
        }
        impl AxValueSourceBuilder {
            pub fn r#type(mut self, r#type: impl Into<AxValueSourceType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn value(mut self, value: impl Into<AxValue>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn attribute(mut self, attribute: impl Into<String>) -> Self {
                self.attribute = Some(attribute.into());
                self
            }
            pub fn attribute_value(mut self, attribute_value: impl Into<AxValue>) -> Self {
                self.attribute_value = Some(attribute_value.into());
                self
            }
            pub fn superseded(mut self, superseded: impl Into<bool>) -> Self {
                self.superseded = Some(superseded.into());
                self
            }
            pub fn native_source(
                mut self,
                native_source: impl Into<AxValueNativeSourceType>,
            ) -> Self {
                self.native_source = Some(native_source.into());
                self
            }
            pub fn native_source_value(mut self, native_source_value: impl Into<AxValue>) -> Self {
                self.native_source_value = Some(native_source_value.into());
                self
            }
            pub fn invalid(mut self, invalid: impl Into<bool>) -> Self {
                self.invalid = Some(invalid.into());
                self
            }
            pub fn invalid_reason(mut self, invalid_reason: impl Into<String>) -> Self {
                self.invalid_reason = Some(invalid_reason.into());
                self
            }
            pub fn build(self) -> Result<AxValueSource, String> {
                Ok(AxValueSource {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    value: self.value,
                    attribute: self.attribute,
                    attribute_value: self.attribute_value,
                    superseded: self.superseded,
                    native_source: self.native_source,
                    native_source_value: self.native_source_value,
                    invalid: self.invalid,
                    invalid_reason: self.invalid_reason,
                })
            }
        }
        impl AxValueSource {
            pub const IDENTIFIER: &'static str = "Accessibility.AXValueSource";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AxRelatedNode {
            #[doc = "The BackendNodeId of the related DOM node."]
            #[serde(rename = "backendDOMNodeId")]
            pub backend_dom_node_id: super::dom::BackendNodeId,
            #[doc = "The IDRef value provided, if any."]
            #[serde(rename = "idref")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub idref: Option<String>,
            #[doc = "The text alternative of this node in the current context."]
            #[serde(rename = "text")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub text: Option<String>,
        }
        impl AxRelatedNode {
            pub fn new(backend_dom_node_id: impl Into<super::dom::BackendNodeId>) -> Self {
                Self {
                    backend_dom_node_id: backend_dom_node_id.into(),
                    idref: None,
                    text: None,
                }
            }
        }
        impl AxRelatedNode {
            pub fn builder() -> AxRelatedNodeBuilder {
                AxRelatedNodeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AxRelatedNodeBuilder {
            backend_dom_node_id: Option<super::dom::BackendNodeId>,
            idref: Option<String>,
            text: Option<String>,
        }
        impl AxRelatedNodeBuilder {
            pub fn backend_dom_node_id(
                mut self,
                backend_dom_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.backend_dom_node_id = Some(backend_dom_node_id.into());
                self
            }
            pub fn idref(mut self, idref: impl Into<String>) -> Self {
                self.idref = Some(idref.into());
                self
            }
            pub fn text(mut self, text: impl Into<String>) -> Self {
                self.text = Some(text.into());
                self
            }
            pub fn build(self) -> Result<AxRelatedNode, String> {
                Ok(AxRelatedNode {
                    backend_dom_node_id: self.backend_dom_node_id.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(backend_dom_node_id)
                        )
                    })?,
                    idref: self.idref,
                    text: self.text,
                })
            }
        }
        impl AxRelatedNode {
            pub const IDENTIFIER: &'static str = "Accessibility.AXRelatedNode";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AxProperty {
            #[doc = "The name of this property."]
            #[serde(rename = "name")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub name: AxPropertyName,
            #[doc = "The value of this property."]
            #[serde(rename = "value")]
            pub value: AxValue,
        }
        impl AxProperty {
            pub fn new(name: impl Into<AxPropertyName>, value: impl Into<AxValue>) -> Self {
                Self {
                    name: name.into(),
                    value: value.into(),
                }
            }
        }
        impl AxProperty {
            pub fn builder() -> AxPropertyBuilder {
                AxPropertyBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AxPropertyBuilder {
            name: Option<AxPropertyName>,
            value: Option<AxValue>,
        }
        impl AxPropertyBuilder {
            pub fn name(mut self, name: impl Into<AxPropertyName>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn value(mut self, value: impl Into<AxValue>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn build(self) -> Result<AxProperty, String> {
                Ok(AxProperty {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    value: self.value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(value))
                    })?,
                })
            }
        }
        impl AxProperty {
            pub const IDENTIFIER: &'static str = "Accessibility.AXProperty";
        }
        #[doc = "A single computed AX property.\n[AXValue](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#type-AXValue)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AxValue {
            #[doc = "The type of this value."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: AxValueType,
            #[doc = "The computed value of this property."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<serde_json::Value>,
            #[doc = "One or more related nodes, if applicable."]
            #[serde(rename = "relatedNodes")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub related_nodes: Option<Vec<AxRelatedNode>>,
            #[doc = "The sources which contributed to the computation of this property."]
            #[serde(rename = "sources")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub sources: Option<Vec<AxValueSource>>,
        }
        impl AxValue {
            pub fn new(r#type: impl Into<AxValueType>) -> Self {
                Self {
                    r#type: r#type.into(),
                    value: None,
                    related_nodes: None,
                    sources: None,
                }
            }
        }
        impl AxValue {
            pub fn builder() -> AxValueBuilder {
                AxValueBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AxValueBuilder {
            r#type: Option<AxValueType>,
            value: Option<serde_json::Value>,
            related_nodes: Option<Vec<AxRelatedNode>>,
            sources: Option<Vec<AxValueSource>>,
        }
        impl AxValueBuilder {
            pub fn r#type(mut self, r#type: impl Into<AxValueType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn value(mut self, value: impl Into<serde_json::Value>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn related_node(mut self, related_node: impl Into<AxRelatedNode>) -> Self {
                let v = self.related_nodes.get_or_insert(Vec::new());
                v.push(related_node.into());
                self
            }
            pub fn related_nodes<I, S>(mut self, related_nodes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxRelatedNode>,
            {
                let v = self.related_nodes.get_or_insert(Vec::new());
                for val in related_nodes {
                    v.push(val.into());
                }
                self
            }
            pub fn source(mut self, source: impl Into<AxValueSource>) -> Self {
                let v = self.sources.get_or_insert(Vec::new());
                v.push(source.into());
                self
            }
            pub fn sources<I, S>(mut self, sources: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxValueSource>,
            {
                let v = self.sources.get_or_insert(Vec::new());
                for val in sources {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<AxValue, String> {
                Ok(AxValue {
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    value: self.value,
                    related_nodes: self.related_nodes,
                    sources: self.sources,
                })
            }
        }
        impl AxValue {
            pub const IDENTIFIER: &'static str = "Accessibility.AXValue";
        }
        #[doc = "Values of AXProperty name:\n- from 'busy' to 'roledescription': states which apply to every AX node\n- from 'live' to 'root': attributes which apply to nodes in live regions\n- from 'autocomplete' to 'valuetext': attributes which apply to widgets\n- from 'checked' to 'selected': states which apply to widgets\n- from 'activedescendant' to 'owns' - relationships between elements other than parent/child/sibling."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum AxPropertyName {
            #[serde(rename = "busy")]
            Busy,
            #[serde(rename = "disabled")]
            Disabled,
            #[serde(rename = "editable")]
            Editable,
            #[serde(rename = "focusable")]
            Focusable,
            #[serde(rename = "focused")]
            Focused,
            #[serde(rename = "hidden")]
            Hidden,
            #[serde(rename = "hiddenRoot")]
            HiddenRoot,
            #[serde(rename = "invalid")]
            Invalid,
            #[serde(rename = "keyshortcuts")]
            Keyshortcuts,
            #[serde(rename = "settable")]
            Settable,
            #[serde(rename = "roledescription")]
            Roledescription,
            #[serde(rename = "live")]
            Live,
            #[serde(rename = "atomic")]
            Atomic,
            #[serde(rename = "relevant")]
            Relevant,
            #[serde(rename = "root")]
            Root,
            #[serde(rename = "autocomplete")]
            Autocomplete,
            #[serde(rename = "hasPopup")]
            HasPopup,
            #[serde(rename = "level")]
            Level,
            #[serde(rename = "multiselectable")]
            Multiselectable,
            #[serde(rename = "orientation")]
            Orientation,
            #[serde(rename = "multiline")]
            Multiline,
            #[serde(rename = "readonly")]
            Readonly,
            #[serde(rename = "required")]
            Required,
            #[serde(rename = "valuemin")]
            Valuemin,
            #[serde(rename = "valuemax")]
            Valuemax,
            #[serde(rename = "valuetext")]
            Valuetext,
            #[serde(rename = "checked")]
            Checked,
            #[serde(rename = "expanded")]
            Expanded,
            #[serde(rename = "modal")]
            Modal,
            #[serde(rename = "pressed")]
            Pressed,
            #[serde(rename = "selected")]
            Selected,
            #[serde(rename = "activedescendant")]
            Activedescendant,
            #[serde(rename = "controls")]
            Controls,
            #[serde(rename = "describedby")]
            Describedby,
            #[serde(rename = "details")]
            Details,
            #[serde(rename = "errormessage")]
            Errormessage,
            #[serde(rename = "flowto")]
            Flowto,
            #[serde(rename = "labelledby")]
            Labelledby,
            #[serde(rename = "owns")]
            Owns,
        }
        impl AsRef<str> for AxPropertyName {
            fn as_ref(&self) -> &str {
                match self {
                    AxPropertyName::Busy => "busy",
                    AxPropertyName::Disabled => "disabled",
                    AxPropertyName::Editable => "editable",
                    AxPropertyName::Focusable => "focusable",
                    AxPropertyName::Focused => "focused",
                    AxPropertyName::Hidden => "hidden",
                    AxPropertyName::HiddenRoot => "hiddenRoot",
                    AxPropertyName::Invalid => "invalid",
                    AxPropertyName::Keyshortcuts => "keyshortcuts",
                    AxPropertyName::Settable => "settable",
                    AxPropertyName::Roledescription => "roledescription",
                    AxPropertyName::Live => "live",
                    AxPropertyName::Atomic => "atomic",
                    AxPropertyName::Relevant => "relevant",
                    AxPropertyName::Root => "root",
                    AxPropertyName::Autocomplete => "autocomplete",
                    AxPropertyName::HasPopup => "hasPopup",
                    AxPropertyName::Level => "level",
                    AxPropertyName::Multiselectable => "multiselectable",
                    AxPropertyName::Orientation => "orientation",
                    AxPropertyName::Multiline => "multiline",
                    AxPropertyName::Readonly => "readonly",
                    AxPropertyName::Required => "required",
                    AxPropertyName::Valuemin => "valuemin",
                    AxPropertyName::Valuemax => "valuemax",
                    AxPropertyName::Valuetext => "valuetext",
                    AxPropertyName::Checked => "checked",
                    AxPropertyName::Expanded => "expanded",
                    AxPropertyName::Modal => "modal",
                    AxPropertyName::Pressed => "pressed",
                    AxPropertyName::Selected => "selected",
                    AxPropertyName::Activedescendant => "activedescendant",
                    AxPropertyName::Controls => "controls",
                    AxPropertyName::Describedby => "describedby",
                    AxPropertyName::Details => "details",
                    AxPropertyName::Errormessage => "errormessage",
                    AxPropertyName::Flowto => "flowto",
                    AxPropertyName::Labelledby => "labelledby",
                    AxPropertyName::Owns => "owns",
                }
            }
        }
        impl ::std::str::FromStr for AxPropertyName {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "busy" | "Busy" => Ok(AxPropertyName::Busy),
                    "disabled" | "Disabled" => Ok(AxPropertyName::Disabled),
                    "editable" | "Editable" => Ok(AxPropertyName::Editable),
                    "focusable" | "Focusable" => Ok(AxPropertyName::Focusable),
                    "focused" | "Focused" => Ok(AxPropertyName::Focused),
                    "hidden" | "Hidden" => Ok(AxPropertyName::Hidden),
                    "hiddenRoot" | "HiddenRoot" | "hiddenroot" => Ok(AxPropertyName::HiddenRoot),
                    "invalid" | "Invalid" => Ok(AxPropertyName::Invalid),
                    "keyshortcuts" | "Keyshortcuts" => Ok(AxPropertyName::Keyshortcuts),
                    "settable" | "Settable" => Ok(AxPropertyName::Settable),
                    "roledescription" | "Roledescription" => Ok(AxPropertyName::Roledescription),
                    "live" | "Live" => Ok(AxPropertyName::Live),
                    "atomic" | "Atomic" => Ok(AxPropertyName::Atomic),
                    "relevant" | "Relevant" => Ok(AxPropertyName::Relevant),
                    "root" | "Root" => Ok(AxPropertyName::Root),
                    "autocomplete" | "Autocomplete" => Ok(AxPropertyName::Autocomplete),
                    "hasPopup" | "HasPopup" | "haspopup" => Ok(AxPropertyName::HasPopup),
                    "level" | "Level" => Ok(AxPropertyName::Level),
                    "multiselectable" | "Multiselectable" => Ok(AxPropertyName::Multiselectable),
                    "orientation" | "Orientation" => Ok(AxPropertyName::Orientation),
                    "multiline" | "Multiline" => Ok(AxPropertyName::Multiline),
                    "readonly" | "Readonly" => Ok(AxPropertyName::Readonly),
                    "required" | "Required" => Ok(AxPropertyName::Required),
                    "valuemin" | "Valuemin" => Ok(AxPropertyName::Valuemin),
                    "valuemax" | "Valuemax" => Ok(AxPropertyName::Valuemax),
                    "valuetext" | "Valuetext" => Ok(AxPropertyName::Valuetext),
                    "checked" | "Checked" => Ok(AxPropertyName::Checked),
                    "expanded" | "Expanded" => Ok(AxPropertyName::Expanded),
                    "modal" | "Modal" => Ok(AxPropertyName::Modal),
                    "pressed" | "Pressed" => Ok(AxPropertyName::Pressed),
                    "selected" | "Selected" => Ok(AxPropertyName::Selected),
                    "activedescendant" | "Activedescendant" => Ok(AxPropertyName::Activedescendant),
                    "controls" | "Controls" => Ok(AxPropertyName::Controls),
                    "describedby" | "Describedby" => Ok(AxPropertyName::Describedby),
                    "details" | "Details" => Ok(AxPropertyName::Details),
                    "errormessage" | "Errormessage" => Ok(AxPropertyName::Errormessage),
                    "flowto" | "Flowto" => Ok(AxPropertyName::Flowto),
                    "labelledby" | "Labelledby" => Ok(AxPropertyName::Labelledby),
                    "owns" | "Owns" => Ok(AxPropertyName::Owns),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "A node in the accessibility tree.\n[AXNode](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#type-AXNode)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AxNode {
            #[doc = "Unique identifier for this node."]
            #[serde(rename = "nodeId")]
            pub node_id: AxNodeId,
            #[doc = "Whether this node is ignored for accessibility"]
            #[serde(rename = "ignored")]
            pub ignored: bool,
            #[doc = "Collection of reasons why this node is hidden."]
            #[serde(rename = "ignoredReasons")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub ignored_reasons: Option<Vec<AxProperty>>,
            #[doc = "This `Node`'s role, whether explicit or implicit."]
            #[serde(rename = "role")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub role: Option<AxValue>,
            #[doc = "The accessible name for this `Node`."]
            #[serde(rename = "name")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub name: Option<AxValue>,
            #[doc = "The accessible description for this `Node`."]
            #[serde(rename = "description")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub description: Option<AxValue>,
            #[doc = "The value for this `Node`."]
            #[serde(rename = "value")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub value: Option<AxValue>,
            #[doc = "All other properties"]
            #[serde(rename = "properties")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub properties: Option<Vec<AxProperty>>,
            #[doc = "IDs for each of this node's child nodes."]
            #[serde(rename = "childIds")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub child_ids: Option<Vec<AxNodeId>>,
            #[doc = "The backend ID for the associated DOM node, if any."]
            #[serde(rename = "backendDOMNodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub backend_dom_node_id: Option<super::dom::BackendNodeId>,
        }
        impl AxNode {
            pub fn new(node_id: impl Into<AxNodeId>, ignored: impl Into<bool>) -> Self {
                Self {
                    node_id: node_id.into(),
                    ignored: ignored.into(),
                    ignored_reasons: None,
                    role: None,
                    name: None,
                    description: None,
                    value: None,
                    properties: None,
                    child_ids: None,
                    backend_dom_node_id: None,
                }
            }
        }
        impl AxNode {
            pub fn builder() -> AxNodeBuilder {
                AxNodeBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AxNodeBuilder {
            node_id: Option<AxNodeId>,
            ignored: Option<bool>,
            ignored_reasons: Option<Vec<AxProperty>>,
            role: Option<AxValue>,
            name: Option<AxValue>,
            description: Option<AxValue>,
            value: Option<AxValue>,
            properties: Option<Vec<AxProperty>>,
            child_ids: Option<Vec<AxNodeId>>,
            backend_dom_node_id: Option<super::dom::BackendNodeId>,
        }
        impl AxNodeBuilder {
            pub fn node_id(mut self, node_id: impl Into<AxNodeId>) -> Self {
                self.node_id = Some(node_id.into());
                self
            }
            pub fn ignored(mut self, ignored: impl Into<bool>) -> Self {
                self.ignored = Some(ignored.into());
                self
            }
            pub fn ignored_reason(mut self, ignored_reason: impl Into<AxProperty>) -> Self {
                let v = self.ignored_reasons.get_or_insert(Vec::new());
                v.push(ignored_reason.into());
                self
            }
            pub fn ignored_reasons<I, S>(mut self, ignored_reasons: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxProperty>,
            {
                let v = self.ignored_reasons.get_or_insert(Vec::new());
                for val in ignored_reasons {
                    v.push(val.into());
                }
                self
            }
            pub fn role(mut self, role: impl Into<AxValue>) -> Self {
                self.role = Some(role.into());
                self
            }
            pub fn name(mut self, name: impl Into<AxValue>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn description(mut self, description: impl Into<AxValue>) -> Self {
                self.description = Some(description.into());
                self
            }
            pub fn value(mut self, value: impl Into<AxValue>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn propertie(mut self, propertie: impl Into<AxProperty>) -> Self {
                let v = self.properties.get_or_insert(Vec::new());
                v.push(propertie.into());
                self
            }
            pub fn properties<I, S>(mut self, properties: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxProperty>,
            {
                let v = self.properties.get_or_insert(Vec::new());
                for val in properties {
                    v.push(val.into());
                }
                self
            }
            pub fn child_id(mut self, child_id: impl Into<AxNodeId>) -> Self {
                let v = self.child_ids.get_or_insert(Vec::new());
                v.push(child_id.into());
                self
            }
            pub fn child_ids<I, S>(mut self, child_ids: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxNodeId>,
            {
                let v = self.child_ids.get_or_insert(Vec::new());
                for val in child_ids {
                    v.push(val.into());
                }
                self
            }
            pub fn backend_dom_node_id(
                mut self,
                backend_dom_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.backend_dom_node_id = Some(backend_dom_node_id.into());
                self
            }
            pub fn build(self) -> Result<AxNode, String> {
                Ok(AxNode {
                    node_id: self.node_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(node_id))
                    })?,
                    ignored: self.ignored.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(ignored))
                    })?,
                    ignored_reasons: self.ignored_reasons,
                    role: self.role,
                    name: self.name,
                    description: self.description,
                    value: self.value,
                    properties: self.properties,
                    child_ids: self.child_ids,
                    backend_dom_node_id: self.backend_dom_node_id,
                })
            }
        }
        impl AxNode {
            pub const IDENTIFIER: &'static str = "Accessibility.AXNode";
        }
        #[doc = "Disables the accessibility domain.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Accessibility.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables the accessibility domain.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[doc = "Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.\nThis turns on accessibility for the page, which can impact performance until accessibility is disabled.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Accessibility.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls.\nThis turns on accessibility for the page, which can impact performance until accessibility is disabled.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.\n[getPartialAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-getPartialAXTree)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetPartialAxTreeParams {
            #[doc = "Identifier of the node to get the partial accessibility tree for."]
            #[serde(rename = "nodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub node_id: Option<super::dom::NodeId>,
            #[doc = "Identifier of the backend node to get the partial accessibility tree for."]
            #[serde(rename = "backendNodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub backend_node_id: Option<super::dom::BackendNodeId>,
            #[doc = "JavaScript object id of the node wrapper to get the partial accessibility tree for."]
            #[serde(rename = "objectId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_id: Option<super::super::js_protocol::runtime::RemoteObjectId>,
            #[doc = "Whether to fetch this nodes ancestors, siblings and children. Defaults to true."]
            #[serde(rename = "fetchRelatives")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub fetch_relatives: Option<bool>,
        }
        impl GetPartialAxTreeParams {
            pub fn builder() -> GetPartialAxTreeParamsBuilder {
                GetPartialAxTreeParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPartialAxTreeParamsBuilder {
            node_id: Option<super::dom::NodeId>,
            backend_node_id: Option<super::dom::BackendNodeId>,
            object_id: Option<super::super::js_protocol::runtime::RemoteObjectId>,
            fetch_relatives: Option<bool>,
        }
        impl GetPartialAxTreeParamsBuilder {
            pub fn node_id(mut self, node_id: impl Into<super::dom::NodeId>) -> Self {
                self.node_id = Some(node_id.into());
                self
            }
            pub fn backend_node_id(
                mut self,
                backend_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.backend_node_id = Some(backend_node_id.into());
                self
            }
            pub fn object_id(
                mut self,
                object_id: impl Into<super::super::js_protocol::runtime::RemoteObjectId>,
            ) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn fetch_relatives(mut self, fetch_relatives: impl Into<bool>) -> Self {
                self.fetch_relatives = Some(fetch_relatives.into());
                self
            }
            pub fn build(self) -> GetPartialAxTreeParams {
                GetPartialAxTreeParams {
                    node_id: self.node_id,
                    backend_node_id: self.backend_node_id,
                    object_id: self.object_id,
                    fetch_relatives: self.fetch_relatives,
                }
            }
        }
        impl GetPartialAxTreeParams {
            pub const IDENTIFIER: &'static str = "Accessibility.getPartialAXTree";
        }
        impl chromiumoxide_types::Method for GetPartialAxTreeParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetPartialAxTreeParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.\n[getPartialAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-getPartialAXTree)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPartialAxTreeReturns {
            #[doc = "The `Accessibility.AXNode` for this DOM node, if it exists, plus its ancestors, siblings and\nchildren, if requested."]
            #[serde(rename = "nodes")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub nodes: Vec<AxNode>,
        }
        impl GetPartialAxTreeReturns {
            pub fn new(nodes: Vec<AxNode>) -> Self {
                Self { nodes }
            }
        }
        impl GetPartialAxTreeReturns {
            pub fn builder() -> GetPartialAxTreeReturnsBuilder {
                GetPartialAxTreeReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPartialAxTreeReturnsBuilder {
            nodes: Option<Vec<AxNode>>,
        }
        impl GetPartialAxTreeReturnsBuilder {
            pub fn node(mut self, node: impl Into<AxNode>) -> Self {
                let v = self.nodes.get_or_insert(Vec::new());
                v.push(node.into());
                self
            }
            pub fn nodes<I, S>(mut self, nodes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxNode>,
            {
                let v = self.nodes.get_or_insert(Vec::new());
                for val in nodes {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetPartialAxTreeReturns, String> {
                Ok(GetPartialAxTreeReturns {
                    nodes: self.nodes.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(nodes))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetPartialAxTreeParams {
            type Response = GetPartialAxTreeReturns;
        }
        #[doc = "Fetches the entire accessibility tree\n[getFullAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-getFullAXTree)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetFullAxTreeParams {}
        impl GetFullAxTreeParams {
            pub const IDENTIFIER: &'static str = "Accessibility.getFullAXTree";
        }
        impl chromiumoxide_types::Method for GetFullAxTreeParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetFullAxTreeParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Fetches the entire accessibility tree\n[getFullAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-getFullAXTree)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetFullAxTreeReturns {
            #[serde(rename = "nodes")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub nodes: Vec<AxNode>,
        }
        impl GetFullAxTreeReturns {
            pub fn new(nodes: Vec<AxNode>) -> Self {
                Self { nodes }
            }
        }
        impl GetFullAxTreeReturns {
            pub fn builder() -> GetFullAxTreeReturnsBuilder {
                GetFullAxTreeReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetFullAxTreeReturnsBuilder {
            nodes: Option<Vec<AxNode>>,
        }
        impl GetFullAxTreeReturnsBuilder {
            pub fn node(mut self, node: impl Into<AxNode>) -> Self {
                let v = self.nodes.get_or_insert(Vec::new());
                v.push(node.into());
                self
            }
            pub fn nodes<I, S>(mut self, nodes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxNode>,
            {
                let v = self.nodes.get_or_insert(Vec::new());
                for val in nodes {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetFullAxTreeReturns, String> {
                Ok(GetFullAxTreeReturns {
                    nodes: self.nodes.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(nodes))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetFullAxTreeParams {
            type Response = GetFullAxTreeReturns;
        }
        #[doc = "Query a DOM node's accessibility subtree for accessible name and role.\nThis command computes the name and role for all nodes in the subtree, including those that are\nignored for accessibility, and returns those that mactch the specified name and role. If no DOM\nnode is specified, or the DOM node does not exist, the command returns an error. If neither\n`accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.\n[queryAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-queryAXTree)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct QueryAxTreeParams {
            #[doc = "Identifier of the node for the root to query."]
            #[serde(rename = "nodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub node_id: Option<super::dom::NodeId>,
            #[doc = "Identifier of the backend node for the root to query."]
            #[serde(rename = "backendNodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub backend_node_id: Option<super::dom::BackendNodeId>,
            #[doc = "JavaScript object id of the node wrapper for the root to query."]
            #[serde(rename = "objectId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub object_id: Option<super::super::js_protocol::runtime::RemoteObjectId>,
            #[doc = "Find nodes with this computed name."]
            #[serde(rename = "accessibleName")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub accessible_name: Option<String>,
            #[doc = "Find nodes with this computed role."]
            #[serde(rename = "role")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub role: Option<String>,
        }
        impl QueryAxTreeParams {
            pub fn builder() -> QueryAxTreeParamsBuilder {
                QueryAxTreeParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct QueryAxTreeParamsBuilder {
            node_id: Option<super::dom::NodeId>,
            backend_node_id: Option<super::dom::BackendNodeId>,
            object_id: Option<super::super::js_protocol::runtime::RemoteObjectId>,
            accessible_name: Option<String>,
            role: Option<String>,
        }
        impl QueryAxTreeParamsBuilder {
            pub fn node_id(mut self, node_id: impl Into<super::dom::NodeId>) -> Self {
                self.node_id = Some(node_id.into());
                self
            }
            pub fn backend_node_id(
                mut self,
                backend_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.backend_node_id = Some(backend_node_id.into());
                self
            }
            pub fn object_id(
                mut self,
                object_id: impl Into<super::super::js_protocol::runtime::RemoteObjectId>,
            ) -> Self {
                self.object_id = Some(object_id.into());
                self
            }
            pub fn accessible_name(mut self, accessible_name: impl Into<String>) -> Self {
                self.accessible_name = Some(accessible_name.into());
                self
            }
            pub fn role(mut self, role: impl Into<String>) -> Self {
                self.role = Some(role.into());
                self
            }
            pub fn build(self) -> QueryAxTreeParams {
                QueryAxTreeParams {
                    node_id: self.node_id,
                    backend_node_id: self.backend_node_id,
                    object_id: self.object_id,
                    accessible_name: self.accessible_name,
                    role: self.role,
                }
            }
        }
        impl QueryAxTreeParams {
            pub const IDENTIFIER: &'static str = "Accessibility.queryAXTree";
        }
        impl chromiumoxide_types::Method for QueryAxTreeParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for QueryAxTreeParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Query a DOM node's accessibility subtree for accessible name and role.\nThis command computes the name and role for all nodes in the subtree, including those that are\nignored for accessibility, and returns those that mactch the specified name and role. If no DOM\nnode is specified, or the DOM node does not exist, the command returns an error. If neither\n`accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.\n[queryAXTree](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#method-queryAXTree)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct QueryAxTreeReturns {
            #[doc = "A list of `Accessibility.AXNode` matching the specified attributes,\nincluding nodes that are ignored for accessibility."]
            #[serde(rename = "nodes")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub nodes: Vec<AxNode>,
        }
        impl QueryAxTreeReturns {
            pub fn new(nodes: Vec<AxNode>) -> Self {
                Self { nodes }
            }
        }
        impl QueryAxTreeReturns {
            pub fn builder() -> QueryAxTreeReturnsBuilder {
                QueryAxTreeReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct QueryAxTreeReturnsBuilder {
            nodes: Option<Vec<AxNode>>,
        }
        impl QueryAxTreeReturnsBuilder {
            pub fn node(mut self, node: impl Into<AxNode>) -> Self {
                let v = self.nodes.get_or_insert(Vec::new());
                v.push(node.into());
                self
            }
            pub fn nodes<I, S>(mut self, nodes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<AxNode>,
            {
                let v = self.nodes.get_or_insert(Vec::new());
                for val in nodes {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<QueryAxTreeReturns, String> {
                Ok(QueryAxTreeReturns {
                    nodes: self.nodes.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(nodes))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for QueryAxTreeParams {
            type Response = QueryAxTreeReturns;
        }
    }
    pub mod animation {
        use serde::{Deserialize, Serialize};
        #[doc = "Animation instance.\n[Animation](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#type-Animation)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct Animation {
            #[doc = "`Animation`'s id."]
            #[serde(rename = "id")]
            pub id: String,
            #[doc = "`Animation`'s name."]
            #[serde(rename = "name")]
            pub name: String,
            #[doc = "`Animation`'s internal paused state."]
            #[serde(rename = "pausedState")]
            pub paused_state: bool,
            #[doc = "`Animation`'s play state."]
            #[serde(rename = "playState")]
            pub play_state: String,
            #[doc = "`Animation`'s playback rate."]
            #[serde(rename = "playbackRate")]
            pub playback_rate: f64,
            #[doc = "`Animation`'s start time."]
            #[serde(rename = "startTime")]
            pub start_time: f64,
            #[doc = "`Animation`'s current time."]
            #[serde(rename = "currentTime")]
            pub current_time: f64,
            #[doc = "Animation type of `Animation`."]
            #[serde(rename = "type")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub r#type: AnimationType,
            #[doc = "`Animation`'s source animation node."]
            #[serde(rename = "source")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub source: Option<AnimationEffect>,
            #[doc = "A unique ID for `Animation` representing the sources that triggered this CSS\nanimation/transition."]
            #[serde(rename = "cssId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub css_id: Option<String>,
        }
        #[doc = "Animation type of `Animation`."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum AnimationType {
            #[serde(rename = "CSSTransition")]
            CssTransition,
            #[serde(rename = "CSSAnimation")]
            CssAnimation,
            #[serde(rename = "WebAnimation")]
            WebAnimation,
        }
        impl AsRef<str> for AnimationType {
            fn as_ref(&self) -> &str {
                match self {
                    AnimationType::CssTransition => "CSSTransition",
                    AnimationType::CssAnimation => "CSSAnimation",
                    AnimationType::WebAnimation => "WebAnimation",
                }
            }
        }
        impl ::std::str::FromStr for AnimationType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "CSSTransition" | "CssTransition" | "csstransition" => {
                        Ok(AnimationType::CssTransition)
                    }
                    "CSSAnimation" | "CssAnimation" | "cssanimation" => {
                        Ok(AnimationType::CssAnimation)
                    }
                    "WebAnimation" | "webanimation" => Ok(AnimationType::WebAnimation),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl Animation {
            pub fn builder() -> AnimationBuilder {
                AnimationBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AnimationBuilder {
            id: Option<String>,
            name: Option<String>,
            paused_state: Option<bool>,
            play_state: Option<String>,
            playback_rate: Option<f64>,
            start_time: Option<f64>,
            current_time: Option<f64>,
            r#type: Option<AnimationType>,
            source: Option<AnimationEffect>,
            css_id: Option<String>,
        }
        impl AnimationBuilder {
            pub fn id(mut self, id: impl Into<String>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn paused_state(mut self, paused_state: impl Into<bool>) -> Self {
                self.paused_state = Some(paused_state.into());
                self
            }
            pub fn play_state(mut self, play_state: impl Into<String>) -> Self {
                self.play_state = Some(play_state.into());
                self
            }
            pub fn playback_rate(mut self, playback_rate: impl Into<f64>) -> Self {
                self.playback_rate = Some(playback_rate.into());
                self
            }
            pub fn start_time(mut self, start_time: impl Into<f64>) -> Self {
                self.start_time = Some(start_time.into());
                self
            }
            pub fn current_time(mut self, current_time: impl Into<f64>) -> Self {
                self.current_time = Some(current_time.into());
                self
            }
            pub fn r#type(mut self, r#type: impl Into<AnimationType>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn source(mut self, source: impl Into<AnimationEffect>) -> Self {
                self.source = Some(source.into());
                self
            }
            pub fn css_id(mut self, css_id: impl Into<String>) -> Self {
                self.css_id = Some(css_id.into());
                self
            }
            pub fn build(self) -> Result<Animation, String> {
                Ok(Animation {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    paused_state: self.paused_state.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(paused_state))
                    })?,
                    play_state: self.play_state.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(play_state))
                    })?,
                    playback_rate: self.playback_rate.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(playback_rate))
                    })?,
                    start_time: self.start_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(start_time))
                    })?,
                    current_time: self.current_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(current_time))
                    })?,
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                    source: self.source,
                    css_id: self.css_id,
                })
            }
        }
        impl Animation {
            pub const IDENTIFIER: &'static str = "Animation.Animation";
        }
        #[doc = "AnimationEffect instance\n[AnimationEffect](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#type-AnimationEffect)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AnimationEffect {
            #[doc = "`AnimationEffect`'s delay."]
            #[serde(rename = "delay")]
            pub delay: f64,
            #[doc = "`AnimationEffect`'s end delay."]
            #[serde(rename = "endDelay")]
            pub end_delay: f64,
            #[doc = "`AnimationEffect`'s iteration start."]
            #[serde(rename = "iterationStart")]
            pub iteration_start: f64,
            #[doc = "`AnimationEffect`'s iterations."]
            #[serde(rename = "iterations")]
            pub iterations: f64,
            #[doc = "`AnimationEffect`'s iteration duration."]
            #[serde(rename = "duration")]
            pub duration: f64,
            #[doc = "`AnimationEffect`'s playback direction."]
            #[serde(rename = "direction")]
            pub direction: String,
            #[doc = "`AnimationEffect`'s fill mode."]
            #[serde(rename = "fill")]
            pub fill: String,
            #[doc = "`AnimationEffect`'s target node."]
            #[serde(rename = "backendNodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub backend_node_id: Option<super::dom::BackendNodeId>,
            #[doc = "`AnimationEffect`'s keyframes."]
            #[serde(rename = "keyframesRule")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub keyframes_rule: Option<KeyframesRule>,
            #[doc = "`AnimationEffect`'s timing function."]
            #[serde(rename = "easing")]
            pub easing: String,
        }
        impl AnimationEffect {
            pub fn builder() -> AnimationEffectBuilder {
                AnimationEffectBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AnimationEffectBuilder {
            delay: Option<f64>,
            end_delay: Option<f64>,
            iteration_start: Option<f64>,
            iterations: Option<f64>,
            duration: Option<f64>,
            direction: Option<String>,
            fill: Option<String>,
            backend_node_id: Option<super::dom::BackendNodeId>,
            keyframes_rule: Option<KeyframesRule>,
            easing: Option<String>,
        }
        impl AnimationEffectBuilder {
            pub fn delay(mut self, delay: impl Into<f64>) -> Self {
                self.delay = Some(delay.into());
                self
            }
            pub fn end_delay(mut self, end_delay: impl Into<f64>) -> Self {
                self.end_delay = Some(end_delay.into());
                self
            }
            pub fn iteration_start(mut self, iteration_start: impl Into<f64>) -> Self {
                self.iteration_start = Some(iteration_start.into());
                self
            }
            pub fn iterations(mut self, iterations: impl Into<f64>) -> Self {
                self.iterations = Some(iterations.into());
                self
            }
            pub fn duration(mut self, duration: impl Into<f64>) -> Self {
                self.duration = Some(duration.into());
                self
            }
            pub fn direction(mut self, direction: impl Into<String>) -> Self {
                self.direction = Some(direction.into());
                self
            }
            pub fn fill(mut self, fill: impl Into<String>) -> Self {
                self.fill = Some(fill.into());
                self
            }
            pub fn backend_node_id(
                mut self,
                backend_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.backend_node_id = Some(backend_node_id.into());
                self
            }
            pub fn keyframes_rule(mut self, keyframes_rule: impl Into<KeyframesRule>) -> Self {
                self.keyframes_rule = Some(keyframes_rule.into());
                self
            }
            pub fn easing(mut self, easing: impl Into<String>) -> Self {
                self.easing = Some(easing.into());
                self
            }
            pub fn build(self) -> Result<AnimationEffect, String> {
                Ok(AnimationEffect {
                    delay: self.delay.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(delay))
                    })?,
                    end_delay: self.end_delay.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(end_delay))
                    })?,
                    iteration_start: self.iteration_start.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(iteration_start))
                    })?,
                    iterations: self.iterations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(iterations))
                    })?,
                    duration: self.duration.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(duration))
                    })?,
                    direction: self.direction.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(direction))
                    })?,
                    fill: self.fill.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(fill))
                    })?,
                    backend_node_id: self.backend_node_id,
                    keyframes_rule: self.keyframes_rule,
                    easing: self.easing.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(easing))
                    })?,
                })
            }
        }
        impl AnimationEffect {
            pub const IDENTIFIER: &'static str = "Animation.AnimationEffect";
        }
        #[doc = "Keyframes Rule\n[KeyframesRule](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#type-KeyframesRule)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct KeyframesRule {
            #[doc = "CSS keyframed animation's name."]
            #[serde(rename = "name")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub name: Option<String>,
            #[doc = "List of animation keyframes."]
            #[serde(rename = "keyframes")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub keyframes: Vec<KeyframeStyle>,
        }
        impl KeyframesRule {
            pub fn new(keyframes: Vec<KeyframeStyle>) -> Self {
                Self {
                    keyframes,
                    name: None,
                }
            }
        }
        impl KeyframesRule {
            pub fn builder() -> KeyframesRuleBuilder {
                KeyframesRuleBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct KeyframesRuleBuilder {
            name: Option<String>,
            keyframes: Option<Vec<KeyframeStyle>>,
        }
        impl KeyframesRuleBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn keyframe(mut self, keyframe: impl Into<KeyframeStyle>) -> Self {
                let v = self.keyframes.get_or_insert(Vec::new());
                v.push(keyframe.into());
                self
            }
            pub fn keyframes<I, S>(mut self, keyframes: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<KeyframeStyle>,
            {
                let v = self.keyframes.get_or_insert(Vec::new());
                for val in keyframes {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<KeyframesRule, String> {
                Ok(KeyframesRule {
                    name: self.name,
                    keyframes: self.keyframes.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(keyframes))
                    })?,
                })
            }
        }
        impl KeyframesRule {
            pub const IDENTIFIER: &'static str = "Animation.KeyframesRule";
        }
        #[doc = "Keyframe Style\n[KeyframeStyle](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#type-KeyframeStyle)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct KeyframeStyle {
            #[doc = "Keyframe's time offset."]
            #[serde(rename = "offset")]
            pub offset: String,
            #[doc = "`AnimationEffect`'s timing function."]
            #[serde(rename = "easing")]
            pub easing: String,
        }
        impl KeyframeStyle {
            pub fn new(offset: impl Into<String>, easing: impl Into<String>) -> Self {
                Self {
                    offset: offset.into(),
                    easing: easing.into(),
                }
            }
        }
        impl KeyframeStyle {
            pub fn builder() -> KeyframeStyleBuilder {
                KeyframeStyleBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct KeyframeStyleBuilder {
            offset: Option<String>,
            easing: Option<String>,
        }
        impl KeyframeStyleBuilder {
            pub fn offset(mut self, offset: impl Into<String>) -> Self {
                self.offset = Some(offset.into());
                self
            }
            pub fn easing(mut self, easing: impl Into<String>) -> Self {
                self.easing = Some(easing.into());
                self
            }
            pub fn build(self) -> Result<KeyframeStyle, String> {
                Ok(KeyframeStyle {
                    offset: self.offset.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(offset))
                    })?,
                    easing: self.easing.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(easing))
                    })?,
                })
            }
        }
        impl KeyframeStyle {
            pub const IDENTIFIER: &'static str = "Animation.KeyframeStyle";
        }
        #[doc = "Disables animation domain notifications.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Animation.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables animation domain notifications.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[doc = "Enables animation domain notifications.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Animation.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables animation domain notifications.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Returns the current time of the an animation.\n[getCurrentTime](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-getCurrentTime)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetCurrentTimeParams {
            #[doc = "Id of animation."]
            #[serde(rename = "id")]
            pub id: String,
        }
        impl GetCurrentTimeParams {
            pub fn new(id: impl Into<String>) -> Self {
                Self { id: id.into() }
            }
        }
        impl<T: Into<String>> From<T> for GetCurrentTimeParams {
            fn from(url: T) -> Self {
                GetCurrentTimeParams::new(url)
            }
        }
        impl GetCurrentTimeParams {
            pub fn builder() -> GetCurrentTimeParamsBuilder {
                GetCurrentTimeParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetCurrentTimeParamsBuilder {
            id: Option<String>,
        }
        impl GetCurrentTimeParamsBuilder {
            pub fn id(mut self, id: impl Into<String>) -> Self {
                self.id = Some(id.into());
                self
            }
            pub fn build(self) -> Result<GetCurrentTimeParams, String> {
                Ok(GetCurrentTimeParams {
                    id: self
                        .id
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(id)))?,
                })
            }
        }
        impl GetCurrentTimeParams {
            pub const IDENTIFIER: &'static str = "Animation.getCurrentTime";
        }
        impl chromiumoxide_types::Method for GetCurrentTimeParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetCurrentTimeParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns the current time of the an animation.\n[getCurrentTime](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-getCurrentTime)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetCurrentTimeReturns {
            #[doc = "Current time of the page."]
            #[serde(rename = "currentTime")]
            pub current_time: f64,
        }
        impl GetCurrentTimeReturns {
            pub fn new(current_time: impl Into<f64>) -> Self {
                Self {
                    current_time: current_time.into(),
                }
            }
        }
        impl GetCurrentTimeReturns {
            pub fn builder() -> GetCurrentTimeReturnsBuilder {
                GetCurrentTimeReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetCurrentTimeReturnsBuilder {
            current_time: Option<f64>,
        }
        impl GetCurrentTimeReturnsBuilder {
            pub fn current_time(mut self, current_time: impl Into<f64>) -> Self {
                self.current_time = Some(current_time.into());
                self
            }
            pub fn build(self) -> Result<GetCurrentTimeReturns, String> {
                Ok(GetCurrentTimeReturns {
                    current_time: self.current_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(current_time))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetCurrentTimeParams {
            type Response = GetCurrentTimeReturns;
        }
        #[doc = "Gets the playback rate of the document timeline.\n[getPlaybackRate](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-getPlaybackRate)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetPlaybackRateParams {}
        impl GetPlaybackRateParams {
            pub const IDENTIFIER: &'static str = "Animation.getPlaybackRate";
        }
        impl chromiumoxide_types::Method for GetPlaybackRateParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetPlaybackRateParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Gets the playback rate of the document timeline.\n[getPlaybackRate](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-getPlaybackRate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetPlaybackRateReturns {
            #[doc = "Playback rate for animations on page."]
            #[serde(rename = "playbackRate")]
            pub playback_rate: f64,
        }
        impl GetPlaybackRateReturns {
            pub fn new(playback_rate: impl Into<f64>) -> Self {
                Self {
                    playback_rate: playback_rate.into(),
                }
            }
        }
        impl GetPlaybackRateReturns {
            pub fn builder() -> GetPlaybackRateReturnsBuilder {
                GetPlaybackRateReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetPlaybackRateReturnsBuilder {
            playback_rate: Option<f64>,
        }
        impl GetPlaybackRateReturnsBuilder {
            pub fn playback_rate(mut self, playback_rate: impl Into<f64>) -> Self {
                self.playback_rate = Some(playback_rate.into());
                self
            }
            pub fn build(self) -> Result<GetPlaybackRateReturns, String> {
                Ok(GetPlaybackRateReturns {
                    playback_rate: self.playback_rate.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(playback_rate))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetPlaybackRateParams {
            type Response = GetPlaybackRateReturns;
        }
        #[doc = "Releases a set of animations to no longer be manipulated.\n[releaseAnimations](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-releaseAnimations)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ReleaseAnimationsParams {
            #[doc = "List of animation ids to seek."]
            #[serde(rename = "animations")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub animations: Vec<String>,
        }
        impl ReleaseAnimationsParams {
            pub fn new(animations: Vec<String>) -> Self {
                Self { animations }
            }
        }
        impl ReleaseAnimationsParams {
            pub fn builder() -> ReleaseAnimationsParamsBuilder {
                ReleaseAnimationsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ReleaseAnimationsParamsBuilder {
            animations: Option<Vec<String>>,
        }
        impl ReleaseAnimationsParamsBuilder {
            pub fn animation(mut self, animation: impl Into<String>) -> Self {
                let v = self.animations.get_or_insert(Vec::new());
                v.push(animation.into());
                self
            }
            pub fn animations<I, S>(mut self, animations: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<String>,
            {
                let v = self.animations.get_or_insert(Vec::new());
                for val in animations {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ReleaseAnimationsParams, String> {
                Ok(ReleaseAnimationsParams {
                    animations: self.animations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(animations))
                    })?,
                })
            }
        }
        impl ReleaseAnimationsParams {
            pub const IDENTIFIER: &'static str = "Animation.releaseAnimations";
        }
        impl chromiumoxide_types::Method for ReleaseAnimationsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ReleaseAnimationsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Releases a set of animations to no longer be manipulated.\n[releaseAnimations](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-releaseAnimations)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ReleaseAnimationsReturns {}
        impl chromiumoxide_types::Command for ReleaseAnimationsParams {
            type Response = ReleaseAnimationsReturns;
        }
        #[doc = "Gets the remote object of the Animation.\n[resolveAnimation](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-resolveAnimation)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ResolveAnimationParams {
            #[doc = "Animation id."]
            #[serde(rename = "animationId")]
            pub animation_id: String,
        }
        impl ResolveAnimationParams {
            pub fn new(animation_id: impl Into<String>) -> Self {
                Self {
                    animation_id: animation_id.into(),
                }
            }
        }
        impl<T: Into<String>> From<T> for ResolveAnimationParams {
            fn from(url: T) -> Self {
                ResolveAnimationParams::new(url)
            }
        }
        impl ResolveAnimationParams {
            pub fn builder() -> ResolveAnimationParamsBuilder {
                ResolveAnimationParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ResolveAnimationParamsBuilder {
            animation_id: Option<String>,
        }
        impl ResolveAnimationParamsBuilder {
            pub fn animation_id(mut self, animation_id: impl Into<String>) -> Self {
                self.animation_id = Some(animation_id.into());
                self
            }
            pub fn build(self) -> Result<ResolveAnimationParams, String> {
                Ok(ResolveAnimationParams {
                    animation_id: self.animation_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(animation_id))
                    })?,
                })
            }
        }
        impl ResolveAnimationParams {
            pub const IDENTIFIER: &'static str = "Animation.resolveAnimation";
        }
        impl chromiumoxide_types::Method for ResolveAnimationParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ResolveAnimationParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Gets the remote object of the Animation.\n[resolveAnimation](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-resolveAnimation)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ResolveAnimationReturns {
            #[doc = "Corresponding remote object."]
            #[serde(rename = "remoteObject")]
            pub remote_object: super::super::js_protocol::runtime::RemoteObject,
        }
        impl ResolveAnimationReturns {
            pub fn new(
                remote_object: impl Into<super::super::js_protocol::runtime::RemoteObject>,
            ) -> Self {
                Self {
                    remote_object: remote_object.into(),
                }
            }
        }
        impl ResolveAnimationReturns {
            pub fn builder() -> ResolveAnimationReturnsBuilder {
                ResolveAnimationReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ResolveAnimationReturnsBuilder {
            remote_object: Option<super::super::js_protocol::runtime::RemoteObject>,
        }
        impl ResolveAnimationReturnsBuilder {
            pub fn remote_object(
                mut self,
                remote_object: impl Into<super::super::js_protocol::runtime::RemoteObject>,
            ) -> Self {
                self.remote_object = Some(remote_object.into());
                self
            }
            pub fn build(self) -> Result<ResolveAnimationReturns, String> {
                Ok(ResolveAnimationReturns {
                    remote_object: self.remote_object.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(remote_object))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for ResolveAnimationParams {
            type Response = ResolveAnimationReturns;
        }
        #[doc = "Seek a set of animations to a particular time within each animation.\n[seekAnimations](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-seekAnimations)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SeekAnimationsParams {
            #[doc = "List of animation ids to seek."]
            #[serde(rename = "animations")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub animations: Vec<String>,
            #[doc = "Set the current time of each animation."]
            #[serde(rename = "currentTime")]
            pub current_time: f64,
        }
        impl SeekAnimationsParams {
            pub fn new(animations: Vec<String>, current_time: impl Into<f64>) -> Self {
                Self {
                    animations,
                    current_time: current_time.into(),
                }
            }
        }
        impl SeekAnimationsParams {
            pub fn builder() -> SeekAnimationsParamsBuilder {
                SeekAnimationsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SeekAnimationsParamsBuilder {
            animations: Option<Vec<String>>,
            current_time: Option<f64>,
        }
        impl SeekAnimationsParamsBuilder {
            pub fn animation(mut self, animation: impl Into<String>) -> Self {
                let v = self.animations.get_or_insert(Vec::new());
                v.push(animation.into());
                self
            }
            pub fn animations<I, S>(mut self, animations: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<String>,
            {
                let v = self.animations.get_or_insert(Vec::new());
                for val in animations {
                    v.push(val.into());
                }
                self
            }
            pub fn current_time(mut self, current_time: impl Into<f64>) -> Self {
                self.current_time = Some(current_time.into());
                self
            }
            pub fn build(self) -> Result<SeekAnimationsParams, String> {
                Ok(SeekAnimationsParams {
                    animations: self.animations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(animations))
                    })?,
                    current_time: self.current_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(current_time))
                    })?,
                })
            }
        }
        impl SeekAnimationsParams {
            pub const IDENTIFIER: &'static str = "Animation.seekAnimations";
        }
        impl chromiumoxide_types::Method for SeekAnimationsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SeekAnimationsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Seek a set of animations to a particular time within each animation.\n[seekAnimations](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-seekAnimations)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SeekAnimationsReturns {}
        impl chromiumoxide_types::Command for SeekAnimationsParams {
            type Response = SeekAnimationsReturns;
        }
        #[doc = "Sets the paused state of a set of animations.\n[setPaused](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setPaused)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetPausedParams {
            #[doc = "Animations to set the pause state of."]
            #[serde(rename = "animations")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub animations: Vec<String>,
            #[doc = "Paused state to set to."]
            #[serde(rename = "paused")]
            pub paused: bool,
        }
        impl SetPausedParams {
            pub fn new(animations: Vec<String>, paused: impl Into<bool>) -> Self {
                Self {
                    animations,
                    paused: paused.into(),
                }
            }
        }
        impl SetPausedParams {
            pub fn builder() -> SetPausedParamsBuilder {
                SetPausedParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetPausedParamsBuilder {
            animations: Option<Vec<String>>,
            paused: Option<bool>,
        }
        impl SetPausedParamsBuilder {
            pub fn animation(mut self, animation: impl Into<String>) -> Self {
                let v = self.animations.get_or_insert(Vec::new());
                v.push(animation.into());
                self
            }
            pub fn animations<I, S>(mut self, animations: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<String>,
            {
                let v = self.animations.get_or_insert(Vec::new());
                for val in animations {
                    v.push(val.into());
                }
                self
            }
            pub fn paused(mut self, paused: impl Into<bool>) -> Self {
                self.paused = Some(paused.into());
                self
            }
            pub fn build(self) -> Result<SetPausedParams, String> {
                Ok(SetPausedParams {
                    animations: self.animations.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(animations))
                    })?,
                    paused: self.paused.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(paused))
                    })?,
                })
            }
        }
        impl SetPausedParams {
            pub const IDENTIFIER: &'static str = "Animation.setPaused";
        }
        impl chromiumoxide_types::Method for SetPausedParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetPausedParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets the paused state of a set of animations.\n[setPaused](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setPaused)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetPausedReturns {}
        impl chromiumoxide_types::Command for SetPausedParams {
            type Response = SetPausedReturns;
        }
        #[doc = "Sets the playback rate of the document timeline.\n[setPlaybackRate](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setPlaybackRate)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetPlaybackRateParams {
            #[doc = "Playback rate for animations on page"]
            #[serde(rename = "playbackRate")]
            pub playback_rate: f64,
        }
        impl SetPlaybackRateParams {
            pub fn new(playback_rate: impl Into<f64>) -> Self {
                Self {
                    playback_rate: playback_rate.into(),
                }
            }
        }
        impl SetPlaybackRateParams {
            pub fn builder() -> SetPlaybackRateParamsBuilder {
                SetPlaybackRateParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetPlaybackRateParamsBuilder {
            playback_rate: Option<f64>,
        }
        impl SetPlaybackRateParamsBuilder {
            pub fn playback_rate(mut self, playback_rate: impl Into<f64>) -> Self {
                self.playback_rate = Some(playback_rate.into());
                self
            }
            pub fn build(self) -> Result<SetPlaybackRateParams, String> {
                Ok(SetPlaybackRateParams {
                    playback_rate: self.playback_rate.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(playback_rate))
                    })?,
                })
            }
        }
        impl SetPlaybackRateParams {
            pub const IDENTIFIER: &'static str = "Animation.setPlaybackRate";
        }
        impl chromiumoxide_types::Method for SetPlaybackRateParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetPlaybackRateParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets the playback rate of the document timeline.\n[setPlaybackRate](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setPlaybackRate)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetPlaybackRateReturns {}
        impl chromiumoxide_types::Command for SetPlaybackRateParams {
            type Response = SetPlaybackRateReturns;
        }
        #[doc = "Sets the timing of an animation node.\n[setTiming](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setTiming)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetTimingParams {
            #[doc = "Animation id."]
            #[serde(rename = "animationId")]
            pub animation_id: String,
            #[doc = "Duration of the animation."]
            #[serde(rename = "duration")]
            pub duration: f64,
            #[doc = "Delay of the animation."]
            #[serde(rename = "delay")]
            pub delay: f64,
        }
        impl SetTimingParams {
            pub fn new(
                animation_id: impl Into<String>,
                duration: impl Into<f64>,
                delay: impl Into<f64>,
            ) -> Self {
                Self {
                    animation_id: animation_id.into(),
                    duration: duration.into(),
                    delay: delay.into(),
                }
            }
        }
        impl SetTimingParams {
            pub fn builder() -> SetTimingParamsBuilder {
                SetTimingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetTimingParamsBuilder {
            animation_id: Option<String>,
            duration: Option<f64>,
            delay: Option<f64>,
        }
        impl SetTimingParamsBuilder {
            pub fn animation_id(mut self, animation_id: impl Into<String>) -> Self {
                self.animation_id = Some(animation_id.into());
                self
            }
            pub fn duration(mut self, duration: impl Into<f64>) -> Self {
                self.duration = Some(duration.into());
                self
            }
            pub fn delay(mut self, delay: impl Into<f64>) -> Self {
                self.delay = Some(delay.into());
                self
            }
            pub fn build(self) -> Result<SetTimingParams, String> {
                Ok(SetTimingParams {
                    animation_id: self.animation_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(animation_id))
                    })?,
                    duration: self.duration.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(duration))
                    })?,
                    delay: self.delay.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(delay))
                    })?,
                })
            }
        }
        impl SetTimingParams {
            pub const IDENTIFIER: &'static str = "Animation.setTiming";
        }
        impl chromiumoxide_types::Method for SetTimingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetTimingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Sets the timing of an animation node.\n[setTiming](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#method-setTiming)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetTimingReturns {}
        impl chromiumoxide_types::Command for SetTimingParams {
            type Response = SetTimingReturns;
        }
        #[doc = "Event for when an animation has been cancelled.\n[animationCanceled](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationCanceled)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventAnimationCanceled {
            #[doc = "Id of the animation that was cancelled."]
            #[serde(rename = "id")]
            pub id: String,
        }
        impl EventAnimationCanceled {
            pub const IDENTIFIER: &'static str = "Animation.animationCanceled";
        }
        impl chromiumoxide_types::Method for EventAnimationCanceled {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventAnimationCanceled {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Event for each animation that has been created.\n[animationCreated](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationCreated)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventAnimationCreated {
            #[doc = "Id of the animation that was created."]
            #[serde(rename = "id")]
            pub id: String,
        }
        impl EventAnimationCreated {
            pub const IDENTIFIER: &'static str = "Animation.animationCreated";
        }
        impl chromiumoxide_types::Method for EventAnimationCreated {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventAnimationCreated {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Event for animation that has been started.\n[animationStarted](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationStarted)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventAnimationStarted {
            #[doc = "Animation that was started."]
            #[serde(rename = "animation")]
            pub animation: Animation,
        }
        impl EventAnimationStarted {
            pub const IDENTIFIER: &'static str = "Animation.animationStarted";
        }
        impl chromiumoxide_types::Method for EventAnimationStarted {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventAnimationStarted {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    pub mod application_cache {
        use serde::{Deserialize, Serialize};
        #[doc = "Detailed application cache resource information.\n[ApplicationCacheResource](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-ApplicationCacheResource)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ApplicationCacheResource {
            #[doc = "Resource url."]
            #[serde(rename = "url")]
            pub url: String,
            #[doc = "Resource size."]
            #[serde(rename = "size")]
            pub size: i64,
            #[doc = "Resource type."]
            #[serde(rename = "type")]
            pub r#type: String,
        }
        impl ApplicationCacheResource {
            pub fn new(
                url: impl Into<String>,
                size: impl Into<i64>,
                r#type: impl Into<String>,
            ) -> Self {
                Self {
                    url: url.into(),
                    size: size.into(),
                    r#type: r#type.into(),
                }
            }
        }
        impl ApplicationCacheResource {
            pub fn builder() -> ApplicationCacheResourceBuilder {
                ApplicationCacheResourceBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ApplicationCacheResourceBuilder {
            url: Option<String>,
            size: Option<i64>,
            r#type: Option<String>,
        }
        impl ApplicationCacheResourceBuilder {
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn size(mut self, size: impl Into<i64>) -> Self {
                self.size = Some(size.into());
                self
            }
            pub fn r#type(mut self, r#type: impl Into<String>) -> Self {
                self.r#type = Some(r#type.into());
                self
            }
            pub fn build(self) -> Result<ApplicationCacheResource, String> {
                Ok(ApplicationCacheResource {
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    size: self.size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(size))
                    })?,
                    r#type: self.r#type.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(r#type))
                    })?,
                })
            }
        }
        impl ApplicationCacheResource {
            pub const IDENTIFIER: &'static str = "ApplicationCache.ApplicationCacheResource";
        }
        #[doc = "Detailed application cache information.\n[ApplicationCache](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-ApplicationCache)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ApplicationCache {
            #[doc = "Manifest URL."]
            #[serde(rename = "manifestURL")]
            pub manifest_url: String,
            #[doc = "Application cache size."]
            #[serde(rename = "size")]
            pub size: f64,
            #[doc = "Application cache creation time."]
            #[serde(rename = "creationTime")]
            pub creation_time: f64,
            #[doc = "Application cache update time."]
            #[serde(rename = "updateTime")]
            pub update_time: f64,
            #[doc = "Application cache resources."]
            #[serde(rename = "resources")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub resources: Vec<ApplicationCacheResource>,
        }
        impl ApplicationCache {
            pub fn builder() -> ApplicationCacheBuilder {
                ApplicationCacheBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ApplicationCacheBuilder {
            manifest_url: Option<String>,
            size: Option<f64>,
            creation_time: Option<f64>,
            update_time: Option<f64>,
            resources: Option<Vec<ApplicationCacheResource>>,
        }
        impl ApplicationCacheBuilder {
            pub fn manifest_url(mut self, manifest_url: impl Into<String>) -> Self {
                self.manifest_url = Some(manifest_url.into());
                self
            }
            pub fn size(mut self, size: impl Into<f64>) -> Self {
                self.size = Some(size.into());
                self
            }
            pub fn creation_time(mut self, creation_time: impl Into<f64>) -> Self {
                self.creation_time = Some(creation_time.into());
                self
            }
            pub fn update_time(mut self, update_time: impl Into<f64>) -> Self {
                self.update_time = Some(update_time.into());
                self
            }
            pub fn resource(mut self, resource: impl Into<ApplicationCacheResource>) -> Self {
                let v = self.resources.get_or_insert(Vec::new());
                v.push(resource.into());
                self
            }
            pub fn resources<I, S>(mut self, resources: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<ApplicationCacheResource>,
            {
                let v = self.resources.get_or_insert(Vec::new());
                for val in resources {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<ApplicationCache, String> {
                Ok(ApplicationCache {
                    manifest_url: self.manifest_url.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(manifest_url))
                    })?,
                    size: self.size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(size))
                    })?,
                    creation_time: self.creation_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(creation_time))
                    })?,
                    update_time: self.update_time.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(update_time))
                    })?,
                    resources: self.resources.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(resources))
                    })?,
                })
            }
        }
        impl ApplicationCache {
            pub const IDENTIFIER: &'static str = "ApplicationCache.ApplicationCache";
        }
        #[doc = "Frame identifier - manifest URL pair.\n[FrameWithManifest](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-FrameWithManifest)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct FrameWithManifest {
            #[doc = "Frame identifier."]
            #[serde(rename = "frameId")]
            pub frame_id: super::page::FrameId,
            #[doc = "Manifest URL."]
            #[serde(rename = "manifestURL")]
            pub manifest_url: String,
            #[doc = "Application cache status."]
            #[serde(rename = "status")]
            pub status: i64,
        }
        impl FrameWithManifest {
            pub fn new(
                frame_id: impl Into<super::page::FrameId>,
                manifest_url: impl Into<String>,
                status: impl Into<i64>,
            ) -> Self {
                Self {
                    frame_id: frame_id.into(),
                    manifest_url: manifest_url.into(),
                    status: status.into(),
                }
            }
        }
        impl FrameWithManifest {
            pub fn builder() -> FrameWithManifestBuilder {
                FrameWithManifestBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct FrameWithManifestBuilder {
            frame_id: Option<super::page::FrameId>,
            manifest_url: Option<String>,
            status: Option<i64>,
        }
        impl FrameWithManifestBuilder {
            pub fn frame_id(mut self, frame_id: impl Into<super::page::FrameId>) -> Self {
                self.frame_id = Some(frame_id.into());
                self
            }
            pub fn manifest_url(mut self, manifest_url: impl Into<String>) -> Self {
                self.manifest_url = Some(manifest_url.into());
                self
            }
            pub fn status(mut self, status: impl Into<i64>) -> Self {
                self.status = Some(status.into());
                self
            }
            pub fn build(self) -> Result<FrameWithManifest, String> {
                Ok(FrameWithManifest {
                    frame_id: self.frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame_id))
                    })?,
                    manifest_url: self.manifest_url.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(manifest_url))
                    })?,
                    status: self.status.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(status))
                    })?,
                })
            }
        }
        impl FrameWithManifest {
            pub const IDENTIFIER: &'static str = "ApplicationCache.FrameWithManifest";
        }
        #[doc = "Enables application cache domain notifications.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "ApplicationCache.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables application cache domain notifications.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[doc = "Returns relevant application cache data for the document in given frame.\n[getApplicationCacheForFrame](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getApplicationCacheForFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetApplicationCacheForFrameParams {
            #[doc = "Identifier of the frame containing document whose application cache is retrieved."]
            #[serde(rename = "frameId")]
            pub frame_id: super::page::FrameId,
        }
        impl GetApplicationCacheForFrameParams {
            pub fn new(frame_id: impl Into<super::page::FrameId>) -> Self {
                Self {
                    frame_id: frame_id.into(),
                }
            }
        }
        impl GetApplicationCacheForFrameParams {
            pub fn builder() -> GetApplicationCacheForFrameParamsBuilder {
                GetApplicationCacheForFrameParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetApplicationCacheForFrameParamsBuilder {
            frame_id: Option<super::page::FrameId>,
        }
        impl GetApplicationCacheForFrameParamsBuilder {
            pub fn frame_id(mut self, frame_id: impl Into<super::page::FrameId>) -> Self {
                self.frame_id = Some(frame_id.into());
                self
            }
            pub fn build(self) -> Result<GetApplicationCacheForFrameParams, String> {
                Ok(GetApplicationCacheForFrameParams {
                    frame_id: self.frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame_id))
                    })?,
                })
            }
        }
        impl GetApplicationCacheForFrameParams {
            pub const IDENTIFIER: &'static str = "ApplicationCache.getApplicationCacheForFrame";
        }
        impl chromiumoxide_types::Method for GetApplicationCacheForFrameParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetApplicationCacheForFrameParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns relevant application cache data for the document in given frame.\n[getApplicationCacheForFrame](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getApplicationCacheForFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetApplicationCacheForFrameReturns {
            #[doc = "Relevant application cache data for the document in given frame."]
            #[serde(rename = "applicationCache")]
            pub application_cache: ApplicationCache,
        }
        impl GetApplicationCacheForFrameReturns {
            pub fn new(application_cache: impl Into<ApplicationCache>) -> Self {
                Self {
                    application_cache: application_cache.into(),
                }
            }
        }
        impl GetApplicationCacheForFrameReturns {
            pub fn builder() -> GetApplicationCacheForFrameReturnsBuilder {
                GetApplicationCacheForFrameReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetApplicationCacheForFrameReturnsBuilder {
            application_cache: Option<ApplicationCache>,
        }
        impl GetApplicationCacheForFrameReturnsBuilder {
            pub fn application_cache(
                mut self,
                application_cache: impl Into<ApplicationCache>,
            ) -> Self {
                self.application_cache = Some(application_cache.into());
                self
            }
            pub fn build(self) -> Result<GetApplicationCacheForFrameReturns, String> {
                Ok(GetApplicationCacheForFrameReturns {
                    application_cache: self.application_cache.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(application_cache)
                        )
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetApplicationCacheForFrameParams {
            type Response = GetApplicationCacheForFrameReturns;
        }
        #[doc = "Returns array of frame identifiers with manifest urls for each frame containing a document\nassociated with some application cache.\n[getFramesWithManifests](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getFramesWithManifests)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct GetFramesWithManifestsParams {}
        impl GetFramesWithManifestsParams {
            pub const IDENTIFIER: &'static str = "ApplicationCache.getFramesWithManifests";
        }
        impl chromiumoxide_types::Method for GetFramesWithManifestsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetFramesWithManifestsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns array of frame identifiers with manifest urls for each frame containing a document\nassociated with some application cache.\n[getFramesWithManifests](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getFramesWithManifests)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetFramesWithManifestsReturns {
            #[doc = "Array of frame identifiers with manifest urls for each frame containing a document\nassociated with some application cache."]
            #[serde(rename = "frameIds")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub frame_ids: Vec<FrameWithManifest>,
        }
        impl GetFramesWithManifestsReturns {
            pub fn new(frame_ids: Vec<FrameWithManifest>) -> Self {
                Self { frame_ids }
            }
        }
        impl GetFramesWithManifestsReturns {
            pub fn builder() -> GetFramesWithManifestsReturnsBuilder {
                GetFramesWithManifestsReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetFramesWithManifestsReturnsBuilder {
            frame_ids: Option<Vec<FrameWithManifest>>,
        }
        impl GetFramesWithManifestsReturnsBuilder {
            pub fn frame_id(mut self, frame_id: impl Into<FrameWithManifest>) -> Self {
                let v = self.frame_ids.get_or_insert(Vec::new());
                v.push(frame_id.into());
                self
            }
            pub fn frame_ids<I, S>(mut self, frame_ids: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<FrameWithManifest>,
            {
                let v = self.frame_ids.get_or_insert(Vec::new());
                for val in frame_ids {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<GetFramesWithManifestsReturns, String> {
                Ok(GetFramesWithManifestsReturns {
                    frame_ids: self.frame_ids.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame_ids))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetFramesWithManifestsParams {
            type Response = GetFramesWithManifestsReturns;
        }
        #[doc = "Returns manifest URL for document in the given frame.\n[getManifestForFrame](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getManifestForFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetManifestForFrameParams {
            #[doc = "Identifier of the frame containing document whose manifest is retrieved."]
            #[serde(rename = "frameId")]
            pub frame_id: super::page::FrameId,
        }
        impl GetManifestForFrameParams {
            pub fn new(frame_id: impl Into<super::page::FrameId>) -> Self {
                Self {
                    frame_id: frame_id.into(),
                }
            }
        }
        impl GetManifestForFrameParams {
            pub fn builder() -> GetManifestForFrameParamsBuilder {
                GetManifestForFrameParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetManifestForFrameParamsBuilder {
            frame_id: Option<super::page::FrameId>,
        }
        impl GetManifestForFrameParamsBuilder {
            pub fn frame_id(mut self, frame_id: impl Into<super::page::FrameId>) -> Self {
                self.frame_id = Some(frame_id.into());
                self
            }
            pub fn build(self) -> Result<GetManifestForFrameParams, String> {
                Ok(GetManifestForFrameParams {
                    frame_id: self.frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame_id))
                    })?,
                })
            }
        }
        impl GetManifestForFrameParams {
            pub const IDENTIFIER: &'static str = "ApplicationCache.getManifestForFrame";
        }
        impl chromiumoxide_types::Method for GetManifestForFrameParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetManifestForFrameParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns manifest URL for document in the given frame.\n[getManifestForFrame](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#method-getManifestForFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetManifestForFrameReturns {
            #[doc = "Manifest URL for document in the given frame."]
            #[serde(rename = "manifestURL")]
            pub manifest_url: String,
        }
        impl GetManifestForFrameReturns {
            pub fn new(manifest_url: impl Into<String>) -> Self {
                Self {
                    manifest_url: manifest_url.into(),
                }
            }
        }
        impl<T: Into<String>> From<T> for GetManifestForFrameReturns {
            fn from(url: T) -> Self {
                GetManifestForFrameReturns::new(url)
            }
        }
        impl GetManifestForFrameReturns {
            pub fn builder() -> GetManifestForFrameReturnsBuilder {
                GetManifestForFrameReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetManifestForFrameReturnsBuilder {
            manifest_url: Option<String>,
        }
        impl GetManifestForFrameReturnsBuilder {
            pub fn manifest_url(mut self, manifest_url: impl Into<String>) -> Self {
                self.manifest_url = Some(manifest_url.into());
                self
            }
            pub fn build(self) -> Result<GetManifestForFrameReturns, String> {
                Ok(GetManifestForFrameReturns {
                    manifest_url: self.manifest_url.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(manifest_url))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetManifestForFrameParams {
            type Response = GetManifestForFrameReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventApplicationCacheStatusUpdated {
            #[doc = "Identifier of the frame containing document whose application cache updated status."]
            #[serde(rename = "frameId")]
            pub frame_id: super::page::FrameId,
            #[doc = "Manifest URL."]
            #[serde(rename = "manifestURL")]
            pub manifest_url: String,
            #[doc = "Updated application cache status."]
            #[serde(rename = "status")]
            pub status: i64,
        }
        impl EventApplicationCacheStatusUpdated {
            pub const IDENTIFIER: &'static str = "ApplicationCache.applicationCacheStatusUpdated";
        }
        impl chromiumoxide_types::Method for EventApplicationCacheStatusUpdated {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventApplicationCacheStatusUpdated {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventNetworkStateUpdated {
            #[serde(rename = "isNowOnline")]
            pub is_now_online: bool,
        }
        impl EventNetworkStateUpdated {
            pub const IDENTIFIER: &'static str = "ApplicationCache.networkStateUpdated";
        }
        impl chromiumoxide_types::Method for EventNetworkStateUpdated {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventNetworkStateUpdated {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    #[doc = "Audits domain allows investigation of page violations and possible improvements."]
    pub mod audits {
        use serde::{Deserialize, Serialize};
        #[doc = "Information about a cookie that is affected by an inspector issue.\n[AffectedCookie](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-AffectedCookie)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AffectedCookie {
            #[doc = "The following three properties uniquely identify a cookie"]
            #[serde(rename = "name")]
            pub name: String,
            #[serde(rename = "path")]
            pub path: String,
            #[serde(rename = "domain")]
            pub domain: String,
        }
        impl AffectedCookie {
            pub fn new(
                name: impl Into<String>,
                path: impl Into<String>,
                domain: impl Into<String>,
            ) -> Self {
                Self {
                    name: name.into(),
                    path: path.into(),
                    domain: domain.into(),
                }
            }
        }
        impl AffectedCookie {
            pub fn builder() -> AffectedCookieBuilder {
                AffectedCookieBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AffectedCookieBuilder {
            name: Option<String>,
            path: Option<String>,
            domain: Option<String>,
        }
        impl AffectedCookieBuilder {
            pub fn name(mut self, name: impl Into<String>) -> Self {
                self.name = Some(name.into());
                self
            }
            pub fn path(mut self, path: impl Into<String>) -> Self {
                self.path = Some(path.into());
                self
            }
            pub fn domain(mut self, domain: impl Into<String>) -> Self {
                self.domain = Some(domain.into());
                self
            }
            pub fn build(self) -> Result<AffectedCookie, String> {
                Ok(AffectedCookie {
                    name: self.name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(name))
                    })?,
                    path: self.path.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(path))
                    })?,
                    domain: self.domain.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(domain))
                    })?,
                })
            }
        }
        impl AffectedCookie {
            pub const IDENTIFIER: &'static str = "Audits.AffectedCookie";
        }
        #[doc = "Information about a request that is affected by an inspector issue.\n[AffectedRequest](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-AffectedRequest)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AffectedRequest {
            #[doc = "The unique request id."]
            #[serde(rename = "requestId")]
            pub request_id: super::network::RequestId,
            #[serde(rename = "url")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub url: Option<String>,
        }
        impl AffectedRequest {
            pub fn new(request_id: impl Into<super::network::RequestId>) -> Self {
                Self {
                    request_id: request_id.into(),
                    url: None,
                }
            }
        }
        impl AffectedRequest {
            pub fn builder() -> AffectedRequestBuilder {
                AffectedRequestBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AffectedRequestBuilder {
            request_id: Option<super::network::RequestId>,
            url: Option<String>,
        }
        impl AffectedRequestBuilder {
            pub fn request_id(mut self, request_id: impl Into<super::network::RequestId>) -> Self {
                self.request_id = Some(request_id.into());
                self
            }
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn build(self) -> Result<AffectedRequest, String> {
                Ok(AffectedRequest {
                    request_id: self.request_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(request_id))
                    })?,
                    url: self.url,
                })
            }
        }
        impl AffectedRequest {
            pub const IDENTIFIER: &'static str = "Audits.AffectedRequest";
        }
        #[doc = "Information about the frame affected by an inspector issue.\n[AffectedFrame](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-AffectedFrame)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct AffectedFrame {
            #[serde(rename = "frameId")]
            pub frame_id: super::page::FrameId,
        }
        impl AffectedFrame {
            pub fn new(frame_id: impl Into<super::page::FrameId>) -> Self {
                Self {
                    frame_id: frame_id.into(),
                }
            }
        }
        impl AffectedFrame {
            pub fn builder() -> AffectedFrameBuilder {
                AffectedFrameBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct AffectedFrameBuilder {
            frame_id: Option<super::page::FrameId>,
        }
        impl AffectedFrameBuilder {
            pub fn frame_id(mut self, frame_id: impl Into<super::page::FrameId>) -> Self {
                self.frame_id = Some(frame_id.into());
                self
            }
            pub fn build(self) -> Result<AffectedFrame, String> {
                Ok(AffectedFrame {
                    frame_id: self.frame_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame_id))
                    })?,
                })
            }
        }
        impl AffectedFrame {
            pub const IDENTIFIER: &'static str = "Audits.AffectedFrame";
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum SameSiteCookieExclusionReason {
            #[serde(rename = "ExcludeSameSiteUnspecifiedTreatedAsLax")]
            ExcludeSameSiteUnspecifiedTreatedAsLax,
            #[serde(rename = "ExcludeSameSiteNoneInsecure")]
            ExcludeSameSiteNoneInsecure,
            #[serde(rename = "ExcludeSameSiteLax")]
            ExcludeSameSiteLax,
            #[serde(rename = "ExcludeSameSiteStrict")]
            ExcludeSameSiteStrict,
        }
        impl AsRef<str> for SameSiteCookieExclusionReason {
            fn as_ref(&self) -> &str {
                match self {
                    SameSiteCookieExclusionReason::ExcludeSameSiteUnspecifiedTreatedAsLax => {
                        "ExcludeSameSiteUnspecifiedTreatedAsLax"
                    }
                    SameSiteCookieExclusionReason::ExcludeSameSiteNoneInsecure => {
                        "ExcludeSameSiteNoneInsecure"
                    }
                    SameSiteCookieExclusionReason::ExcludeSameSiteLax => "ExcludeSameSiteLax",
                    SameSiteCookieExclusionReason::ExcludeSameSiteStrict => "ExcludeSameSiteStrict",
                }
            }
        }
        impl ::std::str::FromStr for SameSiteCookieExclusionReason {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "ExcludeSameSiteUnspecifiedTreatedAsLax"
                    | "excludesamesiteunspecifiedtreatedaslax" => {
                        Ok(SameSiteCookieExclusionReason::ExcludeSameSiteUnspecifiedTreatedAsLax)
                    }
                    "ExcludeSameSiteNoneInsecure" | "excludesamesitenoneinsecure" => {
                        Ok(SameSiteCookieExclusionReason::ExcludeSameSiteNoneInsecure)
                    }
                    "ExcludeSameSiteLax" | "excludesamesitelax" => {
                        Ok(SameSiteCookieExclusionReason::ExcludeSameSiteLax)
                    }
                    "ExcludeSameSiteStrict" | "excludesamesitestrict" => {
                        Ok(SameSiteCookieExclusionReason::ExcludeSameSiteStrict)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum SameSiteCookieWarningReason {
            #[serde(rename = "WarnSameSiteUnspecifiedCrossSiteContext")]
            WarnSameSiteUnspecifiedCrossSiteContext,
            #[serde(rename = "WarnSameSiteNoneInsecure")]
            WarnSameSiteNoneInsecure,
            #[serde(rename = "WarnSameSiteUnspecifiedLaxAllowUnsafe")]
            WarnSameSiteUnspecifiedLaxAllowUnsafe,
            #[serde(rename = "WarnSameSiteStrictLaxDowngradeStrict")]
            WarnSameSiteStrictLaxDowngradeStrict,
            #[serde(rename = "WarnSameSiteStrictCrossDowngradeStrict")]
            WarnSameSiteStrictCrossDowngradeStrict,
            #[serde(rename = "WarnSameSiteStrictCrossDowngradeLax")]
            WarnSameSiteStrictCrossDowngradeLax,
            #[serde(rename = "WarnSameSiteLaxCrossDowngradeStrict")]
            WarnSameSiteLaxCrossDowngradeStrict,
            #[serde(rename = "WarnSameSiteLaxCrossDowngradeLax")]
            WarnSameSiteLaxCrossDowngradeLax,
        }
        impl AsRef<str> for SameSiteCookieWarningReason {
            fn as_ref(&self) -> &str {
                match self {
                    SameSiteCookieWarningReason::WarnSameSiteUnspecifiedCrossSiteContext => {
                        "WarnSameSiteUnspecifiedCrossSiteContext"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteNoneInsecure => {
                        "WarnSameSiteNoneInsecure"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteUnspecifiedLaxAllowUnsafe => {
                        "WarnSameSiteUnspecifiedLaxAllowUnsafe"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteStrictLaxDowngradeStrict => {
                        "WarnSameSiteStrictLaxDowngradeStrict"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteStrictCrossDowngradeStrict => {
                        "WarnSameSiteStrictCrossDowngradeStrict"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteStrictCrossDowngradeLax => {
                        "WarnSameSiteStrictCrossDowngradeLax"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteLaxCrossDowngradeStrict => {
                        "WarnSameSiteLaxCrossDowngradeStrict"
                    }
                    SameSiteCookieWarningReason::WarnSameSiteLaxCrossDowngradeLax => {
                        "WarnSameSiteLaxCrossDowngradeLax"
                    }
                }
            }
        }
        impl ::std::str::FromStr for SameSiteCookieWarningReason {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "WarnSameSiteUnspecifiedCrossSiteContext"
                    | "warnsamesiteunspecifiedcrosssitecontext" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteUnspecifiedCrossSiteContext)
                    }
                    "WarnSameSiteNoneInsecure" | "warnsamesitenoneinsecure" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteNoneInsecure)
                    }
                    "WarnSameSiteUnspecifiedLaxAllowUnsafe"
                    | "warnsamesiteunspecifiedlaxallowunsafe" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteUnspecifiedLaxAllowUnsafe)
                    }
                    "WarnSameSiteStrictLaxDowngradeStrict"
                    | "warnsamesitestrictlaxdowngradestrict" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteStrictLaxDowngradeStrict)
                    }
                    "WarnSameSiteStrictCrossDowngradeStrict"
                    | "warnsamesitestrictcrossdowngradestrict" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteStrictCrossDowngradeStrict)
                    }
                    "WarnSameSiteStrictCrossDowngradeLax"
                    | "warnsamesitestrictcrossdowngradelax" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteStrictCrossDowngradeLax)
                    }
                    "WarnSameSiteLaxCrossDowngradeStrict"
                    | "warnsamesitelaxcrossdowngradestrict" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteLaxCrossDowngradeStrict)
                    }
                    "WarnSameSiteLaxCrossDowngradeLax" | "warnsamesitelaxcrossdowngradelax" => {
                        Ok(SameSiteCookieWarningReason::WarnSameSiteLaxCrossDowngradeLax)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum SameSiteCookieOperation {
            #[serde(rename = "SetCookie")]
            SetCookie,
            #[serde(rename = "ReadCookie")]
            ReadCookie,
        }
        impl AsRef<str> for SameSiteCookieOperation {
            fn as_ref(&self) -> &str {
                match self {
                    SameSiteCookieOperation::SetCookie => "SetCookie",
                    SameSiteCookieOperation::ReadCookie => "ReadCookie",
                }
            }
        }
        impl ::std::str::FromStr for SameSiteCookieOperation {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "SetCookie" | "setcookie" => Ok(SameSiteCookieOperation::SetCookie),
                    "ReadCookie" | "readcookie" => Ok(SameSiteCookieOperation::ReadCookie),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "This information is currently necessary, as the front-end has a difficult\ntime finding a specific cookie. With this, we can convey specific error\ninformation without the cookie.\n[SameSiteCookieIssueDetails](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-SameSiteCookieIssueDetails)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SameSiteCookieIssueDetails {
            #[serde(rename = "cookie")]
            pub cookie: AffectedCookie,
            #[serde(rename = "cookieWarningReasons")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub cookie_warning_reasons: Vec<SameSiteCookieWarningReason>,
            #[serde(rename = "cookieExclusionReasons")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub cookie_exclusion_reasons: Vec<SameSiteCookieExclusionReason>,
            #[doc = "Optionally identifies the site-for-cookies and the cookie url, which\nmay be used by the front-end as additional context."]
            #[serde(rename = "operation")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub operation: SameSiteCookieOperation,
            #[serde(rename = "siteForCookies")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub site_for_cookies: Option<String>,
            #[serde(rename = "cookieUrl")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub cookie_url: Option<String>,
            #[serde(rename = "request")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub request: Option<AffectedRequest>,
        }
        impl SameSiteCookieIssueDetails {
            pub fn new(
                cookie: impl Into<AffectedCookie>,
                cookie_warning_reasons: Vec<SameSiteCookieWarningReason>,
                cookie_exclusion_reasons: Vec<SameSiteCookieExclusionReason>,
                operation: impl Into<SameSiteCookieOperation>,
            ) -> Self {
                Self {
                    cookie: cookie.into(),
                    cookie_warning_reasons,
                    cookie_exclusion_reasons,
                    operation: operation.into(),
                    site_for_cookies: None,
                    cookie_url: None,
                    request: None,
                }
            }
        }
        impl SameSiteCookieIssueDetails {
            pub fn builder() -> SameSiteCookieIssueDetailsBuilder {
                SameSiteCookieIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SameSiteCookieIssueDetailsBuilder {
            cookie: Option<AffectedCookie>,
            cookie_warning_reasons: Option<Vec<SameSiteCookieWarningReason>>,
            cookie_exclusion_reasons: Option<Vec<SameSiteCookieExclusionReason>>,
            operation: Option<SameSiteCookieOperation>,
            site_for_cookies: Option<String>,
            cookie_url: Option<String>,
            request: Option<AffectedRequest>,
        }
        impl SameSiteCookieIssueDetailsBuilder {
            pub fn cookie(mut self, cookie: impl Into<AffectedCookie>) -> Self {
                self.cookie = Some(cookie.into());
                self
            }
            pub fn cookie_warning_reason(
                mut self,
                cookie_warning_reason: impl Into<SameSiteCookieWarningReason>,
            ) -> Self {
                let v = self.cookie_warning_reasons.get_or_insert(Vec::new());
                v.push(cookie_warning_reason.into());
                self
            }
            pub fn cookie_warning_reasons<I, S>(mut self, cookie_warning_reasons: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<SameSiteCookieWarningReason>,
            {
                let v = self.cookie_warning_reasons.get_or_insert(Vec::new());
                for val in cookie_warning_reasons {
                    v.push(val.into());
                }
                self
            }
            pub fn cookie_exclusion_reason(
                mut self,
                cookie_exclusion_reason: impl Into<SameSiteCookieExclusionReason>,
            ) -> Self {
                let v = self.cookie_exclusion_reasons.get_or_insert(Vec::new());
                v.push(cookie_exclusion_reason.into());
                self
            }
            pub fn cookie_exclusion_reasons<I, S>(mut self, cookie_exclusion_reasons: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<SameSiteCookieExclusionReason>,
            {
                let v = self.cookie_exclusion_reasons.get_or_insert(Vec::new());
                for val in cookie_exclusion_reasons {
                    v.push(val.into());
                }
                self
            }
            pub fn operation(mut self, operation: impl Into<SameSiteCookieOperation>) -> Self {
                self.operation = Some(operation.into());
                self
            }
            pub fn site_for_cookies(mut self, site_for_cookies: impl Into<String>) -> Self {
                self.site_for_cookies = Some(site_for_cookies.into());
                self
            }
            pub fn cookie_url(mut self, cookie_url: impl Into<String>) -> Self {
                self.cookie_url = Some(cookie_url.into());
                self
            }
            pub fn request(mut self, request: impl Into<AffectedRequest>) -> Self {
                self.request = Some(request.into());
                self
            }
            pub fn build(self) -> Result<SameSiteCookieIssueDetails, String> {
                Ok(SameSiteCookieIssueDetails {
                    cookie: self.cookie.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(cookie))
                    })?,
                    cookie_warning_reasons: self.cookie_warning_reasons.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(cookie_warning_reasons)
                        )
                    })?,
                    cookie_exclusion_reasons: self.cookie_exclusion_reasons.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(cookie_exclusion_reasons)
                        )
                    })?,
                    operation: self.operation.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(operation))
                    })?,
                    site_for_cookies: self.site_for_cookies,
                    cookie_url: self.cookie_url,
                    request: self.request,
                })
            }
        }
        impl SameSiteCookieIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.SameSiteCookieIssueDetails";
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum MixedContentResolutionStatus {
            #[serde(rename = "MixedContentBlocked")]
            MixedContentBlocked,
            #[serde(rename = "MixedContentAutomaticallyUpgraded")]
            MixedContentAutomaticallyUpgraded,
            #[serde(rename = "MixedContentWarning")]
            MixedContentWarning,
        }
        impl AsRef<str> for MixedContentResolutionStatus {
            fn as_ref(&self) -> &str {
                match self {
                    MixedContentResolutionStatus::MixedContentBlocked => "MixedContentBlocked",
                    MixedContentResolutionStatus::MixedContentAutomaticallyUpgraded => {
                        "MixedContentAutomaticallyUpgraded"
                    }
                    MixedContentResolutionStatus::MixedContentWarning => "MixedContentWarning",
                }
            }
        }
        impl ::std::str::FromStr for MixedContentResolutionStatus {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "MixedContentBlocked" | "mixedcontentblocked" => {
                        Ok(MixedContentResolutionStatus::MixedContentBlocked)
                    }
                    "MixedContentAutomaticallyUpgraded" | "mixedcontentautomaticallyupgraded" => {
                        Ok(MixedContentResolutionStatus::MixedContentAutomaticallyUpgraded)
                    }
                    "MixedContentWarning" | "mixedcontentwarning" => {
                        Ok(MixedContentResolutionStatus::MixedContentWarning)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum MixedContentResourceType {
            #[serde(rename = "Audio")]
            Audio,
            #[serde(rename = "Beacon")]
            Beacon,
            #[serde(rename = "CSPReport")]
            CspReport,
            #[serde(rename = "Download")]
            Download,
            #[serde(rename = "EventSource")]
            EventSource,
            #[serde(rename = "Favicon")]
            Favicon,
            #[serde(rename = "Font")]
            Font,
            #[serde(rename = "Form")]
            Form,
            #[serde(rename = "Frame")]
            Frame,
            #[serde(rename = "Image")]
            Image,
            #[serde(rename = "Import")]
            Import,
            #[serde(rename = "Manifest")]
            Manifest,
            #[serde(rename = "Ping")]
            Ping,
            #[serde(rename = "PluginData")]
            PluginData,
            #[serde(rename = "PluginResource")]
            PluginResource,
            #[serde(rename = "Prefetch")]
            Prefetch,
            #[serde(rename = "Resource")]
            Resource,
            #[serde(rename = "Script")]
            Script,
            #[serde(rename = "ServiceWorker")]
            ServiceWorker,
            #[serde(rename = "SharedWorker")]
            SharedWorker,
            #[serde(rename = "Stylesheet")]
            Stylesheet,
            #[serde(rename = "Track")]
            Track,
            #[serde(rename = "Video")]
            Video,
            #[serde(rename = "Worker")]
            Worker,
            #[serde(rename = "XMLHttpRequest")]
            XmlHttpRequest,
            #[serde(rename = "XSLT")]
            Xslt,
        }
        impl AsRef<str> for MixedContentResourceType {
            fn as_ref(&self) -> &str {
                match self {
                    MixedContentResourceType::Audio => "Audio",
                    MixedContentResourceType::Beacon => "Beacon",
                    MixedContentResourceType::CspReport => "CSPReport",
                    MixedContentResourceType::Download => "Download",
                    MixedContentResourceType::EventSource => "EventSource",
                    MixedContentResourceType::Favicon => "Favicon",
                    MixedContentResourceType::Font => "Font",
                    MixedContentResourceType::Form => "Form",
                    MixedContentResourceType::Frame => "Frame",
                    MixedContentResourceType::Image => "Image",
                    MixedContentResourceType::Import => "Import",
                    MixedContentResourceType::Manifest => "Manifest",
                    MixedContentResourceType::Ping => "Ping",
                    MixedContentResourceType::PluginData => "PluginData",
                    MixedContentResourceType::PluginResource => "PluginResource",
                    MixedContentResourceType::Prefetch => "Prefetch",
                    MixedContentResourceType::Resource => "Resource",
                    MixedContentResourceType::Script => "Script",
                    MixedContentResourceType::ServiceWorker => "ServiceWorker",
                    MixedContentResourceType::SharedWorker => "SharedWorker",
                    MixedContentResourceType::Stylesheet => "Stylesheet",
                    MixedContentResourceType::Track => "Track",
                    MixedContentResourceType::Video => "Video",
                    MixedContentResourceType::Worker => "Worker",
                    MixedContentResourceType::XmlHttpRequest => "XMLHttpRequest",
                    MixedContentResourceType::Xslt => "XSLT",
                }
            }
        }
        impl ::std::str::FromStr for MixedContentResourceType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "Audio" | "audio" => Ok(MixedContentResourceType::Audio),
                    "Beacon" | "beacon" => Ok(MixedContentResourceType::Beacon),
                    "CSPReport" | "CspReport" | "cspreport" => {
                        Ok(MixedContentResourceType::CspReport)
                    }
                    "Download" | "download" => Ok(MixedContentResourceType::Download),
                    "EventSource" | "eventsource" => Ok(MixedContentResourceType::EventSource),
                    "Favicon" | "favicon" => Ok(MixedContentResourceType::Favicon),
                    "Font" | "font" => Ok(MixedContentResourceType::Font),
                    "Form" | "form" => Ok(MixedContentResourceType::Form),
                    "Frame" | "frame" => Ok(MixedContentResourceType::Frame),
                    "Image" | "image" => Ok(MixedContentResourceType::Image),
                    "Import" | "import" => Ok(MixedContentResourceType::Import),
                    "Manifest" | "manifest" => Ok(MixedContentResourceType::Manifest),
                    "Ping" | "ping" => Ok(MixedContentResourceType::Ping),
                    "PluginData" | "plugindata" => Ok(MixedContentResourceType::PluginData),
                    "PluginResource" | "pluginresource" => {
                        Ok(MixedContentResourceType::PluginResource)
                    }
                    "Prefetch" | "prefetch" => Ok(MixedContentResourceType::Prefetch),
                    "Resource" | "resource" => Ok(MixedContentResourceType::Resource),
                    "Script" | "script" => Ok(MixedContentResourceType::Script),
                    "ServiceWorker" | "serviceworker" => {
                        Ok(MixedContentResourceType::ServiceWorker)
                    }
                    "SharedWorker" | "sharedworker" => Ok(MixedContentResourceType::SharedWorker),
                    "Stylesheet" | "stylesheet" => Ok(MixedContentResourceType::Stylesheet),
                    "Track" | "track" => Ok(MixedContentResourceType::Track),
                    "Video" | "video" => Ok(MixedContentResourceType::Video),
                    "Worker" | "worker" => Ok(MixedContentResourceType::Worker),
                    "XMLHttpRequest" | "XmlHttpRequest" | "xmlhttprequest" => {
                        Ok(MixedContentResourceType::XmlHttpRequest)
                    }
                    "XSLT" | "Xslt" | "xslt" => Ok(MixedContentResourceType::Xslt),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct MixedContentIssueDetails {
            #[doc = "The type of resource causing the mixed content issue (css, js, iframe,\nform,...). Marked as optional because it is mapped to from\nblink::mojom::RequestContextType, which will be replaced\nby network::mojom::RequestDestination"]
            #[serde(rename = "resourceType")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub resource_type: Option<MixedContentResourceType>,
            #[doc = "The way the mixed content issue is being resolved."]
            #[serde(rename = "resolutionStatus")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub resolution_status: MixedContentResolutionStatus,
            #[doc = "The unsafe http url causing the mixed content issue."]
            #[serde(rename = "insecureURL")]
            pub insecure_url: String,
            #[doc = "The url responsible for the call to an unsafe url."]
            #[serde(rename = "mainResourceURL")]
            pub main_resource_url: String,
            #[doc = "The mixed content request.\nDoes not always exist (e.g. for unsafe form submission urls)."]
            #[serde(rename = "request")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub request: Option<AffectedRequest>,
            #[doc = "Optional because not every mixed content issue is necessarily linked to a frame."]
            #[serde(rename = "frame")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub frame: Option<AffectedFrame>,
        }
        impl MixedContentIssueDetails {
            pub fn new(
                resolution_status: impl Into<MixedContentResolutionStatus>,
                insecure_url: impl Into<String>,
                main_resource_url: impl Into<String>,
            ) -> Self {
                Self {
                    resolution_status: resolution_status.into(),
                    insecure_url: insecure_url.into(),
                    main_resource_url: main_resource_url.into(),
                    resource_type: None,
                    request: None,
                    frame: None,
                }
            }
        }
        impl MixedContentIssueDetails {
            pub fn builder() -> MixedContentIssueDetailsBuilder {
                MixedContentIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct MixedContentIssueDetailsBuilder {
            resource_type: Option<MixedContentResourceType>,
            resolution_status: Option<MixedContentResolutionStatus>,
            insecure_url: Option<String>,
            main_resource_url: Option<String>,
            request: Option<AffectedRequest>,
            frame: Option<AffectedFrame>,
        }
        impl MixedContentIssueDetailsBuilder {
            pub fn resource_type(
                mut self,
                resource_type: impl Into<MixedContentResourceType>,
            ) -> Self {
                self.resource_type = Some(resource_type.into());
                self
            }
            pub fn resolution_status(
                mut self,
                resolution_status: impl Into<MixedContentResolutionStatus>,
            ) -> Self {
                self.resolution_status = Some(resolution_status.into());
                self
            }
            pub fn insecure_url(mut self, insecure_url: impl Into<String>) -> Self {
                self.insecure_url = Some(insecure_url.into());
                self
            }
            pub fn main_resource_url(mut self, main_resource_url: impl Into<String>) -> Self {
                self.main_resource_url = Some(main_resource_url.into());
                self
            }
            pub fn request(mut self, request: impl Into<AffectedRequest>) -> Self {
                self.request = Some(request.into());
                self
            }
            pub fn frame(mut self, frame: impl Into<AffectedFrame>) -> Self {
                self.frame = Some(frame.into());
                self
            }
            pub fn build(self) -> Result<MixedContentIssueDetails, String> {
                Ok(MixedContentIssueDetails {
                    resource_type: self.resource_type,
                    resolution_status: self.resolution_status.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(resolution_status)
                        )
                    })?,
                    insecure_url: self.insecure_url.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(insecure_url))
                    })?,
                    main_resource_url: self.main_resource_url.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(main_resource_url)
                        )
                    })?,
                    request: self.request,
                    frame: self.frame,
                })
            }
        }
        impl MixedContentIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.MixedContentIssueDetails";
        }
        #[doc = "Enum indicating the reason a response has been blocked. These reasons are\nrefinements of the net error BLOCKED_BY_RESPONSE."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum BlockedByResponseReason {
            #[serde(rename = "CoepFrameResourceNeedsCoepHeader")]
            CoepFrameResourceNeedsCoepHeader,
            #[serde(rename = "CoopSandboxedIFrameCannotNavigateToCoopPage")]
            CoopSandboxedIFrameCannotNavigateToCoopPage,
            #[serde(rename = "CorpNotSameOrigin")]
            CorpNotSameOrigin,
            #[serde(rename = "CorpNotSameOriginAfterDefaultedToSameOriginByCoep")]
            CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
            #[serde(rename = "CorpNotSameSite")]
            CorpNotSameSite,
        }
        impl AsRef<str> for BlockedByResponseReason {
            fn as_ref(&self) -> &str {
                match self {
                    BlockedByResponseReason::CoepFrameResourceNeedsCoepHeader => {
                        "CoepFrameResourceNeedsCoepHeader"
                    }
                    BlockedByResponseReason::CoopSandboxedIFrameCannotNavigateToCoopPage => {
                        "CoopSandboxedIFrameCannotNavigateToCoopPage"
                    }
                    BlockedByResponseReason::CorpNotSameOrigin => "CorpNotSameOrigin",
                    BlockedByResponseReason::CorpNotSameOriginAfterDefaultedToSameOriginByCoep => {
                        "CorpNotSameOriginAfterDefaultedToSameOriginByCoep"
                    }
                    BlockedByResponseReason::CorpNotSameSite => "CorpNotSameSite",
                }
            }
        }
        impl ::std::str::FromStr for BlockedByResponseReason {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "CoepFrameResourceNeedsCoepHeader" | "coepframeresourceneedscoepheader" => {
                        Ok(BlockedByResponseReason::CoepFrameResourceNeedsCoepHeader)
                    }
                    "CoopSandboxedIFrameCannotNavigateToCoopPage"
                    | "coopsandboxediframecannotnavigatetocooppage" => {
                        Ok(BlockedByResponseReason::CoopSandboxedIFrameCannotNavigateToCoopPage)
                    }
                    "CorpNotSameOrigin" | "corpnotsameorigin" => {
                        Ok(BlockedByResponseReason::CorpNotSameOrigin)
                    }
                    "CorpNotSameOriginAfterDefaultedToSameOriginByCoep"
                    | "corpnotsameoriginafterdefaultedtosameoriginbycoep" => Ok(
                        BlockedByResponseReason::CorpNotSameOriginAfterDefaultedToSameOriginByCoep,
                    ),
                    "CorpNotSameSite" | "corpnotsamesite" => {
                        Ok(BlockedByResponseReason::CorpNotSameSite)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Details for a request that has been blocked with the BLOCKED_BY_RESPONSE\ncode. Currently only used for COEP/COOP, but may be extended to include\nsome CSP errors in the future.\n[BlockedByResponseIssueDetails](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-BlockedByResponseIssueDetails)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct BlockedByResponseIssueDetails {
            #[serde(rename = "request")]
            pub request: AffectedRequest,
            #[serde(rename = "parentFrame")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub parent_frame: Option<AffectedFrame>,
            #[serde(rename = "blockedFrame")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub blocked_frame: Option<AffectedFrame>,
            #[serde(rename = "reason")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub reason: BlockedByResponseReason,
        }
        impl BlockedByResponseIssueDetails {
            pub fn new(
                request: impl Into<AffectedRequest>,
                reason: impl Into<BlockedByResponseReason>,
            ) -> Self {
                Self {
                    request: request.into(),
                    reason: reason.into(),
                    parent_frame: None,
                    blocked_frame: None,
                }
            }
        }
        impl BlockedByResponseIssueDetails {
            pub fn builder() -> BlockedByResponseIssueDetailsBuilder {
                BlockedByResponseIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct BlockedByResponseIssueDetailsBuilder {
            request: Option<AffectedRequest>,
            parent_frame: Option<AffectedFrame>,
            blocked_frame: Option<AffectedFrame>,
            reason: Option<BlockedByResponseReason>,
        }
        impl BlockedByResponseIssueDetailsBuilder {
            pub fn request(mut self, request: impl Into<AffectedRequest>) -> Self {
                self.request = Some(request.into());
                self
            }
            pub fn parent_frame(mut self, parent_frame: impl Into<AffectedFrame>) -> Self {
                self.parent_frame = Some(parent_frame.into());
                self
            }
            pub fn blocked_frame(mut self, blocked_frame: impl Into<AffectedFrame>) -> Self {
                self.blocked_frame = Some(blocked_frame.into());
                self
            }
            pub fn reason(mut self, reason: impl Into<BlockedByResponseReason>) -> Self {
                self.reason = Some(reason.into());
                self
            }
            pub fn build(self) -> Result<BlockedByResponseIssueDetails, String> {
                Ok(BlockedByResponseIssueDetails {
                    request: self.request.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(request))
                    })?,
                    parent_frame: self.parent_frame,
                    blocked_frame: self.blocked_frame,
                    reason: self.reason.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(reason))
                    })?,
                })
            }
        }
        impl BlockedByResponseIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.BlockedByResponseIssueDetails";
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum HeavyAdResolutionStatus {
            #[serde(rename = "HeavyAdBlocked")]
            HeavyAdBlocked,
            #[serde(rename = "HeavyAdWarning")]
            HeavyAdWarning,
        }
        impl AsRef<str> for HeavyAdResolutionStatus {
            fn as_ref(&self) -> &str {
                match self {
                    HeavyAdResolutionStatus::HeavyAdBlocked => "HeavyAdBlocked",
                    HeavyAdResolutionStatus::HeavyAdWarning => "HeavyAdWarning",
                }
            }
        }
        impl ::std::str::FromStr for HeavyAdResolutionStatus {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "HeavyAdBlocked" | "heavyadblocked" => {
                        Ok(HeavyAdResolutionStatus::HeavyAdBlocked)
                    }
                    "HeavyAdWarning" | "heavyadwarning" => {
                        Ok(HeavyAdResolutionStatus::HeavyAdWarning)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum HeavyAdReason {
            #[serde(rename = "NetworkTotalLimit")]
            NetworkTotalLimit,
            #[serde(rename = "CpuTotalLimit")]
            CpuTotalLimit,
            #[serde(rename = "CpuPeakLimit")]
            CpuPeakLimit,
        }
        impl AsRef<str> for HeavyAdReason {
            fn as_ref(&self) -> &str {
                match self {
                    HeavyAdReason::NetworkTotalLimit => "NetworkTotalLimit",
                    HeavyAdReason::CpuTotalLimit => "CpuTotalLimit",
                    HeavyAdReason::CpuPeakLimit => "CpuPeakLimit",
                }
            }
        }
        impl ::std::str::FromStr for HeavyAdReason {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "NetworkTotalLimit" | "networktotallimit" => {
                        Ok(HeavyAdReason::NetworkTotalLimit)
                    }
                    "CpuTotalLimit" | "cputotallimit" => Ok(HeavyAdReason::CpuTotalLimit),
                    "CpuPeakLimit" | "cpupeaklimit" => Ok(HeavyAdReason::CpuPeakLimit),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct HeavyAdIssueDetails {
            #[doc = "The resolution status, either blocking the content or warning."]
            #[serde(rename = "resolution")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub resolution: HeavyAdResolutionStatus,
            #[doc = "The reason the ad was blocked, total network or cpu or peak cpu."]
            #[serde(rename = "reason")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub reason: HeavyAdReason,
            #[doc = "The frame that was blocked."]
            #[serde(rename = "frame")]
            pub frame: AffectedFrame,
        }
        impl HeavyAdIssueDetails {
            pub fn new(
                resolution: impl Into<HeavyAdResolutionStatus>,
                reason: impl Into<HeavyAdReason>,
                frame: impl Into<AffectedFrame>,
            ) -> Self {
                Self {
                    resolution: resolution.into(),
                    reason: reason.into(),
                    frame: frame.into(),
                }
            }
        }
        impl HeavyAdIssueDetails {
            pub fn builder() -> HeavyAdIssueDetailsBuilder {
                HeavyAdIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct HeavyAdIssueDetailsBuilder {
            resolution: Option<HeavyAdResolutionStatus>,
            reason: Option<HeavyAdReason>,
            frame: Option<AffectedFrame>,
        }
        impl HeavyAdIssueDetailsBuilder {
            pub fn resolution(mut self, resolution: impl Into<HeavyAdResolutionStatus>) -> Self {
                self.resolution = Some(resolution.into());
                self
            }
            pub fn reason(mut self, reason: impl Into<HeavyAdReason>) -> Self {
                self.reason = Some(reason.into());
                self
            }
            pub fn frame(mut self, frame: impl Into<AffectedFrame>) -> Self {
                self.frame = Some(frame.into());
                self
            }
            pub fn build(self) -> Result<HeavyAdIssueDetails, String> {
                Ok(HeavyAdIssueDetails {
                    resolution: self.resolution.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(resolution))
                    })?,
                    reason: self.reason.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(reason))
                    })?,
                    frame: self.frame.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(frame))
                    })?,
                })
            }
        }
        impl HeavyAdIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.HeavyAdIssueDetails";
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ContentSecurityPolicyViolationType {
            #[serde(rename = "kInlineViolation")]
            KInlineViolation,
            #[serde(rename = "kEvalViolation")]
            KEvalViolation,
            #[serde(rename = "kURLViolation")]
            KUrlViolation,
            #[serde(rename = "kTrustedTypesSinkViolation")]
            KTrustedTypesSinkViolation,
            #[serde(rename = "kTrustedTypesPolicyViolation")]
            KTrustedTypesPolicyViolation,
        }
        impl AsRef<str> for ContentSecurityPolicyViolationType {
            fn as_ref(&self) -> &str {
                match self {
                    ContentSecurityPolicyViolationType::KInlineViolation => "kInlineViolation",
                    ContentSecurityPolicyViolationType::KEvalViolation => "kEvalViolation",
                    ContentSecurityPolicyViolationType::KUrlViolation => "kURLViolation",
                    ContentSecurityPolicyViolationType::KTrustedTypesSinkViolation => {
                        "kTrustedTypesSinkViolation"
                    }
                    ContentSecurityPolicyViolationType::KTrustedTypesPolicyViolation => {
                        "kTrustedTypesPolicyViolation"
                    }
                }
            }
        }
        impl ::std::str::FromStr for ContentSecurityPolicyViolationType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "kInlineViolation" | "KInlineViolation" | "kinlineviolation" => {
                        Ok(ContentSecurityPolicyViolationType::KInlineViolation)
                    }
                    "kEvalViolation" | "KEvalViolation" | "kevalviolation" => {
                        Ok(ContentSecurityPolicyViolationType::KEvalViolation)
                    }
                    "kURLViolation" | "KUrlViolation" | "kurlviolation" => {
                        Ok(ContentSecurityPolicyViolationType::KUrlViolation)
                    }
                    "kTrustedTypesSinkViolation"
                    | "KTrustedTypesSinkViolation"
                    | "ktrustedtypessinkviolation" => {
                        Ok(ContentSecurityPolicyViolationType::KTrustedTypesSinkViolation)
                    }
                    "kTrustedTypesPolicyViolation"
                    | "KTrustedTypesPolicyViolation"
                    | "ktrustedtypespolicyviolation" => {
                        Ok(ContentSecurityPolicyViolationType::KTrustedTypesPolicyViolation)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SourceCodeLocation {
            #[serde(rename = "url")]
            pub url: String,
            #[serde(rename = "lineNumber")]
            pub line_number: i64,
            #[serde(rename = "columnNumber")]
            pub column_number: i64,
        }
        impl SourceCodeLocation {
            pub fn new(
                url: impl Into<String>,
                line_number: impl Into<i64>,
                column_number: impl Into<i64>,
            ) -> Self {
                Self {
                    url: url.into(),
                    line_number: line_number.into(),
                    column_number: column_number.into(),
                }
            }
        }
        impl SourceCodeLocation {
            pub fn builder() -> SourceCodeLocationBuilder {
                SourceCodeLocationBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SourceCodeLocationBuilder {
            url: Option<String>,
            line_number: Option<i64>,
            column_number: Option<i64>,
        }
        impl SourceCodeLocationBuilder {
            pub fn url(mut self, url: impl Into<String>) -> Self {
                self.url = Some(url.into());
                self
            }
            pub fn line_number(mut self, line_number: impl Into<i64>) -> Self {
                self.line_number = Some(line_number.into());
                self
            }
            pub fn column_number(mut self, column_number: impl Into<i64>) -> Self {
                self.column_number = Some(column_number.into());
                self
            }
            pub fn build(self) -> Result<SourceCodeLocation, String> {
                Ok(SourceCodeLocation {
                    url: self
                        .url
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(url)))?,
                    line_number: self.line_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(line_number))
                    })?,
                    column_number: self.column_number.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(column_number))
                    })?,
                })
            }
        }
        impl SourceCodeLocation {
            pub const IDENTIFIER: &'static str = "Audits.SourceCodeLocation";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ContentSecurityPolicyIssueDetails {
            #[doc = "The url not included in allowed sources."]
            #[serde(rename = "blockedURL")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub blocked_url: Option<String>,
            #[doc = "Specific directive that is violated, causing the CSP issue."]
            #[serde(rename = "violatedDirective")]
            pub violated_directive: String,
            #[serde(rename = "isReportOnly")]
            pub is_report_only: bool,
            #[serde(rename = "contentSecurityPolicyViolationType")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub content_security_policy_violation_type: ContentSecurityPolicyViolationType,
            #[serde(rename = "frameAncestor")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub frame_ancestor: Option<AffectedFrame>,
            #[serde(rename = "sourceCodeLocation")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub source_code_location: Option<SourceCodeLocation>,
            #[serde(rename = "violatingNodeId")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub violating_node_id: Option<super::dom::BackendNodeId>,
        }
        impl ContentSecurityPolicyIssueDetails {
            pub fn new(
                violated_directive: impl Into<String>,
                is_report_only: impl Into<bool>,
                content_security_policy_violation_type: impl Into<ContentSecurityPolicyViolationType>,
            ) -> Self {
                Self {
                    violated_directive: violated_directive.into(),
                    is_report_only: is_report_only.into(),
                    content_security_policy_violation_type: content_security_policy_violation_type
                        .into(),
                    blocked_url: None,
                    frame_ancestor: None,
                    source_code_location: None,
                    violating_node_id: None,
                }
            }
        }
        impl ContentSecurityPolicyIssueDetails {
            pub fn builder() -> ContentSecurityPolicyIssueDetailsBuilder {
                ContentSecurityPolicyIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ContentSecurityPolicyIssueDetailsBuilder {
            blocked_url: Option<String>,
            violated_directive: Option<String>,
            is_report_only: Option<bool>,
            content_security_policy_violation_type: Option<ContentSecurityPolicyViolationType>,
            frame_ancestor: Option<AffectedFrame>,
            source_code_location: Option<SourceCodeLocation>,
            violating_node_id: Option<super::dom::BackendNodeId>,
        }
        impl ContentSecurityPolicyIssueDetailsBuilder {
            pub fn blocked_url(mut self, blocked_url: impl Into<String>) -> Self {
                self.blocked_url = Some(blocked_url.into());
                self
            }
            pub fn violated_directive(mut self, violated_directive: impl Into<String>) -> Self {
                self.violated_directive = Some(violated_directive.into());
                self
            }
            pub fn is_report_only(mut self, is_report_only: impl Into<bool>) -> Self {
                self.is_report_only = Some(is_report_only.into());
                self
            }
            pub fn content_security_policy_violation_type(
                mut self,
                content_security_policy_violation_type: impl Into<ContentSecurityPolicyViolationType>,
            ) -> Self {
                self.content_security_policy_violation_type =
                    Some(content_security_policy_violation_type.into());
                self
            }
            pub fn frame_ancestor(mut self, frame_ancestor: impl Into<AffectedFrame>) -> Self {
                self.frame_ancestor = Some(frame_ancestor.into());
                self
            }
            pub fn source_code_location(
                mut self,
                source_code_location: impl Into<SourceCodeLocation>,
            ) -> Self {
                self.source_code_location = Some(source_code_location.into());
                self
            }
            pub fn violating_node_id(
                mut self,
                violating_node_id: impl Into<super::dom::BackendNodeId>,
            ) -> Self {
                self.violating_node_id = Some(violating_node_id.into());
                self
            }
            pub fn build(self) -> Result<ContentSecurityPolicyIssueDetails, String> {
                Ok(ContentSecurityPolicyIssueDetails {
                    blocked_url: self.blocked_url,
                    violated_directive: self.violated_directive.ok_or_else(|| {
                        format!(
                            "Field `{}` is mandatory.",
                            std::stringify!(violated_directive)
                        )
                    })?,
                    is_report_only: self.is_report_only.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(is_report_only))
                    })?,
                    content_security_policy_violation_type: self
                        .content_security_policy_violation_type
                        .ok_or_else(|| {
                            format!(
                                "Field `{}` is mandatory.",
                                std::stringify!(content_security_policy_violation_type)
                            )
                        })?,
                    frame_ancestor: self.frame_ancestor,
                    source_code_location: self.source_code_location,
                    violating_node_id: self.violating_node_id,
                })
            }
        }
        impl ContentSecurityPolicyIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.ContentSecurityPolicyIssueDetails";
        }
        #[doc = "A unique identifier for the type of issue. Each type may use one of the\noptional fields in InspectorIssueDetails to convey more specific\ninformation about the kind of issue."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum InspectorIssueCode {
            #[serde(rename = "SameSiteCookieIssue")]
            SameSiteCookieIssue,
            #[serde(rename = "MixedContentIssue")]
            MixedContentIssue,
            #[serde(rename = "BlockedByResponseIssue")]
            BlockedByResponseIssue,
            #[serde(rename = "HeavyAdIssue")]
            HeavyAdIssue,
            #[serde(rename = "ContentSecurityPolicyIssue")]
            ContentSecurityPolicyIssue,
        }
        impl AsRef<str> for InspectorIssueCode {
            fn as_ref(&self) -> &str {
                match self {
                    InspectorIssueCode::SameSiteCookieIssue => "SameSiteCookieIssue",
                    InspectorIssueCode::MixedContentIssue => "MixedContentIssue",
                    InspectorIssueCode::BlockedByResponseIssue => "BlockedByResponseIssue",
                    InspectorIssueCode::HeavyAdIssue => "HeavyAdIssue",
                    InspectorIssueCode::ContentSecurityPolicyIssue => "ContentSecurityPolicyIssue",
                }
            }
        }
        impl ::std::str::FromStr for InspectorIssueCode {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "SameSiteCookieIssue" | "samesitecookieissue" => {
                        Ok(InspectorIssueCode::SameSiteCookieIssue)
                    }
                    "MixedContentIssue" | "mixedcontentissue" => {
                        Ok(InspectorIssueCode::MixedContentIssue)
                    }
                    "BlockedByResponseIssue" | "blockedbyresponseissue" => {
                        Ok(InspectorIssueCode::BlockedByResponseIssue)
                    }
                    "HeavyAdIssue" | "heavyadissue" => Ok(InspectorIssueCode::HeavyAdIssue),
                    "ContentSecurityPolicyIssue" | "contentsecuritypolicyissue" => {
                        Ok(InspectorIssueCode::ContentSecurityPolicyIssue)
                    }
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "This struct holds a list of optional fields with additional information\nspecific to the kind of issue. When adding a new issue code, please also\nadd a new optional field to this type.\n[InspectorIssueDetails](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-InspectorIssueDetails)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct InspectorIssueDetails {
            #[serde(rename = "sameSiteCookieIssueDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub same_site_cookie_issue_details: Option<SameSiteCookieIssueDetails>,
            #[serde(rename = "mixedContentIssueDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub mixed_content_issue_details: Option<MixedContentIssueDetails>,
            #[serde(rename = "blockedByResponseIssueDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub blocked_by_response_issue_details: Option<BlockedByResponseIssueDetails>,
            #[serde(rename = "heavyAdIssueDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub heavy_ad_issue_details: Option<HeavyAdIssueDetails>,
            #[serde(rename = "contentSecurityPolicyIssueDetails")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub content_security_policy_issue_details: Option<ContentSecurityPolicyIssueDetails>,
        }
        impl InspectorIssueDetails {
            pub fn builder() -> InspectorIssueDetailsBuilder {
                InspectorIssueDetailsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct InspectorIssueDetailsBuilder {
            same_site_cookie_issue_details: Option<SameSiteCookieIssueDetails>,
            mixed_content_issue_details: Option<MixedContentIssueDetails>,
            blocked_by_response_issue_details: Option<BlockedByResponseIssueDetails>,
            heavy_ad_issue_details: Option<HeavyAdIssueDetails>,
            content_security_policy_issue_details: Option<ContentSecurityPolicyIssueDetails>,
        }
        impl InspectorIssueDetailsBuilder {
            pub fn same_site_cookie_issue_details(
                mut self,
                same_site_cookie_issue_details: impl Into<SameSiteCookieIssueDetails>,
            ) -> Self {
                self.same_site_cookie_issue_details = Some(same_site_cookie_issue_details.into());
                self
            }
            pub fn mixed_content_issue_details(
                mut self,
                mixed_content_issue_details: impl Into<MixedContentIssueDetails>,
            ) -> Self {
                self.mixed_content_issue_details = Some(mixed_content_issue_details.into());
                self
            }
            pub fn blocked_by_response_issue_details(
                mut self,
                blocked_by_response_issue_details: impl Into<BlockedByResponseIssueDetails>,
            ) -> Self {
                self.blocked_by_response_issue_details =
                    Some(blocked_by_response_issue_details.into());
                self
            }
            pub fn heavy_ad_issue_details(
                mut self,
                heavy_ad_issue_details: impl Into<HeavyAdIssueDetails>,
            ) -> Self {
                self.heavy_ad_issue_details = Some(heavy_ad_issue_details.into());
                self
            }
            pub fn content_security_policy_issue_details(
                mut self,
                content_security_policy_issue_details: impl Into<ContentSecurityPolicyIssueDetails>,
            ) -> Self {
                self.content_security_policy_issue_details =
                    Some(content_security_policy_issue_details.into());
                self
            }
            pub fn build(self) -> InspectorIssueDetails {
                InspectorIssueDetails {
                    same_site_cookie_issue_details: self.same_site_cookie_issue_details,
                    mixed_content_issue_details: self.mixed_content_issue_details,
                    blocked_by_response_issue_details: self.blocked_by_response_issue_details,
                    heavy_ad_issue_details: self.heavy_ad_issue_details,
                    content_security_policy_issue_details: self
                        .content_security_policy_issue_details,
                }
            }
        }
        impl InspectorIssueDetails {
            pub const IDENTIFIER: &'static str = "Audits.InspectorIssueDetails";
        }
        #[doc = "An inspector issue reported from the back-end.\n[InspectorIssue](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#type-InspectorIssue)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct InspectorIssue {
            #[serde(rename = "code")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub code: InspectorIssueCode,
            #[serde(rename = "details")]
            pub details: InspectorIssueDetails,
        }
        impl InspectorIssue {
            pub fn new(
                code: impl Into<InspectorIssueCode>,
                details: impl Into<InspectorIssueDetails>,
            ) -> Self {
                Self {
                    code: code.into(),
                    details: details.into(),
                }
            }
        }
        impl InspectorIssue {
            pub fn builder() -> InspectorIssueBuilder {
                InspectorIssueBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct InspectorIssueBuilder {
            code: Option<InspectorIssueCode>,
            details: Option<InspectorIssueDetails>,
        }
        impl InspectorIssueBuilder {
            pub fn code(mut self, code: impl Into<InspectorIssueCode>) -> Self {
                self.code = Some(code.into());
                self
            }
            pub fn details(mut self, details: impl Into<InspectorIssueDetails>) -> Self {
                self.details = Some(details.into());
                self
            }
            pub fn build(self) -> Result<InspectorIssue, String> {
                Ok(InspectorIssue {
                    code: self.code.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(code))
                    })?,
                    details: self.details.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(details))
                    })?,
                })
            }
        }
        impl InspectorIssue {
            pub const IDENTIFIER: &'static str = "Audits.InspectorIssue";
        }
        #[doc = "Returns the response body and size if it were re-encoded with the specified settings. Only\napplies to images.\n[getEncodedResponse](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-getEncodedResponse)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetEncodedResponseParams {
            #[doc = "Identifier of the network request to get content for."]
            #[serde(rename = "requestId")]
            pub request_id: super::network::RequestId,
            #[doc = "The encoding to use."]
            #[serde(rename = "encoding")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub encoding: GetEncodedResponseEncoding,
            #[doc = "The quality of the encoding (0-1). (defaults to 1)"]
            #[serde(rename = "quality")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub quality: Option<f64>,
            #[doc = "Whether to only return the size information (defaults to false)."]
            #[serde(rename = "sizeOnly")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub size_only: Option<bool>,
        }
        #[doc = "The encoding to use."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum GetEncodedResponseEncoding {
            #[serde(rename = "webp")]
            Webp,
            #[serde(rename = "jpeg")]
            Jpeg,
            #[serde(rename = "png")]
            Png,
        }
        impl AsRef<str> for GetEncodedResponseEncoding {
            fn as_ref(&self) -> &str {
                match self {
                    GetEncodedResponseEncoding::Webp => "webp",
                    GetEncodedResponseEncoding::Jpeg => "jpeg",
                    GetEncodedResponseEncoding::Png => "png",
                }
            }
        }
        impl ::std::str::FromStr for GetEncodedResponseEncoding {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "webp" | "Webp" => Ok(GetEncodedResponseEncoding::Webp),
                    "jpeg" | "Jpeg" => Ok(GetEncodedResponseEncoding::Jpeg),
                    "png" | "Png" => Ok(GetEncodedResponseEncoding::Png),
                    _ => Err(s.to_string()),
                }
            }
        }
        impl GetEncodedResponseParams {
            pub fn new(
                request_id: impl Into<super::network::RequestId>,
                encoding: impl Into<GetEncodedResponseEncoding>,
            ) -> Self {
                Self {
                    request_id: request_id.into(),
                    encoding: encoding.into(),
                    quality: None,
                    size_only: None,
                }
            }
        }
        impl GetEncodedResponseParams {
            pub fn builder() -> GetEncodedResponseParamsBuilder {
                GetEncodedResponseParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetEncodedResponseParamsBuilder {
            request_id: Option<super::network::RequestId>,
            encoding: Option<GetEncodedResponseEncoding>,
            quality: Option<f64>,
            size_only: Option<bool>,
        }
        impl GetEncodedResponseParamsBuilder {
            pub fn request_id(mut self, request_id: impl Into<super::network::RequestId>) -> Self {
                self.request_id = Some(request_id.into());
                self
            }
            pub fn encoding(mut self, encoding: impl Into<GetEncodedResponseEncoding>) -> Self {
                self.encoding = Some(encoding.into());
                self
            }
            pub fn quality(mut self, quality: impl Into<f64>) -> Self {
                self.quality = Some(quality.into());
                self
            }
            pub fn size_only(mut self, size_only: impl Into<bool>) -> Self {
                self.size_only = Some(size_only.into());
                self
            }
            pub fn build(self) -> Result<GetEncodedResponseParams, String> {
                Ok(GetEncodedResponseParams {
                    request_id: self.request_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(request_id))
                    })?,
                    encoding: self.encoding.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(encoding))
                    })?,
                    quality: self.quality,
                    size_only: self.size_only,
                })
            }
        }
        impl GetEncodedResponseParams {
            pub const IDENTIFIER: &'static str = "Audits.getEncodedResponse";
        }
        impl chromiumoxide_types::Method for GetEncodedResponseParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for GetEncodedResponseParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Returns the response body and size if it were re-encoded with the specified settings. Only\napplies to images.\n[getEncodedResponse](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-getEncodedResponse)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct GetEncodedResponseReturns {
            #[doc = "The encoded body as a base64 string. Omitted if sizeOnly is true."]
            #[serde(rename = "body")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub body: Option<chromiumoxide_types::Binary>,
            #[doc = "Size before re-encoding."]
            #[serde(rename = "originalSize")]
            pub original_size: i64,
            #[doc = "Size after re-encoding."]
            #[serde(rename = "encodedSize")]
            pub encoded_size: i64,
        }
        impl GetEncodedResponseReturns {
            pub fn new(original_size: impl Into<i64>, encoded_size: impl Into<i64>) -> Self {
                Self {
                    original_size: original_size.into(),
                    encoded_size: encoded_size.into(),
                    body: None,
                }
            }
        }
        impl GetEncodedResponseReturns {
            pub fn builder() -> GetEncodedResponseReturnsBuilder {
                GetEncodedResponseReturnsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct GetEncodedResponseReturnsBuilder {
            body: Option<chromiumoxide_types::Binary>,
            original_size: Option<i64>,
            encoded_size: Option<i64>,
        }
        impl GetEncodedResponseReturnsBuilder {
            pub fn body(mut self, body: impl Into<chromiumoxide_types::Binary>) -> Self {
                self.body = Some(body.into());
                self
            }
            pub fn original_size(mut self, original_size: impl Into<i64>) -> Self {
                self.original_size = Some(original_size.into());
                self
            }
            pub fn encoded_size(mut self, encoded_size: impl Into<i64>) -> Self {
                self.encoded_size = Some(encoded_size.into());
                self
            }
            pub fn build(self) -> Result<GetEncodedResponseReturns, String> {
                Ok(GetEncodedResponseReturns {
                    body: self.body,
                    original_size: self.original_size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(original_size))
                    })?,
                    encoded_size: self.encoded_size.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(encoded_size))
                    })?,
                })
            }
        }
        impl chromiumoxide_types::Command for GetEncodedResponseParams {
            type Response = GetEncodedResponseReturns;
        }
        #[doc = "Disables issues domain, prevents further issues from being reported to the client.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableParams {}
        impl DisableParams {
            pub const IDENTIFIER: &'static str = "Audits.disable";
        }
        impl chromiumoxide_types::Method for DisableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for DisableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables issues domain, prevents further issues from being reported to the client.\n[disable](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-disable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct DisableReturns {}
        impl chromiumoxide_types::Command for DisableParams {
            type Response = DisableReturns;
        }
        #[doc = "Enables issues domain, sends the issues collected so far to the client by means of the\n`issueAdded` event.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableParams {}
        impl EnableParams {
            pub const IDENTIFIER: &'static str = "Audits.enable";
        }
        impl chromiumoxide_types::Method for EnableParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EnableParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables issues domain, sends the issues collected so far to the client by means of the\n`issueAdded` event.\n[enable](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#method-enable)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct EnableReturns {}
        impl chromiumoxide_types::Command for EnableParams {
            type Response = EnableReturns;
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventIssueAdded {
            #[serde(rename = "issue")]
            pub issue: InspectorIssue,
        }
        impl EventIssueAdded {
            pub const IDENTIFIER: &'static str = "Audits.issueAdded";
        }
        impl chromiumoxide_types::Method for EventIssueAdded {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventIssueAdded {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    #[doc = "Defines events for background web platform features."]
    pub mod background_service {
        use serde::{Deserialize, Serialize};
        #[doc = "The Background Service that will be associated with the commands/events.\nEvery Background Service operates independently, but they share the same\nAPI."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum ServiceName {
            #[serde(rename = "backgroundFetch")]
            BackgroundFetch,
            #[serde(rename = "backgroundSync")]
            BackgroundSync,
            #[serde(rename = "pushMessaging")]
            PushMessaging,
            #[serde(rename = "notifications")]
            Notifications,
            #[serde(rename = "paymentHandler")]
            PaymentHandler,
            #[serde(rename = "periodicBackgroundSync")]
            PeriodicBackgroundSync,
        }
        impl AsRef<str> for ServiceName {
            fn as_ref(&self) -> &str {
                match self {
                    ServiceName::BackgroundFetch => "backgroundFetch",
                    ServiceName::BackgroundSync => "backgroundSync",
                    ServiceName::PushMessaging => "pushMessaging",
                    ServiceName::Notifications => "notifications",
                    ServiceName::PaymentHandler => "paymentHandler",
                    ServiceName::PeriodicBackgroundSync => "periodicBackgroundSync",
                }
            }
        }
        impl ::std::str::FromStr for ServiceName {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "backgroundFetch" | "BackgroundFetch" | "backgroundfetch" => {
                        Ok(ServiceName::BackgroundFetch)
                    }
                    "backgroundSync" | "BackgroundSync" | "backgroundsync" => {
                        Ok(ServiceName::BackgroundSync)
                    }
                    "pushMessaging" | "PushMessaging" | "pushmessaging" => {
                        Ok(ServiceName::PushMessaging)
                    }
                    "notifications" | "Notifications" => Ok(ServiceName::Notifications),
                    "paymentHandler" | "PaymentHandler" | "paymenthandler" => {
                        Ok(ServiceName::PaymentHandler)
                    }
                    "periodicBackgroundSync"
                    | "PeriodicBackgroundSync"
                    | "periodicbackgroundsync" => Ok(ServiceName::PeriodicBackgroundSync),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "A key-value pair for additional event information to pass along.\n[EventMetadata](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#type-EventMetadata)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventMetadata {
            #[serde(rename = "key")]
            pub key: String,
            #[serde(rename = "value")]
            pub value: String,
        }
        impl EventMetadata {
            pub fn new(key: impl Into<String>, value: impl Into<String>) -> Self {
                Self {
                    key: key.into(),
                    value: value.into(),
                }
            }
        }
        impl EventMetadata {
            pub fn builder() -> EventMetadataBuilder {
                EventMetadataBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct EventMetadataBuilder {
            key: Option<String>,
            value: Option<String>,
        }
        impl EventMetadataBuilder {
            pub fn key(mut self, key: impl Into<String>) -> Self {
                self.key = Some(key.into());
                self
            }
            pub fn value(mut self, value: impl Into<String>) -> Self {
                self.value = Some(value.into());
                self
            }
            pub fn build(self) -> Result<EventMetadata, String> {
                Ok(EventMetadata {
                    key: self
                        .key
                        .ok_or_else(|| format!("Field `{}` is mandatory.", std::stringify!(key)))?,
                    value: self.value.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(value))
                    })?,
                })
            }
        }
        impl EventMetadata {
            pub const IDENTIFIER: &'static str = "BackgroundService.EventMetadata";
        }
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct BackgroundServiceEvent {
            #[doc = "Timestamp of the event (in seconds)."]
            #[serde(rename = "timestamp")]
            pub timestamp: super::network::TimeSinceEpoch,
            #[doc = "The origin this event belongs to."]
            #[serde(rename = "origin")]
            pub origin: String,
            #[doc = "The Service Worker ID that initiated the event."]
            #[serde(rename = "serviceWorkerRegistrationId")]
            pub service_worker_registration_id: super::service_worker::RegistrationId,
            #[doc = "The Background Service this event belongs to."]
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
            #[doc = "A description of the event."]
            #[serde(rename = "eventName")]
            pub event_name: String,
            #[doc = "An identifier that groups related events together."]
            #[serde(rename = "instanceId")]
            pub instance_id: String,
            #[doc = "A list of event-specific information."]
            #[serde(rename = "eventMetadata")]
            #[serde(skip_serializing_if = "Vec::is_empty")]
            pub event_metadata: Vec<EventMetadata>,
        }
        impl BackgroundServiceEvent {
            pub fn builder() -> BackgroundServiceEventBuilder {
                BackgroundServiceEventBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct BackgroundServiceEventBuilder {
            timestamp: Option<super::network::TimeSinceEpoch>,
            origin: Option<String>,
            service_worker_registration_id: Option<super::service_worker::RegistrationId>,
            service: Option<ServiceName>,
            event_name: Option<String>,
            instance_id: Option<String>,
            event_metadata: Option<Vec<EventMetadata>>,
        }
        impl BackgroundServiceEventBuilder {
            pub fn timestamp(
                mut self,
                timestamp: impl Into<super::network::TimeSinceEpoch>,
            ) -> Self {
                self.timestamp = Some(timestamp.into());
                self
            }
            pub fn origin(mut self, origin: impl Into<String>) -> Self {
                self.origin = Some(origin.into());
                self
            }
            pub fn service_worker_registration_id(
                mut self,
                service_worker_registration_id: impl Into<super::service_worker::RegistrationId>,
            ) -> Self {
                self.service_worker_registration_id = Some(service_worker_registration_id.into());
                self
            }
            pub fn service(mut self, service: impl Into<ServiceName>) -> Self {
                self.service = Some(service.into());
                self
            }
            pub fn event_name(mut self, event_name: impl Into<String>) -> Self {
                self.event_name = Some(event_name.into());
                self
            }
            pub fn instance_id(mut self, instance_id: impl Into<String>) -> Self {
                self.instance_id = Some(instance_id.into());
                self
            }
            pub fn event_metadata(mut self, event_metadata: impl Into<EventMetadata>) -> Self {
                let v = self.event_metadata.get_or_insert(Vec::new());
                v.push(event_metadata.into());
                self
            }
            pub fn event_metadatas<I, S>(mut self, event_metadatas: I) -> Self
            where
                I: IntoIterator<Item = S>,
                S: Into<EventMetadata>,
            {
                let v = self.event_metadata.get_or_insert(Vec::new());
                for val in event_metadatas {
                    v.push(val.into());
                }
                self
            }
            pub fn build(self) -> Result<BackgroundServiceEvent, String> {
                Ok(BackgroundServiceEvent {
                    timestamp: self.timestamp.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(timestamp))
                    })?,
                    origin: self.origin.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(origin))
                    })?,
                    service_worker_registration_id: self
                        .service_worker_registration_id
                        .ok_or_else(|| {
                            format!(
                                "Field `{}` is mandatory.",
                                std::stringify!(service_worker_registration_id)
                            )
                        })?,
                    service: self.service.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(service))
                    })?,
                    event_name: self.event_name.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(event_name))
                    })?,
                    instance_id: self.instance_id.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(instance_id))
                    })?,
                    event_metadata: self.event_metadata.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(event_metadata))
                    })?,
                })
            }
        }
        impl BackgroundServiceEvent {
            pub const IDENTIFIER: &'static str = "BackgroundService.BackgroundServiceEvent";
        }
        #[doc = "Enables event updates for the service.\n[startObserving](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-startObserving)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StartObservingParams {
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
        }
        impl StartObservingParams {
            pub fn new(service: impl Into<ServiceName>) -> Self {
                Self {
                    service: service.into(),
                }
            }
        }
        impl StartObservingParams {
            pub fn builder() -> StartObservingParamsBuilder {
                StartObservingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StartObservingParamsBuilder {
            service: Option<ServiceName>,
        }
        impl StartObservingParamsBuilder {
            pub fn service(mut self, service: impl Into<ServiceName>) -> Self {
                self.service = Some(service.into());
                self
            }
            pub fn build(self) -> Result<StartObservingParams, String> {
                Ok(StartObservingParams {
                    service: self.service.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(service))
                    })?,
                })
            }
        }
        impl StartObservingParams {
            pub const IDENTIFIER: &'static str = "BackgroundService.startObserving";
        }
        impl chromiumoxide_types::Method for StartObservingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StartObservingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Enables event updates for the service.\n[startObserving](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-startObserving)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StartObservingReturns {}
        impl chromiumoxide_types::Command for StartObservingParams {
            type Response = StartObservingReturns;
        }
        #[doc = "Disables event updates for the service.\n[stopObserving](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-stopObserving)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct StopObservingParams {
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
        }
        impl StopObservingParams {
            pub fn new(service: impl Into<ServiceName>) -> Self {
                Self {
                    service: service.into(),
                }
            }
        }
        impl StopObservingParams {
            pub fn builder() -> StopObservingParamsBuilder {
                StopObservingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct StopObservingParamsBuilder {
            service: Option<ServiceName>,
        }
        impl StopObservingParamsBuilder {
            pub fn service(mut self, service: impl Into<ServiceName>) -> Self {
                self.service = Some(service.into());
                self
            }
            pub fn build(self) -> Result<StopObservingParams, String> {
                Ok(StopObservingParams {
                    service: self.service.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(service))
                    })?,
                })
            }
        }
        impl StopObservingParams {
            pub const IDENTIFIER: &'static str = "BackgroundService.stopObserving";
        }
        impl chromiumoxide_types::Method for StopObservingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for StopObservingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Disables event updates for the service.\n[stopObserving](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-stopObserving)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct StopObservingReturns {}
        impl chromiumoxide_types::Command for StopObservingParams {
            type Response = StopObservingReturns;
        }
        #[doc = "Set the recording state for the service.\n[setRecording](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-setRecording)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct SetRecordingParams {
            #[serde(rename = "shouldRecord")]
            pub should_record: bool,
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
        }
        impl SetRecordingParams {
            pub fn new(should_record: impl Into<bool>, service: impl Into<ServiceName>) -> Self {
                Self {
                    should_record: should_record.into(),
                    service: service.into(),
                }
            }
        }
        impl SetRecordingParams {
            pub fn builder() -> SetRecordingParamsBuilder {
                SetRecordingParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct SetRecordingParamsBuilder {
            should_record: Option<bool>,
            service: Option<ServiceName>,
        }
        impl SetRecordingParamsBuilder {
            pub fn should_record(mut self, should_record: impl Into<bool>) -> Self {
                self.should_record = Some(should_record.into());
                self
            }
            pub fn service(mut self, service: impl Into<ServiceName>) -> Self {
                self.service = Some(service.into());
                self
            }
            pub fn build(self) -> Result<SetRecordingParams, String> {
                Ok(SetRecordingParams {
                    should_record: self.should_record.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(should_record))
                    })?,
                    service: self.service.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(service))
                    })?,
                })
            }
        }
        impl SetRecordingParams {
            pub const IDENTIFIER: &'static str = "BackgroundService.setRecording";
        }
        impl chromiumoxide_types::Method for SetRecordingParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for SetRecordingParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Set the recording state for the service.\n[setRecording](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-setRecording)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct SetRecordingReturns {}
        impl chromiumoxide_types::Command for SetRecordingParams {
            type Response = SetRecordingReturns;
        }
        #[doc = "Clears all stored data for the service.\n[clearEvents](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-clearEvents)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct ClearEventsParams {
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
        }
        impl ClearEventsParams {
            pub fn new(service: impl Into<ServiceName>) -> Self {
                Self {
                    service: service.into(),
                }
            }
        }
        impl ClearEventsParams {
            pub fn builder() -> ClearEventsParamsBuilder {
                ClearEventsParamsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct ClearEventsParamsBuilder {
            service: Option<ServiceName>,
        }
        impl ClearEventsParamsBuilder {
            pub fn service(mut self, service: impl Into<ServiceName>) -> Self {
                self.service = Some(service.into());
                self
            }
            pub fn build(self) -> Result<ClearEventsParams, String> {
                Ok(ClearEventsParams {
                    service: self.service.ok_or_else(|| {
                        format!("Field `{}` is mandatory.", std::stringify!(service))
                    })?,
                })
            }
        }
        impl ClearEventsParams {
            pub const IDENTIFIER: &'static str = "BackgroundService.clearEvents";
        }
        impl chromiumoxide_types::Method for ClearEventsParams {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for ClearEventsParams {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Clears all stored data for the service.\n[clearEvents](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#method-clearEvents)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct ClearEventsReturns {}
        impl chromiumoxide_types::Command for ClearEventsParams {
            type Response = ClearEventsReturns;
        }
        #[doc = "Called when the recording state for the service has been updated.\n[recordingStateChanged](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#event-recordingStateChanged)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventRecordingStateChanged {
            #[serde(rename = "isRecording")]
            pub is_recording: bool,
            #[serde(rename = "service")]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str")]
            pub service: ServiceName,
        }
        impl EventRecordingStateChanged {
            pub const IDENTIFIER: &'static str = "BackgroundService.recordingStateChanged";
        }
        impl chromiumoxide_types::Method for EventRecordingStateChanged {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventRecordingStateChanged {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
        #[doc = "Called with all existing backgroundServiceEvents when enabled, and all new\nevents afterwards if enabled and recording.\n[backgroundServiceEventReceived](https://chromedevtools.github.io/devtools-protocol/tot/BackgroundService/#event-backgroundServiceEventReceived)"]
        #[derive(Debug, Clone, PartialEq, Serialize, Deserialize)]
        pub struct EventBackgroundServiceEventReceived {
            #[serde(rename = "backgroundServiceEvent")]
            pub background_service_event: BackgroundServiceEvent,
        }
        impl EventBackgroundServiceEventReceived {
            pub const IDENTIFIER: &'static str = "BackgroundService.backgroundServiceEventReceived";
        }
        impl chromiumoxide_types::Method for EventBackgroundServiceEventReceived {
            fn identifier(&self) -> chromiumoxide_types::MethodId {
                Self::IDENTIFIER.into()
            }
        }
        impl chromiumoxide_types::MethodType for EventBackgroundServiceEventReceived {
            fn method_id() -> chromiumoxide_types::MethodId
            where
                Self: Sized,
            {
                Self::IDENTIFIER.into()
            }
        }
    }
    #[doc = "The Browser domain defines methods and events for browser managing."]
    pub mod browser {
        use serde::{Deserialize, Serialize};
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Hash)]
        pub struct BrowserContextId(String);
        impl BrowserContextId {
            pub fn new(val: impl Into<String>) -> Self {
                BrowserContextId(val.into())
            }
            pub fn inner(&self) -> &String {
                &self.0
            }
        }
        impl AsRef<str> for BrowserContextId {
            fn as_ref(&self) -> &str {
                self.0.as_str()
            }
        }
        impl From<BrowserContextId> for String {
            fn from(el: BrowserContextId) -> String {
                el.0
            }
        }
        impl From<String> for BrowserContextId {
            fn from(expr: String) -> Self {
                BrowserContextId(expr)
            }
        }
        impl std::borrow::Borrow<str> for BrowserContextId {
            fn borrow(&self) -> &str {
                &self.0
            }
        }
        impl BrowserContextId {
            pub const IDENTIFIER: &'static str = "Browser.BrowserContextID";
        }
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize, Eq, Copy, Hash)]
        pub struct WindowId(i64);
        impl WindowId {
            pub fn new(val: impl Into<i64>) -> Self {
                WindowId(val.into())
            }
            pub fn inner(&self) -> &i64 {
                &self.0
            }
        }
        impl WindowId {
            pub const IDENTIFIER: &'static str = "Browser.WindowID";
        }
        #[doc = "The state of the browser window."]
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum WindowState {
            #[serde(rename = "normal")]
            Normal,
            #[serde(rename = "minimized")]
            Minimized,
            #[serde(rename = "maximized")]
            Maximized,
            #[serde(rename = "fullscreen")]
            Fullscreen,
        }
        impl AsRef<str> for WindowState {
            fn as_ref(&self) -> &str {
                match self {
                    WindowState::Normal => "normal",
                    WindowState::Minimized => "minimized",
                    WindowState::Maximized => "maximized",
                    WindowState::Fullscreen => "fullscreen",
                }
            }
        }
        impl ::std::str::FromStr for WindowState {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "normal" | "Normal" => Ok(WindowState::Normal),
                    "minimized" | "Minimized" => Ok(WindowState::Minimized),
                    "maximized" | "Maximized" => Ok(WindowState::Maximized),
                    "fullscreen" | "Fullscreen" => Ok(WindowState::Fullscreen),
                    _ => Err(s.to_string()),
                }
            }
        }
        #[doc = "Browser window bounds information\n[Bounds](https://chromedevtools.github.io/devtools-protocol/tot/Browser/#type-Bounds)"]
        #[derive(Debug, Clone, PartialEq, Default, Serialize, Deserialize)]
        pub struct Bounds {
            #[doc = "The offset from the left edge of the screen to the window in pixels."]
            #[serde(rename = "left")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub left: Option<i64>,
            #[doc = "The offset from the top edge of the screen to the window in pixels."]
            #[serde(rename = "top")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub top: Option<i64>,
            #[doc = "The window width in pixels."]
            #[serde(rename = "width")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub width: Option<i64>,
            #[doc = "The window height in pixels."]
            #[serde(rename = "height")]
            #[serde(skip_serializing_if = "Option::is_none")]
            pub height: Option<i64>,
            #[doc = "The window state. Default to normal."]
            #[serde(rename = "windowState")]
            #[serde(skip_serializing_if = "Option::is_none")]
            #[serde(default)]
            #[serde(deserialize_with = "super::super::de::deserialize_from_str_optional")]
            pub window_state: Option<WindowState>,
        }
        impl Bounds {
            pub fn builder() -> BoundsBuilder {
                BoundsBuilder::default()
            }
        }
        #[derive(Default, Clone)]
        pub struct BoundsBuilder {
            left: Option<i64>,
            top: Option<i64>,
            width: Option<i64>,
            height: Option<i64>,
            window_state: Option<WindowState>,
        }
        impl BoundsBuilder {
            pub fn left(mut self, left: impl Into<i64>) -> Self {
                self.left = Some(left.into());
                self
            }
            pub fn top(mut self, top: impl Into<i64>) -> Self {
                self.top = Some(top.into());
                self
            }
            pub fn width(mut self, width: impl Into<i64>) -> Self {
                self.width = Some(width.into());
                self
            }
            pub fn height(mut self, height: impl Into<i64>) -> Self {
                self.height = Some(height.into());
                self
            }
            pub fn window_state(mut self, window_state: impl Into<WindowState>) -> Self {
                self.window_state = Some(window_state.into());
                self
            }
            pub fn build(self) -> Bounds {
                Bounds {
                    left: self.left,
                    top: self.top,
                    width: self.width,
                    height: self.height,
                    window_state: self.window_state,
                }
            }
        }
        impl Bounds {
            pub const IDENTIFIER: &'static str = "Browser.Bounds";
        }
        #[derive(Debug, Clone, PartialEq, Eq, Hash, Serialize, Deserialize)]
        pub enum PermissionType {
            #[serde(rename = "accessibilityEvents")]
            AccessibilityEvents,
            #[serde(rename = "audioCapture")]
            AudioCapture,
            #[serde(rename = "backgroundSync")]
            BackgroundSync,
            #[serde(rename = "backgroundFetch")]
            BackgroundFetch,
            #[serde(rename = "clipboardReadWrite")]
            ClipboardReadWrite,
            #[serde(rename = "clipboardSanitizedWrite")]
            ClipboardSanitizedWrite,
            #[serde(rename = "durableStorage")]
            DurableStorage,
            #[serde(rename = "flash")]
            Flash,
            #[serde(rename = "geolocation")]
            Geolocation,
            #[serde(rename = "midi")]
            Midi,
            #[serde(rename = "midiSysex")]
            MidiSysex,
            #[serde(rename = "nfc")]
            Nfc,
            #[serde(rename = "notifications")]
            Notifications,
            #[serde(rename = "paymentHandler")]
            PaymentHandler,
            #[serde(rename = "periodicBackgroundSync")]
            PeriodicBackgroundSync,
            #[serde(rename = "protectedMediaIdentifier")]
            ProtectedMediaIdentifier,
            #[serde(rename = "sensors")]
            Sensors,
            #[serde(rename = "videoCapture")]
            VideoCapture,
            #[serde(rename = "videoCapturePanTiltZoom")]
            VideoCapturePanTiltZoom,
            #[serde(rename = "idleDetection")]
            IdleDetection,
            #[serde(rename = "wakeLockScreen")]
            WakeLockScreen,
            #[serde(rename = "wakeLockSystem")]
            WakeLockSystem,
        }
        impl AsRef<str> for PermissionType {
            fn as_ref(&self) -> &str {
                match self {
                    PermissionType::AccessibilityEvents => "accessibilityEvents",
                    PermissionType::AudioCapture => "audioCapture",
                    PermissionType::BackgroundSync => "backgroundSync",
                    PermissionType::BackgroundFetch => "backgroundFetch",
                    PermissionType::ClipboardReadWrite => "clipboardReadWrite",
                    PermissionType::ClipboardSanitizedWrite => "clipboardSanitizedWrite",
                    PermissionType::DurableStorage => "durableStorage",
                    PermissionType::Flash => "flash",
                    PermissionType::Geolocation => "geolocation",
                    PermissionType::Midi => "midi",
                    PermissionType::MidiSysex => "midiSysex",
                    PermissionType::Nfc => "nfc",
                    PermissionType::Notifications => "notifications",
                    PermissionType::PaymentHandler => "paymentHandler",
                    PermissionType::PeriodicBackgroundSync => "periodicBackgroundSync",
                    PermissionType::ProtectedMediaIdentifier => "protectedMediaIdentifier",
                    PermissionType::Sensors => "sensors",
                    PermissionType::VideoCapture => "videoCapture",
                    PermissionType::VideoCapturePanTiltZoom => "videoCapturePanTiltZoom",
                    PermissionType::IdleDetection => "idleDetection",
                    PermissionType::WakeLockScreen => "wakeLockScreen",
                    PermissionType::WakeLockSystem => "wakeLockSystem",
                }
            }
        }
        impl ::std::str::FromStr for PermissionType {
            type Err = String;
            fn from_str(s: &str) -> Result<Self, Self::Err> {
                match s {
                    "accessibilityEvents" | "AccessibilityEvents" | "accessibilityevents" => {
                        Ok(PermissionType::AccessibilityEvents)
                    }
                    "audioCapture" | "AudioCapture" | "audiocapture" => {
                        Ok(PermissionType::AudioCapture)
                    }
                    "backgroundSync" | "BackgroundSync" | "backgroundsync" => {
                        Ok(PermissionType::BackgroundSync)
                    }
                    "backgroundFetch" | "BackgroundFetch" | "backgroundfetch" => {
                        Ok(PermissionType::BackgroundFetch)
                    }
                    "clipboardReadWrite" | "ClipboardReadWrite" | "clipboardreadwrite" => {
                        Ok(PermissionType::ClipboardReadWrite)
                    }
                    "clipboardSanitizedWrite"
                    | "ClipboardSanitizedWrite"
                    | "clipboardsanitizedwrite" => Ok(PermissionType::ClipboardSanitizedWrite),
                    "durableStorage" | "DurableStorage" | "durablestorage" => {
                        Ok(PermissionType::DurableStorage)
                    }
                    "flash" | "Flash" => Ok(PermissionType::Flash),
                    "geolocation" | "Geolocation" => Ok(PermissionType::Geolocation),
                    "midi" | "Midi" => Ok(PermissionType::Midi),
                    "midiSysex" | "MidiSysex" | "midisysex" => Ok(PermissionType::MidiSysex),
                    "nfc" | "Nfc" => Ok(PermissionType::Nfc),
                    "notifications" | "Notifications" => Ok(PermissionType::Notifications),
                    "paymentHandler" | "PaymentHandler" | "paymenthandler" => {
                        Ok(PermissionType::PaymentHandler)
                    }
                    "periodicBackgroundSync"
                    | "PeriodicBackgroundSync"
                    | "periodicbackgroundsync" => Ok(PermissionType::PeriodicBackgroundSync),
                    "protectedMediaIdentifier"
                    | "ProtectedMediaIdentifier"
                    | "protectedmediaidentifier" => Ok(PermissionType::ProtectedMediaIdentifier),
                    "sensors" | "Sensors" => Ok(PermissionType::Sensors),
                    "videoCapture" | "VideoCapture" | "videocapture" => {
                        Ok(PermissionType::VideoCapture)
                    }
                    "videoCapturePanTiltZoom"
                    | "VideoCapturePanTiltZoom"
                    | "videocapturepantiltzoom" => Ok(PermissionType::VideoCapturePanTiltZoom),
                    "idleDetection" | "IdleDetection" | "idledetection" => {
                        Ok(Per