use nom::{
    branch::alt,
    bytes::complete::tag,
    character::complete::{alpha1, alphanumeric1},
    combinator::recognize,
    multi::many0,
    sequence::pair,
    IResult,
};

fn identifier(input: &str) -> IResult<&str, &str> {
    recognize(pair(
        alt((alpha1, tag("_"))),
        many0(alt((alphanumeric1, tag("_")))),
    ))(input)
}

fn function(input: &str) -> IResult<&str, &str> {
    recognize(pair(tag("fn"), identifier))(input)
}

pub fn parse(input: &str) -> IResult<&str, &str> {
    function(input)
}