// include!["../src/lib.rs"];
// use chinese2digits::{take_number_from_string};
#[cfg(test)]
mod tests {
    // 注意这个惯用法：在 tests 模块中，从外部作用域导入所有名字。
    use super::*;
    #[test]
    fn test_take_number_from_string() {
        // let aaa Vec[Vec[String]] = vec![["百分之5", "负千分之15"]];
        // Vec<[usize,&str, bool,&str,Vec<&str>,Vec<&str>]:17>

        let test_example: [(usize, &str, bool, &str, Vec<&str>, Vec<&str>); 17] = [
            (
                0,
                "百分之5负千分之15",
                true,
                "0.05-0.015",
                vec!["百分之5", "负千分之15"],
                vec!["0.05", "-0.015"],
            ),
            (
                1,
                "三零万二零千拉阿拉啦啦30万20千嚯嚯或百四嚯嚯嚯四百三十二分之2345啦啦啦啦",
                false,
                "320000拉阿拉啦啦30000020000嚯嚯或4%嚯嚯嚯2345/432啦啦啦啦",
                vec!["三零万二零千", "30万", "20千", "百四", "四百三十二分之2345"],
                vec!["320000", "300000", "20000", "4%", "2345/432"],
            ),
            (
                2,
                "啊啦啦啦300十万你好我20万.3%万你好啊300咯咯咯-.34%啦啦啦300万",
                true,
                "啊啦啦啦30000000你好我20000030你好啊300咯咯咯-0.0034啦啦啦3000000",
                vec!["300十万", "20万", ".3%万", "300", "-.34%", "300万"],
                vec!["30000000", "200000", "30", "300", "-0.0034", "3000000"],
            ),
            (
                3,
                "aaaa.3%万啦啦啦啦0.03万",
                true,
                "aaaa30啦啦啦啦300",
                vec![".3%万", "0.03万"],
                vec!["30", "300"],
            ),
            (4, "十分之一", true, "0.1", vec!["十分之一"], vec!["0.1"]),
            (
                5,
                "四分之三啦啦五百分之二",
                false,
                "3/4啦啦2/500",
                vec!["四分之三", "五百分之二"],
                vec!["3/4", "2/500"],
            ),
            (
                6,
                "4分之3负五分之6咿呀呀 四百分之16ooo千千万万",
                true,
                "0.75-1.2咿呀呀 4.16ooo千千万万",
                vec!["4分之3", "负五分之6", "四百分之16"],
                vec!["0.75", "-1.2", "4.16"],
            ),
            (
                7,
                "百分之四百三十二万分之四三千分之五今天天气不错三百四十点零零三四",
                true,
                "4.320.00430.005今天天气不错340.0034",
                vec![
                    "百分之四百三十二",
                    "万分之四三",
                    "千分之五",
                    "三百四十点零零三四",
                ],
                vec!["4.32", "0.0043", "0.005", "340.0034"],
            ),
            (8, "四千三", true, "4300", vec!["四千三"], vec!["4300"]),
            (
                9,
                "伍亿柒仟万拾柒今天天气不错百分之三亿二百万五啦啦啦啦负百分之点二八你好啊三万二",
                true,
                "570000017今天天气不错3020050啦啦啦啦-0.0028你好啊32000",
                vec![
                    "五亿七千万十七",
                    "百分之三亿二百万五",
                    "负百分之点二八",
                    "三万二",
                ],
                vec!["570000017", "3020050", "-0.0028", "32000"],
            ),
            (
                10,
                "llalala万三威风威风千四五",
                true,
                "llalala0.0003威风威风0.045",
                vec!["万三", "千四五"],
                vec!["0.0003", "0.045"],
            ),
            (
                11,
                "伍亿柒仟万拾柒百分之",
                true,
                "570001700分之",
                vec!["五亿七千万十七百"],
                vec!["570001700"],
            ),
            (
                12,
                "负百分之点二八你好啊百分之三五是不是点五零百分之负六十五点二八",
                true,
                "-0.0028你好啊0.35是不是0.5-0.6528",
                vec![
                    "负百分之点二八",
                    "百分之三五",
                    "点五零",
                    "百分之负六十五点二八",
                ],
                vec!["-0.0028", "0.35", "0.5", "-0.6528"],
            ),
            (
                13,
                "2.55万nonono3.1千万",
                true,
                "25500nonono31000000",
                vec!["2.55万", "3.1千万"],
                vec!["25500", "31000000"],
            ),
            (14, "拾", true, "拾", vec![], vec![]),
            (
                15,
                "零零零三四二啦啦啦啦12.550万啦啦啦啦啦零点零零三四二万",
                true,
                "000342啦啦啦啦125500啦啦啦啦啦34.2",
                vec!["零零零三四二", "12.550万", "零点零零三四二万"],
                vec!["000342", "125500", "34.2"],
            ),
            (
                16,
                "10000000000000000000000000000000000000000000连",
                true,
                "10000000000000000000000000000000000000000000连",
                vec!["10000000000000000000000000000000000000000000"],
                vec!["10000000000000000000000000000000000000000000"],
            ),
        ];

        for i in test_example.into_iter() {
            let aa = i;
            println!("now testing example of {}", aa.0);
            let test_result = chinese2digits::take_number_from_string(&aa.1, aa.2, true);
            assert_eq!(test_result.replaced_text, aa.3);
            assert_eq!(test_result.ch_number_string_list, aa.4);
            assert_eq!(test_result.digits_string_list, aa.5);
        }
    }
}
