use std::ffi::CString;
use x11::xlib;
mod screen;

extern "C" {
    fn handle_xlib_error(display: *mut xlib::_XDisplay, error: *mut xlib::XErrorEvent) -> i32;
}

unsafe fn muti8str(raw_str: *mut i8) -> String {
    CString::from_raw(raw_str).to_str().unwrap().to_string()
}

fn main() {
    unsafe {
        let display = xlib::XOpenDisplay(std::ptr::null());
        xlib::XSetErrorHandler(Some(handle_xlib_error));

        let connection_number = xlib::XConnectionNumber(display);
        let display_string = muti8str(xlib::XDisplayString(display));
        println!("{}: {}", display_string, connection_number);

        // let screen = xlib::XScreenOfDisplay(display, 0);
        // let height = xlib::XHeightOfScreen(screen);
        // let width = xlib::XWidthOfScreen(screen);

        let (width, height) = screen::get_size(display, 0);
        println!("width: {}\nheight: {}", width, height);

        // println!("{:?} {:?} {:?}", display, connection_number, display_string);
        // let (width, height) = get_screen_size(display, 0);

        // println!("width: {}\nheight: {}", width, height);

        // xlib::XCloseDisplay(display);
    }
}
