extern crate cc;
extern crate glob;

fn main() {
    let link_string = String::from_utf8_lossy(
        &std::process::Command::new("pkg-config")
            .arg("--cflags")
            .arg("--libs")
            .arg("x11")
            .output()
            .unwrap()
            .stdout,
    )
    .to_string();

    cc::Build::new()
        .flag(&link_string)
        .files(
            glob::glob("./src/c/*.c")
                .expect("Could not glob c files")
                .map(|file| file.unwrap().as_path().display().to_string())
                .collect::<Vec<String>>(),
        )
        .include("src")
        .compile("c");
}
