use async_trait::async_trait;

use crate::error::Error;
use crate::item::Item;
use crate::money::{Currency, Money};

pub struct ItemPrice {
    pub sku: String,
    pub price: Money,
    pub discount: Money,
}

#[async_trait]
pub trait PriceCalculator {
    async fn calculate_item_prices(
        &mut self,
        _currency: &Currency,
        _promo_codes: &Vec<String>,
        _items: &Vec<Item>,
    ) -> Result<Vec<ItemPrice>, Error> {
        Ok(vec![])
    }
}
