use async_trait::async_trait;

use crate::checkout::CheckoutStore;
use crate::error::Error;
use crate::inventory::InventoryController;
use crate::invoice::InvoiceCalculator;
use crate::order::OrderEvents;
use crate::order::OrderStore;
use crate::payment::PaymentProcessor;
use crate::payment::PaymentStore;
use crate::price::PriceCalculator;
use crate::product::ProductResolver;
use crate::shipping::ShippingCalculator;
use crate::transaction::TransactionController;

#[async_trait]
pub trait Context:
    InvoiceCalculator
    + ProductResolver
    + InventoryController
    + ShippingCalculator
    + PriceCalculator
    + TransactionController
    + CheckoutStore
    + PaymentProcessor
    + PaymentStore
    + OrderStore
    + OrderEvents
{
}

#[async_trait]
pub trait ContextProvider<T: Context> {
    async fn new_context(&self) -> Result<T, Error>;
}
