use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::{
    customer::{Address, Contact},
    invoice::Invoice,
    item::Item,
    shipping::FulfillmentType,
};

#[derive(Serialize, Deserialize, JsonSchema)]
pub enum OrderState {
    PendingPayment, // initial state if the order is created manually; transitions to PendingConfirmation, Confirmed or Cancelled
    PendingConfirmation, // a possible initial state if the order is created via checkout completion; transitions to Confirmed or Cancelled
    Confirmed, // a possible initial state if the order is created via checkout completion; transitions to Shipped or Cancelled
    Shipped, // transitions to Fulfilled or Returned
    Fulfilled, // transitions to Returned
    Returned, // a terminal state
    Cancelled, // a terminal state
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct Order {
    pub id: String,
    pub state: OrderState,
    pub contact: Contact,
    pub shipping_address: Address,
    pub items: Vec<Item>,
    pub fulfillment_type: Option<FulfillmentType>,
    pub invoice: Invoice,
    pub payment_id: String,
}
