use crate::{error::Error, money::Currency, Context, ContextProvider};
pub use checkout_server_derive::Server;
use dropshot::{ApiDescription, HttpServerStarter, ServerContext};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

pub trait Server<'a, T: Context>: ContextProvider<'a, T> {
    type Context: ServerContext;
    fn api_description() -> ApiDescription<Self::Context>;
    fn new_server(self, bind_address: &str) -> Result<HttpServerStarter<Self::Context>, Error>;
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct CreateRequest {
    pub currency: Currency,
}
