use crate::{error::Error, money::Currency, ContextProvider};
use dropshot::{ApiDescription, HttpServerStarter, ServerContext};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

pub trait Server: ContextProvider {
    type Context: ServerContext;
    fn api_description() -> ApiDescription<<Self as Server>::Context>;
    fn new_server(
        self,
        bind_address: &str,
    ) -> Result<HttpServerStarter<<Self as Server>::Context>, Error>;
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct CreateRequest {
    pub currency: Currency,
}
