use cloud_pubsub::{Client, Topic};
use std::sync::Arc;

#[derive(Clone)]
pub struct InternalContext {
    pub payment_processing_topic: Arc<Topic>,
    pub checkout_completion_topic: Arc<Topic>,
}

impl InternalContext {
    pub async fn new(
        google_application_credentials: String,
        payment_processing_topic: String,
        checkout_completion_topic: String,
    ) -> Result<Self, cloud_pubsub::error::Error> {
        let pubsub_client = Arc::new(Client::new(google_application_credentials).await?);

        Ok(Self {
            payment_processing_topic: Arc::new(pubsub_client.topic(payment_processing_topic)),
            checkout_completion_topic: Arc::new(pubsub_client.topic(checkout_completion_topic)),
        })
    }
}
