use cloud_pubsub::{Client, Topic};
use std::sync::Arc;

pub struct InternalContext {
    pub payment_processing_topic: Arc<Topic>,
}

impl InternalContext {
    pub async fn new(
        google_application_credentials: String,
    ) -> Result<Self, cloud_pubsub::error::Error> {
        let pubsub_client = Arc::new(Client::new(google_application_credentials).await?);

        Ok(Self {
            payment_processing_topic: Arc::new(pubsub_client.topic("".to_string())),
        })
    }
}
