use dropshot::{ApiDescription, HttpServerStarter, ServerContext};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

pub use checkout_server_derive::Server;
use uuid::Uuid;

use crate::context::{Context, ContextProvider};
use crate::customer::{Address, Contact};
use crate::error::Error;
use crate::money::Currency;

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct StandardPathParams {
    pub id: Uuid,
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct CreateBodyParams {
    pub currency: Currency,
    pub contact: Option<Contact>,
    pub shipping_address: Option<Address>,
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct AddOrRemoveItemBodyParams {
    pub sku: String,
    pub quantity: u64,
}

pub trait Server<'a, T: Context>: ContextProvider<'a, T> {
    type Context: ServerContext;
    fn api_description() -> ApiDescription<Self::Context>;
    fn new_server(self, bind_address: &str) -> Result<HttpServerStarter<Self::Context>, Error>;
}
