use async_trait::async_trait;
use uuid::Uuid;

use crate::checkout::Checkout;
use crate::error::Error;

#[async_trait]
pub trait CheckoutStore {
    async fn set_checkout(&mut self, id: &Uuid, co: &Checkout) -> Result<(), Error>;
    async fn get_checkout(&mut self, id: &Uuid) -> Result<Option<Checkout>, Error>;
}
