use async_trait::async_trait;

use crate::error::Error;
use crate::event::EventHandler;
use crate::inventory::InventoryController;
use crate::invoice::InvoiceCalculator;
use crate::price::PriceCalculator;
use crate::product::ProductResolver;
use crate::shipping::ShippingCalculator;
use crate::store::CheckoutStore;
use crate::transaction::TransactionController;

#[async_trait]
pub trait Context:
    InvoiceCalculator
    + ProductResolver
    + InventoryController
    + ShippingCalculator
    + PriceCalculator
    + EventHandler
    + TransactionController
    + CheckoutStore
{
}

#[async_trait]
pub trait ContextProvider<'a, T: Context> {
    async fn new_context(&'a self) -> Result<T, Error>;
}
