use async_trait::async_trait;
use chrono::{DateTime, Duration, Utc};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};
use uuid::Uuid;

use crate::error::Error;
use crate::item::Item;

#[derive(Debug, Serialize, Deserialize, JsonSchema)]
pub struct StockIssue {
    sku: String,
    max_available: u64,
}

pub enum ReserveResult {
    Success(DateTime<Utc>),
    StockIssue(Vec<StockIssue>),
}

#[async_trait]
pub trait InventoryController {
    async fn reserve_items(&mut self, _co_id: &Uuid, _items: &Vec<Item>) -> Result<ReserveResult, Error> {
        let deadline = Utc::now() + Duration::days(1);
        Ok(ReserveResult::Success(deadline))
    }

    async fn free_items(&mut self, _co_id: &Uuid, _items: &Vec<Item>) -> Result<(), Error> {
        Ok(())
    }
}
