use serde::{Deserialize, Serialize};
use serde_json::to_string_pretty;

#[derive(Debug, Serialize, Deserialize)]
pub struct Error {
    pub code: String,
    pub message: String,
}

pub fn new_bad_request_error(msg: &str) -> Error {
    Error {
        code: String::from("400"),
        message: msg.to_string(),
    }
}

pub fn new_application_error<T: Serialize>(code: &str, payload: T) -> Error {
    Error {
        code: code.to_string(),
        message: to_string_pretty(&payload).unwrap(),
    }
}
