use async_trait::async_trait;

use crate::checkout::Checkout;
use crate::error::Error;

#[async_trait]
pub trait EventHandler {
    async fn on_create(&mut self, _co: &Checkout) -> Result<(), Error> {
        Ok(())
    }

    async fn on_add_item(
        &mut self,
        _co: &Checkout,
        _sku: &str,
        _quantity: u64,
    ) -> Result<(), Error> {
        Ok(())
    }

    async fn on_remove_item(
        &mut self,
        _co: &Checkout,
        _sku: &str,
        _quantity: u64,
    ) -> Result<(), Error> {
        Ok(())
    }

    async fn on_confirm_items(&mut self, _co: &Checkout) -> Result<(), Error> {
        Ok(())
    }

    async fn on_update_shipping_address(&mut self, _co: &Checkout) -> Result<(), Error> {
        Ok(())
    }

    async fn on_update_fulfillment_type(&mut self, _co: &Checkout) -> Result<(), Error> {
        Ok(())
    }
}
