use async_trait::async_trait;

use crate::error::Error;
use crate::item::Item;
use crate::money::{Currency, Money};

pub struct ItemPrice {
    pub sku: String,
    pub price: Money,
    pub discount: Money,
}

#[async_trait]
pub trait PriceCalculator {
    async fn calculate_item_prices(
        &mut self,
        currency: &Currency,
        promo_codes: &Vec<String>,
        items: &Vec<Item>,
    ) -> Result<Vec<ItemPrice>, Error>;
}
