use crate::{item::Item, money::Currency, error::Error};
use async_trait::async_trait;

#[async_trait]
pub trait PriceCalculator {
    async fn update_item_prices(
        &mut self,
        currency: &Currency,
        promo_codes: &Vec<String>,
        items: &mut Vec<Item>,
    ) -> Result<(), Error>;
}
