use async_trait::async_trait;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::error::Error;
use crate::item::Item;

#[derive(Debug, Serialize, Deserialize, JsonSchema)]
pub struct StockIssue {
    sku: String,
    max_available: u64,
}

#[derive(Debug, Serialize, Deserialize, JsonSchema)]
pub struct StockUnit {
    sku: String,
    quantity: u64,
}

impl From<&Item> for StockUnit {
    fn from(item: &Item) -> Self {
        Self {
            sku: item.sku.clone(),
            quantity: item.quantity,
        }
    }
}

#[async_trait]
pub trait InventoryController {
    async fn reserve_items(
        &mut self,
        _items: &Vec<Item>,
    ) -> Result<Option<Vec<StockIssue>>, Error> {
        Ok(None)
    }

    async fn free_items(&mut self, _items: &Vec<Item>) -> Result<(), Error> {
        Ok(())
    }

    async fn add_stock(&mut self, _stock_units: &Vec<StockUnit>) -> Result<(), Error> {
        Ok(())
    }

    async fn remove_stock(&mut self, _stock_units: &Vec<StockUnit>) -> Result<(), Error> {
        Ok(())
    }
}
