use async_trait::async_trait;
use dropshot::{ApiDescription, ServerContext};

pub use checkout_server_derive::Server;

use crate::context::{ClientContext, ClientContextProvider};
use crate::error::Error;

#[async_trait]
pub trait Server<'a, C: ClientContext>: ClientContextProvider<'a, C> {
    type Context: ServerContext;
    fn api_description() -> ApiDescription<Self::Context>;
    async fn start(self) -> Result<(), Error>;
}
