use async_trait::async_trait;

use crate::checkout::CheckoutStore;
use crate::error::Error;
use crate::inventory::InventoryController;
use crate::invoice::InvoiceCalculator;
use crate::order::OrderEvents;
use crate::order::OrderStore;
use crate::payment::PaymentProcessor;
use crate::payment::PaymentStore;
use crate::price::PriceCalculator;
use crate::product::ProductResolver;
use crate::shipping::ShippingCalculator;
use crate::transaction::TransactionController;

#[async_trait]
pub trait Context:
    ClientContext
    + InventoryController
    + TransactionController
    + CheckoutStore
    + PaymentStore
    + OrderStore
{
}

#[async_trait]
pub trait ClientContext:
    InvoiceCalculator
    + ProductResolver
    + ShippingCalculator
    + PriceCalculator
    + PaymentProcessor
    + OrderEvents
{
}

#[async_trait]
pub trait ClientContextProvider<'a, C: ClientContext> {
    async fn new_context(&'a self) -> Result<C, Error>;
}
