use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct Image {
    pub url: String,
    pub title: Option<String>,
    pub dimensions: Option<ImageDimensions>,
}

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct ImageDimensions {
    pub width: f64,
    pub height: f64,
}
