use async_trait::async_trait;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::error::Error;
use crate::image::Image;
use crate::money::{Currency, Money};

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct Product {
    pub sku: String,
    pub title: String,
    pub description: Option<String>,
    pub price: Money,
    pub images: Vec<Image>,
}

#[async_trait]
pub trait ProductResolver {
    async fn resolve_product(&mut self, currency: &Currency, sku: &str) -> Result<Product, Error>;
}
