use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::{image::Image, money::Money};

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct Item {
    pub sku: String,
    pub title: String,
    pub description: Option<String>,
    pub quantity: u64,
    pub price: Money,
    pub discount: Money,
    pub images: Vec<Image>,
}
