use async_trait::async_trait;
use dropshot::{ApiDescription, ServerContext};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

pub use checkout_server_derive::Server;

use crate::context::{ClientContext, ClientContextProvider};
use crate::customer::{Address, Contact};
use crate::error::Error;
use crate::money::Currency;

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct IdParam {
    pub id: String,
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct CreateParams {
    pub currency: Currency,
    pub contact: Option<Contact>,
    pub shipping_address: Option<Address>,
}

#[derive(Serialize, Deserialize, JsonSchema)]
pub struct AddOrRemoveItemParams {
    pub sku: String,
    pub quantity: u64,
}

#[async_trait]
pub trait Server<'a, C: ClientContext>: ClientContextProvider<'a, C> {
    type Context: ServerContext;
    fn api_description() -> ApiDescription<Self::Context>;
    async fn start(self) -> Result<(), Error>;
}
