use async_trait::async_trait;
use chrono::{DateTime, Duration, Utc};
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::error::Error;
use crate::item::Item;

#[derive(Debug, Serialize, Deserialize, JsonSchema)]
pub struct StockIssue {
    sku: String,
    max_available: u64,
}

#[derive(Debug, Serialize, Deserialize, JsonSchema)]
pub struct StockUnit {
    sku: String,
    quantity: u64,
}

pub enum ReserveResult {
    Success(DateTime<Utc>),
    StockIssue(Vec<StockIssue>),
}

#[async_trait]
pub trait InventoryController {
    async fn reserve_items(&mut self, _items: &Vec<Item>) -> Result<ReserveResult, Error> {
        let deadline = Utc::now() + Duration::days(365);
        Ok(ReserveResult::Success(deadline))
    }

    async fn free_items(&mut self, _items: &Vec<Item>) -> Result<(), Error> {
        Ok(())
    }

    async fn add_stock(&mut self, _stock_units: &Vec<StockUnit>) -> Result<(), Error> {
        Ok(())
    }

    async fn remove_stock(&mut self, _stock_units: &Vec<StockUnit>) -> Result<(), Error> {
        Ok(())
    }
}
