use async_trait::async_trait;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};

use crate::customer::Address;
use crate::error::Error;
use crate::item::Item;
use crate::money::{Currency, Money};

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub enum FulfillmentType {
    Pickup,
    Shipping(ShippingQuote),
}

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub enum FulfillmentTypeSelection {
    Pickup,
    Shipping(String),
}

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct ShippingQuote {
    pub id: String,
    pub service: Service,
    pub price: Money,
    pub discount: Money,
}

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct Courier {
    pub id: String,
    pub name: String,
}

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct Service {
    pub id: String,
    pub courier: Courier,
    pub name: String,
}

#[async_trait]
pub trait ShippingCalculator {
    async fn get_shipping_quotes(
        &mut self,
        currency: &Currency,
        promo_codes: &Vec<String>,
        items: &Vec<Item>,
        address: &Address,
    ) -> Result<Vec<ShippingQuote>, Error>;
}
