use async_trait::async_trait;

use crate::money::{Money, Currency};
use crate::error::Error;

pub struct Product {
    pub sku: String,
    pub title: String,
    pub description: Option<String>,
    pub price: Money,
}

#[async_trait]
pub trait ProductResolver {
    async fn resolve_product(&mut self, currency: &Currency, sku: &str) -> Result<Product, Error>;
}