use async_trait::async_trait;

use crate::error::Error;

#[async_trait]
pub trait TransactionController {
    async fn start_transaction(&mut self) -> Result<(), Error> {
        Ok(())
    }

    async fn commit_transaction(&mut self) -> Result<(), Error> {
        Ok(())
    }

    async fn abort_transaction(&mut self) -> Result<(), Error> {
        Ok(())
    }
}
