use super::dummy_context::DummyContextProvider;
use crate::{money::Currency, Checkout, CheckoutContext, CheckoutContextProvider};
use dropshot::endpoint;
use dropshot::ApiDescription;
use dropshot::ConfigDropshot;
use dropshot::ConfigLogging;
use dropshot::ConfigLoggingLevel;
use dropshot::HttpError;
use dropshot::HttpResponseOk;
use dropshot::HttpServerStarter;
use dropshot::RequestContext;
use dropshot::TypedBody;
use http::StatusCode;
use schemars::JsonSchema;
use serde::{Deserialize, Serialize};
use std::sync::Arc;

struct Context {
    provider: DummyContextProvider,
}

#[derive(Serialize, Deserialize, JsonSchema)]
struct CreateRequest {
    currency: Currency,
}

#[endpoint {
    method = POST,
    path = "/create",
}]
async fn create(
    req_ctx: Arc<RequestContext<Context>>,
    body_params: TypedBody<CreateRequest>,
) -> Result<HttpResponseOk<Checkout>, HttpError> {
    let params = body_params.into_inner();

    let mut ctx = req_ctx.context().provider.new_context().await.unwrap();

    ctx.start_transaction().await.unwrap();

    let res = Checkout::create(&mut ctx, Currency::new("CAD", 2)).await;

    match res {
        Ok(co) => {
            ctx.commit_transaction().await.unwrap();
            Ok(HttpResponseOk(co))
        }
        Err(_) => {
            ctx.abort_transaction().await.unwrap();
            Err(HttpError {
                status_code: StatusCode::BAD_REQUEST,
                error_code: None,
                external_message: "puta madre".to_string(),
                internal_message: "puta madre".to_string(),
            })
        }
    }
}
