use crate::address::Address;
use crate::inventory::InventoryController;
use crate::invoice::InvoiceCalculator;
use crate::item::{Item, ItemTitleResolver};
use crate::money::Currency;
use crate::price::PriceCalculator;
use crate::shipping::{ShippingCalculator, ShippingQuote};
use crate::{CheckoutContext, CheckoutContextProvider, CheckoutError};
use async_trait::async_trait;

pub struct DummyContext {}

impl DummyContext {
    pub fn new() -> Self {
        Self {}
    }
}

#[async_trait]
impl ItemTitleResolver for DummyContext {
    async fn resolve_item_title(&mut self, sku: &str) -> Result<String, CheckoutError> {
        Ok(sku.to_string())
    }
}

#[async_trait]
impl PriceCalculator for DummyContext {
    async fn update_item_prices(
        &mut self,
        _currency: &Currency,
        _promo_codes: &Vec<String>,
        _items: &mut Vec<Item>,
    ) -> Result<(), CheckoutError> {
        Ok(())
    }
}

#[async_trait]
impl ShippingCalculator for DummyContext {
    async fn get_shipping_quotes(
        &mut self,
        _currency: &Currency,
        _promo_codes: &Vec<String>,
        _items: &Vec<Item>,
        _address: &Address,
    ) -> Result<Vec<ShippingQuote>, CheckoutError> {
        Ok(vec![])
    }
}

impl InventoryController for DummyContext {}
impl InvoiceCalculator for DummyContext {}
impl CheckoutContext for DummyContext {}

pub struct DummyContextProvider {}

#[async_trait]
impl CheckoutContextProvider for DummyContextProvider {
    type Context = DummyContext;

    async fn new_context(&self) -> Result<Self::Context, CheckoutError> {
        Ok(DummyContext::new())
    }
}
