use crate::{money::Money, CheckoutError};
use async_trait::async_trait;
use serde::{Deserialize, Serialize};
use schemars::JsonSchema;

#[derive(Clone, Serialize, Deserialize, JsonSchema)]
pub struct Item {
    pub sku: String,
    pub title: String,
    pub quantity: u64,
    pub price: Money,
    pub discount: Money,
}

#[async_trait]
pub trait ItemTitleResolver {
    async fn resolve_item_title(&mut self, sku: &str) -> Result<String, CheckoutError>;
}
