use crate::{item::Item, money::Currency, CheckoutError};
use async_trait::async_trait;

#[async_trait]
pub trait PriceCalculator {
    async fn update_item_prices(
        &mut self,
        currency: &Currency,
        promo_codes: &Vec<String>,
        items: &mut Vec<Item>,
    ) -> Result<(), CheckoutError>;
}
