use crate::{money::Money, CheckoutError};
use async_trait::async_trait;
use serde::{Deserialize, Serialize};

#[derive(Clone, Serialize, Deserialize)]
pub struct Item {
    pub sku: String,
    pub title: String,
    pub quantity: u64,
    pub price: Money,
    pub discount: Money,
}

#[async_trait]
pub trait ItemTitleResolver {
    async fn resolve_item_title(&mut self, sku: &str) -> Result<String, CheckoutError>;
}
