use crate::{item::Item, CheckoutError};
use async_trait::async_trait;
use chrono::{DateTime, Utc};
use serde::{Deserialize, Serialize};

#[derive(Debug, Serialize, Deserialize)]
pub struct StockIssue {
    sku: String,
    max_available: u64,
}

#[async_trait]
pub trait InventoryController {
    async fn reserve_items(&mut self, _items: &Vec<Item>) -> Result<DateTime<Utc>, CheckoutError> {
        Ok(Utc::now())
    }

    async fn free_items(&mut self, _items: &Vec<Item>) -> Result<(), CheckoutError> {
        Ok(())
    }
}
