use crate::inventory::InventoryController;
use crate::invoice::InvoiceCalculator;
use crate::item::{Item, ItemTitleResolver};
use crate::price::PriceCalculator;
use crate::shipping::{Courier, Service, ShippingCalculator, ShippingQuote};
use crate::Address;
use crate::{CheckoutContext, CheckoutError};
use crate::{Currency, Money};
use async_trait::async_trait;

pub struct DummyContext {}

#[async_trait]
impl ItemTitleResolver for DummyContext {
    async fn resolve_item_title(&mut self, sku: &str) -> Result<String, CheckoutError> {
        Ok(sku.to_string())
    }
}

#[async_trait]
impl PriceCalculator for DummyContext {
    async fn update_item_prices(
        &mut self,
        _currency: &Currency,
        _promo_codes: &Vec<String>,
        _items: &mut Vec<Item>,
    ) -> Result<(), CheckoutError> {
        Ok(())
    }
}

#[async_trait]
impl ShippingCalculator for DummyContext {
    async fn get_shipping_quotes(
        &mut self,
        currency: &Currency,
        _promo_codes: &Vec<String>,
        _items: &Vec<Item>,
        _address: &Address,
    ) -> Result<Vec<ShippingQuote>, CheckoutError> {
        Ok(vec![dummy_shipping_quote(currency)])
    }
}

impl InventoryController for DummyContext {}
impl InvoiceCalculator for DummyContext {}

#[async_trait]
impl CheckoutContext for DummyContext {
    async fn new() -> Self {
        Self {}
    }
}

fn dummy_shipping_quote(currency: &Currency) -> ShippingQuote {
    ShippingQuote {
        id: "DEFAULT".to_string(),
        service: Service {
            id: "2D".to_string(),
            courier: Courier {
                id: "DEFAULT".to_string(),
                name: "BATH BUILT".to_string(),
            },
            name: "2 Day Shipping".to_string(),
        },
        price: Money::new(currency.clone(), "150"),
        discount: Money::new(currency.clone(), "0"),
    }
}
