use checkout_controller::{address::Address, money::Currency, tenants::dummy::DummyContext, Checkout, State};
use dotenv::dotenv;
use uuid::Uuid;

#[tokio::main]
async fn main() {
    dotenv().unwrap();

    let mut co = Checkout {
        id: Uuid::new_v4(),
        state: State::Shopping,
        currency: Currency {
            iso_code: "CAD".to_string(),
            scale: 2,
        },
        promo_codes: vec![],
        items: vec![],
        fulfillment_type: None,
        shipping_address: None,
        shipping_quotes: vec![],
        invoice: None,
    };

    let mut ctx = DummyContext {};
    co.add_item(&mut ctx, "YAKIBO".to_string(), 1)
        .await
        .unwrap();
    co.remove_item(&mut ctx, "YAKIBO".to_string(), 2)
        .await
        .unwrap();
    co.add_item(&mut ctx, "BOKOI".to_string(), 12)
        .await
        .unwrap();
    co.add_item(&mut ctx, "YAKIBO".to_string(), 5)
        .await
        .unwrap();
    co.confirm_items(&mut ctx).await.unwrap();
    co.confirm_items(&mut ctx).await.unwrap();
    co.update_shipping_address(
        &mut ctx,
        Address {
            line_1: "444 Lepper Place".to_string(),
            line_2: None,
            city: "Vancouver".to_string(),
            postal_code: "V9V4K2".to_string(),
            province: Some("BC".to_string()),
            country: "Canada".to_string(),
        },
    )
    .await
    .unwrap();

    co.add_item(&mut ctx, "YAKIBO".to_string(), 1)
        .await
        .unwrap();
    co.confirm_items(&mut ctx).await.unwrap();
    co.update_shipping_address(
        &mut ctx,
        Address {
            line_1: "444 Lepper Place".to_string(),
            line_2: None,
            city: "Vancouver".to_string(),
            postal_code: "V9V4K2".to_string(),
            province: Some("BC".to_string()),
            country: "Canada".to_string(),
        },
    )
    .await
    .unwrap();
}
