pub mod color;
pub mod r#type;

pub use color::*;
pub use r#type::*;

/// A land object
#[derive(Copy, Clone, Debug, PartialEq, Eq, Hash, Default)]
pub struct Land {
    pub color: Color,
    pub tp: Type,
    pub amount: i32,
}

impl Land {
    /// Creates a new empty [`Land`].
    ///
    /// # Examples
    ///
    /// ```
    /// use checkmate::{Land, Color, Type};
    ///
    /// let land = Land::new();
    /// assert_eq!(land.color, Color::Grey);
    /// assert_eq!(land.tp, Type::Empty);
    /// assert_eq!(land.amount, 0);
    /// ```
    pub fn new() -> Self {
        Self {
            color: Color::Grey,
            tp: Type::Empty,
            amount: 0,
        }
    }
}
