use std::{error, fmt};

/// Error type of this crate
#[derive(Debug, PartialEq, Eq, Clone, Copy, Hash)]
pub enum Error {
    WrongLandColor(i32),
    WrongLandType(i32),
}

impl fmt::Display for Error {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        use Error::*;

        match self {
            WrongLandColor(value) => write!(f, "Failed to convert {} into land::Color", value),
            WrongLandType(value) => write!(f, "Failed to convert {} into land::Type", value),
        }
    }
}

impl error::Error for Error {}

#[cfg(test)]
mod tests {
    use super::*;

    #[test]
    fn error_display() {
        assert_eq!(
            format!("{}", Error::WrongLandColor(0)),
            String::from("Failed to convert 0 into land::Color")
        );
        assert_eq!(
            format!("{}", Error::WrongLandType(0)),
            String::from("Failed to convert 0 into land::Type")
        );
    }
}
