[![Crates.io](https://img.shields.io/crates/v/chatora-errno)](https://crates.io/crates/chatora-errno)
[![docs.rs](https://docs.rs/chatora-errno/badge.svg?version=1.0.2)](https://docs.rs/chatora-errno/1.0.2/)

# chatora-errno

A thin Rust wrapper library around libc [`errno`][errno] interface.

[errno]: https://en.wikipedia.org/wiki/Errno.h


## Examples

```rust
use chatora_errno::{clear_errno, describe_errno, get_errno, set_errno};

// Clear current errno.
clear_errno();

// Get the current value of errno.
let errno: i32 = get_errno();

assert_eq!(errno, 0);

// Equivalent to `clear_errno()`.
set_errno(0);

// Get string description of an errno.
let err_string: String = describe_errno(errno).unwrap();

assert_eq!(
    format!("{} (os error {})", err_string, errno),
    format!("{}", std::io::Error::from_raw_os_error(errno))
);
assert_eq!(err_string, "Success");
```


## Usage

To use `chatora-errno`, add this to your `Cargo.toml`:

```toml
[dependencies]
chatora-errno = "1.0.2"
```


## License

Licensed under either of

 * Apache License, Version 2.0
   ([LICENSE-APACHE](LICENSE-APACHE) or http://www.apache.org/licenses/LICENSE-2.0)
 * MIT license
   ([LICENSE-MIT](LICENSE-MIT) or http://opensource.org/licenses/MIT)

at your option.


## Contribution

Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in the work by you, as defined in the Apache-2.0 license, shall be
dual licensed as above, without any additional terms or conditions.
