#![warn(
    explicit_outlives_requirements,
    invalid_html_tags,
    macro_use_extern_crate,
    missing_copy_implementations,
    missing_crate_level_docs,
    missing_debug_implementations,
    missing_doc_code_examples,
    missing_docs,
    pointer_structural_match,
    private_doc_tests,
    single_use_lifetimes,
    trivial_casts,
    trivial_numeric_casts,
    unreachable_pub,
    // unsafe_op_in_unsafe_fn,
    unused_crate_dependencies,
    unused_extern_crates,
    unused_import_braces,
    unused_lifetimes,
    unused_qualifications,
    unused_results,
    variant_size_differences,
    clippy::pedantic,
    clippy::nursery,
    clippy::cargo,
    clippy::clone_on_ref_ptr,
    clippy::exhaustive_enums,
    clippy::exhaustive_structs,
    clippy::filetype_is_file,
    clippy::float_cmp_const,
    clippy::if_then_some_else_none,
    clippy::lossy_float_literal,
    clippy::rc_buffer,
)]
#![allow(
    // clippy::cognitive_complexity,
    clippy::missing_errors_doc,
    clippy::multiple_crate_versions,
    clippy::must_use_candidate,
)]
// #![rustfmt::skip]
// #![clippy::cognitive_complexity_threshold = "20"]
#![doc(test(no_crate_inject, attr(allow(unused_variables), deny(warnings))))]

//! A thin Rust wrapper library around libc [`errno`][errno] interface.
//!
//! [errno]: https://en.wikipedia.org/wiki/Errno.h
//!
//!
//! # Examples
//!
//! ```rust
//! use chatora_errno::{clear_errno, describe_errno, get_errno, set_errno};
//!
//! // Clear current errno.
//! clear_errno();
//!
//! // Get the current value of errno.
//! let errno: i32 = get_errno();
//!
//! assert_eq!(errno, 0);
//!
//! // Equivalent to `clear_errno()`.
//! set_errno(0);
//!
//! // Get string description of an errno.
//! let err_string: String = describe_errno(errno).unwrap();
//!
//! assert_eq!(
//!     format!("{} (os error {})", err_string, errno),
//!     format!("{}", std::io::Error::from_raw_os_error(errno))
//! );
//! assert_eq!(err_string, "Success");
//! ```

#[cfg(doctest)]
#[macro_use]
extern crate doc_comment;
#[cfg(doctest)]
doctest!("../README.md");

// Avoid `unused_crate_dependencies`.
#[cfg(doctest)]
use doc_comment as _;

#[cfg(not(any(
    target_os = "linux",
    target_os = "emscripten",
    target_os = "fuchsia",
    target_os = "l4re",
    target_os = "netbsd",
    target_os = "openbsd",
    target_os = "android",
    target_os = "redox",
    target_env = "newlib",
    any(target_os = "solaris", target_os = "illumos"),
    any(target_os = "macos", target_os = "ios", target_os = "freebsd"),
    target_os = "haiku",
    target_os = "wasi",
)))]
compile_error!("Unsupported `target_os`.");

#[cfg_attr(target_family = "unix", path = "unix.rs")]
#[cfg_attr(target_os = "wasi", path = "wasi.rs")]
mod os;

pub use self::os::{clear_errno, describe_errno, get_errno, set_errno};
