pub struct Config<'a> {
    pub changelogs_folder: &'a str,
    pub changelog_file: &'a str,
    pub link_format: Option<String>,
    pub versioning: Option<String>,
}

impl Default for Config<'static> {
    fn default() -> Config<'static> {
        Self {
            changelogs_folder: "./changelogs",
            changelog_file: "./CHANGELOG.md",
            link_format: None,
            versioning: None,
        }
    }
}
