use tokio::io::{self, AsyncWriteExt, AsyncBufReadExt};

pub async fn prompt(txt: &str) -> Result<String, io::Error> {
    let mut out = io::stdout();

    out.write_all(txt.as_bytes()).await?;

    let _ = out.flush().await;

    let mut input = String::new();
    
    io::BufReader::new(io::stdin())
        .read_line(&mut input).await?;

    let input = input.trim().to_owned();

    Ok(input)
}
